/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPAddress;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPSendFinisher;
import net.i2p.router.transport.ntcp.Reader;
import net.i2p.router.transport.ntcp.Writer;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NTCPTransport
extends TransportImpl {
    private final Log _log;
    private final SharedBid _fastBid;
    private final SharedBid _slowBid;
    private final SharedBid _slowCostBid;
    private final SharedBid _nearCapacityBid;
    private final SharedBid _nearCapacityCostBid;
    private final SharedBid _transientFail;
    private final Object _conLock;
    private final Map<Hash, NTCPConnection> _conByIdent;
    private NTCPAddress _myAddress;
    private final EventPumper _pumper;
    private final Reader _reader;
    private Writer _writer;
    private final Set<NTCPConnection> _establishing;
    public static final String PROP_BIND_INTERFACE = "i2np.ntcp.bindInterface";
    private final NTCPSendFinisher _finisher;
    private final DHSessionKeyBuilder.Factory _dhFactory;
    private long _lastBadSkew;
    private static final long[] RATES = new long[]{600000L};
    private static final int MIN_PEER_PORT = 500;
    private static final String THINSP = " / ";
    private static final int MIN_CONCURRENT_READERS = 2;
    private static final int MIN_CONCURRENT_WRITERS = 2;
    private static final int MAX_CONCURRENT_READERS = 4;
    private static final int MAX_CONCURRENT_WRITERS = 4;
    public static final int ESTABLISH_TIMEOUT = 10000;
    public static final String STYLE = "NTCP";
    private static final NumberFormat _rateFmt = new DecimalFormat("#,##0.00");
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public NTCPTransport(RouterContext ctx, DHSessionKeyBuilder.Factory dh) {
        super(ctx);
        this._dhFactory = dh;
        this._log = ctx.logManager().getLog(this.getClass());
        this._context.statManager().createRateStat("ntcp.sendTime", "Total message lifetime when sent completely", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendQueueSize", "How many messages were ahead of the current one on the connection's queue when it was first added", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveTime", "How long it takes to receive an inbound message", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveSize", "How large the received message was", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendBacklogTime", "How long the head of the send queue has been waiting when we fail to add a new one to the queue (period is the number of messages queued)", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeWrites", "How many times do we need to proactively add in an extra nio write to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeCloses", "How many times do we need to proactively close an idle connection to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeInvalid", "How many times do we close a connection to a peer to work around a JVM bug?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.accept", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptShitlistedPeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptUnreachablePeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.closeOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedInvalidPort", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.bidRejectedLocalAddress", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeout", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeoutIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedUnresolved", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectSuccessful", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptDecryptedI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIME", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptMetaCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptTooLargeI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.dontSendOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundCheckConnection", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablished", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablishedDuplicate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.infoMessageEnqueued", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.floodInfoMessageEnqueued", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidDH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXY", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXxorBIH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundDFE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSize", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.multipleCloseOnRemove", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundEstablishFailed", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundFailedIOEImmediate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidOutboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.noBidTooLargeI2NP", "send size", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.queuedRecv", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.read", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.readError", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveCorruptEstablishment", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveMeta", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.registerConnect", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledReadComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledWriteComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.wantsQueuedWrite", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.writeError", "", "ntcp", RATES);
        this._establishing = new ConcurrentHashSet(16);
        this._conLock = new Object();
        this._conByIdent = new ConcurrentHashMap<Hash, NTCPConnection>(64);
        this._finisher = new NTCPSendFinisher(ctx, this);
        this._pumper = new EventPumper(ctx, this);
        this._reader = new Reader(ctx);
        this._writer = new Writer(ctx);
        this._fastBid = new SharedBid(25);
        this._slowBid = new SharedBid(70);
        this._slowCostBid = new SharedBid(85);
        this._nearCapacityBid = new SharedBid(90);
        this._nearCapacityCostBid = new SharedBid(105);
        this._transientFail = new SharedBid(999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inboundEstablished(NTCPConnection con) {
        NTCPConnection old;
        this._context.statManager().addRateData("ntcp.inboundEstablished", 1L);
        this.markReachable(con.getRemotePeer().calculateHash(), true);
        Object object = this._conLock;
        synchronized (object) {
            old = this._conByIdent.put(con.getRemotePeer().calculateHash(), con);
        }
        if (old != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Old connection closed: " + old + " replaced by " + con);
            }
            this._context.statManager().addRateData("ntcp.inboundEstablishedDuplicate", old.getUptime());
            old.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void outboundMessageReady() {
        OutNetMessage msg = this.getNextMessage();
        if (msg != null) {
            RouterIdentity ident = msg.getTarget().getIdentity();
            Hash ih = ident.calculateHash();
            NTCPConnection con = null;
            boolean isNew = false;
            Object object = this._conLock;
            synchronized (object) {
                con = this._conByIdent.get(ih);
                if (con == null) {
                    isNew = true;
                    RouterAddress addr = msg.getTarget().getTargetAddress(STYLE);
                    if (addr != null) {
                        NTCPAddress naddr = new NTCPAddress(addr);
                        con = new NTCPConnection(this._context, this, ident, naddr);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Send on a new con: " + con + " at " + addr + " for " + ih.toBase64());
                        }
                        this._conByIdent.put(ih, con);
                    } else {
                        this._log.error("we bid on a peer who doesn't have an ntcp address? " + msg.getTarget());
                        return;
                    }
                }
            }
            if (isNew) {
                con.enqueueInfoMessage();
                con.send(msg);
                try {
                    SocketChannel channel = SocketChannel.open();
                    con.setChannel(channel);
                    channel.configureBlocking(false);
                    this._pumper.registerConnect(con);
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Error opening a channel", (Throwable)ioe);
                    }
                    this._context.statManager().addRateData("ntcp.outboundFailedIOEImmediate", 1L);
                    con.close();
                }
            } else {
                con.send(msg);
            }
        }
    }

    @Override
    public void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        super.afterSend(msg, sendSuccessful, allowRequeue, msToSend);
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        if (!this.isAlive()) {
            return null;
        }
        if (dataSize > 16378L) {
            this._context.statManager().addRateData("ntcp.noBidTooLargeI2NP", dataSize);
            return null;
        }
        Hash peer = toAddress.getIdentity().calculateHash();
        if (this._context.shitlist().isShitlisted(peer, STYLE)) {
            this._context.statManager().addRateData("ntcp.attemptShitlistedPeer", 1L);
            return null;
        }
        if (this.isUnreachable(peer)) {
            this._context.statManager().addRateData("ntcp.attemptUnreachablePeer", 1L);
            return null;
        }
        boolean established = this.isEstablished(toAddress.getIdentity());
        if (established) {
            if (this._log.shouldLog(10)) {
                this._log.debug("fast bid when trying to send to " + peer + " as its already established");
            }
            return this._fastBid;
        }
        RouterAddress addr = toAddress.getTargetAddress(STYLE);
        if (addr == null) {
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + peer + " as they don't have an ntcp address");
            }
            return null;
        }
        byte[] ip = addr.getIP();
        if (addr.getPort() < 500 || ip == null) {
            this._context.statManager().addRateData("ntcp.connectFailedInvalidPort", 1L);
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + peer + " as they don't have a valid ntcp address");
            }
            return null;
        }
        if (!NTCPTransport.isPubliclyRoutable(ip) && !this._context.getProperty("i2np.ntcp.allowLocal", "false").equals("true")) {
            this._context.statManager().addRateData("ntcp.bidRejectedLocalAddress", 1L);
            this.markUnreachable(peer);
            if (this._log.shouldLog(10)) {
                this._log.debug("no bid when trying to send to " + peer + " as they have a private ntcp address");
            }
            return null;
        }
        if (!this.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("no bid when trying to send to " + peer + ", max connection limit reached");
            }
            return this._transientFail;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("slow bid when trying to send to " + peer);
        }
        if (this.haveCapacity()) {
            if (addr.getCost() > 10) {
                return this._slowCostBid;
            }
            return this._slowBid;
        }
        if (addr.getCost() > 10) {
            return this._nearCapacityCostBid;
        }
        return this._nearCapacityBid;
    }

    public boolean allowConnection() {
        return this.countActivePeers() < this.getMaxConnections();
    }

    void sendComplete(OutNetMessage msg) {
        this._finisher.add(msg);
    }

    private boolean isEstablished(RouterIdentity peer) {
        return this.isEstablished(peer.calculateHash());
    }

    @Override
    public boolean isEstablished(Hash dest) {
        NTCPConnection con = this._conByIdent.get(dest);
        return con != null && con.isEstablished() && !con.isClosed();
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        NTCPConnection con = this._conByIdent.get(dest);
        return con != null && con.isEstablished() && con.tooBacklogged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCon(NTCPConnection con) {
        NTCPConnection removed = null;
        RouterIdentity ident = con.getRemotePeer();
        if (ident != null) {
            Object object = this._conLock;
            synchronized (object) {
                removed = this._conByIdent.remove(ident.calculateHash());
            }
        }
        if (removed != null && removed != con) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple connections on remove, closing " + removed + " (already closed " + con + ")");
            }
            this._context.statManager().addRateData("ntcp.multipleCloseOnRemove", removed.getUptime());
            removed.close();
        }
    }

    @Override
    public int countActivePeers() {
        return this._conByIdent.size();
    }

    @Override
    public int countActiveSendPeers() {
        int active = 0;
        for (NTCPConnection con : this._conByIdent.values()) {
            if (con.getTimeSinceSend() > 60000L && con.getTimeSinceReceive() > 60000L) continue;
            ++active;
        }
        return active;
    }

    void setLastBadSkew(long skew) {
        this._lastBadSkew = skew;
    }

    @Override
    public Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        for (NTCPConnection con : this._conByIdent.values()) {
            if (!con.isEstablished()) continue;
            skews.addElement(con.getClockSkew());
        }
        if (skews.size() < 5 && this._lastBadSkew != 0L) {
            skews.addElement(this._lastBadSkew);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("NTCP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    @Override
    public synchronized RouterAddress startListening() {
        if (this._pumper.isAlive()) {
            return this._myAddress != null ? this._myAddress.toRouterAddress() : null;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting ntcp transport listening");
        }
        this.startIt();
        this.configureLocalAddress();
        return this.bindAddress();
    }

    public synchronized RouterAddress restartListening(RouterAddress addr) {
        if (this._pumper.isAlive()) {
            return this._myAddress != null ? this._myAddress.toRouterAddress() : null;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Restarting ntcp transport listening");
        }
        this.startIt();
        this._myAddress = addr == null ? null : new NTCPAddress(addr);
        return this.bindAddress();
    }

    private void startIt() {
        int nr;
        int nw;
        this._finisher.start();
        this._pumper.startPumping();
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x8000000L;
        }
        if (maxMemory < 0x2000000L) {
            nw = 1;
            nr = 1;
        } else if (maxMemory < 0x4000000L) {
            nw = 2;
            nr = 2;
        } else {
            nr = Math.max(2, Math.min(4, this._context.bandwidthLimiter().getInboundKBytesPerSecond() / 20));
            nw = Math.max(2, Math.min(4, this._context.bandwidthLimiter().getOutboundKBytesPerSecond() / 20));
        }
        this._reader.startReading(nr);
        this._writer.startWriting(nw);
    }

    public boolean isAlive() {
        return this._pumper.isAlive();
    }

    private RouterAddress bindAddress() {
        if (this._myAddress != null) {
            InetAddress bindToAddr = null;
            String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
            if (bindTo == null) {
                boolean isFixed = this._context.getProperty("i2np.ntcp.autoip", "true").toLowerCase(Locale.US).equals("false");
                String fixedHost = this._context.getProperty("i2np.ntcp.hostname");
                if (isFixed && fixedHost != null) {
                    try {
                        String testAddr = InetAddress.getByName(fixedHost).getHostAddress();
                        if (Addresses.getAddresses().contains(testAddr)) {
                            bindTo = testAddr;
                        }
                    }
                    catch (UnknownHostException uhe) {
                        // empty catch block
                    }
                }
            }
            if (bindTo != null) {
                try {
                    bindToAddr = InetAddress.getByName(bindTo);
                }
                catch (UnknownHostException uhe) {
                    this._log.log(50, "Invalid NTCP bind interface specified [" + bindTo + "]", (Throwable)uhe);
                    return null;
                }
            }
            try {
                ServerSocketChannel chan = ServerSocketChannel.open();
                chan.configureBlocking(false);
                int port = this._myAddress.getPort();
                if (port > 0 && port < 1024) {
                    this._log.logAlways(30, "Specified NTCP port is " + port + ", ports lower than 1024 not recommended");
                }
                InetSocketAddress addr = null;
                if (bindToAddr == null) {
                    addr = new InetSocketAddress(port);
                } else {
                    addr = new InetSocketAddress(bindToAddr, port);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Binding only to " + bindToAddr);
                    }
                }
                chan.socket().bind(addr);
                if (this._log.shouldLog(20)) {
                    this._log.info("Listening on " + addr);
                }
                this._pumper.register(chan);
            }
            catch (IOException ioe) {
                this._log.error("Error listening", (Throwable)ioe);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Outbound NTCP connections only - no listener configured");
        }
        if (this._myAddress != null) {
            RouterAddress rv = this._myAddress.toRouterAddress();
            if (rv != null) {
                this.replaceAddress(rv);
            }
            return rv;
        }
        return null;
    }

    Reader getReader() {
        return this._reader;
    }

    Writer getWriter() {
        return this._writer;
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    EventPumper getPumper() {
        return this._pumper;
    }

    DHSessionKeyBuilder getDHBuilder() {
        return this._dhFactory.getBuilder();
    }

    void establishing(NTCPConnection con) {
        this._establishing.add(con);
    }

    void expireTimedOut() {
        int expired = 0;
        Iterator<NTCPConnection> iter = this._establishing.iterator();
        while (iter.hasNext()) {
            NTCPConnection con = iter.next();
            if (con.isClosed() || con.isEstablished()) {
                iter.remove();
                continue;
            }
            if (con.getTimeSinceCreated() <= 10000L) continue;
            iter.remove();
            con.close();
            ++expired;
        }
        if (expired > 0) {
            this._context.statManager().addRateData("ntcp.outboundEstablishFailed", (long)expired);
        }
    }

    private void configureLocalAddress() {
        RouterContext ctx = this.getContext();
        if (ctx == null) {
            System.err.println("NIO transport has no context?");
        } else {
            RouterAddress ra = CommSystemFacadeImpl.createNTCPAddress(ctx);
            if (ra != null) {
                NTCPAddress addr = new NTCPAddress(ra);
                if (addr.getPort() <= 0) {
                    this._myAddress = null;
                    if (this._log.shouldLog(40)) {
                        this._log.error("NTCP address is outbound only, since the NTCP configuration is invalid");
                    }
                } else {
                    this._myAddress = addr;
                    this.replaceAddress(ra);
                    if (this._log.shouldLog(20)) {
                        this._log.info("NTCP address configured: " + this._myAddress);
                    }
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("NTCP address is outbound only");
            }
        }
    }

    @Override
    public void forwardPortStatus(int port, int externalPort, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the NTCP port: " + port);
            } else {
                this._log.warn("UPnP has failed to open the NTCP port: " + port + " reason: " + reason);
            }
        }
    }

    @Override
    public int getRequestedPort() {
        return this._context.getProperty("i2np.ntcp.port", -1);
    }

    @Override
    public short getReachabilityStatus() {
        if (this.isAlive() && this._myAddress != null) {
            for (NTCPConnection con : this._conByIdent.values()) {
                if (!con.isInbound()) continue;
                return 0;
            }
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopListening() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Stopping ntcp transport");
        }
        this._pumper.stopPumping();
        this._writer.stopWriting();
        this._reader.stopReading();
        this._finisher.stop();
        HashMap<Hash, NTCPConnection> cons = null;
        Object object = this._conLock;
        synchronized (object) {
            cons = new HashMap<Hash, NTCPConnection>(this._conByIdent);
            this._conByIdent.clear();
        }
        for (NTCPConnection con : cons.values()) {
            con.close();
        }
        NTCPConnection.releaseResources();
        this.replaceAddress(null);
    }

    public void renderStatusHTML(java.io.Writer out, int sortFlags) throws IOException {
    }

    @Override
    public void renderStatusHTML(java.io.Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<NTCPConnection> peers = new TreeSet<NTCPConnection>(this.getComparator(sortFlags));
        peers.addAll(this._conByIdent.values());
        long offsetTotal = 0L;
        float bpsSend = 0.0f;
        float bpsRecv = 0.0f;
        long totalUptime = 0L;
        long totalSend = 0L;
        long totalRecv = 0L;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"ntcpcon\">").append(this._("NTCP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._("Limit")).append(": ").append(this.getMaxConnections());
        buf.append(". ").append(this._("Timeout")).append(": ").append(DataHelper.formatDuration2((long)this._pumper.getIdleTimeout()));
        buf.append(".</h3>\n<table>\n<tr><th><a href=\"#def.peer\">").append(this._("Peer")).append("</a></th><th>").append(this._("Dir")).append("</th><th align=\"right\"><a href=\"#def.idle\">").append(this._("Idle")).append("</a></th><th align=\"right\"><a href=\"#def.rate\">").append(this._("In/Out")).append("</a></th><th align=\"right\"><a href=\"#def.up\">").append(this._("Up")).append("</a></th><th align=\"right\"><a href=\"#def.skew\">").append(this._("Skew")).append("</a></th><th align=\"right\"><a href=\"#def.send\">").append(this._("TX")).append("</a></th><th align=\"right\"><a href=\"#def.recv\">").append(this._("RX")).append("</a></th><th>").append(this._("Out Queue")).append("</th><th>").append(this._("Backlogged?")).append("</th> </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        for (NTCPConnection con : peers) {
            float r;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(con.getRemotePeer().calculateHash()));
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._("Inbound")).append("\"/>");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._("Outbound")).append("\"/>");
            }
            buf.append("</td><td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)con.getTimeSinceReceive()));
            buf.append(THINSP).append(DataHelper.formatDuration2((long)con.getTimeSinceSend()));
            buf.append("</td><td class=\"cells\" align=\"right\">");
            if (con.getTimeSinceReceive() < 120000L) {
                r = con.getRecvRate();
                buf.append(NTCPTransport.formatRate(r / 1024.0f));
                bpsRecv += r;
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append(THINSP);
            if (con.getTimeSinceSend() < 120000L) {
                r = con.getSendRate();
                buf.append(NTCPTransport.formatRate(r / 1024.0f));
                bpsSend += r;
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append("</td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2((long)con.getUptime()));
            totalUptime += con.getUptime();
            offsetTotal += con.getClockSkew();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2((long)(1000L * con.getClockSkew())));
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesSent());
            totalSend += con.getMessagesSent();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesReceived());
            totalRecv += con.getMessagesReceived();
            long outQueue = con.getOutboundQueueSize();
            buf.append("</td><td class=\"cells\" align=\"center\">").append(outQueue);
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isBacklogged()) {
                buf.append("&#x2713;");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (!peers.isEmpty()) {
            buf.append("<tr class=\"tablefooter\"><td align=\"center\"><b>").append(peers.size()).append(' ').append(this._("peers")).append("</b></td><td>&nbsp;</td><td>&nbsp;");
            buf.append("</td><td align=\"center\"><b>").append(NTCPTransport.formatRate(bpsRecv / 1024.0f)).append(THINSP).append(NTCPTransport.formatRate(bpsSend / 1024.0f)).append("</b>");
            buf.append("</td><td align=\"center\"><b>").append(DataHelper.formatDuration2((long)(totalUptime / (long)peers.size())));
            buf.append("</b></td><td align=\"center\"><b>").append(DataHelper.formatDuration2((long)(offsetTotal * 1000L / (long)peers.size())));
            buf.append("</b></td><td align=\"center\"><b>").append(totalSend).append("</b></td><td align=\"center\"><b>").append(totalRecv);
            buf.append("</b></td><td>&nbsp;</td><td>&nbsp;</td></tr>\n");
        }
        buf.append("</table>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatRate(float rate) {
        NumberFormat numberFormat = _rateFmt;
        synchronized (numberFormat) {
            return _rateFmt.format(rate);
        }
    }

    private Comparator getComparator(int sortFlags) {
        Comparator<NTCPConnection> rv = null;
        switch (Math.abs(sortFlags)) {
            default: 
        }
        rv = AlphaComparator.instance();
        if (sortFlags < 0) {
            rv = Collections.reverseOrder(rv);
        }
        return rv;
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PeerComparator
    implements Comparator<NTCPConnection> {
        private PeerComparator() {
        }

        @Override
        public int compare(NTCPConnection l, NTCPConnection r) {
            if (l == null || r == null) {
                throw new IllegalArgumentException();
            }
            return l.getRemotePeer().calculateHash().toBase64().compareTo(r.getRemotePeer().calculateHash().toBase64());
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        public Transport getTransport() {
            return NTCPTransport.this;
        }

        public String toString() {
            return "NTCP bid @ " + this.getLatencyMs();
        }
    }
}

