/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.time;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import net.i2p.router.time.NtpMessage;

class NtpClient {
    private static final double SECONDS_1900_TO_EPOCH = 2.2089888E9;
    private static final int NTP_PORT = 123;

    NtpClient() {
    }

    public static long currentTime(String[] serverNames) {
        int i;
        if (serverNames == null) {
            throw new IllegalArgumentException("No NTP servers specified");
        }
        ArrayList<String> names = new ArrayList<String>(serverNames.length);
        for (i = 0; i < serverNames.length; ++i) {
            names.add(serverNames[i]);
        }
        Collections.shuffle(names);
        for (i = 0; i < names.size(); ++i) {
            long now = NtpClient.currentTime((String)names.get(i));
            if (now <= 0L) continue;
            return now;
        }
        throw new IllegalArgumentException("No reachable NTP servers specified");
    }

    public static long[] currentTimeAndStratum(String[] serverNames) {
        int i;
        if (serverNames == null) {
            throw new IllegalArgumentException("No NTP servers specified");
        }
        ArrayList<String> names = new ArrayList<String>(serverNames.length);
        for (i = 0; i < serverNames.length; ++i) {
            names.add(serverNames[i]);
        }
        Collections.shuffle(names);
        for (i = 0; i < names.size(); ++i) {
            long[] rv = NtpClient.currentTimeAndStratum((String)names.get(i));
            if (rv == null || rv[0] <= 0L) continue;
            return rv;
        }
        throw new IllegalArgumentException("No reachable NTP servers specified");
    }

    public static long currentTime(String serverName) {
        long[] la = NtpClient.currentTimeAndStratum(serverName);
        if (la != null) {
            return la[0];
        }
        return -1L;
    }

    private static long[] currentTimeAndStratum(String serverName) {
        try {
            DatagramSocket socket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(serverName);
            byte[] buf = new NtpMessage().toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
            NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
            socket.send(packet);
            packet = new DatagramPacket(buf, buf.length);
            socket.setSoTimeout(10000);
            try {
                socket.receive(packet);
            }
            catch (InterruptedIOException iie) {
                socket.close();
                return null;
            }
            double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
            NtpMessage msg = new NtpMessage(packet.getData());
            double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
            socket.close();
            if (msg.stratum < 1 || msg.stratum > 15) {
                return null;
            }
            long[] rv = new long[]{(long)((double)System.currentTimeMillis() + localClockOffset * 1000.0), msg.stratum};
            return rv;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length <= 0) {
            NtpClient.printUsage();
            return;
        }
        long now = NtpClient.currentTime(args);
        System.out.println("Current time: " + new Date(now));
    }

    static void printUsage() {
        System.out.println("NtpClient - an NTP client for Java.\n\nThis program connects to an NTP server and prints the current time to the console.\n\n\nUsage: java NtpClient server[ server]*\n\n\nThis program is copyright (c) Adam Buckley 2004 and distributed under the terms\nof the GNU General Public License.  This program is distributed in the hope\nthat it will be useful, but WITHOUT ANY WARRANTY; without even the implied\nwarranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\nGeneral Public License available at http://www.gnu.org/licenses/gpl.html for\nmore details.");
    }
}

