/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.startup.WorkingDir;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MigrateJetty {
    private static boolean _wasChecked;
    private static boolean _hasJetty6;
    private static final String OLD_CLASS = "org.mortbay.jetty.Server";
    private static final String NEW_CLASS = "org.mortbay.start.Main";
    private static final String BACKUP = "jetty5.xml";
    private static final String JETTY6_TEMPLATE_DIR = "eepsite-jetty6";
    private static final String JETTY6_TEMPLATE_PKGDIR = "eepsite";
    private static final String BASE_CONTEXT = "contexts/base-context.xml";
    private static final String CGI_CONTEXT = "contexts/cgi-context.xml";

    MigrateJetty() {
    }

    public static void migrate(RouterContext ctx, List<ClientAppConfig> apps) {
        boolean shouldSave = false;
        for (int i = 0; i < apps.size(); ++i) {
            boolean ok;
            String[] args;
            ClientAppConfig app = apps.get(i);
            if (!app.className.equals(OLD_CLASS)) continue;
            String client = "client application " + i + " [" + app.clientName + "] from Jetty 5 " + OLD_CLASS + " to Jetty 6 " + NEW_CLASS;
            if (!MigrateJetty.hasJetty6()) {
                System.err.println("WARNING: Jetty 6 unavailable, cannot migrate " + client);
                continue;
            }
            if (app.args == null || (args = LoadClientAppsJob.parseArgs(app.args)).length == 0) continue;
            String xml = args[0];
            File xmlFile = new File(xml);
            if (!xmlFile.isAbsolute()) {
                xmlFile = new File(ctx.getAppDir(), xml);
            }
            if (!xmlFile.exists()) {
                System.err.println("WARNING: XML file " + xmlFile + " not found, cannot migrate " + client);
                continue;
            }
            File eepsite = xmlFile.getParentFile();
            File backup = new File(eepsite, BACKUP);
            if (backup.exists()) {
                backup = new File(eepsite, BACKUP + ctx.random().nextInt());
            }
            if (!(ok = WorkingDir.copyFile(xmlFile, backup))) {
                System.err.println("WARNING: Failed to copy XML file " + xmlFile + " to " + backup + ", cannot migrate " + client);
                continue;
            }
            File baseEep = new File(ctx.getBaseDir(), JETTY6_TEMPLATE_DIR);
            if (!baseEep.exists()) {
                baseEep = new File(ctx.getBaseDir(), JETTY6_TEMPLATE_PKGDIR);
            }
            if (baseEep.equals(eepsite)) {
                System.err.println("Eepsite in non-split directory " + eepsite + ", cannot migrate " + client);
                continue;
            }
            File baseContext = new File(baseEep, BASE_CONTEXT);
            if (!baseContext.exists()) {
                System.err.println("WARNING: Cannot find new XML file template " + baseContext + ", cannot migrate " + client);
                continue;
            }
            String newPath = eepsite.getAbsolutePath() + File.separatorChar;
            ok = WorkingDir.migrateJettyXml(baseEep, eepsite, "jetty.xml", "./eepsite/", newPath);
            if (!ok) {
                System.err.println("WARNING: Failed to modify XML file " + xmlFile + ", cannot migrate " + client);
                continue;
            }
            WorkingDir.migrateJettyXml(baseEep, eepsite, "jetty-ssl.xml", "./eepsite/", newPath);
            new File(eepsite, "contexts").mkdir();
            WorkingDir.migrateJettyXml(baseEep, eepsite, BASE_CONTEXT, "./eepsite/", newPath);
            WorkingDir.migrateJettyXml(baseEep, eepsite, CGI_CONTEXT, "./eepsite/", newPath);
            WorkingDir.copyFile(new File(baseEep, "jetty-rewrite.xml"), new File(eepsite, "jetty-rewrite.xml"));
            new File(eepsite, "etc").mkdir();
            File to = new File(eepsite, "etc/realm.properties");
            if (!to.exists()) {
                WorkingDir.copyFile(new File(baseEep, "etc/realm.properties"), to);
            }
            if (!(to = new File(eepsite, "etc/webdefault.xml")).exists()) {
                WorkingDir.copyFile(new File(baseEep, "etc/webdefault.xml"), to);
            }
            app.className = NEW_CLASS;
            shouldSave = true;
            System.err.println("WARNING: Migrated " + client + '\n' + "Check the following files in " + eepsite + ": jetty.xml, " + BASE_CONTEXT + ", and " + CGI_CONTEXT + "\n" + "Your old jetty.xml was saved as " + backup + '\n' + "If you modified your jetty.xml to change ports, thread limits, etc, you MUST\n" + "edit it to change them again. Your port was reset to 7658.");
        }
        if (shouldSave) {
            boolean ok;
            File cfgFile = ClientAppConfig.configFile(ctx);
            File backup = new File(cfgFile.getAbsolutePath() + ".jetty5");
            if (backup.exists()) {
                backup = new File(cfgFile.getAbsolutePath() + ctx.random().nextInt());
            }
            if (ok = WorkingDir.copyFile(cfgFile, backup)) {
                ClientAppConfig.writeClientAppConfig(ctx, apps);
                System.err.println("WARNING: Migrated clients config file " + cfgFile + " from Jetty 5 " + OLD_CLASS + " to Jetty 6 " + NEW_CLASS + "\n" + "Your old clients config file was saved as " + backup);
            }
        }
    }

    private static boolean hasJetty6() {
        if (!_wasChecked) {
            try {
                LoadClientAppsJob.testClient(NEW_CLASS, null);
                _hasJetty6 = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _wasChecked = true;
        }
        return _hasJetty6;
    }
}

