/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

class FloodfillMonitorJob
extends JobImpl {
    private final Log _log;
    private final FloodfillNetworkDatabaseFacade _facade;
    private long _lastChanged;
    private static final int REQUEUE_DELAY = 3600000;
    private static final long MIN_UPTIME = 0x6DDD00L;
    private static final long MIN_CHANGE_DELAY = 21600000L;
    private static final int MIN_FF = 360;
    private static final int MAX_FF = 999999;
    private static final String PROP_FLOODFILL_PARTICIPANT = "router.floodfillParticipant";

    public FloodfillMonitorJob(RouterContext context, FloodfillNetworkDatabaseFacade facade) {
        super(context);
        this._facade = facade;
        this._log = context.logManager().getLog(FloodfillMonitorJob.class);
    }

    public String getName() {
        return "Monitor the floodfill pool";
    }

    public void runJob() {
        boolean wasFF = this._facade.floodfillEnabled();
        boolean ff = this.shouldBeFloodfill();
        this._facade.setFloodfillEnabled(ff);
        if (ff != wasFF) {
            this.getContext().router().rebuildRouterInfo();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Should we be floodfill? " + ff);
        }
        int delay = 1800000 + this.getContext().random().nextInt(3600000);
        if (!ff) {
            delay *= 7;
        }
        this.requeue(delay);
    }

    private boolean shouldBeFloodfill() {
        if (this.getContext().getProperty("__shutdownInProgress") != null) {
            return false;
        }
        if (this.getContext().router().isHidden()) {
            return false;
        }
        String enabled = this.getContext().getProperty(PROP_FLOODFILL_PARTICIPANT, "auto");
        if ("true".equals(enabled)) {
            return true;
        }
        if ("false".equals(enabled)) {
            return false;
        }
        if (this.getContext().router().getUptime() < 0x6DDD00L) {
            return false;
        }
        if (this.getContext().router().getRouterInfo().getCapabilities().indexOf("O") < 0) {
            return false;
        }
        List<Hash> floodfillPeers = this._facade.getFloodfillPeers();
        long now = this.getContext().clock().now();
        if (floodfillPeers == null || floodfillPeers.isEmpty()) {
            this._lastChanged = now;
            return true;
        }
        boolean wasFF = this._facade.floodfillEnabled();
        if (this._lastChanged + 21600000L > now) {
            return wasFF;
        }
        int ffcount = floodfillPeers.size();
        int failcount = 0;
        long before = now - 3600000L;
        for (Hash peer : floodfillPeers) {
            PeerProfile profile = this.getContext().profileOrganizer().getProfile(peer);
            if (profile != null && profile.getLastHeardFrom() >= before && !profile.getIsFailing() && !this.getContext().shitlist().isShitlisted(peer) && !this.getContext().commSystem().wasUnreachable(peer)) continue;
            ++failcount;
        }
        if (wasFF) {
            ++ffcount;
        }
        int good = ffcount - failcount;
        boolean happy = this.getContext().router().getRouterInfo().getCapabilities().indexOf("R") >= 0;
        happy = happy && this.getContext().jobQueue().getMaxLag() < 2000L;
        happy = happy && this._facade.getKnownRouters() >= 200;
        happy = happy && this.getContext().commSystem().countActivePeers() >= 50;
        happy = happy && this.getContext().tunnelManager().getParticipatingCount() >= 100;
        boolean bl = happy = happy && Math.abs(this.getContext().clock().getOffset()) < 10000L;
        if (happy) {
            RouterAddress ra = this.getContext().router().getRouterInfo().getTargetAddress("SSU");
            if (ra == null) {
                happy = false;
            } else if (ra.getOption("ihost0") != null) {
                happy = false;
            }
        }
        if (good < 360 && happy) {
            if (!wasFF) {
                this._lastChanged = now;
                this._log.logAlways(20, "Only " + good + " ff peers and we want " + 360 + " so we are becoming floodfill");
            }
            return true;
        }
        if (good > 999999 || good > 360 && !happy) {
            if (wasFF) {
                this._lastChanged = now;
                this._log.logAlways(20, "Have " + good + " ff peers and we need only " + 360 + " to " + 999999 + " so we are disabling floodfill; reachable? " + happy);
            }
            return false;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Have " + good + " ff peers, not changing, enabled? " + wasFF + "; reachable? " + happy);
        }
        return wasFF;
    }
}

