/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Date;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.RequestLeaseSetMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.LeaseRequestState;
import net.i2p.util.Log;

class RequestLeaseSetJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final LeaseRequestState _requestState;

    public RequestLeaseSetJob(RouterContext ctx, ClientConnectionRunner runner, LeaseSet set, long expiration, Job onCreate, Job onFail, LeaseRequestState state) {
        super(ctx);
        this._log = ctx.logManager().getLog(RequestLeaseSetJob.class);
        this._runner = runner;
        this._requestState = state;
        ctx.statManager().createRateStat("client.requestLeaseSetSuccess", "How frequently the router requests successfully a new leaseSet?", "ClientMessages", new long[]{3600000L});
        ctx.statManager().createRateStat("client.requestLeaseSetTimeout", "How frequently the router requests a new leaseSet but gets no reply?", "ClientMessages", new long[]{3600000L});
        ctx.statManager().createRateStat("client.requestLeaseSetDropped", "How frequently the router requests a new leaseSet but the client drops?", "ClientMessages", new long[]{3600000L});
    }

    public String getName() {
        return "Request Lease Set";
    }

    public void runJob() {
        if (this._runner.isDead()) {
            return;
        }
        RequestLeaseSetMessage msg = new RequestLeaseSetMessage();
        long endTime = this._requestState.getRequested().getEarliestLeaseDate();
        long fudge = 300L - (endTime - this.getContext().clock().now()) / 2000L;
        Date end = new Date(endTime += fudge);
        msg.setEndDate(end);
        msg.setSessionId(this._runner.getSessionId());
        for (int i = 0; i < this._requestState.getRequested().getLeaseCount(); ++i) {
            msg.addEndpoint(this._requestState.getRequested().getLease(i).getGateway(), this._requestState.getRequested().getLease(i).getTunnelId());
        }
        try {
            this._runner.doSend((I2CPMessage)msg);
            this.getContext().jobQueue().addJob(new CheckLeaseRequestStatus(this.getContext(), this._requestState));
            return;
        }
        catch (I2CPMessageException ime) {
            this.getContext().statManager().addRateData("client.requestLeaseSetDropped", 1L, 0L);
            this._log.error("Error sending I2CP message requesting the lease set", (Throwable)ime);
            this._requestState.setIsSuccessful(false);
            this._runner.setLeaseRequest(null);
            this._runner.disconnectClient("I2CP error requesting leaseSet");
            return;
        }
    }

    private class CheckLeaseRequestStatus
    extends JobImpl {
        private final LeaseRequestState _req;
        private final long _start;

        public CheckLeaseRequestStatus(RouterContext enclosingContext, LeaseRequestState state) {
            super(enclosingContext);
            this._req = state;
            this._start = System.currentTimeMillis();
            this.getTiming().setStartAfter(state.getExpiration());
        }

        public void runJob() {
            if (RequestLeaseSetJob.this._runner.isDead()) {
                if (RequestLeaseSetJob.this._log.shouldLog(10)) {
                    RequestLeaseSetJob.this._log.debug("Already dead, dont try to expire the leaseSet lookup");
                }
                return;
            }
            if (this._req.getIsSuccessful()) {
                this.getContext().statManager().addRateData("client.requestLeaseSetSuccess", 1L, 0L);
                return;
            }
            this.getContext().statManager().addRateData("client.requestLeaseSetTimeout", 1L, 0L);
            if (RequestLeaseSetJob.this._log.shouldLog(40)) {
                long waited = System.currentTimeMillis() - this._start;
                RequestLeaseSetJob.this._log.error("Failed to receive a leaseSet in the time allotted (" + waited + "): " + this._req + " for " + RequestLeaseSetJob.this._runner.getConfig().getDestination().calculateHash().toBase64());
            }
            RequestLeaseSetJob.this._runner.disconnectClient("Took too long to request leaseSet");
            if (this._req.getOnFailed() != null) {
                RequestLeaseSetJob.this.getContext().jobQueue().addJob(this._req.getOnFailed());
            }
        }

        public String getName() {
            return "Check LeaseRequest Status";
        }
    }
}

