/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2cp.DestReplyMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;

class LookupDestJob
extends JobImpl {
    private final ClientConnectionRunner _runner;
    private final Hash _hash;

    public LookupDestJob(RouterContext context, ClientConnectionRunner runner, Hash h) {
        super(context);
        this._runner = runner;
        this._hash = h;
    }

    public String getName() {
        return "LeaseSet Lookup for Client";
    }

    public void runJob() {
        DoneJob done = new DoneJob(this.getContext());
        this.getContext().netDb().lookupLeaseSet(this._hash, done, done, 15000L);
    }

    private void returnDest(Destination d) {
        DestReplyMessage msg = new DestReplyMessage(d);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException i2CPMessageException) {
            // empty catch block
        }
    }

    private void returnHash(Hash h) {
        DestReplyMessage msg = new DestReplyMessage(h);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException i2CPMessageException) {
            // empty catch block
        }
    }

    private class DoneJob
    extends JobImpl {
        public DoneJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "LeaseSet Lookup Reply to Client";
        }

        public void runJob() {
            LeaseSet ls = this.getContext().netDb().lookupLeaseSetLocally(LookupDestJob.this._hash);
            if (ls != null) {
                LookupDestJob.this.returnDest(ls.getDestination());
            } else {
                LookupDestJob.this.returnHash(LookupDestJob.this._hash);
            }
        }
    }
}

