/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Map;
import java.util.Properties;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.BandwidthLimitsMessage;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;
import net.i2p.data.i2cp.ReceiveMessageEndMessage;
import net.i2p.data.i2cp.ReconfigureSessionMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.data.i2cp.SessionStatusMessage;
import net.i2p.data.i2cp.SetDateMessage;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.CreateSessionJob;
import net.i2p.router.client.LookupDestJob;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

class ClientMessageEventListener
implements I2CPMessageReader.I2CPMessageEventListener {
    private final Log _log;
    private final RouterContext _context;
    private final ClientConnectionRunner _runner;
    private final boolean _enforceAuth;
    private static final int MAX_SESSION_ID = Short.MAX_VALUE;
    private static volatile int _id = RandomSource.getInstance().nextInt(Short.MAX_VALUE);
    private static final Object _sessionIdLock = new Object();

    public ClientMessageEventListener(RouterContext context, ClientConnectionRunner runner, boolean enforceAuth) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientMessageEventListener.class);
        this._runner = runner;
        this._enforceAuth = enforceAuth;
        this._context.statManager().createRateStat("client.distributeTime", "How long it took to inject the client message into the router", "ClientMessages", new long[]{60000L, 600000L, 3600000L});
    }

    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Message recieved: \n" + message);
        }
        switch (message.getType()) {
            case 32: {
                this.handleGetDate(reader, (GetDateMessage)message);
                break;
            }
            case 33: {
                this.handleSetDate(reader, (SetDateMessage)message);
                break;
            }
            case 1: {
                this.handleCreateSession(reader, (CreateSessionMessage)message);
                break;
            }
            case 5: {
                this.handleSendMessage(reader, (SendMessageMessage)message);
                break;
            }
            case 36: {
                this.handleSendMessage(reader, (SendMessageMessage)((SendMessageExpiresMessage)message));
                break;
            }
            case 6: {
                this.handleReceiveBegin(reader, (ReceiveMessageBeginMessage)message);
                break;
            }
            case 7: {
                this.handleReceiveEnd(reader, (ReceiveMessageEndMessage)message);
                break;
            }
            case 4: {
                this.handleCreateLeaseSet(reader, (CreateLeaseSetMessage)message);
                break;
            }
            case 3: {
                this.handleDestroySession(reader, (DestroySessionMessage)message);
                break;
            }
            case 34: {
                this.handleDestLookup(reader, (DestLookupMessage)message);
                break;
            }
            case 2: {
                this.handleReconfigureSession(reader, (ReconfigureSessionMessage)message);
                break;
            }
            case 8: {
                this.handleGetBWLimits(reader, (GetBandwidthLimitsMessage)message);
                break;
            }
            default: {
                if (!this._log.shouldLog(40)) break;
                this._log.error("Unhandled I2CP type received: " + message.getType());
            }
        }
    }

    public void readError(I2CPMessageReader reader, Exception error) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Error occurred", (Throwable)error);
        }
        this._runner.stopRunning();
    }

    public void disconnected(I2CPMessageReader reader) {
        if (this._runner.isDead()) {
            return;
        }
        this._runner.disconnected();
    }

    private void handleGetDate(I2CPMessageReader reader, GetDateMessage message) {
        block2: {
            String clientVersion = message.getVersion();
            try {
                this._runner.doSend((I2CPMessage)new SetDateMessage(clientVersion != null ? "0.9.3" : null));
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(40)) break block2;
                this._log.error("Error writing out the setDate message", (Throwable)ime);
            }
        }
    }

    private void handleSetDate(I2CPMessageReader reader, SetDateMessage message) {
    }

    private void handleCreateSession(I2CPMessageReader reader, CreateSessionMessage message) {
        Properties props;
        SessionConfig in = message.getSessionConfig();
        if (in.verifySignature()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Signature verified correctly on create session message");
            }
        } else {
            if (this._log.shouldLog(40)) {
                this._log.error("Signature verification *FAILED* on a create session message.  Hijack attempt?");
            }
            this._runner.disconnectClient("Invalid signature on CreateSessionMessage");
            return;
        }
        if (this._enforceAuth && this._context.getBooleanProperty("i2cp.auth")) {
            String configUser = this._context.getProperty("i2cp.username");
            String configPW = this._context.getProperty("i2cp.password");
            if (configUser != null && configPW != null) {
                props = in.getOptions();
                String user = props.getProperty("i2cp.username");
                String pw = props.getProperty("i2cp.password");
                if (user == null || pw == null) {
                    this._log.error("I2CP auth failed for client: " + props.getProperty("inbound.nickname"));
                    this._runner.disconnectClient("Authorization required to create session, specify i2cp.username and i2cp.password in session options");
                    return;
                }
                if (!user.equals(configUser) || !pw.equals(configPW)) {
                    this._log.error("I2CP auth failed for client: " + props.getProperty("inbound.nickname") + " user: " + user);
                    this._runner.disconnectClient("Authorization failed for Create Session, user = " + user);
                    return;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("I2CP auth success for client: " + props.getProperty("inbound.nickname") + " user: " + user);
                }
            }
        }
        SessionId sessionId = new SessionId();
        sessionId.setSessionId(ClientMessageEventListener.getNextSessionId());
        this._runner.setSessionId(sessionId);
        this.sendStatusMessage(1);
        SessionConfig cfg = new SessionConfig(in.getDestination());
        cfg.setSignature(in.getSignature());
        props = new Properties();
        props.putAll((Map<?, ?>)in.getOptions());
        cfg.setOptions(props);
        this._runner.sessionEstablished(cfg);
        if (this._log.shouldLog(10)) {
            this._log.debug("after sessionEstablished for " + message.getSessionConfig().getDestination().calculateHash().toBase64());
        }
        this._context.jobQueue().addJob(new CreateSessionJob(this._context, this._runner));
    }

    private void handleSendMessage(I2CPMessageReader reader, SendMessageMessage message) {
        if (this._log.shouldLog(10)) {
            this._log.debug("handleSendMessage called");
        }
        long beforeDistribute = this._context.clock().now();
        MessageId id = this._runner.distributeMessage(message);
        long timeToDistribute = this._context.clock().now() - beforeDistribute;
        this._runner.ackSendMessage(id, message.getNonce());
        this._context.statManager().addRateData("client.distributeTime", timeToDistribute, timeToDistribute);
        if (timeToDistribute > 50L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to distribute the message (which holds up the ack): " + timeToDistribute);
        }
    }

    private void handleReceiveBegin(I2CPMessageReader reader, ReceiveMessageBeginMessage message) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling recieve begin: id = " + message.getMessageId());
        }
        MessagePayloadMessage msg = new MessagePayloadMessage();
        msg.setMessageId(message.getMessageId());
        msg.setSessionId((long)this._runner.getSessionId().getSessionId());
        Payload payload = this._runner.getPayload(new MessageId(message.getMessageId()));
        if (payload == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Payload for message id [" + message.getMessageId() + "] is null!  Unknown message id?");
            }
            return;
        }
        msg.setPayload(payload);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error delivering the payload", (Throwable)ime);
        }
    }

    private void handleReceiveEnd(I2CPMessageReader reader, ReceiveMessageEndMessage message) {
        this._runner.removePayload(new MessageId(message.getMessageId()));
    }

    private void handleDestroySession(I2CPMessageReader reader, DestroySessionMessage message) {
        if (this._log.shouldLog(20)) {
            this._log.info("Destroying client session " + this._runner.getSessionId());
        }
        this._runner.stopRunning();
    }

    private void handleCreateLeaseSet(I2CPMessageReader reader, CreateLeaseSetMessage message) {
        if (message.getLeaseSet() == null || message.getPrivateKey() == null || message.getSigningPrivateKey() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null lease set granted: " + message);
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("New lease set granted for destination " + message.getLeaseSet().getDestination().calculateHash().toBase64());
        }
        this._context.keyManager().registerKeys(message.getLeaseSet().getDestination(), message.getSigningPrivateKey(), message.getPrivateKey());
        this._context.netDb().publish(message.getLeaseSet());
        this._runner.leaseSetCreated(message.getLeaseSet());
    }

    private void handleDestLookup(I2CPMessageReader reader, DestLookupMessage message) {
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getHash()));
    }

    private void handleReconfigureSession(I2CPMessageReader reader, ReconfigureSessionMessage message) {
        if (this._log.shouldLog(20)) {
            this._log.info("Updating options - old: " + this._runner.getConfig() + " new: " + message.getSessionConfig());
        }
        if (!message.getSessionConfig().getDestination().equals((Object)this._runner.getConfig().getDestination())) {
            this._log.error("Dest mismatch");
            this.sendStatusMessage(3);
            this._runner.stopRunning();
            return;
        }
        this._runner.getConfig().getOptions().putAll((Map<?, ?>)message.getSessionConfig().getOptions());
        ClientTunnelSettings settings = new ClientTunnelSettings();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this._runner.getConfig().getOptions());
        settings.readFromProperties(props);
        this._context.tunnelManager().setInboundSettings(this._runner.getConfig().getDestination().calculateHash(), settings.getInboundSettings());
        this._context.tunnelManager().setOutboundSettings(this._runner.getConfig().getDestination().calculateHash(), settings.getOutboundSettings());
        this.sendStatusMessage(2);
    }

    private void sendStatusMessage(int status) {
        SessionStatusMessage msg = new SessionStatusMessage();
        msg.setSessionId(this._runner.getSessionId());
        msg.setStatus(status);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error writing out the session status message", (Throwable)ime);
        }
    }

    private void handleGetBWLimits(I2CPMessageReader reader, GetBandwidthLimitsMessage message) {
        if (this._log.shouldLog(20)) {
            this._log.info("Got BW Limits request");
        }
        int in = this._context.bandwidthLimiter().getInboundKBytesPerSecond() * 4 / 7;
        int out = this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 4 / 7;
        BandwidthLimitsMessage msg = new BandwidthLimitsMessage(in, out);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error writing out the session status message", (Throwable)ime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getNextSessionId() {
        Object object = _sessionIdLock;
        synchronized (object) {
            int id = ++_id % Short.MAX_VALUE;
            if (_id >= Short.MAX_VALUE) {
                _id = 0;
            }
            return id;
        }
    }
}

