/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.internal.I2CPMessageQueue;
import net.i2p.router.ClientMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientListenerRunner;
import net.i2p.router.client.I2CPMessageQueueImpl;
import net.i2p.router.client.QueuedClientConnectionRunner;
import net.i2p.router.client.SSLClientListenerRunner;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientManager {
    private final Log _log;
    private ClientListenerRunner _listener;
    private final Map<Destination, ClientConnectionRunner> _runners;
    private final Map<Hash, ClientConnectionRunner> _runnersByHash;
    private final Set<ClientConnectionRunner> _pendingRunners;
    private final RouterContext _ctx;
    private volatile boolean _isStarted;
    private static final String PROP_DISABLE_EXTERNAL = "i2cp.disableInterface";
    private static final String PROP_ENABLE_SSL = "i2cp.SSL";
    private static final int INTERNAL_QUEUE_SIZE = 256;
    private static final int REQUEST_LEASESET_TIMEOUT = 120000;

    public ClientManager(RouterContext context, int port) {
        this._ctx = context;
        this._log = context.logManager().getLog(ClientManager.class);
        this._runners = new ConcurrentHashMap<Destination, ClientConnectionRunner>();
        this._runnersByHash = new ConcurrentHashMap<Hash, ClientConnectionRunner>();
        this._pendingRunners = new HashSet<ClientConnectionRunner>();
        this.startListeners(port);
    }

    private void startListeners(int port) {
        if (!this._ctx.getBooleanProperty(PROP_DISABLE_EXTERNAL)) {
            this._listener = this._ctx.getBooleanProperty(PROP_ENABLE_SSL) ? new SSLClientListenerRunner(this._ctx, this, port) : new ClientListenerRunner(this._ctx, this, port);
            I2PThread t = new I2PThread((Runnable)this._listener, "ClientListener:" + port, true);
            t.start();
        }
        this._isStarted = true;
    }

    public synchronized void restart() {
        this.shutdown("Router restart");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int port = this._ctx.getProperty("i2cp.port", 7654);
        this.startListeners(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(String msg) {
        this._isStarted = false;
        this._log.info("Shutting down the ClientManager");
        if (this._listener != null) {
            this._listener.stopListening();
        }
        HashSet<ClientConnectionRunner> runners = new HashSet<ClientConnectionRunner>();
        Object object = this._runners;
        synchronized (object) {
            for (ClientConnectionRunner runner : this._runners.values()) {
                runners.add(runner);
            }
        }
        object = this._pendingRunners;
        synchronized (object) {
            for (ClientConnectionRunner runner : this._pendingRunners) {
                runners.add(runner);
            }
        }
        for (ClientConnectionRunner runner : runners) {
            runner.disconnectClient(msg, 30);
        }
        this._runnersByHash.clear();
    }

    public I2CPMessageQueue internalConnect() throws I2PSessionException {
        if (!this._isStarted) {
            throw new I2PSessionException("Router client manager is shut down");
        }
        LinkedBlockingQueue<I2CPMessage> in = new LinkedBlockingQueue<I2CPMessage>(256);
        LinkedBlockingQueue<I2CPMessage> out = new LinkedBlockingQueue<I2CPMessage>(256);
        I2CPMessageQueueImpl myQueue = new I2CPMessageQueueImpl(in, out);
        I2CPMessageQueueImpl hisQueue = new I2CPMessageQueueImpl(out, in);
        QueuedClientConnectionRunner runner = new QueuedClientConnectionRunner(this._ctx, this, myQueue);
        this.registerConnection(runner);
        return hisQueue;
    }

    public boolean isAlive() {
        return this._isStarted && (this._listener == null || this._listener.isListening());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnection(ClientConnectionRunner runner) {
        try {
            runner.startRunning();
            Set<ClientConnectionRunner> set = this._pendingRunners;
            synchronized (set) {
                this._pendingRunners.add(runner);
            }
        }
        catch (IOException ioe) {
            this._log.error("Error starting up the runner", (Throwable)ioe);
            runner.stopRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnection(ClientConnectionRunner runner) {
        this._log.warn("Unregistering (dropping) a client connection");
        Set<ClientConnectionRunner> set = this._pendingRunners;
        synchronized (set) {
            this._pendingRunners.remove(runner);
        }
        if (runner.getConfig() != null && runner.getConfig().getDestination() != null) {
            Destination dest = runner.getConfig().getDestination();
            Map<Destination, ClientConnectionRunner> map = this._runners;
            synchronized (map) {
                this._runners.remove(dest);
                this._runnersByHash.remove(dest.calculateHash());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destinationEstablished(ClientConnectionRunner runner) {
        Destination dest = runner.getConfig().getDestination();
        if (this._log.shouldLog(10)) {
            this._log.debug("DestinationEstablished called for destination " + dest.calculateHash().toBase64());
        }
        Set<ClientConnectionRunner> set = this._pendingRunners;
        synchronized (set) {
            this._pendingRunners.remove(runner);
        }
        boolean fail = false;
        Map<Destination, ClientConnectionRunner> map = this._runners;
        synchronized (map) {
            fail = this._runnersByHash.containsKey(dest.calculateHash());
            if (!fail) {
                this._runners.put(dest, runner);
                this._runnersByHash.put(dest.calculateHash(), runner);
            }
        }
        if (fail) {
            this._log.log(50, "Client attempted to register duplicate destination " + dest.calculateHash().toBase64());
            runner.disconnectClient("Duplicate destination");
        }
    }

    void distributeMessage(Destination fromDest, Destination toDest, Payload payload, MessageId msgId, long expiration, int flags) {
        ClientConnectionRunner runner = this.getRunner(toDest);
        if (runner != null) {
            ClientConnectionRunner sender;
            if (this._log.shouldLog(10)) {
                this._log.debug("Message " + msgId + " is targeting a local destination.  distribute it as such");
            }
            if ((sender = this.getRunner(fromDest)) == null) {
                return;
            }
            this._ctx.jobQueue().addJob(new DistributeLocal(toDest, runner, sender, fromDest, payload, msgId));
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Message " + msgId + " is targeting a REMOTE destination!  Added to the client message pool");
            }
            if ((runner = this.getRunner(fromDest)) == null) {
                return;
            }
            ClientMessage msg = new ClientMessage();
            msg.setDestination(toDest);
            msg.setPayload(payload);
            msg.setSenderConfig(runner.getConfig());
            msg.setFromDestination(runner.getConfig().getDestination());
            msg.setMessageId(msgId);
            msg.setExpiration(expiration);
            msg.setFlags(flags);
            this._ctx.clientMessagePool().add(msg, true);
        }
    }

    public void requestLeaseSet(Destination dest, LeaseSet set, long timeout, Job onCreateJob, Job onFailedJob) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner == null) {
            if (this._log.shouldLog(40)) {
                this._log.warn("Cannot request the lease set, as we can't find a client runner for " + dest.calculateHash().toBase64() + ".  disconnected?");
            }
            this._ctx.jobQueue().addJob(onFailedJob);
        } else {
            runner.requestLeaseSet(set, this._ctx.clock().now() + timeout, onCreateJob, onFailedJob);
        }
    }

    public void requestLeaseSet(Hash dest, LeaseSet ls) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            runner.requestLeaseSet(ls, 120000L, null, null);
        }
    }

    public boolean isLocal(Destination dest) {
        return this._runners.containsKey(dest);
    }

    public boolean isLocal(Hash destHash) {
        if (destHash == null) {
            return false;
        }
        return this._runnersByHash.containsKey(destHash);
    }

    public boolean shouldPublishLeaseSet(Hash destHash) {
        if (destHash == null) {
            return true;
        }
        ClientConnectionRunner runner = this.getRunner(destHash);
        if (runner == null) {
            return true;
        }
        return !Boolean.parseBoolean(runner.getConfig().getOptions().getProperty("i2cp.dontPublishLeaseSet"));
    }

    public Set<Destination> listClients() {
        HashSet<Destination> rv = new HashSet<Destination>();
        rv.addAll(this._runners.keySet());
        return rv;
    }

    ClientConnectionRunner getRunner(Destination dest) {
        return this._runners.get(dest);
    }

    public SessionConfig getClientSessionConfig(Destination dest) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            return runner.getConfig();
        }
        return null;
    }

    public SessionKeyManager getClientSessionKeyManager(Hash dest) {
        ClientConnectionRunner runner = this.getRunner(dest);
        if (runner != null) {
            return runner.getSessionKeyManager();
        }
        return null;
    }

    private ClientConnectionRunner getRunner(Hash destHash) {
        if (destHash == null) {
            return null;
        }
        return this._runnersByHash.get(destHash);
    }

    public void messageDeliveryStatusUpdate(Destination fromDest, MessageId id, boolean delivered) {
        ClientConnectionRunner runner = this.getRunner(fromDest);
        if (runner != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Delivering status [" + (delivered ? "success" : "failure") + "] to " + fromDest.calculateHash().toBase64() + " for message " + id);
            }
            runner.updateMessageDeliveryStatus(id, delivered);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Cannot deliver status [" + (delivered ? "success" : "failure") + "] to " + fromDest.calculateHash().toBase64() + " for message " + id);
        }
    }

    Set<Destination> getRunnerDestinations() {
        HashSet<Destination> dests = new HashSet<Destination>();
        dests.addAll(this._runners.keySet());
        return dests;
    }

    public void reportAbuse(Destination dest, String reason, int severity) {
        if (dest != null) {
            ClientConnectionRunner runner = this.getRunner(dest);
            if (runner != null) {
                runner.reportAbuse(reason, severity);
            }
        } else {
            Set<Destination> dests = this.getRunnerDestinations();
            for (Destination d : dests) {
                this.reportAbuse(d, reason, severity);
            }
        }
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    public void messageReceived(ClientMessage msg) {
        new HandleJob(msg).runJob();
    }

    private class DistributeLocal
    extends JobImpl {
        private final Destination _toDest;
        private final ClientConnectionRunner _to;
        private final ClientConnectionRunner _from;
        private final Destination _fromDest;
        private final Payload _payload;
        private final MessageId _msgId;

        public DistributeLocal(Destination toDest, ClientConnectionRunner to, ClientConnectionRunner from, Destination fromDest, Payload payload, MessageId id) {
            super(ClientManager.this._ctx);
            this._toDest = toDest;
            this._to = to;
            this._from = from;
            this._fromDest = fromDest;
            this._payload = payload;
            this._msgId = id;
        }

        public String getName() {
            return "Distribute local message";
        }

        public void runJob() {
            this._to.receiveMessage(this._toDest, this._fromDest, this._payload);
            if (this._from != null) {
                this._from.updateMessageDeliveryStatus(this._msgId, true);
            }
        }
    }

    private class HandleJob
    extends JobImpl {
        private final ClientMessage _msg;

        public HandleJob(ClientMessage msg) {
            super(ClientManager.this._ctx);
            this._msg = msg;
        }

        public String getName() {
            return "Handle Inbound Client Messages";
        }

        public void runJob() {
            ClientConnectionRunner runner = this._msg.getDestination() != null ? ClientManager.this.getRunner(this._msg.getDestination()) : ClientManager.this.getRunner(this._msg.getDestinationHash());
            if (runner != null) {
                runner.receiveMessage(this._msg.getDestination(), null, this._msg.getPayload());
            } else if (ClientManager.this._log.shouldLog(30)) {
                ClientManager.this._log.warn("Message received but we don't have a connection to " + this._msg.getDestination() + "/" + this._msg.getDestinationHash() + " currently.  DROPPED");
            }
        }
    }
}

