/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class OutNetMessagePool {
    private final Log _log;
    private final RouterContext _context;

    public OutNetMessagePool(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(OutNetMessagePool.class);
    }

    public void add(OutNetMessage msg) {
        MessageSelector selector;
        boolean valid = this.validate(msg);
        if (!valid) {
            this._context.messageRegistry().unregisterPending(msg);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding outbound message to " + msg.getTarget().getIdentity().getHash().toBase64().substring(0, 6) + " with id " + msg.getMessage().getUniqueId() + " expiring on " + msg.getMessage().getMessageExpiration() + " of type " + msg.getMessageType());
        }
        if ((selector = msg.getReplySelector()) != null) {
            this._context.messageRegistry().registerPending(msg);
        }
        this._context.commSystem().processMessage(msg);
    }

    private boolean validate(OutNetMessage msg) {
        if (msg == null) {
            return false;
        }
        if (msg.getMessage() == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Null message in the OutNetMessage - expired too soon");
            }
            return false;
        }
        if (msg.getTarget() == null) {
            this._log.error("No target in the OutNetMessage: " + msg, (Throwable)new Exception());
            return false;
        }
        if (msg.getPriority() < 0) {
            this._log.error("Priority less than 0?  sounds like nonsense to me... " + msg, (Throwable)new Exception());
            return false;
        }
        if (msg.getExpiration() <= this._context.clock().now()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping expired outbound msg: " + msg, (Throwable)new Exception());
            }
            return false;
        }
        return true;
    }
}

