/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Blocklist {
    private final Log _log;
    private final RouterContext _context;
    private long[] _blocklist;
    private int _blocklistSize;
    private final Object _lock = new Object();
    private Entry _wrapSave;
    private final Set<Hash> _inProcess = new HashSet<Hash>(4);
    private Map<Hash, String> _peerBlocklist = new HashMap<Hash, String>(4);
    private final Set<Integer> _singleIPBlocklist = new ConcurrentHashSet(4);
    static final String PROP_BLOCKLIST_ENABLED = "router.blocklist.enable";
    static final String PROP_BLOCKLIST_DETAIL = "router.blocklist.detail";
    static final String PROP_BLOCKLIST_FILE = "router.blocklist.file";
    static final String BLOCKLIST_FILE_DEFAULT = "blocklist.txt";
    private static final int MAX_DISPLAY = 1000;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public Blocklist(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(Blocklist.class);
    }

    private Blocklist() {
        this._context = null;
        this._log = new Log(Blocklist.class);
    }

    public void startup() {
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_BLOCKLIST_ENABLED)) {
            return;
        }
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE, BLOCKLIST_FILE_DEFAULT);
        ReadinJob job = new ReadinJob(file);
        job.getTiming().setStartAfter(this._context.clock().now() + 120000L);
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this._lock;
        synchronized (object) {
            this._blocklistSize = 0;
            this._blocklist = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBlocklistFile(String file) {
        File BLFile = new File(file);
        if (!BLFile.isAbsolute()) {
            BLFile = new File(this._context.getConfigDir(), file);
        }
        if (BLFile == null || !BLFile.exists() || BLFile.length() <= 0L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Blocklist file not found: " + file);
            }
            return;
        }
        long start = this._context.clock().now();
        int maxSize = this.getSize(BLFile);
        try {
            this._blocklist = new long[maxSize + 1];
        }
        catch (OutOfMemoryError oom) {
            this._log.log(50, "OOM creating the blocklist");
            return;
        }
        int count = 0;
        int badcount = 0;
        int peercount = 0;
        long ipcount = 0L;
        FileInputStream in = null;
        try {
            in = new FileInputStream(BLFile);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            String buf = null;
            while ((buf = br.readLine()) != null && count < maxSize) {
                Entry e = this.parse(buf, true);
                if (e == null) {
                    ++badcount;
                    continue;
                }
                if (e.peer != null) {
                    this._peerBlocklist.put(e.peer, e.comment);
                    ++peercount;
                    continue;
                }
                byte[] ip1 = e.ip1;
                byte[] ip2 = e.ip2;
                this.store(ip1, ip2, count++);
                ipcount += (long)(1 + Blocklist.toInt(ip2) - Blocklist.toInt(ip1));
            }
        }
        catch (IOException ioe) {
            this._blocklist = null;
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the BLFile", (Throwable)ioe);
            }
            return;
        }
        catch (OutOfMemoryError oom) {
            this._blocklist = null;
            this._log.log(50, "OOM reading the blocklist");
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._wrapSave != null) {
            this.store(this._wrapSave.ip1, this._wrapSave.ip2, count++);
            ipcount += (long)(1 + Blocklist.toInt(this._wrapSave.ip2) - Blocklist.toInt(this._wrapSave.ip1));
        }
        int removed = 0;
        try {
            Arrays.sort(this._blocklist, 0, count);
            removed = this.removeOverlap(this._blocklist, count);
            if (removed > 0) {
                Arrays.sort(this._blocklist, 0, count);
            }
        }
        catch (OutOfMemoryError oom) {
            this._blocklist = null;
            this._log.log(50, "OOM sorting the blocklist");
            return;
        }
        this._blocklistSize = count - removed;
        if (this._log.shouldLog(30)) {
            this._log.warn("Removed " + badcount + " bad entries and comment lines");
            this._log.warn("Read " + count + " valid entries from the blocklist " + BLFile);
            this._log.warn("Merged " + removed + " overlapping entries");
            this._log.warn("Result is " + this._blocklistSize + " entries");
            this._log.warn("Blocking " + ipcount + " IPs and " + peercount + " hashes");
            this._log.warn("Blocklist processing finished, time: " + (this._context.clock().now() - start));
        }
    }

    private Entry parse(String buf, boolean bitch) {
        byte[] ip2;
        byte[] ip1;
        byte[] b;
        int start1 = 0;
        int end1 = buf.length();
        if (end1 <= 0) {
            return null;
        }
        if (end1 <= 0) {
            return null;
        }
        int start2 = -1;
        int mask = -1;
        String comment = null;
        int index = buf.indexOf("#");
        if (index == 0) {
            return null;
        }
        index = buf.lastIndexOf(":");
        if (index >= 0) {
            comment = buf.substring(0, index);
            start1 = index + 1;
        }
        if (end1 - start1 == 44 && buf.substring(start1).indexOf(".") < 0 && (b = Base64.decode((String)buf.substring(start1))) != null) {
            return new Entry(comment, Hash.create((byte[])b), null, null);
        }
        index = buf.indexOf("-", start1);
        if (index >= 0) {
            end1 = index;
            start2 = index + 1;
        } else {
            index = buf.indexOf("/", start1);
            if (index >= 0) {
                end1 = index;
                mask = index + 1;
            }
        }
        if (end1 - start1 <= 0) {
            return null;
        }
        try {
            InetAddress pi = InetAddress.getByName(buf.substring(start1, end1));
            if (pi == null) {
                return null;
            }
            ip1 = pi.getAddress();
            if (ip1.length != 4) {
                throw new UnknownHostException();
            }
            if (start2 >= 0) {
                pi = InetAddress.getByName(buf.substring(start2));
                if (pi == null) {
                    return null;
                }
                ip2 = pi.getAddress();
                if (ip2.length != 4) {
                    throw new UnknownHostException();
                }
                if ((ip1[0] & 0xFF) < 128 && (ip2[0] & 0xFF) >= 128) {
                    if (this._wrapSave == null) {
                        this._wrapSave = new Entry(comment, null, new byte[]{-128, 0, 0, 0}, new byte[]{ip2[0], ip2[1], ip2[2], ip2[3]});
                        ip2 = new byte[]{127, -1, -1, -1};
                    } else {
                        throw new NumberFormatException();
                    }
                }
                for (int i = 0; i < 4 && (ip2[i] & 0xFF) <= (ip1[i] & 0xFF); ++i) {
                    if ((ip2[i] & 0xFF) >= (ip1[i] & 0xFF)) continue;
                    throw new NumberFormatException();
                }
            } else if (mask >= 0) {
                int i;
                int m = Integer.parseInt(buf.substring(mask));
                if (m < 3 || m > 32) {
                    throw new NumberFormatException();
                }
                ip2 = new byte[4];
                for (i = 0; i < 4; ++i) {
                    ip2[i] = ip1[i];
                }
                for (i = 0; i < 32 - m; ++i) {
                    int n = (31 - i) / 8;
                    ip2[n] = (byte)(ip2[n] | 1 << i % 8);
                }
            } else {
                ip2 = ip1;
            }
        }
        catch (UnknownHostException uhe) {
            if (bitch && this._log.shouldLog(40)) {
                this._log.error("Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            if (bitch && this._log.shouldLog(40)) {
                this._log.error("Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (bitch && this._log.shouldLog(40)) {
                this._log.error("Format error in the blocklist file: " + buf);
            }
            return null;
        }
        return new Entry(comment, null, ip1, ip2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize(File BLFile) {
        if (!BLFile.exists() || BLFile.length() <= 0L) {
            return 0;
        }
        int lines = 0;
        FileInputStream in = null;
        try {
            in = new FileInputStream(BLFile);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "ISO-8859-1"));
            while (br.readLine() != null) {
                ++lines;
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading the BLFile", (Throwable)ioe);
            }
            int n = 0;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return lines;
    }

    private int removeOverlap(long[] blist, int count) {
        int removed;
        if (count <= 0) {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < count - 1; i += removed + 1) {
            removed = 0;
            int to = Blocklist.getTo(blist[i]);
            for (int next = i + 1; next < count && to >= Blocklist.getFrom(blist[next]); ++next) {
                int nextTo;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Combining entries " + Blocklist.toStr(blist[i]) + " and " + Blocklist.toStr(blist[next]));
                }
                if ((nextTo = Blocklist.getTo(blist[next])) > to) {
                    this.store(Blocklist.getFrom(blist[i]), nextTo, i);
                }
                blist[next] = Long.MAX_VALUE;
                ++lines;
                ++removed;
            }
        }
        return lines;
    }

    public void add(String ip) {
        byte[] pib = Addresses.getIP((String)ip);
        if (pib == null) {
            return;
        }
        this.add(pib);
    }

    public void add(byte[] ip) {
        if (ip.length != 4) {
            return;
        }
        if (this.add(Blocklist.toInt(ip)) && this._log.shouldLog(30)) {
            this._log.warn("Adding IP to blocklist: " + Addresses.toString((byte[])ip));
        }
    }

    private boolean add(int ip) {
        return this._singleIPBlocklist.add(ip);
    }

    private boolean isOnSingleList(int ip) {
        return this._singleIPBlocklist.contains(ip);
    }

    private List<byte[]> getAddresses(Hash peer) {
        ArrayList<byte[]> rv = new ArrayList<byte[]>(1);
        RouterInfo pinfo = this._context.netDb().lookupRouterInfoLocally(peer);
        if (pinfo == null) {
            return rv;
        }
        byte[] oldpib = null;
        for (RouterAddress pa : pinfo.getAddresses()) {
            byte[] pib = pa.getIP();
            if (pib == null || DataHelper.eq(oldpib, (byte[])pib)) continue;
            oldpib = pib;
            rv.add(pib);
        }
        return rv;
    }

    public boolean isBlocklisted(Hash peer) {
        List<byte[]> ips = this.getAddresses(peer);
        for (byte[] ip : ips) {
            if (!this.isBlocklisted(ip)) continue;
            if (!this._context.shitlist().isShitlisted(peer)) {
                this.shitlist(peer, ip);
            }
            return true;
        }
        return false;
    }

    public boolean isBlocklisted(String ip) {
        byte[] pib = Addresses.getIP((String)ip);
        if (pib == null) {
            return false;
        }
        return this.isBlocklisted(pib);
    }

    public boolean isBlocklisted(byte[] ip) {
        if (ip.length != 4) {
            return false;
        }
        return this.isBlocklisted(Blocklist.toInt(ip));
    }

    private boolean isBlocklisted(int ip) {
        if (this.isOnSingleList(ip)) {
            return true;
        }
        int hi = this._blocklistSize - 1;
        if (hi <= 0) {
            return false;
        }
        int lo = 0;
        int cur = hi / 2;
        while (!this.match(ip, cur)) {
            if (this.isHigher(ip, cur)) {
                lo = cur;
            } else {
                hi = cur;
            }
            if (hi - lo <= 1) {
                if (lo == cur) {
                    cur = hi;
                    break;
                }
                cur = lo;
                break;
            }
            cur = lo + (hi - lo) / 2;
        }
        return this.match(ip, cur);
    }

    private boolean match(int ip, int cur) {
        return this.match(ip, this._blocklist[cur]);
    }

    private boolean match(int ip, long entry) {
        if (Blocklist.getFrom(entry) > ip) {
            return false;
        }
        return ip <= Blocklist.getTo(entry);
    }

    private boolean isHigher(int ip, int cur) {
        return ip > Blocklist.getFrom(this._blocklist[cur]);
    }

    private static int getFrom(long entry) {
        return (int)(entry >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getTo(long entry) {
        return (int)(entry & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long toEntry(byte[] ip1, byte[] ip2) {
        int i;
        long entry = 0L;
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip2[i] & 0xFF) << (3 - i) * 8;
        }
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip1[i] & 0xFF) << 32 + (3 - i) * 8;
        }
        return entry;
    }

    private void store(byte[] ip1, byte[] ip2, int idx) {
        this._blocklist[idx] = Blocklist.toEntry(ip1, ip2);
    }

    private void store(int ip1, int ip2, int idx) {
        long entry = (long)ip1 << 32;
        this._blocklist[idx] = entry |= (long)ip2;
    }

    private static int toInt(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return rv;
    }

    private static String toStr(long entry) {
        StringBuilder buf = new StringBuilder(32);
        for (int i = 7; i >= 0; --i) {
            buf.append(entry >> 8 * i & 0xFFL);
            if (i == 4) {
                buf.append('-');
                continue;
            }
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private static String toStr(int ip) {
        StringBuilder buf = new StringBuilder(16);
        for (int i = 3; i >= 0; --i) {
            buf.append(ip >> 8 * i & 0xFF);
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shitlist(Hash peer, byte[] ip) {
        boolean shouldRunJob;
        int number;
        String reason = Blocklist._x("IP banned by blocklist.txt entry {0}");
        this._context.shitlist().shitlistRouterForever(peer, reason, Addresses.toString((byte[])ip));
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_BLOCKLIST_DETAIL)) {
            return;
        }
        Set<Hash> set = this._inProcess;
        synchronized (set) {
            number = this._inProcess.size();
            shouldRunJob = this._inProcess.add(peer);
        }
        if (!shouldRunJob) {
            return;
        }
        ShitlistJob job = new ShitlistJob(peer, this.getAddresses(peer));
        if (number > 0) {
            job.getTiming().setStartAfter(this._context.clock().now() + 30000L * (long)number);
        }
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shitlistForever(Hash peer, List<byte[]> ips) {
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE, BLOCKLIST_FILE_DEFAULT);
        File BLFile = new File(file);
        if (!BLFile.isAbsolute()) {
            BLFile = new File(this._context.getConfigDir(), file);
        }
        if (BLFile == null || !BLFile.exists() || BLFile.length() <= 0L) {
            if (this._log.shouldLog(40)) {
                this._log.error("Blocklist file not found: " + file);
            }
            return;
        }
        for (byte[] ip : ips) {
            int ipint = Blocklist.toInt(ip);
            FileInputStream in = null;
            try {
                in = new FileInputStream(BLFile);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                String buf = null;
                while ((buf = br.readLine()) != null) {
                    Entry e = this.parse(buf, false);
                    if (e == null || e.peer != null) continue;
                    if (!this.match(ipint, Blocklist.toEntry(e.ip1, e.ip2))) continue;
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    String reason = Blocklist._x("IP banned by blocklist.txt entry {0}");
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Shitlisting " + peer + " " + reason);
                    }
                    this._context.shitlist().shitlistRouterForever(peer, reason, buf.toString());
                    return;
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error reading the BLFile", (Throwable)ioe);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void renderStatusHTML(Writer out) throws IOException {
        TreeSet<Integer> singles = new TreeSet<Integer>();
        singles.addAll(this._singleIPBlocklist);
        if (!singles.isEmpty()) {
            int ip;
            Integer ii2;
            out.write("<table><tr><th align=\"center\" colspan=\"2\"><b>");
            out.write(this._("IPs Banned Until Restart"));
            out.write("</b></td></tr>");
            for (Integer ii2 : singles) {
                ip = ii2;
                if (ip < 0) continue;
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(ip));
                out.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            }
            Iterator i$ = singles.iterator();
            while (i$.hasNext() && (ip = (ii2 = (Integer)i$.next()).intValue()) < 0) {
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(ip));
                out.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            }
            out.write("</table>");
        }
        if (this._blocklistSize > 0) {
            int to;
            int from;
            int i;
            out.write("<table><tr><th align=\"center\" colspan=\"2\"><b>");
            out.write(this._("IPs Permanently Banned"));
            out.write("</b></th></tr><tr><td align=\"center\" width=\"50%\"><b>");
            out.write(this._("From"));
            out.write("</b></td><td align=\"center\" width=\"50%\"><b>");
            out.write(this._("To"));
            out.write("</b></td></tr>");
            int max = Math.min(this._blocklistSize, 1000);
            int displayed = 0;
            for (i = 0; i < max; ++i) {
                from = Blocklist.getFrom(this._blocklist[i]);
                if (from < 0) continue;
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(from));
                out.write("</td><td align=\"center\" width=\"50%\">");
                to = Blocklist.getTo(this._blocklist[i]);
                if (to != from) {
                    out.write(Blocklist.toStr(to));
                    out.write("</td></tr>\n");
                } else {
                    out.write("&nbsp;</td></tr>\n");
                }
                ++displayed;
            }
            for (i = 0; i < max && displayed++ < max && (from = Blocklist.getFrom(this._blocklist[i])) < 0; ++i) {
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(from));
                out.write("</td><td align=\"center\" width=\"50%\">");
                to = Blocklist.getTo(this._blocklist[i]);
                if (to != from) {
                    out.write(Blocklist.toStr(to));
                    out.write("</td></tr>\n");
                    continue;
                }
                out.write("&nbsp;</td></tr>\n");
            }
            if (this._blocklistSize > 1000) {
                out.write("<tr><th colspan=2>First 1000 displayed, see the blocklist.txt file for the full list</th></tr>");
            }
            out.write("</table>");
        } else {
            out.write("<br><i>");
            out.write(this._("none"));
            out.write("</i>");
        }
        out.flush();
    }

    private static final String _x(String s) {
        return s;
    }

    private String _(String key) {
        return Translate.getString((String)key, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private static class Entry {
        final String comment;
        final byte[] ip1;
        final byte[] ip2;
        final Hash peer;

        public Entry(String c, Hash h, byte[] i1, byte[] i2) {
            this.comment = c;
            this.peer = h;
            this.ip1 = i1;
            this.ip2 = i2;
        }
    }

    private class ReadinJob
    extends JobImpl {
        private final String _file;

        public ReadinJob(String f) {
            super(Blocklist.this._context);
            this._file = f;
        }

        public String getName() {
            return "Read Blocklist";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            Object object = Blocklist.this._lock;
            synchronized (object) {
                try {
                    Blocklist.this.readBlocklistFile(this._file);
                }
                catch (OutOfMemoryError oom) {
                    Blocklist.this._log.log(50, "OOM processing the blocklist");
                    Blocklist.this.disable();
                    return;
                }
            }
            for (Hash peer : Blocklist.this._peerBlocklist.keySet()) {
                String comment = (String)Blocklist.this._peerBlocklist.get(peer);
                String reason = comment != null ? Blocklist._x("Banned by router hash: {0}") : Blocklist._x("Banned by router hash");
                Blocklist.this._context.shitlist().shitlistRouterForever(peer, reason, comment);
            }
            Blocklist.this._peerBlocklist = null;
            if (Blocklist.this._blocklistSize <= 0) {
                return;
            }
            FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)Blocklist.this._context.netDb();
            int count = 0;
            for (RouterInfo ri : fndf.getKnownRouterData()) {
                Hash peer = ri.getIdentity().getHash();
                if (!Blocklist.this.isBlocklisted(peer)) continue;
                ++count;
            }
            if (count > 0 && Blocklist.this._log.shouldLog(30)) {
                Blocklist.this._log.warn("Blocklisted " + count + " routers in the netDb.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShitlistJob
    extends JobImpl {
        private final Hash _peer;
        private final List<byte[]> _ips;

        public ShitlistJob(Hash p, List<byte[]> ips) {
            super(Blocklist.this._context);
            this._peer = p;
            this._ips = ips;
        }

        @Override
        public String getName() {
            return "Ban Peer by IP";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Blocklist.this.shitlistForever(this._peer, this._ips);
            Set set = Blocklist.this._inProcess;
            synchronized (set) {
                Blocklist.this._inProcess.remove(this._peer);
            }
        }
    }
}

