/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class GarlicClove
extends DataStructureImpl {
    private final Log _log;
    private DeliveryInstructions _instructions;
    private I2NPMessage _msg;
    private long _cloveId;
    private Date _expiration;
    private Certificate _certificate;
    private final I2NPMessageHandler _handler;

    public GarlicClove(RouterContext context) {
        this._log = context.logManager().getLog(GarlicClove.class);
        this._handler = new I2NPMessageHandler(context);
        this._cloveId = -1L;
    }

    public DeliveryInstructions getInstructions() {
        return this._instructions;
    }

    public void setInstructions(DeliveryInstructions instr) {
        this._instructions = instr;
    }

    public I2NPMessage getData() {
        return this._msg;
    }

    public void setData(I2NPMessage msg) {
        this._msg = msg;
    }

    public long getCloveId() {
        return this._cloveId;
    }

    public void setCloveId(long id) {
        this._cloveId = id;
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date exp) {
        this._expiration = exp;
    }

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        this._certificate = cert;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._instructions = new DeliveryInstructions();
        this._instructions.readBytes(in);
        if (this._log.shouldLog(10)) {
            this._log.debug("Read instructions: " + (Object)((Object)this._instructions));
        }
        try {
            this._msg = this._handler.readMessage(in);
        }
        catch (I2NPMessageException ime) {
            throw new DataFormatException("Unable to read the message from a garlic clove", (Throwable)((Object)ime));
        }
        this._cloveId = DataHelper.readLong((InputStream)in, (int)4);
        this._expiration = DataHelper.readDate((InputStream)in);
        if (this._log.shouldLog(10)) {
            this._log.debug("CloveID read: " + this._cloveId + " expiration read: " + this._expiration);
        }
        this._certificate = Certificate.create((InputStream)in);
        if (this._log.shouldLog(10)) {
            this._log.debug("Read cert: " + this._certificate);
        }
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        int cur = offset;
        this._instructions = new DeliveryInstructions();
        cur += this._instructions.readBytes(source, cur);
        if (this._log.shouldLog(10)) {
            this._log.debug("Read instructions: " + (Object)((Object)this._instructions));
        }
        try {
            cur += this._handler.readMessage(source, cur);
            this._msg = this._handler.lastRead();
        }
        catch (I2NPMessageException ime) {
            throw new DataFormatException("Unable to read the message from a garlic clove", (Throwable)((Object)ime));
        }
        this._cloveId = DataHelper.fromLong((byte[])source, (int)cur, (int)4);
        this._expiration = DataHelper.fromDate((byte[])source, (int)(cur += 4));
        cur += 8;
        if (this._log.shouldLog(10)) {
            this._log.debug("CloveID read: " + this._cloveId + " expiration read: " + this._expiration);
        }
        this._certificate = Certificate.create((byte[])source, (int)cur);
        cur += this._certificate.size();
        if (this._log.shouldLog(10)) {
            this._log.debug("Read cert: " + this._certificate);
        }
        return cur - offset;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        StringBuilder error = null;
        if (this._instructions == null) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append("No instructions ");
        }
        if (this._msg == null) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append("No message ");
        }
        if (this._cloveId < 0L) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append("CloveID < 0 [").append(this._cloveId).append("] ");
        }
        if (this._expiration == null) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append("Expiration is null ");
        }
        if (this._certificate == null) {
            if (error == null) {
                error = new StringBuilder();
            }
            error.append("Certificate is null ");
        }
        if (error != null && error.length() > 0) {
            throw new DataFormatException(error.toString());
        }
        this._instructions.writeBytes(out);
        if (this._log.shouldLog(10)) {
            this._log.debug("Wrote instructions: " + (Object)((Object)this._instructions));
        }
        try {
            byte[] m = this._msg.toByteArray();
            if (m == null) {
                throw new RuntimeException("foo, returned null");
            }
            if (m.length <= 0) {
                throw new RuntimeException("foo, returned 0 length");
            }
            out.write(m);
        }
        catch (Exception e) {
            throw new DataFormatException("Unable to write the clove: " + this._msg + " to " + out, (Throwable)e);
        }
        DataHelper.writeLong((OutputStream)out, (int)4, (long)this._cloveId);
        DataHelper.writeDate((OutputStream)out, (Date)this._expiration);
        if (this._log.shouldLog(10)) {
            this._log.debug("CloveID written: " + this._cloveId + " expiration written: " + this._expiration);
        }
        this._certificate.writeBytes(out);
        if (this._log.shouldLog(10)) {
            this._log.debug("Written cert: " + this._certificate);
        }
    }

    public byte[] toByteArray() {
        byte[] m;
        byte[] rv = new byte[this.estimateSize()];
        int offset = 0;
        offset += this._instructions.writeBytes(rv, offset);
        if (this._log.shouldLog(10)) {
            this._log.debug("Wrote instructions: " + (Object)((Object)this._instructions));
        }
        try {
            m = this._msg.toByteArray();
            System.arraycopy(m, 0, rv, offset, m.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write: " + this._msg + ": " + e.getMessage());
        }
        DataHelper.toLong((byte[])rv, (int)(offset += m.length), (int)4, (long)this._cloveId);
        DataHelper.toDate((byte[])rv, (int)(offset += 4), (long)this._expiration.getTime());
        offset += 8;
        offset += this._certificate.writeBytes(rv, offset);
        if (offset != rv.length) {
            this._log.log(50, "Clove offset: " + offset + " but estimated length: " + rv.length);
        }
        return rv;
    }

    public int estimateSize() {
        return this._instructions.getSize() + this._msg.getMessageSize() + 4 + 8 + this._certificate.size();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GarlicClove)) {
            return false;
        }
        GarlicClove clove = (GarlicClove)((Object)obj);
        return DataHelper.eq((Object)this.getCertificate(), (Object)clove.getCertificate()) && this._cloveId == clove.getCloveId() && DataHelper.eq((Object)this.getData(), (Object)clove.getData()) && DataHelper.eq((Object)this.getExpiration(), (Object)clove.getExpiration()) && DataHelper.eq((Object)((Object)this.getInstructions()), (Object)((Object)clove.getInstructions()));
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getCertificate()) + (int)this.getCloveId() + DataHelper.hashCode((Object)this.getData()) + DataHelper.hashCode((Date)this.getExpiration()) + DataHelper.hashCode((Object)((Object)this.getInstructions()));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[GarlicClove: ");
        buf.append("\n\tInstructions: ").append((Object)this.getInstructions());
        buf.append("\n\tCertificate: ").append(this.getCertificate());
        buf.append("\n\tClove ID: ").append(this.getCloveId());
        buf.append("\n\tExpiration: ").append(this.getExpiration());
        buf.append("\n\tData: ").append(this.getData());
        buf.append("]");
        return buf.toString();
    }
}

