/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.kademlia;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.SimpleDataStructure;
import net.i2p.kademlia.KBucket;
import net.i2p.kademlia.KBucketImpl;
import net.i2p.kademlia.KBucketTrimmer;
import net.i2p.kademlia.RandomTrimmer;
import net.i2p.kademlia.SelectionCollector;
import net.i2p.kademlia.XORComparator;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KBucketSet<T extends SimpleDataStructure> {
    private final Log _log;
    private final I2PAppContext _context;
    private final T _us;
    private final List<KBucket> _buckets;
    private final Range<T> _rangeCalc;
    private final KBucketTrimmer _trimmer;
    private final ReentrantReadWriteLock _bucketsLock = new ReentrantReadWriteLock(false);
    private final int KEYSIZE_BITS;
    private final int NUM_BUCKETS;
    private final int BUCKET_SIZE;
    private final int B_VALUE;
    private final int B_FACTOR;

    public KBucketSet(I2PAppContext context, T us, int max, int b) {
        this(context, us, max, b, new RandomTrimmer(context, max));
    }

    public KBucketSet(I2PAppContext context, T us, int max, int b, KBucketTrimmer trimmer) {
        this._us = us;
        this._context = context;
        this._log = context.logManager().getLog(KBucketSet.class);
        this._trimmer = trimmer;
        if (max <= 4 || b <= 0 || b > 8) {
            throw new IllegalArgumentException();
        }
        this.KEYSIZE_BITS = ((SimpleDataStructure)us).length() * 8;
        this.B_VALUE = b;
        this.B_FACTOR = 1 << b - 1;
        this.NUM_BUCKETS = this.KEYSIZE_BITS * this.B_FACTOR;
        this.BUCKET_SIZE = max;
        this._buckets = this.createBuckets();
        this._rangeCalc = new Range<T>(us, this.B_VALUE);
        this.makeKey(new byte[((SimpleDataStructure)us).length()]);
    }

    private void getReadLock() {
        this._bucketsLock.readLock().lock();
    }

    private boolean tryReadLock() {
        return this._bucketsLock.readLock().tryLock();
    }

    private void releaseReadLock() {
        this._bucketsLock.readLock().unlock();
    }

    private boolean getWriteLock() {
        try {
            boolean rv = this._bucketsLock.writeLock().tryLock(3000L, TimeUnit.MILLISECONDS);
            if (!rv && this._log.shouldLog(30)) {
                this._log.warn("no lock, size is: " + this._bucketsLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void releaseWriteLock() {
        this._bucketsLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T peer) {
        KBucket bucket;
        this.getReadLock();
        try {
            bucket = this.getBucket(peer);
        }
        finally {
            this.releaseReadLock();
        }
        if (bucket != null) {
            if (bucket.add(peer)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Peer " + peer + " added to bucket " + bucket);
                }
                if (this.shouldSplit(bucket)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Splitting bucket " + bucket);
                    }
                    this.split(bucket.getRangeBegin());
                }
                return true;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Peer " + peer + " NOT added to bucket " + bucket);
            }
            return false;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Failed to add, probably us: " + peer);
        }
        return false;
    }

    private boolean shouldSplit(KBucket b) {
        return b.getRangeBegin() != b.getRangeEnd() && b.getKeyCount() > this.BUCKET_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(int r) {
        if (!this.getWriteLock()) {
            return;
        }
        try {
            this.locked_split(r);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void locked_split(int r) {
        int b = this.pickBucket(r);
        while (this.shouldSplit(this._buckets.get(b))) {
            KBucket b0 = this._buckets.get(b);
            int s1 = b0.getRangeBegin();
            int e2 = b0.getRangeEnd();
            int s2 = this.B_FACTOR > 1 && (s1 & this.B_FACTOR - 1) == 0 && (e2 + 1 & this.B_FACTOR - 1) == 0 && e2 > s1 + this.B_FACTOR ? e2 + 1 - this.B_FACTOR : s1 + (1 + e2 - s1) / 2;
            int e1 = s2 - 1;
            if (this._log.shouldLog(20)) {
                this._log.info("Splitting (" + s1 + ',' + e2 + ") -> (" + s1 + ',' + e1 + ") (" + s2 + ',' + e2 + ')');
            }
            KBucket b1 = this.createBucket(s1, e1);
            KBucket b2 = this.createBucket(s2, e2);
            for (SimpleDataStructure key : b0.getEntries()) {
                if (this.getRange(key) < s2) {
                    b1.add(key);
                    continue;
                }
                b2.add(key);
            }
            this._buckets.set(b, b1);
            this._buckets.add(b + 1, b2);
            if (this._log.shouldLog(10)) {
                this._log.debug("Split bucket at idx " + b + ":\n" + b0 + "\ninto: " + b1 + "\nand: " + b2);
            }
            if (b2.getKeyCount() <= this.BUCKET_SIZE || !this._log.shouldLog(20)) continue;
            this._log.info("All went into 2nd bucket after split");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int rv = 0;
        this.getReadLock();
        try {
            for (KBucket b : this._buckets) {
                rv += b.getKeyCount();
            }
        }
        finally {
            this.releaseReadLock();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T entry) {
        KBucket kbucket;
        this.getReadLock();
        try {
            kbucket = this.getBucket(entry);
        }
        finally {
            this.releaseReadLock();
        }
        boolean removed = kbucket.remove(entry);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.getReadLock();
        try {
            for (KBucket b : this._buckets) {
                b.clear();
            }
        }
        finally {
            this.releaseReadLock();
        }
        this._rangeCalc.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getAll() {
        HashSet all = new HashSet(256);
        this.getReadLock();
        try {
            for (KBucket b : this._buckets) {
                all.addAll(b.getEntries());
            }
        }
        finally {
            this.releaseReadLock();
        }
        return all;
    }

    public Set<T> getAll(Set<T> toIgnore) {
        Set<T> all = this.getAll();
        all.removeAll(toIgnore);
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAll(SelectionCollector<T> collector) {
        this.getReadLock();
        try {
            for (KBucket b : this._buckets) {
                b.getEntries(collector);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    public List<T> getClosest(int max) {
        return this.getClosest(max, Collections.EMPTY_SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getClosest(int max, Collection<T> toIgnore) {
        ArrayList<SimpleDataStructure> rv = new ArrayList<SimpleDataStructure>(max);
        int count = 0;
        this.getReadLock();
        try {
            for (int i = 0; i < this._buckets.size() && count < max; ++i) {
                Set entries = this._buckets.get(i).getEntries();
                for (SimpleDataStructure e : entries) {
                    if (toIgnore.contains(e)) continue;
                    rv.add(e);
                    ++count;
                }
            }
        }
        finally {
            this.releaseReadLock();
        }
        XORComparator<T> comp = new XORComparator<T>(this._us);
        Collections.sort(rv, comp);
        int sz = rv.size();
        for (int i = sz - 1; i >= max; --i) {
            rv.remove(i);
        }
        return rv;
    }

    public List<T> getClosest(T key, int max) {
        return this.getClosest(key, max, Collections.EMPTY_SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getClosest(T key, int max, Collection<T> toIgnore) {
        if (((SimpleDataStructure)key).equals(this._us)) {
            return this.getClosest(max, toIgnore);
        }
        ArrayList<SimpleDataStructure> rv = new ArrayList<SimpleDataStructure>(max);
        int count = 0;
        this.getReadLock();
        try {
            Set entries;
            int start;
            int i;
            for (i = start = this.pickBucket(key); i >= 0 && count < max; --i) {
                entries = this._buckets.get(i).getEntries();
                for (SimpleDataStructure e : entries) {
                    if (toIgnore.contains(e)) continue;
                    rv.add(e);
                    ++count;
                }
            }
            for (i = start + 1; i < this._buckets.size() && count < max; ++i) {
                entries = this._buckets.get(i).getEntries();
                for (SimpleDataStructure e : entries) {
                    if (toIgnore.contains(e)) continue;
                    rv.add(e);
                    ++count;
                }
            }
        }
        finally {
            this.releaseReadLock();
        }
        XORComparator<T> comp = new XORComparator<T>(key);
        Collections.sort(rv, comp);
        int sz = rv.size();
        for (int i = sz - 1; i >= max; --i) {
            rv.remove(i);
        }
        return rv;
    }

    private int pickBucket(T key) {
        int range = this.getRange(key);
        if (range < 0) {
            return -1;
        }
        int rv = this.pickBucket(range);
        if (rv >= 0) {
            return rv;
        }
        this._log.error("Key does not fit in any bucket?! WTF!\nKey  : [" + DataHelper.toHexString(((SimpleDataStructure)key).getData()) + "]" + "\nUs   : " + this._us + "\nDelta: [" + DataHelper.toHexString(DataHelper.xor(((SimpleDataStructure)this._us).getData(), ((SimpleDataStructure)key).getData())) + "]", new Exception("WTF"));
        this._log.error(this.toString());
        throw new IllegalStateException("pickBucket returned " + rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<KBucket<T>> getBuckets() {
        this.getReadLock();
        try {
            ArrayList<KBucket<T>> arrayList = new ArrayList<KBucket<T>>(this._buckets);
            return arrayList;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private KBucket getBucket(T key) {
        int bucket = this.pickBucket(key);
        if (bucket < 0) {
            return null;
        }
        return this._buckets.get(bucket);
    }

    private int pickBucket(int range) {
        if (this.B_VALUE <= 3) {
            for (int i = this._buckets.size() - 1; i >= 0; --i) {
                KBucket b = this._buckets.get(i);
                if (range < b.getRangeBegin() || range > b.getRangeEnd()) continue;
                return i;
            }
            return -1;
        }
        DummyBucket dummy = new DummyBucket(range);
        return Collections.binarySearch(this._buckets, dummy, new BucketComparator());
    }

    private List<KBucket> createBuckets() {
        ArrayList<KBucket> buckets = new ArrayList<KBucket>(4 * this.B_FACTOR);
        buckets.add(this.createBucket(0, this.NUM_BUCKETS - 1));
        return buckets;
    }

    private KBucket createBucket(int start, int end) {
        if (end - start >= this.B_FACTOR && ((end + 1 & this.B_FACTOR - 1) != 0 || (start & this.B_FACTOR - 1) != 0)) {
            throw new IllegalArgumentException("Sub-bkt crosses K-bkt boundary: " + start + '-' + end);
        }
        KBucketImpl bucket = new KBucketImpl(this._context, start, end, this.BUCKET_SIZE, this._trimmer);
        return bucket;
    }

    int getRange(T key) {
        return this._rangeCalc.getRange(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getExploreKeys(long age) {
        ArrayList<T> rv = new ArrayList<T>(this._buckets.size());
        long old = this._context.clock().now() - age;
        this.getReadLock();
        try {
            for (KBucket b : this._buckets) {
                if (b.getLastChanged() >= old && b.getKeyCount() >= this.BUCKET_SIZE * 3 / 4) continue;
                rv.add(this.generateRandomKey(b));
            }
        }
        finally {
            this.releaseReadLock();
        }
        return rv;
    }

    T generateRandomKey(KBucket bucket) {
        int begin = bucket.getRangeBegin();
        int end = bucket.getRangeEnd();
        int fixed = 0;
        for (int bsz = 1 + end - begin; bsz < this.B_FACTOR; bsz <<= 1) {
            ++fixed;
        }
        int fixedBits = 0;
        if (fixed > 0) {
            int mask = (1 << fixed) - 1;
            fixedBits = begin >> this.B_VALUE - (fixed + 1) & mask;
        }
        int obegin = begin;
        int oend = end;
        BigInteger variance = (begin >>= this.B_VALUE - 1) > 0 ? new BigInteger(begin - fixed, this._context.random()) : BigInteger.ZERO;
        int numNonZero = 1 + (end >>= this.B_VALUE - 1) - begin;
        if (numNonZero == 1) {
            variance = variance.setBit(begin);
            if (fixed > 0) {
                variance = variance.or(BigInteger.valueOf(fixedBits).shiftLeft(begin - fixed));
            }
        } else {
            BigInteger nonz;
            if (fixed > 0) {
                throw new IllegalStateException("WTF " + bucket);
            }
            if (numNonZero <= 62) {
                long nz = 1L + this._context.random().nextLong((1L << numNonZero) - 1L);
                nonz = BigInteger.valueOf(nz);
            } else {
                while ((nonz = new BigInteger(numNonZero, this._context.random())).equals(BigInteger.ZERO)) {
                }
            }
            if (begin > 0) {
                nonz = nonz.shiftLeft(begin);
            }
            variance = variance.or(nonz);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("SB(" + obegin + ',' + oend + ") KB(" + begin + ',' + end + ") fixed=" + fixed + " fixedBits=" + fixedBits + " numNonZ=" + numNonZero);
        }
        byte[] data = variance.toByteArray();
        T key = this.makeKey(data);
        byte[] hash = DataHelper.xor(((SimpleDataStructure)key).getData(), ((SimpleDataStructure)this._us).getData());
        T rv = this.makeKey(hash);
        return rv;
    }

    private T makeKey(byte[] data) {
        SimpleDataStructure rv;
        int dlen = data.length;
        int len = ((SimpleDataStructure)this._us).length();
        if (dlen > len + 1 || dlen == len + 1 && data[0] != 0) {
            throw new IllegalArgumentException("bad length " + dlen + " > " + len);
        }
        try {
            rv = (SimpleDataStructure)this._us.getClass().newInstance();
        }
        catch (Exception e) {
            this._log.error("fail", e);
            throw new RuntimeException(e);
        }
        if (dlen == len) {
            rv.setData(data);
        } else {
            byte[] ndata = new byte[len];
            if (dlen == len + 1) {
                System.arraycopy(data, 1, ndata, 0, len);
            } else {
                System.arraycopy(data, 0, ndata, len - dlen, dlen);
            }
            rv.setData(ndata);
        }
        return (T)rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("Bucket set rooted on: ").append(((SimpleDataStructure)this._us).toString()).append(" K= ").append(this.BUCKET_SIZE).append(" B= ").append(this.B_VALUE).append(" with ").append(this.size()).append(" keys in ").append(this._buckets.size()).append(" buckets:\n");
        this.getReadLock();
        try {
            int len = this._buckets.size();
            for (int i = 0; i < len; ++i) {
                KBucket b = this._buckets.get(i);
                buf.append("* Bucket ").append(i).append("/").append(len).append(": ");
                buf.append(b.toString()).append("\n");
            }
        }
        finally {
            this.releaseReadLock();
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BucketComparator
    implements Comparator<KBucket> {
        private BucketComparator() {
        }

        @Override
        public int compare(KBucket l, KBucket r) {
            if (l.getRangeEnd() < r.getRangeBegin()) {
                return -1;
            }
            if (l.getRangeBegin() > r.getRangeEnd()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyBucket<T extends SimpleDataStructure>
    implements KBucket<T> {
        private final int r;

        public DummyBucket(int range) {
            this.r = range;
        }

        @Override
        public int getRangeBegin() {
            return this.r;
        }

        @Override
        public int getRangeEnd() {
            return this.r;
        }

        @Override
        public int getKeyCount() {
            return 0;
        }

        @Override
        public Set<T> getEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getEntries(SelectionCollector<T> collector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean add(T peer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(T peer) {
            return false;
        }

        @Override
        public void setLastChanged() {
        }

        @Override
        public long getLastChanged() {
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Range<T extends SimpleDataStructure> {
        private final int _bValue;
        private final BigInteger _bigUs;
        private final Map<T, Integer> _distanceCache;

        public Range(T us, int bValue) {
            this._bValue = bValue;
            this._bigUs = new BigInteger(1, ((SimpleDataStructure)us).getData());
            this._distanceCache = new LHMCache<T, Integer>(256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRange(T key) {
            Integer rv;
            Map<T, Integer> map = this._distanceCache;
            synchronized (map) {
                rv = this._distanceCache.get(key);
                if (rv == null) {
                    BigInteger xor = this._bigUs.xor(new BigInteger(1, ((SimpleDataStructure)key).getData()));
                    int range = xor.bitLength() - 1;
                    if (this._bValue > 1) {
                        int toShift = range + 1 - this._bValue;
                        int highbit = range;
                        range <<= this._bValue - 1;
                        if (toShift >= 0) {
                            int extra = xor.clearBit(highbit).shiftRight(toShift).intValue();
                            range += extra;
                        }
                    }
                    rv = range;
                    this._distanceCache.put(key, rv);
                }
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Map<T, Integer> map = this._distanceCache;
            synchronized (map) {
                this._distanceCache.clear();
            }
        }
    }
}

