/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.desktopgui;

import javax.swing.SwingUtilities;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.desktopgui.ExternalTrayManager;
import net.i2p.desktopgui.InternalTrayManager;
import net.i2p.desktopgui.TrayManager;
import net.i2p.router.RouterContext;
import net.i2p.router.app.RouterApp;
import net.i2p.util.I2PProperties;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class Main
implements RouterApp {
    private final I2PAppContext _appContext;
    private final RouterContext _context;
    private final ClientAppManager _mgr;
    private final Log log;
    private ClientAppState _state = ClientAppState.UNINITIALIZED;
    private TrayManager _trayManager;
    public static final String PROP_ENABLE = "desktopgui.enabled";
    private static final String PROP_SWING = "desktopgui.swing";

    public Main(RouterContext ctx, ClientAppManager mgr, String[] args) {
        this._context = ctx;
        this._appContext = this._context;
        this._mgr = mgr;
        this.log = this._appContext.logManager().getLog(Main.class);
        this._state = ClientAppState.INITIALIZED;
    }

    public Main() {
        this._appContext = I2PAppContext.getGlobalContext();
        this._context = this._appContext instanceof RouterContext ? (RouterContext)this._appContext : null;
        this._mgr = null;
        this.log = this._appContext.logManager().getLog(Main.class);
        this._state = ClientAppState.INITIALIZED;
    }

    private synchronized void startUp() throws Exception {
        boolean useSwingDefault = !SystemVersion.isWindows() && !SystemVersion.isMac();
        boolean useSwing = this._appContext.getProperty(PROP_SWING, useSwingDefault);
        final TrayManager trayManager = this._context != null ? new InternalTrayManager(this._context, this, useSwing) : new ExternalTrayManager(this._appContext, this, useSwing);
        trayManager.startManager();
        this._trayManager = trayManager;
        this.changeState(ClientAppState.RUNNING);
        if (this._mgr != null) {
            this._mgr.register((ClientApp)this);
        }
        if (this._context != null) {
            this._context.addPropertyCallback(new I2PProperties.I2PPropertyCallback(){

                public void propertyChanged(String arg0, String arg1) {
                    if (arg0.equals("routerconsole.lang")) {
                        trayManager.languageChanged();
                    }
                }
            });
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.beginStartup(args);
    }

    private void beginStartup(String[] args) {
        this.changeState(ClientAppState.STARTING);
        String headless = System.getProperty("java.awt.headless");
        boolean isHeadless = Boolean.parseBoolean(headless);
        if (isHeadless) {
            this.log.warn("Headless environment: not starting desktopgui!");
            this.changeState(ClientAppState.START_FAILED, "Headless environment: not starting desktopgui!", null);
            return;
        }
        if (this._context == null) {
            Main.launchForeverLoop();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main.this.startUp();
                }
                catch (Exception e) {
                    Main.this.log.error("Failed while running desktopgui!", (Throwable)e);
                    Main.this.changeState(ClientAppState.START_FAILED, "Failed while running desktopgui!", e);
                }
            }
        });
    }

    private static void launchForeverLoop() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object o;
                    Object object = o = new Object();
                    synchronized (object) {
                        o.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r, "DesktopGUI spinner");
        t.setDaemon(false);
        t.start();
    }

    public synchronized void startup() {
        this.beginStartup(null);
    }

    public synchronized void shutdown(String[] args) {
        if (this._state == ClientAppState.STOPPED) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        if (this._trayManager != null) {
            this._trayManager.stopManager();
        }
        this.changeState(ClientAppState.STOPPED);
    }

    public synchronized ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return "desktopgui";
    }

    public String getDisplayName() {
        return "Desktop GUI";
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null, null);
    }

    private synchronized void changeState(ClientAppState state, String msg, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify((ClientApp)this, state, msg, e);
        }
        if (this._context == null) {
            if (msg != null) {
                System.out.println(state + ": " + msg);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }
}

