/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.util.Arrays;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.DataProcessor;

class RpnCalculator {
    private static final byte TKN_VAR = 0;
    private static final byte TKN_NUM = 1;
    private static final byte TKN_PLUS = 2;
    private static final byte TKN_MINUS = 3;
    private static final byte TKN_MULT = 4;
    private static final byte TKN_DIV = 5;
    private static final byte TKN_MOD = 6;
    private static final byte TKN_SIN = 7;
    private static final byte TKN_COS = 8;
    private static final byte TKN_LOG = 9;
    private static final byte TKN_EXP = 10;
    private static final byte TKN_FLOOR = 11;
    private static final byte TKN_CEIL = 12;
    private static final byte TKN_ROUND = 13;
    private static final byte TKN_POW = 14;
    private static final byte TKN_ABS = 15;
    private static final byte TKN_SQRT = 16;
    private static final byte TKN_RANDOM = 17;
    private static final byte TKN_LT = 18;
    private static final byte TKN_LE = 19;
    private static final byte TKN_GT = 20;
    private static final byte TKN_GE = 21;
    private static final byte TKN_EQ = 22;
    private static final byte TKN_IF = 23;
    private static final byte TKN_MIN = 24;
    private static final byte TKN_MAX = 25;
    private static final byte TKN_LIMIT = 26;
    private static final byte TKN_DUP = 27;
    private static final byte TKN_EXC = 28;
    private static final byte TKN_POP = 29;
    private static final byte TKN_UN = 30;
    private static final byte TKN_UNKN = 31;
    private static final byte TKN_NOW = 32;
    private static final byte TKN_TIME = 33;
    private static final byte TKN_PI = 34;
    private static final byte TKN_E = 35;
    private static final byte TKN_AND = 36;
    private static final byte TKN_OR = 37;
    private static final byte TKN_XOR = 38;
    private static final byte TKN_PREV = 39;
    private static final byte TKN_INF = 40;
    private static final byte TKN_NEGINF = 41;
    private static final byte TKN_STEP = 42;
    private static final byte TKN_YEAR = 43;
    private static final byte TKN_MONTH = 44;
    private static final byte TKN_DATE = 45;
    private static final byte TKN_HOUR = 46;
    private static final byte TKN_MINUTE = 47;
    private static final byte TKN_SECOND = 48;
    private static final byte TKN_WEEK = 49;
    private static final byte TKN_SIGN = 50;
    private static final byte TKN_RND = 51;
    private static final byte TKN_ADDNAN = 52;
    private static final byte TKN_NE = 53;
    private static final byte TKN_ISINF = 54;
    private static final byte TKN_ATAN = 55;
    private static final byte TKN_ATAN2 = 56;
    private static final byte TKN_DEG2RAD = 57;
    private static final byte TKN_RAD2DEG = 58;
    private static final byte TKN_COUNT = 59;
    private static final byte TKN_SORT = 60;
    private static final byte TKN_REV = 61;
    private static final byte TKN_AVG = 62;
    private static final byte TKN_LTIME = 63;
    private static final byte TKN_TREND = 64;
    private static final byte TKN_TRENDNAN = 65;
    private static final byte TKN_PREDICT = 66;
    private static final byte TKN_PREDICTSIGMA = 67;
    private String rpnExpression;
    private String sourceName;
    private DataProcessor dataProcessor;
    private Token[] tokens;
    private RpnStack stack = new RpnStack();
    private double[] calculatedValues;
    private long[] timestamps;
    private double timeStep;

    RpnCalculator(String rpnExpression, String sourceName, DataProcessor dataProcessor) throws RrdException {
        this.rpnExpression = rpnExpression;
        this.sourceName = sourceName;
        this.dataProcessor = dataProcessor;
        this.timestamps = dataProcessor.getTimestamps();
        this.timeStep = this.timestamps[1] - this.timestamps[0];
        this.calculatedValues = new double[this.timestamps.length];
        StringTokenizer st = new StringTokenizer(rpnExpression, ", ");
        this.tokens = new Token[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.tokens[i] = this.createToken(st.nextToken());
            ++i;
        }
    }

    private Token createToken(String parsedText) throws RrdException {
        Token token = new Token();
        if (Util.isDouble(parsedText)) {
            token.id = 1;
            token.number = Util.parseDouble(parsedText);
        } else if (parsedText.equals("+")) {
            token.id = (byte)2;
        } else if (parsedText.equals("-")) {
            token.id = (byte)3;
        } else if (parsedText.equals("*")) {
            token.id = (byte)4;
        } else if (parsedText.equals("/")) {
            token.id = (byte)5;
        } else if (parsedText.equals("%")) {
            token.id = (byte)6;
        } else if (parsedText.equals("SIN")) {
            token.id = (byte)7;
        } else if (parsedText.equals("COS")) {
            token.id = (byte)8;
        } else if (parsedText.equals("LOG")) {
            token.id = (byte)9;
        } else if (parsedText.equals("EXP")) {
            token.id = (byte)10;
        } else if (parsedText.equals("FLOOR")) {
            token.id = (byte)11;
        } else if (parsedText.equals("CEIL")) {
            token.id = (byte)12;
        } else if (parsedText.equals("ROUND")) {
            token.id = (byte)13;
        } else if (parsedText.equals("POW")) {
            token.id = (byte)14;
        } else if (parsedText.equals("ABS")) {
            token.id = (byte)15;
        } else if (parsedText.equals("SQRT")) {
            token.id = (byte)16;
        } else if (parsedText.equals("RANDOM")) {
            token.id = (byte)17;
        } else if (parsedText.equals("LT")) {
            token.id = (byte)18;
        } else if (parsedText.equals("LE")) {
            token.id = (byte)19;
        } else if (parsedText.equals("GT")) {
            token.id = (byte)20;
        } else if (parsedText.equals("GE")) {
            token.id = (byte)21;
        } else if (parsedText.equals("EQ")) {
            token.id = (byte)22;
        } else if (parsedText.equals("IF")) {
            token.id = (byte)23;
        } else if (parsedText.equals("MIN")) {
            token.id = (byte)24;
        } else if (parsedText.equals("MAX")) {
            token.id = (byte)25;
        } else if (parsedText.equals("LIMIT")) {
            token.id = (byte)26;
        } else if (parsedText.equals("DUP")) {
            token.id = (byte)27;
        } else if (parsedText.equals("EXC")) {
            token.id = (byte)28;
        } else if (parsedText.equals("POP")) {
            token.id = (byte)29;
        } else if (parsedText.equals("UN")) {
            token.id = (byte)30;
        } else if (parsedText.equals("UNKN")) {
            token.id = (byte)31;
        } else if (parsedText.equals("NOW")) {
            token.id = (byte)32;
        } else if (parsedText.equals("TIME")) {
            token.id = (byte)33;
        } else if (parsedText.equals("LTIME")) {
            token.id = (byte)63;
        } else if (parsedText.equals("PI")) {
            token.id = (byte)34;
        } else if (parsedText.equals("E")) {
            token.id = (byte)35;
        } else if (parsedText.equals("AND")) {
            token.id = (byte)36;
        } else if (parsedText.equals("OR")) {
            token.id = (byte)37;
        } else if (parsedText.equals("XOR")) {
            token.id = (byte)38;
        } else if (parsedText.equals("PREV")) {
            token.id = (byte)39;
            token.variable = this.sourceName;
            token.values = this.calculatedValues;
        } else if (parsedText.startsWith("PREV(") && parsedText.endsWith(")")) {
            token.id = (byte)39;
            token.variable = parsedText.substring(5, parsedText.length() - 1);
            token.values = this.dataProcessor.getValues(token.variable);
        } else if (parsedText.equals("INF")) {
            token.id = (byte)40;
        } else if (parsedText.equals("NEGINF")) {
            token.id = (byte)41;
        } else if (parsedText.equals("STEP")) {
            token.id = (byte)42;
        } else if (parsedText.equals("YEAR")) {
            token.id = (byte)43;
        } else if (parsedText.equals("MONTH")) {
            token.id = (byte)44;
        } else if (parsedText.equals("DATE")) {
            token.id = (byte)45;
        } else if (parsedText.equals("HOUR")) {
            token.id = (byte)46;
        } else if (parsedText.equals("MINUTE")) {
            token.id = (byte)47;
        } else if (parsedText.equals("SECOND")) {
            token.id = (byte)48;
        } else if (parsedText.equals("WEEK")) {
            token.id = (byte)49;
        } else if (parsedText.equals("SIGN")) {
            token.id = (byte)50;
        } else if (parsedText.equals("RND")) {
            token.id = (byte)51;
        } else if (parsedText.equals("ADDNAN")) {
            token.id = (byte)52;
        } else if (parsedText.equals("NE")) {
            token.id = (byte)53;
        } else if (parsedText.equals("ISINF")) {
            token.id = (byte)54;
        } else if (parsedText.equals("ATAN")) {
            token.id = (byte)55;
        } else if (parsedText.equals("ATAN2")) {
            token.id = (byte)56;
        } else if (parsedText.equals("DEG2RAD")) {
            token.id = (byte)57;
        } else if (parsedText.equals("RAD2DEG")) {
            token.id = (byte)58;
        } else if (parsedText.equals("COUNT")) {
            token.id = (byte)59;
        } else if (parsedText.equals("SORT")) {
            token.id = (byte)60;
        } else if (parsedText.equals("REV")) {
            token.id = (byte)61;
        } else if (parsedText.equals("AVG")) {
            token.id = (byte)62;
        } else if (parsedText.equals("TREND")) {
            token.id = (byte)64;
        } else if (parsedText.equals("TRENDNAN")) {
            token.id = (byte)65;
        } else if (parsedText.equals("PREDICT")) {
            token.id = (byte)66;
        } else if (parsedText.equals("PREDICTSIGMA")) {
            token.id = (byte)67;
        } else {
            token.id = 0;
            token.variable = parsedText;
            token.values = this.dataProcessor.getValues(token.variable);
        }
        return token;
    }

    double[] calculateValues() throws RrdException {
        TimeZone tz = TimeZone.getDefault();
        for (int slot = 0; slot < this.timestamps.length; ++slot) {
            this.resetStack();
            int token_rpi = -1;
            block69: for (int rpi = 0; rpi < this.tokens.length; ++rpi) {
                Token token = this.tokens[rpi];
                switch (token.id) {
                    case 1: {
                        this.push(token.number);
                        continue block69;
                    }
                    case 0: {
                        this.push(token.values[slot]);
                        token_rpi = rpi;
                        continue block69;
                    }
                    case 59: {
                        this.push(slot + 1);
                        continue block69;
                    }
                    case 2: {
                        this.push(this.pop() + this.pop());
                        continue block69;
                    }
                    case 3: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 - x2);
                        continue block69;
                    }
                    case 4: {
                        this.push(this.pop() * this.pop());
                        continue block69;
                    }
                    case 5: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 / x2);
                        continue block69;
                    }
                    case 6: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 % x2);
                        continue block69;
                    }
                    case 7: {
                        this.push(Math.sin(this.pop()));
                        continue block69;
                    }
                    case 8: {
                        this.push(Math.cos(this.pop()));
                        continue block69;
                    }
                    case 55: {
                        this.push(Math.atan(this.pop()));
                        continue block69;
                    }
                    case 56: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(Math.atan2(x1, x2));
                        continue block69;
                    }
                    case 9: {
                        this.push(Math.log(this.pop()));
                        continue block69;
                    }
                    case 10: {
                        this.push(Math.exp(this.pop()));
                        continue block69;
                    }
                    case 11: {
                        this.push(Math.floor(this.pop()));
                        continue block69;
                    }
                    case 12: {
                        this.push(Math.ceil(this.pop()));
                        continue block69;
                    }
                    case 13: {
                        this.push(Math.round(this.pop()));
                        continue block69;
                    }
                    case 14: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(Math.pow(x1, x2));
                        continue block69;
                    }
                    case 15: {
                        this.push(Math.abs(this.pop()));
                        continue block69;
                    }
                    case 16: {
                        this.push(Math.sqrt(this.pop()));
                        continue block69;
                    }
                    case 17: {
                        this.push(Math.random());
                        continue block69;
                    }
                    case 18: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 < x2 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 19: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 <= x2 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 20: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 > x2 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 21: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 >= x2 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 22: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 == x2 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 53: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 != x2 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 23: {
                        double x3 = this.pop();
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 != 0.0 ? x2 : x3);
                        continue block69;
                    }
                    case 24: {
                        this.push(Math.min(this.pop(), this.pop()));
                        continue block69;
                    }
                    case 25: {
                        this.push(Math.max(this.pop(), this.pop()));
                        continue block69;
                    }
                    case 26: {
                        double x3 = this.pop();
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 < x2 || x1 > x3 ? Double.NaN : x1);
                        continue block69;
                    }
                    case 27: {
                        this.push(this.peek());
                        continue block69;
                    }
                    case 28: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x2);
                        this.push(x1);
                        continue block69;
                    }
                    case 29: {
                        this.pop();
                        continue block69;
                    }
                    case 30: {
                        this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 54: {
                        this.push(Double.isInfinite(this.pop()) ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 31: {
                        this.push(Double.NaN);
                        continue block69;
                    }
                    case 32: {
                        this.push(Util.getTime());
                        continue block69;
                    }
                    case 33: {
                        this.push(this.timestamps[slot]);
                        continue block69;
                    }
                    case 63: {
                        this.push(this.timestamps[slot] + (long)tz.getOffset(this.timestamps[slot]) / 1000L);
                        continue block69;
                    }
                    case 34: {
                        this.push(Math.PI);
                        continue block69;
                    }
                    case 35: {
                        this.push(Math.E);
                        continue block69;
                    }
                    case 36: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 != 0.0 && x2 != 0.0 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 37: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 != 0.0 || x2 != 0.0 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 38: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        this.push(x1 != 0.0 && x2 == 0.0 || x1 == 0.0 && x2 != 0.0 ? 1.0 : 0.0);
                        continue block69;
                    }
                    case 39: {
                        this.push(slot == 0 ? Double.NaN : token.values[slot - 1]);
                        continue block69;
                    }
                    case 40: {
                        this.push(Double.POSITIVE_INFINITY);
                        continue block69;
                    }
                    case 41: {
                        this.push(Double.NEGATIVE_INFINITY);
                        continue block69;
                    }
                    case 42: {
                        this.push(this.timeStep);
                        continue block69;
                    }
                    case 43: {
                        this.push(this.getCalendarField(this.pop(), 1));
                        continue block69;
                    }
                    case 44: {
                        this.push(this.getCalendarField(this.pop(), 2));
                        continue block69;
                    }
                    case 45: {
                        this.push(this.getCalendarField(this.pop(), 5));
                        continue block69;
                    }
                    case 46: {
                        this.push(this.getCalendarField(this.pop(), 11));
                        continue block69;
                    }
                    case 47: {
                        this.push(this.getCalendarField(this.pop(), 12));
                        continue block69;
                    }
                    case 48: {
                        this.push(this.getCalendarField(this.pop(), 13));
                        continue block69;
                    }
                    case 49: {
                        this.push(this.getCalendarField(this.pop(), 3));
                        continue block69;
                    }
                    case 50: {
                        double x1 = this.pop();
                        this.push(Double.isNaN(x1) ? Double.NaN : (x1 > 0.0 ? 1.0 : (x1 < 0.0 ? -1.0 : 0.0)));
                        continue block69;
                    }
                    case 51: {
                        this.push(Math.floor(this.pop() * Math.random()));
                        continue block69;
                    }
                    case 52: {
                        double x2 = this.pop();
                        double x1 = this.pop();
                        if (Double.isNaN(x1)) {
                            this.push(x2);
                            continue block69;
                        }
                        if (Double.isNaN(x2)) {
                            this.push(x1);
                            continue block69;
                        }
                        this.push(x1 + x2);
                        continue block69;
                    }
                    case 57: {
                        this.push(Math.toRadians(this.pop()));
                        continue block69;
                    }
                    case 58: {
                        this.push(Math.toDegrees(this.pop()));
                        continue block69;
                    }
                    case 60: {
                        int i;
                        int n = (int)this.pop();
                        double[] array = new double[n];
                        for (i = 0; i < n; ++i) {
                            array[i] = this.pop();
                        }
                        Arrays.sort(array);
                        for (i = 0; i < n; ++i) {
                            this.push(array[i]);
                        }
                        continue block69;
                    }
                    case 61: {
                        int i;
                        int n = (int)this.pop();
                        double[] array = new double[n];
                        for (i = 0; i < n; ++i) {
                            array[i] = this.pop();
                        }
                        for (i = 0; i < n; ++i) {
                            this.push(array[i]);
                        }
                        continue block69;
                    }
                    case 62: {
                        double x1;
                        int count = 0;
                        double sum = 0.0;
                        for (int n = (int)this.pop(); n > 0; --n) {
                            x1 = this.pop();
                            if (Double.isNaN(x1)) continue;
                            sum += x1;
                            ++count;
                        }
                        if (count > 0) {
                            this.push(sum / (double)count);
                            continue block69;
                        }
                        this.push(Double.NaN);
                        continue block69;
                    }
                    case 64: 
                    case 65: {
                        int dur = (int)this.pop();
                        this.pop();
                        if ((double)(slot + 1) < Math.ceil((double)dur / this.timeStep)) {
                            this.push(Double.NaN);
                            continue block69;
                        }
                        double[] vals = this.dataProcessor.getValues(this.tokens[token_rpi].variable);
                        boolean ignorenan = token.id == 65;
                        double accum = 0.0;
                        int count = 0;
                        int start = (int)Math.ceil((double)dur / this.timeStep);
                        int row = 2;
                        while (slot + row > vals.length) {
                            --row;
                        }
                        while (start > 0) {
                            double val = vals[slot + row - start];
                            if (ignorenan || !Double.isNaN(val)) {
                                accum = Util.sum(accum, val);
                                ++count;
                            }
                            --start;
                        }
                        this.push(count == 0 ? Double.NaN : accum / (double)count);
                        continue block69;
                    }
                    case 66: 
                    case 67: {
                        double[] multipliers;
                        this.pop();
                        int locstepsize = (int)this.pop();
                        int num_shifts = (int)this.pop();
                        if (num_shifts < 0) {
                            multipliers = new double[]{this.pop()};
                        } else {
                            multipliers = new double[num_shifts];
                            for (int i = 0; i < num_shifts; ++i) {
                                multipliers[i] = this.pop();
                            }
                        }
                        double val = Double.NaN;
                        double[] vals = this.dataProcessor.getValues(this.tokens[rpi - 1].variable);
                        int locstep = (int)Math.ceil((float)locstepsize / (float)this.timeStep);
                        double sum = 0.0;
                        double sum2 = 0.0;
                        int count = 0;
                        int doshifts = Math.abs(num_shifts);
                        for (int loop = 0; loop < doshifts; ++loop) {
                            int shiftstep = 1;
                            shiftstep = num_shifts < 0 ? loop * (int)multipliers[0] : (int)multipliers[loop];
                            if (shiftstep < 0) {
                                throw new RrdException("negative shift step not allowed: " + shiftstep);
                            }
                            shiftstep = (int)Math.ceil((float)shiftstep / (float)this.timeStep);
                            for (int i = 0; i <= locstep; ++i) {
                                int offset = shiftstep + i;
                                if (offset < 0 || offset >= slot || Double.isNaN(val = vals[slot - offset])) continue;
                                sum = Util.sum(sum, val);
                                sum2 = Util.sum(sum2, val * val);
                                ++count;
                            }
                        }
                        val = Double.NaN;
                        if (token.id == 66) {
                            if (count > 0) {
                                val = sum / (double)count;
                            }
                        } else if (count > 1) {
                            val = (double)count * sum2 - sum * sum;
                            val = val < 0.0 ? Double.NaN : Math.sqrt(val / ((double)count * ((double)count - 1.0)));
                        }
                        this.push(val);
                        continue block69;
                    }
                    default: {
                        throw new RrdException("Unexpected RPN token encountered, token.id=" + token.id);
                    }
                }
            }
            this.calculatedValues[slot] = this.pop();
            if (slot != 0 || this.isStackEmpty()) continue;
            throw new RrdException("Stack not empty at the end of calculation. Probably bad RPN expression [" + this.rpnExpression + "]");
        }
        return this.calculatedValues;
    }

    private double getCalendarField(double timestamp, int field) {
        Calendar calendar = Util.getCalendar((long)timestamp);
        return calendar.get(field);
    }

    private void push(double x) throws RrdException {
        this.stack.push(x);
    }

    private double pop() throws RrdException {
        return this.stack.pop();
    }

    private double peek() throws RrdException {
        return this.stack.peek();
    }

    private void resetStack() {
        this.stack.reset();
    }

    private boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    private static final class RpnStack {
        private static final int MAX_STACK_SIZE = 1000;
        private double[] stack = new double[1000];
        private int pos = 0;

        private RpnStack() {
        }

        void push(double x) throws RrdException {
            if (this.pos >= 1000) {
                throw new RrdException("PUSH failed, RPN stack full [1000]");
            }
            this.stack[this.pos++] = x;
        }

        double pop() throws RrdException {
            if (this.pos <= 0) {
                throw new RrdException("POP failed, RPN stack is empty ");
            }
            return this.stack[--this.pos];
        }

        double peek() throws RrdException {
            if (this.pos <= 0) {
                throw new RrdException("PEEK failed, RPN stack is empty ");
            }
            return this.stack[this.pos - 1];
        }

        void reset() {
            this.pos = 0;
        }

        boolean isEmpty() {
            return this.pos <= 0;
        }
    }

    private static final class Token {
        byte id = (byte)-1;
        double number = Double.NaN;
        String variable = null;
        double[] values = null;

        private Token() {
        }
    }
}

