/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Properties;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMDatagramSession;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMv3DatagramServer;
import net.i2p.sam.SAMv3Handler;
import net.i2p.sam.SAMv3RawSession;
import net.i2p.sam.Session;
import net.i2p.sam.SessionRecord;

class SAMv3DatagramSession
extends SAMDatagramSession
implements Session,
SAMDatagramReceiver {
    private final SAMv3Handler handler;
    private final SAMv3DatagramServer server;
    private final String nick;
    private final SocketAddress clientAddress;

    @Override
    public String getNick() {
        return this.nick;
    }

    public SAMv3DatagramSession(String nick, SAMv3DatagramServer dgServer) throws IOException, DataFormatException, I2PSessionException, SAMException {
        super(SAMv3Handler.sSessionsHash.get(nick).getDest(), SAMv3Handler.sSessionsHash.get(nick).getProps(), null);
        this.nick = nick;
        this.recv = this;
        this.server = dgServer;
        SessionRecord rec = SAMv3Handler.sSessionsHash.get(nick);
        if (rec == null) {
            throw new SAMException("Record disappeared for nickname : \"" + nick + "\"");
        }
        this.handler = rec.getHandler();
        Properties props = rec.getProps();
        this.clientAddress = SAMv3RawSession.getSocketAddress(props, this.handler);
    }

    public SAMv3DatagramSession(String nick, Properties props, SAMv3Handler handler, I2PSession isess, int listenPort, SAMv3DatagramServer dgServer) throws IOException, DataFormatException, I2PSessionException {
        super(isess, props, listenPort, null);
        this.nick = nick;
        this.recv = this;
        this.server = dgServer;
        this.handler = handler;
        this.clientAddress = SAMv3RawSession.getSocketAddress(props, handler);
    }

    @Override
    public void receiveDatagramBytes(Destination sender, byte[] data, int proto, int fromPort, int toPort) throws IOException {
        if (this.clientAddress == null) {
            this.handler.receiveDatagramBytes(sender, data, proto, fromPort, toPort);
        } else {
            StringBuilder buf = new StringBuilder(600);
            buf.append(sender.toBase64());
            if (this.handler.verMajor == 3 && this.handler.verMinor >= 2 || this.handler.verMajor > 3) {
                buf.append(" FROM_PORT=").append(fromPort).append(" TO_PORT=").append(toPort);
            }
            buf.append('\n');
            String msg = buf.toString();
            ByteBuffer msgBuf = ByteBuffer.allocate(msg.length() + data.length);
            msgBuf.put(DataHelper.getASCII(msg));
            msgBuf.put(data);
            msgBuf.flip();
            this.server.send(this.clientAddress, msgBuf);
        }
    }

    @Override
    public void stopDatagramReceiving() {
    }
}

