/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;

class ProfileOrganizerRenderer {
    private final RouterContext _context;
    private final ProfileOrganizer _organizer;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00");
    private static final String NA = HelperBase._x("n/a");

    public ProfileOrganizerRenderer(ProfileOrganizer organizer, RouterContext context) {
        this._context = context;
        this._organizer = organizer;
    }

    public void renderStatusHTML(Writer out, int mode) throws IOException {
        boolean full = mode == 1;
        Set<Hash> peers = this._organizer.selectAllPeers();
        long now = this._context.clock().now();
        long hideBefore = now - 5400000L;
        TreeSet<PeerProfile> order = new TreeSet<PeerProfile>(mode == 2 ? new HashComparator() : new ProfileComparator());
        int older = 0;
        int standard = 0;
        for (Hash peer : peers) {
            PeerProfile prof;
            if (this._organizer.getUs().equals(peer) || (prof = this._organizer.getProfileNonblocking(peer)) == null) continue;
            if (mode == 2) {
                RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
                if (info == null || info.getCapabilities().indexOf(102) < 0) continue;
                order.add(prof);
                continue;
            }
            if (prof.getLastSendSuccessful() <= hideBefore) {
                ++older;
                continue;
            }
            if (!full && !this._organizer.isHighCapacity(peer)) {
                ++standard;
                continue;
            }
            order.add(prof);
        }
        int fast = 0;
        int reliable = 0;
        int integrated = 0;
        StringBuilder buf = new StringBuilder(16384);
        if (mode < 2) {
            buf.append(this.ngettext("Showing 1 recent profile.", "Showing {0} recent profiles.", order.size())).append('\n');
            if (older > 0) {
                buf.append(this.ngettext("Hiding 1 older profile.", "Hiding {0} older profiles.", older)).append('\n');
            }
            if (standard > 0) {
                buf.append("<a href=\"/profiles?f=1\">").append(this.ngettext("Hiding 1 standard profile.", "Hiding {0} standard profiles.", standard)).append("</a>\n");
            }
            buf.append("</p>");
            buf.append("<table>");
            buf.append("<tr>");
            buf.append("<th>").append(this._t("Peer")).append("</th>");
            buf.append("<th>").append(this._t("Groups (Caps)")).append("</th>");
            buf.append("<th>").append(this._t("Speed")).append("</th>");
            buf.append("<th>").append(this._t("Capacity")).append("</th>");
            buf.append("<th>").append(this._t("Integration")).append("</th>");
            buf.append("<th>").append(this._t("Status")).append("</th>");
            buf.append("<th>&nbsp;</th>");
            buf.append("</tr>");
            int prevTier = 1;
            for (PeerProfile prof : order) {
                Rate accepted;
                long total;
                RouterInfo info;
                Hash peer = prof.getPeer();
                int tier = 0;
                boolean isIntegrated = false;
                if (this._organizer.isFast(peer)) {
                    tier = 1;
                    ++fast;
                    ++reliable;
                } else if (this._organizer.isHighCapacity(peer)) {
                    tier = 2;
                    ++reliable;
                } else if (!this._organizer.isFailing(peer)) {
                    tier = 3;
                }
                if (this._organizer.isWellIntegrated(peer)) {
                    isIntegrated = true;
                    ++integrated;
                }
                if (tier != prevTier) {
                    buf.append("<tr><td colspan=\"7\"><hr></td></tr>\n");
                }
                prevTier = tier;
                buf.append("<tr><td align=\"center\" nowrap>");
                buf.append(this._context.commSystem().renderPeerHTML(peer));
                buf.append("</td><td align=\"center\">");
                switch (tier) {
                    case 1: {
                        buf.append(this._t("Fast, High Capacity"));
                        break;
                    }
                    case 2: {
                        buf.append(this._t("High Capacity"));
                        break;
                    }
                    case 3: {
                        buf.append(this._t("Standard"));
                        break;
                    }
                    default: {
                        buf.append(this._t("Failing"));
                    }
                }
                if (isIntegrated) {
                    buf.append(", ").append(this._t("Integrated"));
                }
                if ((info = this._context.netDb().lookupRouterInfoLocally(peer)) != null) {
                    buf.append(" (").append(DataHelper.stripHTML(info.getCapabilities()));
                    String v = info.getOption("router.version");
                    if (v != null) {
                        buf.append(' ').append(DataHelper.stripHTML(v));
                    }
                    buf.append(')');
                }
                buf.append("<td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getSpeedValue()));
                long bonus = prof.getSpeedBonus();
                if (bonus != 0L) {
                    if (bonus > 0L) {
                        buf.append(" (+");
                    } else {
                        buf.append(" (");
                    }
                    buf.append(bonus).append(')');
                }
                buf.append("</td><td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getCapacityValue()));
                bonus = prof.getCapacityBonus();
                if (bonus != 0L) {
                    if (bonus > 0L) {
                        buf.append(" (+");
                    } else {
                        buf.append(" (");
                    }
                    buf.append(bonus).append(')');
                }
                buf.append("</td><td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getIntegrationValue()));
                buf.append("</td><td align=\"center\">");
                if (this._context.banlist().isBanlisted(peer)) {
                    buf.append(this._t("Banned"));
                }
                if (prof.getIsFailing()) {
                    buf.append(' ').append(this._t("Failing"));
                }
                if (this._context.commSystem().wasUnreachable(peer)) {
                    buf.append(' ').append(this._t("Unreachable"));
                }
                RateAverages ra = RateAverages.getTemp();
                Rate failed = prof.getTunnelHistory().getFailedRate().getRate(1800000L);
                long fails = failed.computeAverages(ra, false).getTotalEventCount();
                if (fails > 0L && (total = fails + (accepted = prof.getTunnelCreateResponseTime().getRate(1800000L)).computeAverages(ra, false).getTotalEventCount()) / fails <= 10L) {
                    buf.append(' ').append(fails).append('/').append(total).append(' ').append(this._t("Test Fails"));
                }
                buf.append("&nbsp;</td>");
                buf.append("<td nowrap align=\"center\"><a href=\"viewprofile?peer=").append(peer.toBase64()).append("\">").append(this._t("profile")).append("</a>");
                buf.append("&nbsp;<a href=\"configpeer?peer=").append(peer.toBase64()).append("\">+-</a></td>\n");
                buf.append("</tr>");
                out.write(buf.toString());
                buf.setLength(0);
            }
            buf.append("</table>");
        } else {
            buf.append("<table>");
            buf.append("<tr>");
            buf.append("<th class=\"smallhead\">").append(this._t("Peer")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Caps")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Integ. Value")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Heard About")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Heard From")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Good Send")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Bad Send")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("10m Resp. Time")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("1h Resp. Time")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("1d Resp. Time")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Good Lookup")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Bad Lookup")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Good Store")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("Last Bad Store")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("1h Fail Rate")).append("</th>");
            buf.append("<th class=\"smallhead\">").append(this._t("1d Fail Rate")).append("</th>");
            buf.append("</tr>");
            RateAverages ra = RateAverages.getTemp();
            for (PeerProfile prof : order) {
                Hash peer = prof.getPeer();
                buf.append("<tr><td align=\"center\" nowrap>");
                buf.append(this._context.commSystem().renderPeerHTML(peer));
                buf.append("</td>");
                RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
                if (info != null) {
                    buf.append("<td align=\"center\">").append(DataHelper.stripHTML(info.getCapabilities())).append("</td>");
                } else {
                    buf.append("<td>&nbsp;</td>");
                }
                buf.append("<td align=\"right\">").append(ProfileOrganizerRenderer.num(prof.getIntegrationValue())).append("</td>");
                buf.append("<td align=\"right\">").append(this.formatInterval(now, prof.getLastHeardAbout())).append("</td>");
                buf.append("<td align=\"right\">").append(this.formatInterval(now, prof.getLastHeardFrom())).append("</td>");
                buf.append("<td align=\"right\">").append(this.formatInterval(now, prof.getLastSendSuccessful())).append("</td>");
                buf.append("<td align=\"right\">").append(this.formatInterval(now, prof.getLastSendFailed())).append("</td>");
                buf.append("<td align=\"right\">").append(this.avg(prof, 600000L, ra)).append("</td>");
                buf.append("<td align=\"right\">").append(this.avg(prof, 3600000L, ra)).append("</td>");
                buf.append("<td align=\"right\">").append(this.avg(prof, 86400000L, ra)).append("</td>");
                DBHistory dbh = prof.getDBHistory();
                if (dbh != null) {
                    buf.append("<td align=\"right\">").append(this.formatInterval(now, dbh.getLastLookupSuccessful())).append("</td>");
                    buf.append("<td align=\"right\">").append(this.formatInterval(now, dbh.getLastLookupFailed())).append("</td>");
                    buf.append("<td align=\"right\">").append(this.formatInterval(now, dbh.getLastStoreSuccessful())).append("</td>");
                    buf.append("<td align=\"right\">").append(this.formatInterval(now, dbh.getLastStoreFailed())).append("</td>");
                    buf.append("<td align=\"right\">").append(this.davg(dbh, 3600000L, ra)).append("</td>");
                    buf.append("<td align=\"right\">").append(this.davg(dbh, 86400000L, ra)).append("</td>");
                } else {
                    for (int i = 0; i < 6; ++i) {
                        buf.append("<td align=\"right\">").append(this._t(NA));
                    }
                }
                buf.append("</tr>\n");
            }
            buf.append("</table>");
        }
        if (mode < 2) {
            buf.append("<h3>").append(this._t("Thresholds")).append("</h3>");
            buf.append("<p><b>").append(this._t("Speed")).append(":</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getSpeedThreshold())).append(" (").append(fast).append(' ').append(this._t("fast peers")).append(")<br>");
            buf.append("<b>").append(this._t("Capacity")).append(":</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getCapacityThreshold())).append(" (").append(reliable).append(' ').append(this._t("high capacity peers")).append(")<br>");
            buf.append("<b>").append(this._t("Integration")).append(":</b> ").append(ProfileOrganizerRenderer.num(this._organizer.getIntegrationThreshold())).append(" (").append(integrated).append(' ').append(this._t(" well integrated peers")).append(")</p>");
            buf.append("<h3>").append(this._t("Definitions")).append("</h3><ul>");
            buf.append("<li><b>").append(this._t("groups")).append("</b>: ").append(this._t("as determined by the profile organizer")).append("</li>");
            buf.append("<li><b>").append(this._t("caps")).append("</b>: ").append(this._t("capabilities in the netDb, not used to determine profiles")).append("</li>");
            buf.append("<li><b>").append(this._t("speed")).append("</b>: ").append(this._t("peak throughput (bytes per second) over a 1 minute period that the peer has sustained in a single tunnel")).append("</li>");
            buf.append("<li><b>").append(this._t("capacity")).append("</b>: ").append(this._t("how many tunnels can we ask them to join in an hour?")).append("</li>");
            buf.append("<li><b>").append(this._t("integration")).append("</b>: ").append(this._t("how many new peers have they told us about lately?")).append("</li>");
            buf.append("<li><b>").append(this._t("status")).append("</b>: ").append(this._t("is the peer banned, or unreachable, or failing tunnel tests?")).append("</li>");
            buf.append("</ul>");
        }
        out.write(buf.toString());
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    private String avg(PeerProfile prof, long rate, RateAverages ra) {
        RateStat rs = prof.getDbResponseTime();
        if (rs == null) {
            return this._t(NA);
        }
        Rate r = rs.getRate(rate);
        if (r == null) {
            return this._t(NA);
        }
        r.computeAverages(ra, false);
        if (ra.getTotalEventCount() == 0L) {
            return this._t(NA);
        }
        return DataHelper.formatDuration2(Math.round(ra.getAverage()));
    }

    private String davg(DBHistory dbh, long rate, RateAverages ra) {
        RateStat rs = dbh.getFailedLookupRate();
        if (rs == null) {
            return "0%";
        }
        Rate r = rs.getRate(rate);
        if (r == null) {
            return "0%";
        }
        r.computeAverages(ra, false);
        if (ra.getTotalEventCount() <= 0L) {
            return "0%";
        }
        double avg = 0.5 + 100.0 * ra.getAverage();
        return (int)avg + "%";
    }

    private String formatInterval(long now, long then) {
        if (then <= 0L) {
            return this._t(NA);
        }
        if (now <= then) {
            return DataHelper.formatDuration2(1L);
        }
        return DataHelper.formatDuration2(now - then);
    }

    private String _t(String s) {
        return Messages.getString(s, this._context);
    }

    public String ngettext(String s, String p, int n) {
        return Messages.getString(n, s, p, (I2PAppContext)this._context);
    }

    private static class HashComparator
    implements Comparator<PeerProfile>,
    Serializable {
        private HashComparator() {
        }

        @Override
        public int compare(PeerProfile left, PeerProfile right) {
            return DataHelper.compareTo(left.getPeer().getData(), right.getPeer().getData());
        }
    }

    private class ProfileComparator
    extends HashComparator {
        private ProfileComparator() {
        }

        @Override
        public int compare(PeerProfile left, PeerProfile right) {
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                    return super.compare(left, right);
                }
                return -1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                    return 1;
                }
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(right.getPeer())) {
                    return super.compare(left, right);
                }
                return -1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(left.getPeer())) {
                if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(right.getPeer())) {
                    return super.compare(left, right);
                }
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFast(right.getPeer())) {
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isHighCapacity(right.getPeer())) {
                return 1;
            }
            if (ProfileOrganizerRenderer.this._context.profileOrganizer().isFailing(right.getPeer())) {
                return -1;
            }
            return super.compare(left, right);
        }
    }
}

