/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.router.web.WebAppStarter;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class LocaleWebAppHandler
extends HandlerWrapper {
    private final I2PAppContext _context;
    private final WebAppContext _wac;

    public LocaleWebAppHandler(I2PAppContext ctx, String path, String warPath, File tmpdir, ServletHandler servletHandler) {
        this._context = ctx;
        this._wac = new WebAppContext(warPath, path);
        this.setInitParams(WebAppStarter.INIT_PARAMS);
        this._wac.setTempDirectory(tmpdir);
        this._wac.setExtractWAR(false);
        this._wac.setSessionHandler(new SessionHandler());
        this._wac.setServletHandler(servletHandler);
        this.setHandler((Handler)this._wac);
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        int len;
        if (pathInContext.equals("/") || pathInContext.equals("/index.html")) {
            pathInContext = "/index.jsp";
        } else if (!(pathInContext.indexOf(47, 1) >= 0 || pathInContext.endsWith(".jsp") || pathInContext.endsWith(".log") || pathInContext.endsWith(".txt"))) {
            pathInContext = pathInContext + ".jsp";
        }
        String newPath = pathInContext;
        if (pathInContext.equals("/help.jsp") && ((len = pathInContext.length()) < 8 || pathInContext.charAt(len - 7) != '_')) {
            String lang = this._context.getProperty("routerconsole.lang");
            if (lang == null || lang.length() <= 0) {
                lang = Locale.getDefault().getLanguage();
            }
            if (lang != null && lang.length() > 0 && !lang.equals("en")) {
                String servletPath;
                String testPath = pathInContext.substring(0, len - 4) + '_' + lang + ".jsp";
                PathMap.Entry servlet = this._wac.getServletHandler().getHolderEntry(testPath);
                if (servlet != null && (servletPath = (String)servlet.getKey()) != null && !servletPath.startsWith("*")) {
                    newPath = testPath;
                }
            }
        }
        super.handle(newPath, baseRequest, httpRequest, httpResponse);
    }

    private void setInitParams(Map<?, ?> params) {
        LocaleWebAppHandler.setInitParams(this._wac, params);
    }

    public static void setInitParams(WebAppContext context, Map<?, ?> params) {
        for (Map.Entry<?, ?> e : params.entrySet()) {
            context.setInitParameter((String)e.getKey(), (String)e.getValue());
        }
    }
}

