/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.web.FormHandler;
import net.i2p.util.ConvertToHash;

public class ConfigKeyringHandler
extends FormHandler {
    private String _peer;
    private String _key;

    @Override
    protected void processForm() {
        if (this._action == null) {
            return;
        }
        boolean adding = this._action.equals(this._t("Add key"));
        if (adding || this._action.equals(this._t("Delete key"))) {
            if (this._peer == null) {
                this.addFormError(this._t("You must enter a destination"));
            }
            if (this._key == null && adding) {
                this.addFormError(this._t("You must enter a key"));
            }
            if (this._peer == null || this._key == null && adding) {
                return;
            }
            Hash h = ConvertToHash.getHash(this._peer);
            if (adding) {
                SessionKey sk = new SessionKey();
                try {
                    sk.fromBase64(this._key);
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
                if (h != null && h.getData() != null && sk.getData() != null) {
                    this._context.keyRing().put(h, sk);
                    this.addFormNotice(this._t("Key for") + " " + h.toBase64() + " " + this._t("added to keyring"));
                } else {
                    this.addFormError(this._t("Invalid destination or key"));
                }
            } else if (h != null && h.getData() != null) {
                if (this._context.keyRing().remove(h) != null) {
                    this.addFormNotice(this._t("Key for") + " " + h.toBase64() + " " + this._t("removed from keyring"));
                } else {
                    this.addFormNotice(this._t("Key for") + " " + h.toBase64() + " " + this._t("not found in keyring"));
                }
            } else {
                this.addFormError(this._t("Invalid destination"));
            }
        }
    }

    public void setPeer(String peer) {
        this._peer = peer;
    }

    public void setKey(String peer) {
        this._key = peer;
    }
}

