/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileUtil;

public class CertHelper
extends HelperBase {
    private static final String DIR = "certificates";
    private static final String I2CP = "i2cp/i2cp.local.crt";
    private static final String CONSOLE = "console/console.local.crt";
    private static final String I2PTUNNEL_DIR = "i2ptunnel";

    public String getSummary() {
        File dir = new File(this._context.getConfigDir(), DIR);
        try {
            File f;
            this._out.write("<h3>");
            this._out.write(this._t("Local SSL Certificates"));
            this._out.write("</h3>\n");
            this.output("Console", new File(dir, CONSOLE));
            this.output("I2CP", new File(dir, I2CP));
            File tunnelDir = new File(this._context.getConfigDir(), I2PTUNNEL_DIR);
            boolean hasTunnels = false;
            File[] tunnels = tunnelDir.listFiles();
            if (tunnels != null) {
                for (int i = 0; i < tunnels.length; ++i) {
                    String name;
                    f = tunnels[i];
                    if (!f.isFile() || !(name = f.getName()).endsWith(".local.crt") || !name.startsWith("i2ptunnel-")) continue;
                    String b32 = name.substring(10, name.length() - 10);
                    this.output(this._t("I2PTunnel") + ' ' + b32, f);
                    hasTunnels = true;
                }
            }
            if (!hasTunnels) {
                this.output(this._t("I2PTunnel"), null);
            }
            this._out.write("<h3>");
            this._out.write(this._t("Local Router Family Certificate"));
            this._out.write("</h3>\n");
            String family = this._context.getProperty("netdb.family.name");
            if (family != null) {
                f = new File(dir, "family");
                f = new File(f, family + ".crt");
                this.output(this._t("Family") + ": " + DataHelper.escapeHTML(family), f);
            } else {
                this._out.write("<p>");
                this._out.write(this._t("none"));
                this._out.write("</p>\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void output(String name, File file) throws IOException {
        this._out.write("<p><h4>");
        this._out.write(name);
        this._out.write("</h4>");
        if (file != null && file.exists()) {
            String cert = FileUtil.readTextFile(file.toString(), -1, true);
            if (cert != null) {
                this._out.write("\n<textarea readonly=\"readonly\">\n");
                this._out.write(cert);
                this._out.write("</textarea>\n");
            } else {
                this._out.write(": read failure");
            }
        } else {
            this._out.write("<p>");
            this._out.write(this._t("none"));
            this._out.write("</p>\n");
        }
    }
}

