/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.util.RFC822Date;
import net.i2p.update.UpdateType;
import net.i2p.util.EepHead;
import net.i2p.util.SystemVersion;

class UnsignedUpdateChecker
extends UpdateRunner {
    private final long _ms;
    private boolean _unsignedUpdateAvailable;

    public UnsignedUpdateChecker(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris, long lastUpdateTime) {
        super(ctx, mgr, UpdateType.ROUTER_UNSIGNED, uris);
        this._ms = lastUpdateTime;
    }

    @Override
    public void run() {
        this._isRunning = true;
        boolean success = false;
        try {
            success = this.fetchUnsignedHead();
        }
        catch (Throwable t) {
            this._mgr.notifyTaskFailed(this, "", t);
        }
        finally {
            this._mgr.notifyCheckComplete(this, this._unsignedUpdateAvailable, success);
            this._isRunning = false;
        }
    }

    private boolean fetchUnsignedHead() {
        if (this._urls.isEmpty()) {
            return false;
        }
        this._currentURI = (URI)this._urls.get(0);
        String url = this._currentURI.toString();
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = this._context.getProperty("router.updateProxyPort", 4444);
        if (proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
            String msg = this._t("HTTP client proxy tunnel must be running");
            if (this._log.shouldWarn()) {
                this._log.warn(msg);
            }
            this.updateStatus("<b>" + msg + "</b>");
            return false;
        }
        try {
            EepHead get = new EepHead((I2PAppContext)this._context, proxyHost, proxyPort, 0, url);
            if (get.fetch()) {
                String lastmod = get.getLastModified();
                if (lastmod != null) {
                    long modtime = RFC822Date.parse822Date(lastmod);
                    if (modtime <= 0L) {
                        return false;
                    }
                    if (this._ms <= 0L) {
                        return false;
                    }
                    if (modtime > this._ms) {
                        String newVersion = Long.toString(modtime);
                        if (SystemVersion.isJava7()) {
                            this._unsignedUpdateAvailable = true;
                            this._mgr.notifyVersionAvailable(this, (URI)this._urls.get(0), this.getType(), "", this.getMethod(), this._urls, newVersion, "");
                        } else {
                            String ourJava = System.getProperty("java.version");
                            String msg = this._mgr._t("Requires Java version {0} but installed Java version is {1}", "1.7", ourJava);
                            this._log.logAlways(30, "Cannot update to version " + newVersion + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, (URI)this._urls.get(0), this.getType(), "", newVersion, msg);
                        }
                    }
                }
                return true;
            }
        }
        catch (Throwable t) {
            this._log.error("Error fetching the update", t);
        }
        return false;
    }
}

