/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.util.ByteCache;
import net.i2p.util.Clock;
import net.i2p.util.I2PAppThread;
import net.i2p.util.InternalSocket;
import net.i2p.util.Log;

public class I2PTunnelRunner
extends I2PAppThread
implements I2PSocket.SocketErrorListener {
    protected final Log _log;
    private static final AtomicLong __runnerId = new AtomicLong();
    private final long _runnerId;
    static int MAX_PACKET_SIZE;
    static final int NETWORK_BUFFER_SIZE;
    private final Socket s;
    private final I2PSocket i2ps;
    private final Object slock;
    private final Object finishLock = new Object();
    private volatile boolean finished;
    private final byte[] initialI2PData;
    private final byte[] initialSocketData;
    private long lastActivityOn;
    private final long startedOn;
    private final List<I2PSocket> sockList;
    private final Runnable onTimeout;
    private final FailCallback _onFail;
    private long totalSent;
    private long totalReceived;
    private static final byte[] POST;

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List<I2PSocket> sockList) {
        this(s, i2ps, slock, initialI2PData, null, sockList, null, null, true);
    }

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null, null, true);
    }

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List<I2PSocket> sockList, Runnable onTimeout) {
        this(s, i2ps, slock, initialI2PData, null, sockList, onTimeout, null, true);
    }

    @Deprecated
    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, Runnable onTimeout) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, onTimeout, null, true);
    }

    public I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, FailCallback onFail) {
        this(s, i2ps, slock, initialI2PData, initialSocketData, sockList, null, onFail, false);
    }

    private I2PTunnelRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, List<I2PSocket> sockList, Runnable onTimeout, FailCallback onFail, boolean shouldStart) {
        this.sockList = sockList;
        this.s = s;
        this.i2ps = i2ps;
        this.slock = slock;
        this.initialI2PData = initialI2PData;
        this.initialSocketData = initialSocketData;
        this.onTimeout = onTimeout;
        this._onFail = onFail;
        this.lastActivityOn = -1L;
        this.startedOn = Clock.getInstance().now();
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        if (this._log.shouldLog(20)) {
            this._log.info("I2PTunnelRunner started");
        }
        this._runnerId = __runnerId.incrementAndGet();
        this.setName("I2PTunnelRunner " + this._runnerId);
        if (shouldStart) {
            this.start();
        }
    }

    @Deprecated
    public boolean isFinished() {
        return this.finished;
    }

    @Deprecated
    public long getLastActivityOn() {
        return this.lastActivityOn;
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    protected InputStream getSocketIn() throws IOException {
        return this.s.getInputStream();
    }

    protected OutputStream getSocketOut() throws IOException {
        return this.s.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStream in = this.getSocketIn();
            OutputStream out = this.getSocketOut();
            InputStream i2pin = this.i2ps.getInputStream();
            OutputStream i2pout = this.i2ps.getOutputStream();
            if (this.initialI2PData != null) {
                i2pout.write(this.initialI2PData);
                if (!(this.initialI2PData.length > 1730 || this.initialI2PData.length >= 5 && DataHelper.eq(POST, 0, this.initialI2PData, 0, 5))) {
                    i2pout.flush();
                }
            }
            if (this.initialSocketData != null) {
                out.write(this.initialSocketData);
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Initial data " + (this.initialI2PData != null ? this.initialI2PData.length : 0) + " written to I2P, " + (this.initialSocketData != null ? this.initialSocketData.length : 0) + " written to the socket, starting forwarders");
            }
            if (!(this.s instanceof InternalSocket)) {
                in = new BufferedInputStream(in, 2 * NETWORK_BUFFER_SIZE);
            }
            StreamForwarder toI2P = new StreamForwarder(in, i2pout, true);
            StreamForwarder fromI2P = new StreamForwarder(i2pin, out, false);
            toI2P.start();
            fromI2P.run();
            Object object = this.finishLock;
            synchronized (object) {
                while (!this.finished) {
                    this.finishLock.wait();
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("At least one forwarder completed, closing and joining");
            }
            if (this.onTimeout != null || this._onFail != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("runner has a timeout job, totalReceived = " + this.totalReceived + " totalSent = " + this.totalSent + " job = " + this.onTimeout);
                }
                if (this.totalReceived <= 0L) {
                    if (this._onFail != null) {
                        Exception e = fromI2P.getFailure();
                        if (e == null) {
                            e = toI2P.getFailure();
                        }
                        this._onFail.onFail(e);
                    } else {
                        this.onTimeout.run();
                    }
                }
            }
            this.close(out, in, i2pout, i2pin, this.s, this.i2ps, toI2P, fromI2P);
        }
        catch (InterruptedException ex) {
            if (this._log.shouldLog(40)) {
                this._log.error("Interrupted", ex);
            }
        }
        catch (SSLException she) {
            this._log.error("SSL error", she);
        }
        catch (IOException ex) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Error forwarding", ex);
            }
        }
        catch (IllegalStateException ise) {
            if (this._log.shouldLog(30)) {
                this._log.warn("gnu?", ise);
            }
        }
        catch (RuntimeException e) {
            if (this._log.shouldLog(40)) {
                this._log.error("Internal error", e);
            }
        }
        finally {
            block65: {
                block64: {
                    this.removeRef();
                    try {
                        if (this.s != null) {
                            this.s.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!this._log.shouldLog(30)) break block64;
                        this._log.warn("Could not close java socket", ex);
                    }
                }
                if (this.i2ps != null) {
                    try {
                        this.i2ps.close();
                    }
                    catch (IOException ex) {
                        if (!this._log.shouldLog(30)) break block65;
                        this._log.warn("Could not close I2PSocket", ex);
                    }
                }
            }
        }
    }

    protected void close(OutputStream out, InputStream in, OutputStream i2pout, InputStream i2pin, Socket s, I2PSocket i2ps, Thread t1, Thread t2) throws InterruptedException {
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2pout.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2pin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2ps.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t1.join(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorOccurred() {
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRef() {
        if (this.sockList != null) {
            Object object = this.slock;
            synchronized (object) {
                this.sockList.remove(this.i2ps);
            }
        }
    }

    static {
        NETWORK_BUFFER_SIZE = MAX_PACKET_SIZE = 4096;
        POST = new byte[]{80, 79, 83, 84, 32};
    }

    public static interface FailCallback {
        public void onFail(Exception var1);
    }

    private class StreamForwarder
    extends I2PAppThread {
        private final InputStream in;
        private final OutputStream out;
        private final String direction;
        private final boolean _toI2P;
        private final ByteCache _cache;
        private volatile Exception _failure;

        public StreamForwarder(InputStream in, OutputStream out, boolean toI2P) {
            this.in = in;
            this.out = out;
            this._toI2P = toI2P;
            this.direction = toI2P ? "toI2P" : "fromI2P";
            this._cache = ByteCache.getInstance(32, NETWORK_BUFFER_SIZE);
            this.setName("StreamForwarder " + I2PTunnelRunner.this._runnerId + '.' + this.direction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String from = I2PTunnelRunner.this.i2ps.getThisDestination().calculateHash().toBase64().substring(0, 6);
            String to = I2PTunnelRunner.this.i2ps.getPeerDestination().calculateHash().toBase64().substring(0, 6);
            if (I2PTunnelRunner.this._log.shouldLog(10)) {
                I2PTunnelRunner.this._log.debug(this.direction + ": Forwarding between " + from + " and " + to);
            }
            ByteArray ba = this._cache.acquire();
            byte[] buffer = ba.getData();
            try {
                int len;
                while ((len = this.in.read(buffer)) != -1) {
                    if (len > 0) {
                        this.out.write(buffer, 0, len);
                        if (this._toI2P) {
                            I2PTunnelRunner.this.totalSent = I2PTunnelRunner.this.totalSent + (long)len;
                        } else {
                            I2PTunnelRunner.this.totalReceived = I2PTunnelRunner.this.totalReceived + (long)len;
                        }
                    }
                    if (this.in.available() != 0) continue;
                    if (I2PTunnelRunner.this._log.shouldLog(10)) {
                        I2PTunnelRunner.this._log.debug(this.direction + ": " + len + " bytes flushed through " + (this._toI2P ? "to " : "from ") + to);
                    }
                    if (this._toI2P) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (this.in.available() > 0) continue;
                        this.out.flush();
                        continue;
                    }
                    this.out.flush();
                }
            }
            catch (SocketException ex) {
                Object object = I2PTunnelRunner.this.finishLock;
                synchronized (object) {
                    if (!I2PTunnelRunner.this.finished && I2PTunnelRunner.this._log.shouldLog(10)) {
                        I2PTunnelRunner.this._log.debug(this.direction + ": Socket closed - error reading and writing", ex);
                    }
                }
                this._failure = ex;
            }
            catch (InterruptedIOException ex) {
                if (I2PTunnelRunner.this._log.shouldLog(30)) {
                    I2PTunnelRunner.this._log.warn(this.direction + ": Closing connection due to timeout (error: \"" + ex.getMessage() + "\")");
                }
                this._failure = ex;
            }
            catch (IOException ex) {
                if (!I2PTunnelRunner.this.finished && I2PTunnelRunner.this._log.shouldLog(30)) {
                    I2PTunnelRunner.this._log.warn(this.direction + ": Error forwarding", ex);
                }
                this._failure = ex;
            }
            finally {
                block65: {
                    block64: {
                        this._cache.release(ba);
                        if (I2PTunnelRunner.this._log.shouldLog(20)) {
                            I2PTunnelRunner.this._log.info(this.direction + ": done forwarding between " + from + " and " + to);
                        }
                        try {
                            this.in.close();
                        }
                        catch (IOException ex) {
                            if (!I2PTunnelRunner.this._log.shouldLog(30)) break block64;
                            I2PTunnelRunner.this._log.warn(this.direction + ": Error closing input stream", ex);
                        }
                    }
                    try {
                        if (I2PTunnelRunner.this.onTimeout == null && I2PTunnelRunner.this._onFail == null || this._toI2P || I2PTunnelRunner.this.totalReceived > 0L) {
                            this.out.close();
                        } else if (I2PTunnelRunner.this._log.shouldLog(20)) {
                            I2PTunnelRunner.this._log.info(this.direction + ": not closing so we can write the error message");
                        }
                    }
                    catch (IOException ioe) {
                        if (!I2PTunnelRunner.this._log.shouldLog(30)) break block65;
                        I2PTunnelRunner.this._log.warn(this.direction + ": Error flushing to close", ioe);
                    }
                }
                Object ioe = I2PTunnelRunner.this.finishLock;
                synchronized (ioe) {
                    I2PTunnelRunner.this.finished = true;
                    I2PTunnelRunner.this.finishLock.notifyAll();
                }
            }
        }

        public Exception getFailure() {
            return this._failure;
        }
    }
}

