/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.PeerManagerFacade;
import net.i2p.router.PeerSelectionCriteria;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerManager;
import net.i2p.router.peermanager.PeerTestJob;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.util.Log;

public class PeerManagerFacadeImpl
implements PeerManagerFacade {
    private final Log _log;
    private PeerManager _manager;
    private final RouterContext _context;
    private final ProfilePersistenceHelper _persistenceHelper;
    private final PeerTestJob _testJob;

    public PeerManagerFacadeImpl(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PeerManagerFacadeImpl.class);
        this._persistenceHelper = new ProfilePersistenceHelper(ctx);
        this._testJob = new PeerTestJob(this._context);
    }

    @Override
    public synchronized void startup() {
        this._log.info("Starting up the peer manager");
        this._manager = new PeerManager(this._context);
        this._persistenceHelper.setUs(this._context.routerHash());
        this._testJob.startTesting(this._manager);
    }

    @Override
    public synchronized void shutdown() {
        this._log.info("Shutting down the peer manager");
        this._testJob.stopTesting();
        if (this._manager != null) {
            this._manager.storeProfiles();
            this._manager.clearProfiles();
        }
    }

    @Override
    public synchronized void restart() {
        this._manager.storeProfiles();
        this._persistenceHelper.setUs(this._context.routerHash());
        this._manager.loadProfiles();
    }

    @Override
    public List<Hash> selectPeers(PeerSelectionCriteria criteria) {
        return this._manager.selectPeers(criteria);
    }

    @Override
    public void setCapabilities(Hash peer, String caps) {
        if (this._manager == null) {
            return;
        }
        this._manager.setCapabilities(peer, caps);
    }

    @Override
    public void removeCapabilities(Hash peer) {
        if (this._manager == null) {
            return;
        }
        this._manager.removeCapabilities(peer);
    }

    @Override
    @Deprecated
    public Hash selectRandomByCapability(char capability) {
        return null;
    }

    @Override
    public Set<Hash> getPeersByCapability(char capability) {
        if (this._manager == null) {
            return Collections.emptySet();
        }
        return this._manager.getPeersByCapability(capability);
    }

    @Override
    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }
}

