/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;

class ThrottledPumpedTunnelGateway
extends PumpedTunnelGateway {
    private final HopConfig _config;

    public ThrottledPumpedTunnelGateway(RouterContext context, TunnelGateway.QueuePreprocessor preprocessor, TunnelGateway.Sender sender, TunnelGateway.Receiver receiver, TunnelGatewayPumper pumper, HopConfig config) {
        super(context, preprocessor, sender, receiver, pumper);
        this._config = config;
    }

    @Override
    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        int size = Math.max(msg.getMessageSize(), 512);
        if (this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.IBGW, msg.getType(), size)) {
            int kb = (size + 1023) / 1024;
            for (int i = 0; i < kb; ++i) {
                this._config.incrementProcessedMessages();
            }
            return;
        }
        this.add(new PendingGatewayMessage(msg, toRouter, toTunnel));
    }

    public String toString() {
        return "IBGW " + this._config.getReceiveTunnel();
    }
}

