/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Adler32;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.util.PriBlockingQueue;
import net.i2p.util.ByteCache;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

class NTCPConnection
implements Closeable {
    private final RouterContext _context;
    private final Log _log;
    private SocketChannel _chan;
    private SelectionKey _conKey;
    private final FIFOBandwidthLimiter.CompleteListener _inboundListener;
    private final FIFOBandwidthLimiter.CompleteListener _outboundListener;
    private final Queue<ByteBuffer> _readBufs;
    private final Queue<ByteBuffer> _writeBufs;
    private final Set<FIFOBandwidthLimiter.Request> _bwInRequests;
    private final Set<FIFOBandwidthLimiter.Request> _bwOutRequests;
    private long _establishedOn;
    private volatile EstablishState _establishState;
    private final NTCPTransport _transport;
    private final boolean _isInbound;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final RouterAddress _remAddr;
    private RouterIdentity _remotePeer;
    private long _clockSkew;
    private final PriBlockingQueue<OutNetMessage> _outbound;
    private OutNetMessage _currentOutbound;
    private SessionKey _sessionKey;
    private byte[] _curReadBlock;
    private int _curReadBlockIndex;
    private final byte[] _decryptBlockBuf;
    private byte[] _prevReadBlock;
    private byte[] _prevWriteEnd;
    private final ReadState _curReadState;
    private final AtomicInteger _messagesRead = new AtomicInteger();
    private final AtomicInteger _messagesWritten = new AtomicInteger();
    private long _lastSendTime;
    private long _lastReceiveTime;
    private long _lastRateUpdated;
    private final long _created;
    private long _nextMetaTime = Long.MAX_VALUE;
    private int _consecutiveZeroReads;
    private static final int BLOCK_SIZE = 16;
    private static final int META_SIZE = 16;
    private final byte[] _meta = new byte[16];
    private boolean _sendingMeta;
    private long _nextInfoTime;
    private boolean _mayDisconnect;
    private static final long STAT_UPDATE_TIME_MS = 30000L;
    private static final int META_FREQUENCY = 2700000;
    private static final int INFO_FREQUENCY = 3000000;
    public static final int BUFFER_SIZE = 16384;
    private static final int MAX_DATA_READ_BUFS = 16;
    private static final ByteCache _dataReadBufs = ByteCache.getInstance(16, 16384);
    public static final int MAX_MSG_SIZE = 16378;
    private static final int INFO_PRIORITY = 150;
    private static final String FIXED_RI_VERSION = "0.9.12";
    private static final AtomicLong __connID = new AtomicLong();
    private final long _connID = __connID.incrementAndGet();
    private static final boolean FAST_LARGE = true;
    private long _bytesReceived;
    private long _bytesSent;
    private long _lastBytesReceived;
    private long _lastBytesSent;
    private float _sendBps;
    private float _recvBps;
    private static final int MAX_HANDLERS = 4;
    private static final LinkedBlockingQueue<I2NPMessageHandler> _i2npHandlers = new LinkedBlockingQueue(4);

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, SocketChannel chan, SelectionKey key) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._created = ctx.clock().now();
        this._transport = transport;
        this._remAddr = null;
        this._chan = chan;
        this._readBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._writeBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._bwInRequests = new ConcurrentHashSet<FIFOBandwidthLimiter.Request>(2);
        this._bwOutRequests = new ConcurrentHashSet<FIFOBandwidthLimiter.Request>(8);
        this._outbound = new PriBlockingQueue(ctx, "NTCP-Connection", 32);
        this._isInbound = true;
        this._decryptBlockBuf = new byte[16];
        this._curReadState = new ReadState();
        this._establishState = new EstablishState(ctx, transport, this);
        this._conKey = key;
        this._conKey.attach(this);
        this._inboundListener = new InboundListener();
        this._outboundListener = new OutboundListener();
        this.initialize();
    }

    public NTCPConnection(RouterContext ctx, NTCPTransport transport, RouterIdentity remotePeer, RouterAddress remAddr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._created = ctx.clock().now();
        this._transport = transport;
        this._remotePeer = remotePeer;
        this._remAddr = remAddr;
        this._readBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._writeBufs = new ConcurrentLinkedQueue<ByteBuffer>();
        this._bwInRequests = new ConcurrentHashSet<FIFOBandwidthLimiter.Request>(2);
        this._bwOutRequests = new ConcurrentHashSet<FIFOBandwidthLimiter.Request>(8);
        this._outbound = new PriBlockingQueue(ctx, "NTCP-Connection", 32);
        this._isInbound = false;
        this._establishState = new EstablishState(ctx, transport, this);
        this._decryptBlockBuf = new byte[16];
        this._curReadState = new ReadState();
        this._inboundListener = new InboundListener();
        this._outboundListener = new OutboundListener();
        this.initialize();
    }

    private void initialize() {
        this._lastSendTime = this._created;
        this._lastReceiveTime = this._created;
        this._lastRateUpdated = this._created;
        this._curReadBlock = new byte[16];
        this._prevReadBlock = new byte[16];
        this._transport.establishing(this);
    }

    public SocketChannel getChannel() {
        return this._chan;
    }

    public SelectionKey getKey() {
        return this._conKey;
    }

    public void setChannel(SocketChannel chan) {
        this._chan = chan;
    }

    public void setKey(SelectionKey key) {
        this._conKey = key;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean isEstablished() {
        return this._establishState.isComplete();
    }

    public boolean isIPv6() {
        return this._chan != null && this._chan.socket().getInetAddress() instanceof Inet6Address;
    }

    public EstablishState getEstablishState() {
        return this._establishState;
    }

    public RouterAddress getRemoteAddress() {
        return this._remAddr;
    }

    public RouterIdentity getRemotePeer() {
        return this._remotePeer;
    }

    public void setRemotePeer(RouterIdentity ident) {
        this._remotePeer = ident;
    }

    public void finishInboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        NTCPConnection toClose = this.locked_finishInboundEstablishment(key, clockSkew, prevWriteEnd, prevReadEnd);
        if (toClose != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Old connection closed: " + toClose + " replaced by " + this);
            }
            this._context.statManager().addRateData("ntcp.inboundEstablishedDuplicate", toClose.getUptime());
            toClose.close();
        }
        this.enqueueInfoMessage();
    }

    private synchronized NTCPConnection locked_finishInboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        this._sessionKey = key;
        this._clockSkew = clockSkew;
        this._prevWriteEnd = prevWriteEnd;
        System.arraycopy(prevReadEnd, prevReadEnd.length - 16, this._prevReadBlock, 0, 16);
        this._establishedOn = this._context.clock().now();
        NTCPConnection rv = this._transport.inboundEstablished(this);
        this._nextMetaTime = this._establishedOn + 1350000L + (long)this._context.random().nextInt(2700000);
        this._nextInfoTime = this._establishedOn + 1500000L + (long)this._context.random().nextInt(3000000);
        this._establishState = EstablishState.VERIFIED;
        return rv;
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getUptime() {
        if (!this.isEstablished()) {
            return this.getTimeSinceCreated();
        }
        return this._context.clock().now() - this._establishedOn;
    }

    public int getMessagesSent() {
        return this._messagesWritten.get();
    }

    public int getMessagesReceived() {
        return this._messagesRead.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutboundQueueSize() {
        int queued;
        PriBlockingQueue<OutNetMessage> priBlockingQueue = this._outbound;
        synchronized (priBlockingQueue) {
            queued = this._outbound.size();
            if (this.getCurrentOutbound() != null) {
                ++queued;
            }
        }
        return queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutNetMessage getCurrentOutbound() {
        PriBlockingQueue<OutNetMessage> priBlockingQueue = this._outbound;
        synchronized (priBlockingQueue) {
            return this._currentOutbound;
        }
    }

    public long getTimeSinceSend() {
        return this._context.clock().now() - this._lastSendTime;
    }

    public long getTimeSinceReceive() {
        return this._context.clock().now() - this._lastReceiveTime;
    }

    public long getTimeSinceCreated() {
        return this._context.clock().now() - this._created;
    }

    public long getCreated() {
        return this._created;
    }

    public void setMayDisconnect() {
        this._mayDisconnect = true;
    }

    public boolean getMayDisconnect() {
        return this._mayDisconnect;
    }

    public void clearZeroRead() {
        this._consecutiveZeroReads = 0;
    }

    public int gotZeroRead() {
        return ++this._consecutiveZeroReads;
    }

    public boolean isClosed() {
        return this._closed.get();
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean allowRequeue) {
        NTCPConnection toClose;
        if (!this._closed.compareAndSet(false, true)) {
            this._log.logCloseLoop("NTCPConnection", this);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Closing connection " + this.toString(), new Exception("cause"));
        }
        if ((toClose = this.locked_close(allowRequeue)) != null && toClose != this) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple connections on remove, closing " + toClose + " (already closed " + this + ")");
            }
            this._context.statManager().addRateData("ntcp.multipleCloseOnRemove", toClose.getUptime());
            toClose.close();
        }
    }

    public void closeOnTimeout(String cause, Exception e) {
        EstablishState es = this._establishState;
        this.close();
        es.close(cause, e);
    }

    private synchronized NTCPConnection locked_close(boolean allowRequeue) {
        ByteBuffer bb;
        if (this._chan != null) {
            try {
                this._chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._conKey != null) {
            this._conKey.cancel();
        }
        this._establishState = EstablishState.FAILED;
        NTCPConnection old = this._transport.removeCon(this);
        this._transport.getReader().connectionClosed(this);
        this._transport.getWriter().connectionClosed(this);
        for (FIFOBandwidthLimiter.Request req : this._bwInRequests) {
            req.abort();
        }
        this._bwInRequests.clear();
        for (FIFOBandwidthLimiter.Request req : this._bwOutRequests) {
            req.abort();
        }
        this._bwOutRequests.clear();
        this._writeBufs.clear();
        while ((bb = this._readBufs.poll()) != null) {
            EventPumper.releaseBuf(bb);
        }
        ArrayList pending = new ArrayList();
        this._outbound.drainTo(pending);
        for (OutNetMessage msg : pending) {
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
        OutNetMessage msg = this.getCurrentOutbound();
        if (msg != null) {
            this._transport.afterSend(msg, false, allowRequeue, msg.getLifetime());
        }
        return old;
    }

    public void send(OutNetMessage msg) {
        boolean noOutbound;
        this._outbound.offer(msg);
        boolean bl = noOutbound = this.getCurrentOutbound() == null;
        if (this.isEstablished() && noOutbound) {
            this._transport.getWriter().wantsWrite(this, "enqueued");
        }
    }

    public boolean isBacklogged() {
        return this._outbound.isBacklogged();
    }

    public boolean tooBacklogged() {
        if (this.getUptime() < 10000L) {
            return false;
        }
        if (this._outbound.isBacklogged()) {
            int size = this._outbound.size();
            if (this._log.shouldLog(30)) {
                int writeBufs = this._writeBufs.size();
                boolean currentOutboundSet = this.getCurrentOutbound() != null;
                try {
                    this._log.warn("Too backlogged: size is " + size + ", wantsWrite? " + (0 != (this._conKey.interestOps() & 4)) + ", currentOut set? " + currentOutboundSet + ", writeBufs: " + writeBufs + " on " + this.toString());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public void enqueueInfoMessage() {
        int priority = 150;
        if (this._log.shouldLog(20)) {
            this._log.info("SENDING INFO message pri. " + priority + ": " + this.toString());
        }
        DatabaseStoreMessage dsm = new DatabaseStoreMessage(this._context);
        dsm.setEntry(this._context.router().getRouterInfo());
        OutNetMessage infoMsg = new OutNetMessage(this._context, dsm, this._context.clock().now() + 10000L, priority, null);
        infoMsg.beginSend();
        this.send(infoMsg);
    }

    public synchronized void finishOutboundEstablishment(SessionKey key, long clockSkew, byte[] prevWriteEnd, byte[] prevReadEnd) {
        if (this._log.shouldLog(10)) {
            this._log.debug("outbound established (key=" + key + " skew=" + clockSkew + " prevWriteEnd=" + Base64.encode(prevWriteEnd) + ")");
        }
        this._sessionKey = key;
        this._clockSkew = clockSkew;
        this._prevWriteEnd = prevWriteEnd;
        System.arraycopy(prevReadEnd, prevReadEnd.length - 16, this._prevReadBlock, 0, 16);
        if (this._log.shouldLog(10)) {
            this._log.debug("Outbound established, prevWriteEnd: " + Base64.encode(prevWriteEnd) + " prevReadEnd: " + Base64.encode(prevReadEnd));
        }
        this._establishedOn = this._context.clock().now();
        this._establishState = EstablishState.VERIFIED;
        this._transport.markReachable(this.getRemotePeer().calculateHash(), false);
        boolean msgs = !this._outbound.isEmpty();
        this._nextMetaTime = this._establishedOn + 1350000L + (long)this._context.random().nextInt(2700000);
        this._nextInfoTime = this._establishedOn + 1500000L + (long)this._context.random().nextInt(3000000);
        if (msgs) {
            this._transport.getWriter().wantsWrite(this, "outbound established");
        }
    }

    synchronized void prepareNextWrite(PrepBuffer prep) {
        this.prepareNextWriteFast(prep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNextWriteFast(PrepBuffer buf) {
        if (this._closed.get()) {
            return;
        }
        if (!this._isInbound && !this.isEstablished()) {
            return;
        }
        long now = this._context.clock().now();
        if (this._nextMetaTime <= now) {
            this.sendMeta();
            this._nextMetaTime = now + 1350000L + (long)this._context.random().nextInt(1350000);
        }
        OutNetMessage msg = null;
        PriBlockingQueue<OutNetMessage> priBlockingQueue = this._outbound;
        synchronized (priBlockingQueue) {
            if (this._currentOutbound != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("attempt for multiple outbound messages with " + System.identityHashCode(this._currentOutbound) + " already waiting and " + this._outbound.size() + " queued");
                }
                return;
            }
            msg = (OutNetMessage)this._outbound.poll();
            if (msg == null) {
                return;
            }
            this._currentOutbound = msg;
        }
        this.bufferedPrepare(msg, buf);
        this._context.aes().encrypt(buf.unencrypted, 0, buf.encrypted, 0, this._sessionKey, this._prevWriteEnd, 0, buf.unencryptedLength);
        System.arraycopy(buf.encrypted, buf.encrypted.length - 16, this._prevWriteEnd, 0, this._prevWriteEnd.length);
        this._transport.getPumper().wantsWrite(this, buf.encrypted);
        if (this._nextInfoTime <= now) {
            this.enqueueInfoMessage();
            this._nextInfoTime = now + 1500000L + (long)this._context.random().nextInt(3000000);
        }
    }

    private void bufferedPrepare(OutNetMessage msg, PrepBuffer buf) {
        I2NPMessage m = msg.getMessage();
        int sz = buf.baseLength = m.toByteArray(buf.base);
        int min = 2 + sz + 4;
        int rem = min % 16;
        int padding = 0;
        if (rem > 0) {
            padding = 16 - rem;
        }
        buf.unencryptedLength = min + padding;
        DataHelper.toLong(buf.unencrypted, 0, 2, sz);
        System.arraycopy(buf.base, 0, buf.unencrypted, 2, buf.baseLength);
        if (padding > 0) {
            this._context.random().nextBytes(buf.unencrypted, 2 + sz, padding);
        }
        buf.crc.update(buf.unencrypted, 0, buf.unencryptedLength - 4);
        long val = buf.crc.getValue();
        if (this._log.shouldLog(10)) {
            this._log.debug("Outbound message " + this._messagesWritten + " has crc " + val + " sz=" + sz + " rem=" + rem + " padding=" + padding);
        }
        DataHelper.toLong(buf.unencrypted, buf.unencryptedLength - 4, 4, val);
        buf.encrypted = new byte[buf.unencryptedLength];
    }

    public void outboundConnected() {
        this._conKey.interestOps(1);
        this._transport.getWriter().wantsWrite(this, "outbound connected");
    }

    private void removeIBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwInRequests.remove(req);
    }

    private void addIBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwInRequests.add(req);
    }

    private void removeOBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwOutRequests.remove(req);
    }

    private void addOBRequest(FIFOBandwidthLimiter.Request req) {
        this._bwOutRequests.add(req);
    }

    public void queuedRecv(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        req.attach(buf);
        req.setCompleteListener(this._inboundListener);
        this.addIBRequest(req);
    }

    public void queuedWrite(ByteBuffer buf, FIFOBandwidthLimiter.Request req) {
        req.attach(buf);
        req.setCompleteListener(this._outboundListener);
        this.addOBRequest(req);
    }

    public void recv(ByteBuffer buf) {
        this._bytesReceived += (long)buf.remaining();
        this._readBufs.offer(buf);
        this._transport.getReader().wantsRead(this);
        this.updateStats();
    }

    public void write(ByteBuffer buf) {
        this._writeBufs.offer(buf);
        this._transport.getPumper().wantsWrite(this);
    }

    public ByteBuffer getNextReadBuf() {
        return this._readBufs.poll();
    }

    public boolean isWriteBufEmpty() {
        return this._writeBufs.isEmpty();
    }

    public ByteBuffer getNextWriteBuf() {
        return this._writeBufs.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteBuf(ByteBuffer buf) {
        this._bytesSent += (long)buf.capacity();
        OutNetMessage msg = null;
        boolean clearMessage = false;
        if (this._sendingMeta && buf.capacity() == this._meta.length) {
            this._sendingMeta = false;
        } else {
            clearMessage = true;
        }
        this._writeBufs.remove(buf);
        if (clearMessage) {
            PriBlockingQueue<OutNetMessage> priBlockingQueue = this._outbound;
            synchronized (priBlockingQueue) {
                if (this._currentOutbound != null) {
                    msg = this._currentOutbound;
                    this._currentOutbound = null;
                }
            }
            if (msg != null) {
                this._lastSendTime = this._context.clock().now();
                this._context.statManager().addRateData("ntcp.sendTime", msg.getSendTime());
                if (this._log.shouldLog(10)) {
                    this._log.debug("I2NP message " + this._messagesWritten + "/" + msg.getMessageId() + " sent after " + msg.getSendTime() + "/" + msg.getLifetime() + " with " + buf.capacity() + " bytes (uid=" + System.identityHashCode(msg) + " on " + this.toString() + ")");
                }
                this._messagesWritten.incrementAndGet();
                this._transport.sendComplete(msg);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("I2NP meta message sent completely");
        }
        if (this.getOutboundQueueSize() > 0) {
            this._transport.getWriter().wantsWrite(this, "write completed");
        }
        this.updateStats();
    }

    public float getSendRate() {
        return this._sendBps;
    }

    public float getRecvRate() {
        return this._recvBps;
    }

    private void updateStats() {
        long now = this._context.clock().now();
        long time = now - this._lastRateUpdated;
        if (time >= 30000L) {
            long totS = this._bytesSent;
            long totR = this._bytesReceived;
            long sent = totS - this._lastBytesSent;
            long recv = totR - this._lastBytesReceived;
            this._lastBytesSent = totS;
            this._lastBytesReceived = totR;
            this._lastRateUpdated = now;
            this._sendBps = 0.9f * this._sendBps + 0.1f * ((float)sent * 1000.0f) / (float)time;
            this._recvBps = 0.9f * this._recvBps + 0.1f * ((float)recv * 1000.0f) / (float)time;
        }
    }

    synchronized void recvEncryptedI2NP(ByteBuffer buf) {
        int tot;
        if (this._curReadBlockIndex == 0 && buf.hasArray() && (tot = buf.remaining()) >= 32 && tot % 16 == 0) {
            this.recvEncryptedFast(buf);
            return;
        }
        while (buf.hasRemaining() && !this._closed.get()) {
            int want = Math.min(buf.remaining(), 16 - this._curReadBlockIndex);
            if (want > 0) {
                buf.get(this._curReadBlock, this._curReadBlockIndex, want);
                this._curReadBlockIndex += want;
            }
            if (this._curReadBlockIndex < 16) continue;
            this._context.aes().decryptBlock(this._curReadBlock, 0, this._sessionKey, this._decryptBlockBuf, 0);
            for (int i = 0; i < 16; ++i) {
                int n = i;
                this._decryptBlockBuf[n] = (byte)(this._decryptBlockBuf[n] ^ this._prevReadBlock[i]);
            }
            boolean ok = this.recvUnencryptedI2NP();
            if (!ok) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Read buffer " + System.identityHashCode(buf) + " contained corrupt data");
                }
                this._context.statManager().addRateData("ntcp.corruptDecryptedI2NP", 1L);
                return;
            }
            byte[] swap = this._prevReadBlock;
            this._prevReadBlock = this._curReadBlock;
            this._curReadBlock = swap;
            this._curReadBlockIndex = 0;
        }
    }

    private void recvEncryptedFast(ByteBuffer buf) {
        int pos;
        byte[] array = buf.array();
        int end = pos + buf.remaining();
        boolean first = true;
        for (pos = buf.arrayOffset(); pos < end && !this._closed.get(); pos += 16) {
            this._context.aes().decryptBlock(array, pos, this._sessionKey, this._decryptBlockBuf, 0);
            if (first) {
                for (int i = 0; i < 16; ++i) {
                    int n = i;
                    this._decryptBlockBuf[n] = (byte)(this._decryptBlockBuf[n] ^ this._prevReadBlock[i]);
                }
                first = false;
            } else {
                int start = pos - 16;
                for (int i = 0; i < 16; ++i) {
                    int n = i;
                    this._decryptBlockBuf[n] = (byte)(this._decryptBlockBuf[n] ^ array[start + i]);
                }
            }
            boolean ok = this.recvUnencryptedI2NP();
            if (ok) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Read buffer " + System.identityHashCode(buf) + " contained corrupt data");
            }
            this._context.statManager().addRateData("ntcp.corruptDecryptedI2NP", 1L);
            return;
        }
        System.arraycopy(array, end - 16, this._prevReadBlock, 0, 16);
    }

    private boolean recvUnencryptedI2NP() {
        this._curReadState.receiveBlock(this._decryptBlockBuf);
        if (this._curReadState.getSize() > 16384) {
            if (this._log.shouldLog(30)) {
                this._log.warn("I2NP message too big - size: " + this._curReadState.getSize() + " Dropping " + this.toString());
            }
            this._context.statManager().addRateData("ntcp.corruptTooLargeI2NP", this._curReadState.getSize());
            this.close();
            return false;
        }
        return true;
    }

    private void readMeta(byte[] unencrypted) {
        long ourTs = (this._context.clock().now() + 500L) / 1000L;
        long ts = DataHelper.fromLong(unencrypted, 2, 4);
        Adler32 crc = new Adler32();
        crc.update(unencrypted, 0, unencrypted.length - 4);
        long expected = crc.getValue();
        long read = DataHelper.fromLong(unencrypted, unencrypted.length - 4, 4);
        if (read != expected) {
            if (this._log.shouldLog(30)) {
                this._log.warn("I2NP metadata message had a bad CRC value");
            }
            this._context.statManager().addRateData("ntcp.corruptMetaCRC", 1L);
            this.close();
            return;
        }
        long newSkew = ourTs - ts;
        if (Math.abs(newSkew * 1000L) > 60000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer's skew jumped too far (from " + this._clockSkew + " s to " + newSkew + " s): " + this.toString());
            }
            this._context.statManager().addRateData("ntcp.corruptSkew", newSkew);
            this.close();
            return;
        }
        this._context.statManager().addRateData("ntcp.receiveMeta", newSkew);
        if (this._log.shouldLog(10)) {
            this._log.debug("Received NTCP metadata, old skew of " + this._clockSkew + " s, new skew of " + newSkew + "s.");
        }
        this._clockSkew = newSkew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeta() {
        byte[] encrypted = new byte[this._meta.length];
        byte[] byArray = this._meta;
        synchronized (this._meta) {
            DataHelper.toLong(this._meta, 0, 2, 0L);
            DataHelper.toLong(this._meta, 2, 4, (this._context.clock().now() + 500L) / 1000L);
            this._context.random().nextBytes(this._meta, 6, 6);
            Adler32 crc = new Adler32();
            crc.update(this._meta, 0, this._meta.length - 4);
            DataHelper.toLong(this._meta, this._meta.length - 4, 4, crc.getValue());
            this._context.aes().encrypt(this._meta, 0, encrypted, 0, this._sessionKey, this._prevWriteEnd, 0, this._meta.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            System.arraycopy(encrypted, encrypted.length - 16, this._prevWriteEnd, 0, this._prevWriteEnd.length);
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending NTCP metadata");
            }
            this._sendingMeta = true;
            this._transport.getPumper().wantsWrite(this, encrypted);
            return;
        }
    }

    private static final I2NPMessageHandler acquireHandler(RouterContext ctx) {
        I2NPMessageHandler rv = _i2npHandlers.poll();
        if (rv == null) {
            rv = new I2NPMessageHandler(ctx);
        }
        return rv;
    }

    private static void releaseHandler(I2NPMessageHandler handler) {
        _i2npHandlers.offer(handler);
    }

    private static ByteArray acquireReadBuf() {
        return _dataReadBufs.acquire();
    }

    private static void releaseReadBuf(ByteArray buf) {
        _dataReadBufs.release(buf, false);
    }

    static void releaseResources() {
        _i2npHandlers.clear();
    }

    public String toString() {
        return "NTCP conn " + this._connID + (this._isInbound ? " from " : " to ") + (this._remotePeer == null ? "unknown" : this._remotePeer.calculateHash().toBase64().substring(0, 6)) + (this.isEstablished() ? "" : " not established") + " created " + DataHelper.formatDuration(this.getTimeSinceCreated()) + " ago, last send " + DataHelper.formatDuration(this.getTimeSinceSend()) + " ago, last recv " + DataHelper.formatDuration(this.getTimeSinceReceive()) + " ago, sent " + this._messagesWritten + ", rcvd " + this._messagesRead;
    }

    private class InboundListener
    implements FIFOBandwidthLimiter.CompleteListener {
        private InboundListener() {
        }

        @Override
        public void complete(FIFOBandwidthLimiter.Request req) {
            NTCPConnection.this.removeIBRequest(req);
            ByteBuffer buf = (ByteBuffer)req.attachment();
            if (NTCPConnection.this._closed.get()) {
                EventPumper.releaseBuf(buf);
                return;
            }
            NTCPConnection.this._context.statManager().addRateData("ntcp.throttledReadComplete", NTCPConnection.this._context.clock().now() - req.getRequestTime());
            NTCPConnection.this.recv(buf);
            NTCPConnection.this._transport.getPumper().wantsRead(NTCPConnection.this);
        }
    }

    private class OutboundListener
    implements FIFOBandwidthLimiter.CompleteListener {
        private OutboundListener() {
        }

        @Override
        public void complete(FIFOBandwidthLimiter.Request req) {
            NTCPConnection.this.removeOBRequest(req);
            ByteBuffer buf = (ByteBuffer)req.attachment();
            if (!NTCPConnection.this._closed.get()) {
                NTCPConnection.this._context.statManager().addRateData("ntcp.throttledWriteComplete", NTCPConnection.this._context.clock().now() - req.getRequestTime());
                NTCPConnection.this.write(buf);
            }
        }
    }

    public static class PrepBuffer {
        final byte[] unencrypted = new byte[16384];
        int unencryptedLength;
        final byte[] base = new byte[16384];
        int baseLength;
        final Adler32 crc = new Adler32();
        byte[] encrypted;

        public void init() {
            this.unencryptedLength = 0;
            this.baseLength = 0;
            this.encrypted = null;
            this.crc.reset();
        }
    }

    private class ReadState {
        private int _size;
        private ByteArray _dataBuf;
        private int _nextWrite;
        private long _expectedCrc;
        private final Adler32 _crc = new Adler32();
        private long _stateBegin;
        private int _blocks;

        public ReadState() {
            this.init();
        }

        private void init() {
            this._size = -1;
            this._nextWrite = 0;
            this._expectedCrc = -1L;
            this._stateBegin = -1L;
            this._blocks = -1;
            this._crc.reset();
            if (this._dataBuf != null) {
                NTCPConnection.releaseReadBuf(this._dataBuf);
            }
            this._dataBuf = null;
        }

        public int getSize() {
            return this._size;
        }

        public void receiveBlock(byte[] buf) {
            if (this._size == -1) {
                this.receiveInitial(buf);
            } else {
                this.receiveSubsequent(buf);
            }
        }

        private void receiveInitial(byte[] buf) {
            this._size = (int)DataHelper.fromLong(buf, 0, 2);
            if (this._size == 0) {
                NTCPConnection.this.readMeta(buf);
                this.init();
            } else {
                this._stateBegin = NTCPConnection.this._context.clock().now();
                this._dataBuf = NTCPConnection.acquireReadBuf();
                System.arraycopy(buf, 2, this._dataBuf.getData(), 0, buf.length - 2);
                this._nextWrite += buf.length - 2;
                this._crc.update(buf);
                ++this._blocks;
                if (NTCPConnection.this._log.shouldLog(10)) {
                    NTCPConnection.this._log.debug("new I2NP message with size: " + this._size + " for message " + NTCPConnection.this._messagesRead);
                }
            }
        }

        private void receiveSubsequent(byte[] buf) {
            ++this._blocks;
            int remaining = this._size - this._nextWrite;
            int blockUsed = Math.min(buf.length, remaining);
            if (remaining > 0) {
                System.arraycopy(buf, 0, this._dataBuf.getData(), this._nextWrite, blockUsed);
                this._nextWrite += blockUsed;
                remaining -= blockUsed;
            }
            if (remaining <= 0 && buf.length - blockUsed < 4) {
                if (NTCPConnection.this._log.shouldLog(10)) {
                    NTCPConnection.this._log.debug("crc wraparound required on block " + this._blocks + " in message " + NTCPConnection.this._messagesRead);
                }
                this._crc.update(buf);
                return;
            }
            if (remaining <= 0) {
                this.receiveLastBlock(buf);
            } else {
                this._crc.update(buf);
            }
        }

        private void receiveLastBlock(byte[] buf) {
            this._expectedCrc = DataHelper.fromLong(buf, buf.length - 4, 4);
            this._crc.update(buf, 0, buf.length - 4);
            long val = this._crc.getValue();
            if (val == this._expectedCrc) {
                try {
                    I2NPMessageHandler h = NTCPConnection.acquireHandler(NTCPConnection.this._context);
                    h.readMessage(this._dataBuf.getData(), 0, this._size);
                    I2NPMessage read = h.lastRead();
                    long timeToRecv = NTCPConnection.this._context.clock().now() - this._stateBegin;
                    NTCPConnection.releaseHandler(h);
                    if (NTCPConnection.this._log.shouldLog(10)) {
                        NTCPConnection.this._log.debug("I2NP message " + NTCPConnection.this._messagesRead + "/" + (read != null ? read.getUniqueId() : 0L) + " received after " + timeToRecv + " with " + this._size + "/" + this._blocks * 16 + " bytes on " + NTCPConnection.this.toString());
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.receiveTime", timeToRecv);
                    NTCPConnection.this._context.statManager().addRateData("ntcp.receiveSize", this._size);
                    if (read != null) {
                        NTCPConnection.this._transport.messageReceived(read, NTCPConnection.this._remotePeer, null, timeToRecv, this._size);
                        NTCPConnection.this._lastReceiveTime = NTCPConnection.this._context.clock().now();
                        NTCPConnection.this._messagesRead.incrementAndGet();
                    }
                }
                catch (I2NPMessageException ime) {
                    if (NTCPConnection.this._log.shouldLog(30)) {
                        NTCPConnection.this._log.warn("Error parsing I2NP message\nDUMP:\n" + HexDump.dump(this._dataBuf.getData(), 0, this._size) + "\nRAW:\n" + Base64.encode(this._dataBuf.getData(), 0, this._size) + ime);
                    }
                    NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPIME", 1L);
                }
            } else {
                if (NTCPConnection.this._log.shouldLog(30)) {
                    NTCPConnection.this._log.warn("CRC incorrect for message " + NTCPConnection.this._messagesRead + " (calc=" + val + " expected=" + this._expectedCrc + ") size=" + this._size + " blocks " + this._blocks);
                }
                NTCPConnection.this._context.statManager().addRateData("ntcp.corruptI2NPCRC", 1L);
            }
            this.init();
        }
    }
}

