/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.time;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import net.i2p.data.DataHelper;
import net.i2p.router.time.NtpMessage;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

class NtpClient {
    public static final double SECONDS_1900_TO_EPOCH = 2.2089888E9;
    private static final int NTP_PORT = 123;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int OFF_ORIGTIME = 24;
    private static final int OFF_TXTIME = 40;
    private static final int MIN_PKT_LEN = 48;

    NtpClient() {
    }

    public static long[] currentTimeAndStratum(String[] serverNames, int perServerTimeout, Log log) {
        int i;
        if (serverNames == null) {
            throw new IllegalArgumentException("No NTP servers specified");
        }
        ArrayList<String> names = new ArrayList<String>(serverNames.length);
        for (i = 0; i < serverNames.length; ++i) {
            names.add(serverNames[i]);
        }
        Collections.shuffle(names);
        for (i = 0; i < names.size(); ++i) {
            long[] rv = NtpClient.currentTimeAndStratum((String)names.get(i), perServerTimeout, log);
            if (rv == null || rv[0] <= 0L) continue;
            return rv;
        }
        throw new IllegalArgumentException("No reachable NTP servers specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] currentTimeAndStratum(String serverName, int timeout, Log log) {
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(serverName);
            byte[] buf = new NtpMessage().toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
            byte[] txtime = new byte[8];
            NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
            socket.send(packet);
            System.arraycopy(packet.getData(), 40, txtime, 0, 8);
            if (log != null && log.shouldDebug()) {
                log.debug("Sent:\n" + HexDump.dump(buf));
            }
            packet = new DatagramPacket(buf, buf.length);
            socket.setSoTimeout(timeout);
            socket.receive(packet);
            double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
            if (packet.getLength() < 48) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Short packet length " + packet.getLength());
                }
                long[] lArray = null;
                return lArray;
            }
            NtpMessage msg = new NtpMessage(packet.getData());
            if (log != null && log.shouldDebug()) {
                log.debug("Received from: " + packet.getAddress().getHostAddress() + '\n' + msg + '\n' + HexDump.dump(packet.getData()));
            }
            if (msg.stratum < 1 || msg.stratum > 15) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Response from NTP server of unacceptable stratum " + msg.stratum + ", failing.");
                }
                long[] lArray = null;
                return lArray;
            }
            if (!DataHelper.eq(txtime, 0, packet.getData(), 24, 8)) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Origin time mismatch sent:\n" + HexDump.dump(txtime) + "rcvd:\n" + HexDump.dump(packet.getData(), 24, 8));
                }
                long[] lArray = null;
                return lArray;
            }
            double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
            long[] rv = new long[]{(long)((double)System.currentTimeMillis() + localClockOffset * 1000.0), msg.stratum};
            if (log != null && log.shouldInfo()) {
                double roundTripDelay = destinationTimestamp - msg.originateTimestamp - (msg.receiveTimestamp - msg.transmitTimestamp);
                log.info("host: " + packet.getAddress().getHostAddress() + " rtt: " + roundTripDelay + " offset: " + localClockOffset + " seconds");
            }
            long[] lArray = rv;
            return lArray;
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length <= 0) {
            args = new String[]{"pool.ntp.org"};
        }
        Log log = new Log(NtpClient.class);
        long[] rv = NtpClient.currentTimeAndStratum(args, 10000, log);
        System.out.println("Current time: " + new Date(rv[0]) + " (stratum " + rv[1] + ')');
    }
}

