/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.KeyCertificate;
import net.i2p.data.LeaseSet;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.RejectTrimmer;
import net.i2p.router.Job;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.networkdb.PublishLocalRouterInfoJob;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.ExpireLeasesJob;
import net.i2p.router.networkdb.kademlia.ExpireRoutersJob;
import net.i2p.router.networkdb.kademlia.NegativeLookupCache;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.networkdb.kademlia.RepublishLeaseSetJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.StartExplorersJob;
import net.i2p.router.networkdb.kademlia.StoreJob;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class KademliaNetworkDatabaseFacade
extends NetworkDatabaseFacade {
    protected final Log _log;
    private KBucketSet<Hash> _kb;
    private DataStore _ds;
    private String _dbDir;
    private final Set<Hash> _exploreKeys = new ConcurrentHashSet<Hash>(64);
    private boolean _initialized;
    private long _started;
    private StartExplorersJob _exploreJob;
    private long _lastExploreNew;
    protected final PeerSelector _peerSelector;
    protected final RouterContext _context;
    private final ReseedChecker _reseedChecker;
    private volatile long _lastRIPublishTime;
    private NegativeLookupCache _negativeCache;
    protected final int _networkID;
    private final Map<Hash, RepublishLeaseSetJob> _publishingLeaseSets;
    private final Map<Hash, SearchJob> _activeRequests;
    protected static final long DONT_FAIL_PERIOD = 600000L;
    private static final boolean QUIET = false;
    public static final String PROP_DB_DIR = "router.networkDatabase.dbDir";
    public static final String DEFAULT_DB_DIR = "netDb";
    static final int MIN_RESEED = 50;
    protected static final int MIN_REMAINING_ROUTERS = 40;
    private static final long ROUTER_INFO_EXPIRATION = 97200000L;
    private static final long ROUTER_INFO_EXPIRATION_MIN = 5400000L;
    private static final long ROUTER_INFO_EXPIRATION_SHORT = 4500000L;
    private static final long ROUTER_INFO_EXPIRATION_FLOODFILL = 3600000L;
    private static final long ROUTER_INFO_EXPIRATION_INTRODUCED = 2700000L;
    private static final long EXPLORE_JOB_DELAY = 600000L;
    protected static final long PUBLISH_JOB_DELAY = 300000L;
    static final int MAX_EXPLORE_QUEUE = 128;
    private static final int BUCKET_SIZE = 24;
    private static final int KAD_B = 4;
    private static final long PUBLISH_DELAY = 3000L;
    static final long MAX_LEASE_FUTURE = 1200000L;
    private static final int MIN_ROUTERS = 90;
    private static final int MIN_PER_PEER_TIMEOUT = 2000;
    private static final int MAX_PER_PEER_TIMEOUT = 7000;
    private static final int TIMEOUT_MULTIPLIER = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchComplete(Hash key) {
        if (this._log.shouldLog(10)) {
            this._log.debug("search Complete: " + key);
        }
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            this._activeRequests.remove(key);
        }
    }

    public KademliaNetworkDatabaseFacade(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(this.getClass());
        this._networkID = context.router().getNetworkID();
        this._peerSelector = this.createPeerSelector();
        this._publishingLeaseSets = new HashMap<Hash, RepublishLeaseSetJob>(8);
        this._activeRequests = new HashMap<Hash, SearchJob>(8);
        this._reseedChecker = new ReseedChecker(context);
        context.statManager().createRateStat("netDb.lookupDeferred", "how many lookups are deferred?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.exploreKeySet", "how many keys are queued for exploration?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.negativeCache", "Aborted lookup, already cached", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeRouterInfoSent", "How many routerInfo store messages have we sent?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeLeaseSetSent", "How many leaseSet store messages have we sent?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storePeers", "How many peers each netDb must be sent to before success?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeFailedPeers", "How many peers each netDb must be sent to before failing completely?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.ackTime", "How long does it take for a peer to ack a netDb store?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.replyTimeout", "How long after a netDb send does the timeout expire (when the peer doesn't reply in time)?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.republishLeaseSetCount", "How often we republish a leaseSet?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.DSMAllZeros", "Store with zero key", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.DLMAllZeros", "Lookup with zero key", "NetworkDatabase", new long[]{3600000L});
    }

    @Override
    public boolean isInitialized() {
        return this._initialized && this._ds != null && this._ds.isInitialized();
    }

    protected PeerSelector createPeerSelector() {
        return new PeerSelector(this._context);
    }

    public PeerSelector getPeerSelector() {
        return this._peerSelector;
    }

    @Override
    public ReseedChecker reseedChecker() {
        return this._reseedChecker;
    }

    KBucketSet<Hash> getKBuckets() {
        return this._kb;
    }

    DataStore getDataStore() {
        return this._ds;
    }

    long getLastExploreNewDate() {
        return this._lastExploreNew;
    }

    void setLastExploreNewDate(long when) {
        this._lastExploreNew = when;
        if (this._exploreJob != null) {
            this._exploreJob.updateExploreSchedule();
        }
    }

    public Set<Hash> getExploreKeys() {
        if (!this._initialized) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._exploreKeys);
    }

    public void removeFromExploreKeys(Collection<Hash> toRemove) {
        if (!this._initialized) {
            return;
        }
        this._exploreKeys.removeAll(toRemove);
        this._context.statManager().addRateData("netDb.exploreKeySet", this._exploreKeys.size());
    }

    public void queueForExploration(Collection<Hash> keys) {
        if (!this._initialized) {
            return;
        }
        Iterator<Hash> iter = keys.iterator();
        while (iter.hasNext() && this._exploreKeys.size() < 128) {
            this._exploreKeys.add(iter.next());
        }
        this._context.statManager().addRateData("netDb.exploreKeySet", this._exploreKeys.size());
    }

    @Override
    public synchronized void shutdown() {
        this._initialized = false;
        if (this._kb != null) {
            this._kb.clear();
        }
        if (this._ds != null) {
            this._ds.stop();
        }
        this._exploreKeys.clear();
        this._negativeCache.clear();
    }

    @Override
    public synchronized void restart() {
        this._dbDir = this._context.router().getConfigSetting(PROP_DB_DIR);
        if (this._dbDir == null) {
            this._log.info("No DB dir specified [router.networkDatabase.dbDir], using [netDb]");
            this._dbDir = DEFAULT_DB_DIR;
        }
        this._ds.restart();
        this._exploreKeys.clear();
        this._initialized = true;
        RouterInfo ri = this._context.router().getRouterInfo();
        this.publish(ri);
    }

    @Override
    public void rescan() {
        if (this.isInitialized()) {
            this._ds.rescan();
        }
    }

    String getDbDir() {
        return this._dbDir;
    }

    @Override
    public synchronized void startup() {
        this._log.info("Starting up the kademlia network database");
        RouterInfo ri = this._context.router().getRouterInfo();
        String dbDir = this._context.getProperty(PROP_DB_DIR, DEFAULT_DB_DIR);
        this._kb = new KBucketSet<Hash>(this._context, ri.getIdentity().getHash(), 24, 4, new RejectTrimmer());
        try {
            this._ds = new PersistentDataStore(this._context, dbDir, this);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to initialize netdb storage", ioe);
        }
        this._dbDir = dbDir;
        this._negativeCache = new NegativeLookupCache(this._context);
        this.createHandlers();
        this._initialized = true;
        this._started = System.currentTimeMillis();
        ExpireLeasesJob elj = new ExpireLeasesJob(this._context, this);
        elj.getTiming().setStartAfter(this._context.clock().now() + 120000L);
        this._context.jobQueue().addJob(elj);
        if (!this._context.commSystem().isDummy()) {
            ExpireRoutersJob erj = new ExpireRoutersJob(this._context, this);
            erj.getTiming().setStartAfter(this._context.clock().now() + 3600000L + 600000L);
            this._context.jobQueue().addJob(erj);
        }
        if (this._exploreJob == null) {
            this._exploreJob = new StartExplorersJob(this._context, this);
        }
        this._exploreJob.getTiming().setStartAfter(this._context.clock().now() + 600000L);
        this._context.jobQueue().addJob(this._exploreJob);
        PublishLocalRouterInfoJob plrij = new PublishLocalRouterInfoJob(this._context);
        this._context.jobQueue().addJob(plrij);
    }

    protected void createHandlers() {
    }

    @Override
    public Set<Hash> findNearestRouters(Hash key, int maxNumRouters, Set<Hash> peersToIgnore) {
        if (!this._initialized) {
            return Collections.emptySet();
        }
        return new HashSet<Hash>(this._peerSelector.selectNearest(key, maxNumRouters, peersToIgnore, this._kb));
    }

    @Override
    public Set<Hash> getAllRouters() {
        if (!this._initialized) {
            return Collections.emptySet();
        }
        Set<Map.Entry<Hash, DatabaseEntry>> entries = this._ds.getMapEntries();
        HashSet<Hash> rv = new HashSet<Hash>(entries.size());
        for (Map.Entry<Hash, DatabaseEntry> entry : entries) {
            if (entry.getValue().getType() != 0) continue;
            rv.add(entry.getKey());
        }
        return rv;
    }

    @Override
    public int getKnownRouters() {
        if (this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (ds.getType() != 0) continue;
            ++rv;
        }
        return rv;
    }

    @Override
    public int getKnownLeaseSets() {
        if (this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (ds.getType() != 1 || !((LeaseSet)ds).getReceivedAsPublished()) continue;
            ++rv;
        }
        return rv;
    }

    protected int getKBucketSetSize() {
        if (this._kb == null) {
            return 0;
        }
        return this._kb.size();
    }

    @Override
    public DatabaseEntry lookupLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry rv = this._ds.get(key);
        if (rv == null) {
            return null;
        }
        if (rv.getType() == 1) {
            LeaseSet ls = (LeaseSet)rv;
            if (ls.isCurrent(60000L)) {
                return rv;
            }
            this.fail(key);
        } else if (rv.getType() == 0) {
            try {
                if (this.validate((RouterInfo)rv) == null) {
                    return rv;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.fail(key);
        }
        return null;
    }

    DatabaseEntry lookupLocallyWithoutValidation(Hash key) {
        if (!this._initialized) {
            return null;
        }
        return this._ds.get(key);
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        this.lookupLeaseSet(key, onFindJob, onFailedLookupJob, timeoutMs, null);
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        LeaseSet ls = this.lookupLeaseSetLocally(key);
        if (ls != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Negative cached, not searching LS: " + key);
            }
            if (onFailedLookupJob != null) {
                this._context.jobQueue().addJob(onFailedLookupJob);
            }
        } else {
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true, fromLocalDest);
        }
    }

    @Override
    public void lookupLeaseSetRemotely(Hash key, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        this.search(key, null, null, 20000L, true, fromLocalDest);
    }

    @Override
    public LeaseSet lookupLeaseSetLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 1) {
                LeaseSet ls = (LeaseSet)ds;
                if (ls.isCurrent(60000L)) {
                    return ls;
                }
                this.fail(key);
                this._exploreKeys.add(key);
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void lookupDestination(Hash key, Job onFinishedJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        Destination d = this.lookupDestinationLocally(key);
        if (d != null) {
            this._context.jobQueue().addJob(onFinishedJob);
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Negative cached, not searching dest: " + key);
            }
        } else {
            this.search(key, onFinishedJob, onFinishedJob, timeoutMs, true, fromLocalDest);
        }
    }

    @Override
    public Destination lookupDestinationLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 1) {
                LeaseSet ls = (LeaseSet)ds;
                return ls.getDestination();
            }
        } else {
            return this._negativeCache.getBadDest(key);
        }
        return null;
    }

    @Override
    public void lookupRouterInfo(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        RouterInfo ri = this.lookupRouterInfoLocally(key);
        if (ri != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else if (this._context.banlist().isBanlistedForever(key)) {
            if (onFailedLookupJob != null) {
                this._context.jobQueue().addJob(onFailedLookupJob);
            }
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Negative cached, not searching RI: " + key);
            }
        } else {
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, false);
        }
    }

    @Override
    public RouterInfo lookupRouterInfoLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 0) {
                boolean valid = true;
                try {
                    valid = null == this.validate((RouterInfo)ds);
                }
                catch (IllegalArgumentException iae) {
                    valid = false;
                }
                if (!valid) {
                    this.fail(key);
                    return null;
                }
                return (RouterInfo)ds;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LeaseSet localLeaseSet) throws IllegalArgumentException {
        int code;
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getDestination().calculateHash();
        try {
            this.store(h, localLeaseSet);
        }
        catch (IllegalArgumentException iae) {
            this._log.error("locally published leaseSet is not valid?", iae);
            throw iae;
        }
        if (!this._context.clientManager().shouldPublishLeaseSet(h)) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress() && ((code = this._context.router().scheduledGracefulExitCode()) == 2 || code == 3)) {
            return;
        }
        RepublishLeaseSetJob j = null;
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            j = this._publishingLeaseSets.get(h);
            if (j == null) {
                j = new RepublishLeaseSetJob(this._context, this, h);
                this._publishingLeaseSets.put(h, j);
            }
        }
        long nextTime = Math.max(j.lastPublished() + 60000L, this._context.clock().now() + 3000L);
        this._context.jobQueue().removeJob(j);
        j.getTiming().setStartAfter(nextTime);
        if (this._log.shouldLog(20)) {
            this._log.info("Queueing to publish at " + new Date(nextTime) + ' ' + localLeaseSet);
        }
        this._context.jobQueue().addJob(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPublishing(Hash target) {
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            this._publishingLeaseSets.remove(target);
        }
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (!this._initialized) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            return;
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Hash h = localRouterInfo.getIdentity().getHash();
        this.store(h, localRouterInfo);
    }

    void routerInfoPublishSuccessful() {
        this._lastRIPublishTime = this._context.clock().now();
    }

    @Override
    public long getLastRouterInfoPublishTime() {
        return this._lastRIPublishTime;
    }

    private String validate(Hash key, LeaseSet leaseSet) throws UnsupportedCryptoException {
        if (!key.equals(leaseSet.getDestination().calculateHash())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid store attempt! key does not match leaseSet.destination!  key = " + key + ", leaseSet = " + leaseSet);
            }
            return "Key does not match leaseSet.destination - " + key.toBase64();
        }
        if (!leaseSet.verifySignature()) {
            this.processStoreFailure(key, leaseSet);
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid leaseSet signature! " + leaseSet);
            }
            return "Invalid leaseSet signature on " + key;
        }
        long earliest = leaseSet.getEarliestLeaseDate();
        long latest = leaseSet.getLatestLeaseDate();
        long now = this._context.clock().now();
        if (earliest <= now - 600000L || latest <= now - 60000L) {
            long age = now - earliest;
            if (this._log.shouldLog(30)) {
                this._log.warn("Old leaseSet!  not storing it: " + leaseSet.getDestination().calculateHash() + " first exp. " + new Date(earliest) + " last exp. " + new Date(latest), new Exception("Rejecting store"));
            }
            return "Expired leaseSet for " + leaseSet.getDestination().calculateHash() + " expired " + DataHelper.formatDuration(age) + " ago";
        }
        if (latest > now + 1260000L) {
            long age = latest - now;
            if (this._log.shouldLog(30)) {
                this._log.warn("LeaseSet expires too far in the future: " + leaseSet.getDestination().calculateHash() + " expires " + DataHelper.formatDuration(age) + " from now");
            }
            return "Future expiring leaseSet for " + leaseSet.getDestination().calculateHash() + " expiring in " + DataHelper.formatDuration(age);
        }
        return null;
    }

    @Override
    public LeaseSet store(Hash key, LeaseSet leaseSet) throws IllegalArgumentException {
        if (!this._initialized) {
            return null;
        }
        LeaseSet rv = null;
        try {
            rv = (LeaseSet)this._ds.get(key);
            if (rv != null && rv.equals(leaseSet)) {
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace RI with " + leaseSet);
        }
        if (rv != null && !leaseSet.getDestination().equals(rv.getDestination())) {
            throw new IllegalArgumentException("LS Hash collision");
        }
        String err = this.validate(key, leaseSet);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        this._ds.put(key, leaseSet);
        return rv;
    }

    private String validate(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        boolean validFamily;
        if (!key.equals(routerInfo.getIdentity().getHash())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid store attempt! key does not match routerInfo.identity!  key = " + key + ", router = " + routerInfo);
            }
            return "Key does not match routerInfo.identity";
        }
        if (!routerInfo.isValid()) {
            this.processStoreFailure(key, routerInfo);
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid routerInfo signature!  forged router structure!  router = " + routerInfo);
            }
            return "Invalid routerInfo signature";
        }
        if (routerInfo.getNetworkId() != this._networkID) {
            this._context.banlist().banlistRouter(key, "Not in our network");
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad network: " + routerInfo);
            }
            return "Not in our network";
        }
        FamilyKeyCrypto fkc = this._context.router().getFamilyKeyCrypto();
        if (fkc != null && !(validFamily = fkc.verify(routerInfo)) && this._log.shouldWarn()) {
            this._log.warn("Bad family sig: " + routerInfo.getHash());
        }
        return this.validate(routerInfo);
    }

    String validate(RouterInfo routerInfo) throws IllegalArgumentException {
        long age;
        long now = this._context.clock().now();
        boolean upLongEnough = this._context.router().getUptime() > 3600000L;
        long adjustedExpiration = this.floodfillEnabled() ? 3600000L : Math.min(97200000L, 5400000L + 8262000000L / (long)(this._kb.size() + 1));
        if (upLongEnough && !routerInfo.isCurrent(adjustedExpiration)) {
            age = this._context.clock().now() - routerInfo.getPublished();
            int existing = this._kb.size();
            if (existing >= 40) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Expired RI " + routerInfo.getIdentity().getHash(), new Exception());
                }
                return "Peer expired " + DataHelper.formatDuration(age) + " ago";
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Even though the peer is old, we have only " + existing + " peers left " + routerInfo);
            }
        }
        if (routerInfo.getPublished() > now + 120000L) {
            age = routerInfo.getPublished() - this._context.clock().now();
            if (this._log.shouldLog(20)) {
                this._log.info("Peer " + routerInfo.getIdentity().getHash() + " published their routerInfo in the future?! [" + new Date(routerInfo.getPublished()) + "]", new Exception());
            }
            return "Peer published " + DataHelper.formatDuration(age) + " in the future?!";
        }
        if (!routerInfo.isCurrent(2700000L)) {
            if (routerInfo.getAddresses().isEmpty()) {
                return "Old peer with no addresses";
            }
            if (routerInfo.getCapabilities().indexOf(85) >= 0) {
                return "Old peer and thinks it is unreachable";
            }
            for (RouterAddress ra : routerInfo.getAddresses()) {
                if (ra.getOption("ihost0") == null) continue;
                return "Old peer with SSU Introducers";
            }
        }
        if (upLongEnough && routerInfo.getPublished() < now - 172800000L) {
            age = this._context.clock().now() - routerInfo.getPublished();
            return "Peer published " + DataHelper.formatDuration(age) + " ago";
        }
        if (upLongEnough && !routerInfo.isCurrent(4500000L) && routerInfo.getTargetAddress("NTCP") == null) {
            return "Peer published > 75m ago, SSU only without introducers";
        }
        return null;
    }

    @Override
    public RouterInfo store(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        return this.store(key, routerInfo, true);
    }

    RouterInfo store(Hash key, RouterInfo routerInfo, boolean persist) throws IllegalArgumentException {
        if (!this._initialized) {
            return null;
        }
        RouterInfo rv = null;
        try {
            rv = (RouterInfo)this._ds.get(key, persist);
            if (rv != null && rv.equals(routerInfo)) {
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace LS with " + routerInfo);
        }
        if (rv != null && !routerInfo.getIdentity().equals(rv.getIdentity())) {
            throw new IllegalArgumentException("RI Hash collision");
        }
        String err = this.validate(key, routerInfo);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        this._context.peerManager().setCapabilities(key, routerInfo.getCapabilities());
        this._ds.put(key, routerInfo, persist);
        if (rv == null) {
            this._kb.add(key);
        }
        return rv;
    }

    private void processStoreFailure(Hash h, DatabaseEntry entry) throws UnsupportedCryptoException {
        if (entry.getHash().equals(h)) {
            RouterInfo ri;
            RouterIdentity id;
            Certificate c;
            if (entry.getType() == 1) {
                LeaseSet ls = (LeaseSet)entry;
                Destination d = ls.getDestination();
                Certificate c2 = d.getCertificate();
                if (c2.getCertificateType() == 5) {
                    try {
                        KeyCertificate kc = c2.toKeyCertificate();
                        SigType type = kc.getSigType();
                        if (type == null || !type.isAvailable() || type.getBaseAlgorithm() == SigAlgo.RSA) {
                            String stype;
                            this.failPermanently(d);
                            String string = stype = type != null ? type.toString() : Integer.toString(kc.getSigTypeCode());
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Unsupported sig type " + stype + " for destination " + h);
                            }
                            throw new UnsupportedCryptoException("Sig type " + stype);
                        }
                    }
                    catch (DataFormatException kc) {}
                }
            } else if (entry.getType() == 0 && (c = (id = (ri = (RouterInfo)entry).getIdentity()).getCertificate()).getCertificateType() == 5) {
                try {
                    KeyCertificate kc = c.toKeyCertificate();
                    SigType type = kc.getSigType();
                    if (type == null || !type.isAvailable()) {
                        String stype = type != null ? type.toString() : Integer.toString(kc.getSigTypeCode());
                        this._context.banlist().banlistRouterForever(h, "Unsupported signature type " + stype);
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Unsupported sig type " + stype + " for router " + h);
                        }
                        throw new UnsupportedCryptoException("Sig type " + stype);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Verify fail, cause unknown: " + entry);
        }
    }

    @Override
    public void fail(Hash dbEntry) {
        if (!this._initialized) {
            return;
        }
        DatabaseEntry o = this._ds.get(dbEntry);
        if (o == null) {
            this._kb.remove(dbEntry);
            this._context.peerManager().removeCapabilities(dbEntry);
            return;
        }
        if (o.getType() == 0) {
            this.lookupBeforeDropping(dbEntry, (RouterInfo)o);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Dropping a lease: " + dbEntry);
        }
        this._ds.remove(dbEntry, false);
    }

    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        this.dropAfterLookupFailed(peer);
    }

    void dropAfterLookupFailed(Hash peer) {
        this._context.peerManager().removeCapabilities(peer);
        this._kb.remove(peer);
        this._ds.remove(peer);
    }

    @Override
    public void unpublish(LeaseSet localLeaseSet) {
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getDestination().calculateHash();
        DatabaseEntry data = this._ds.remove(h);
        if (data == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unpublished a lease we don't know...: " + localLeaseSet);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Unpublished a lease: " + h);
        }
    }

    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        throw new UnsupportedOperationException();
    }

    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease, Hash fromLocalDest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LeaseSet> getLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (o.getType() != 1) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<RouterInfo> getRouters() {
        if (!this._initialized) {
            return null;
        }
        HashSet<RouterInfo> routers = new HashSet<RouterInfo>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (o.getType() != 0) continue;
            routers.add((RouterInfo)o);
        }
        return routers;
    }

    public int getPeerTimeout(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        double responseTime = 7000.0;
        if (prof != null && prof.getIsExpandedDB()) {
            responseTime = prof.getDbResponseTime().getRate(86400000L).getAverageValue();
            if (responseTime <= 0.0 || responseTime > 7000.0) {
                responseTime = 7000.0;
            } else if (responseTime < 2000.0) {
                responseTime = 2000.0;
            }
        }
        return 3 * (int)responseTime;
    }

    public void sendStore(Hash key, DatabaseEntry ds, Job onSuccess, Job onFailure, long sendTimeout, Set<Hash> toIgnore) {
        if (ds == null || key == null) {
            if (onFailure != null) {
                this._context.jobQueue().addJob(onFailure);
            }
            return;
        }
        this._context.jobQueue().addJob(new StoreJob(this._context, this, key, ds, onSuccess, onFailure, sendTimeout, toIgnore));
    }

    void lookupFailed(Hash key) {
        this._negativeCache.lookupFailed(key);
    }

    boolean isNegativeCached(Hash key) {
        boolean rv = this._negativeCache.isCached(key);
        if (rv) {
            this._context.statManager().addRateData("netDb.negativeCache", 1L);
        }
        return rv;
    }

    void failPermanently(Destination dest) {
        this._negativeCache.failPermanently(dest);
    }

    @Override
    public boolean isNegativeCachedForever(Hash key) {
        return this._negativeCache.getBadDest(key) != null;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        out.write(this._kb.toString().replace("\n", "<br>\n"));
    }
}

