/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.Translate;

public class Blocklist {
    private final Log _log;
    private final RouterContext _context;
    private long[] _blocklist;
    private int _blocklistSize;
    private final Object _lock = new Object();
    private Entry _wrapSave;
    private final Set<Hash> _inProcess = new HashSet<Hash>(4);
    private final File _blocklistFeedFile;
    private Map<Hash, String> _peerBlocklist = new HashMap<Hash, String>(4);
    private static final int MAX_IPV4_SINGLES = 8192;
    private static final int MAX_IPV6_SINGLES = 4096;
    private final Set<Integer> _singleIPBlocklist = new ConcurrentHashSet<Integer>(4);
    private final Map<BigInteger, Object> _singleIPv6Blocklist = new LHMCache<BigInteger, Object>(4096);
    private static final Object DUMMY = 0;
    private static final String PROP_BLOCKLIST_ENABLED = "router.blocklist.enable";
    private static final String PROP_BLOCKLIST_DETAIL = "router.blocklist.detail";
    private static final String PROP_BLOCKLIST_FILE = "router.blocklist.file";
    private static final String BLOCKLIST_FILE_DEFAULT = "blocklist.txt";
    private static final String BLOCKLIST_FEED_FILE = "docs/feed/blocklist/blocklist.txt";
    private static final int MAX_DISPLAY = 1000;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public Blocklist(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(Blocklist.class);
        this._blocklistFeedFile = new File(context.getConfigDir(), BLOCKLIST_FEED_FILE);
    }

    private Blocklist() {
        this._context = null;
        this._log = new Log(Blocklist.class);
        this._blocklistFeedFile = new File(BLOCKLIST_FEED_FILE);
    }

    public void startup() {
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_BLOCKLIST_ENABLED)) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>(4);
        File blFile = new File(this._context.getBaseDir(), BLOCKLIST_FILE_DEFAULT);
        files.add(blFile);
        if (!this._context.getConfigDir().equals(this._context.getBaseDir())) {
            blFile = new File(this._context.getConfigDir(), BLOCKLIST_FILE_DEFAULT);
            files.add(blFile);
        }
        files.add(this._blocklistFeedFile);
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE);
        if (file != null && !file.equals(BLOCKLIST_FILE_DEFAULT)) {
            blFile = new File(file);
            if (!blFile.isAbsolute()) {
                blFile = new File(this._context.getConfigDir(), file);
            }
            files.add(blFile);
        }
        ReadinJob job = new ReadinJob(files);
        job.getTiming().setStartAfter(this._context.clock().now() + 30000L);
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this._lock;
        synchronized (object) {
            this._blocklistSize = 0;
            this._blocklist = null;
        }
    }

    private void allocate(List<File> files) {
        int maxSize = 0;
        for (File f : files) {
            maxSize += this.getSize(f);
        }
        try {
            this._blocklist = new long[maxSize + files.size()];
        }
        catch (OutOfMemoryError oom) {
            this._log.log(50, "OOM creating the blocklist");
            this.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBlocklistFile(File blFile, int count) {
        if (blFile == null || !blFile.exists() || blFile.length() <= 0L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Blocklist file not found: " + blFile);
            }
            return count;
        }
        long start = this._context.clock().now();
        int oldcount = count;
        int badcount = 0;
        int peercount = 0;
        long ipcount = 0L;
        boolean isFeedFile = blFile.equals(this._blocklistFeedFile);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "UTF-8"));
            String buf = null;
            while ((buf = br.readLine()) != null) {
                Entry e = this.parse(buf, true);
                if (e == null) {
                    ++badcount;
                    continue;
                }
                if (e.peer != null) {
                    this._peerBlocklist.put(e.peer, e.comment);
                    ++peercount;
                    continue;
                }
                byte[] ip1 = e.ip1;
                if (ip1.length == 4) {
                    if (isFeedFile) {
                        this.add(ip1);
                        continue;
                    }
                    byte[] ip2 = e.ip2;
                    this.store(ip1, ip2, count++);
                    ipcount += (long)(1 + Blocklist.toInt(ip2) - Blocklist.toInt(ip1));
                    continue;
                }
                this.add(ip1);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the blocklist file", ioe);
            }
            int n = count;
            return n;
        }
        catch (OutOfMemoryError oom) {
            this._blocklist = null;
            this._log.log(50, "OOM reading the blocklist");
            int n = count;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._wrapSave != null) {
            this.store(this._wrapSave.ip1, this._wrapSave.ip2, count++);
            ipcount += (long)(1 + Blocklist.toInt(this._wrapSave.ip2) - Blocklist.toInt(this._wrapSave.ip1));
            this._wrapSave = null;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Stats for " + blFile);
            this._log.info("Removed " + badcount + " bad entries and comment lines");
            this._log.info("Read " + (count - oldcount) + " valid entries from the blocklist " + blFile);
            this._log.info("Blocking " + ipcount + " IPs and " + peercount + " hashes");
            this._log.info("Blocklist processing finished, time: " + (this._context.clock().now() - start));
        }
        return count;
    }

    private void merge(int count) {
        long start = this._context.clock().now();
        int removed = 0;
        try {
            Arrays.sort(this._blocklist, 0, count);
            removed = this.removeOverlap(this._blocklist, count);
            if (removed > 0) {
                Arrays.sort(this._blocklist, 0, count);
            }
        }
        catch (OutOfMemoryError oom) {
            this._blocklist = null;
            this._log.log(50, "OOM sorting the blocklist");
            return;
        }
        this._blocklistSize = count - removed;
        if (this._log.shouldLog(20)) {
            this._log.info("Merged Stats");
            this._log.info("Read " + count + " total entries from the blocklists");
            this._log.info("Merged " + removed + " overlapping entries");
            this._log.info("Result is " + this._blocklistSize + " entries");
            this._log.info("Blocklist processing finished, time: " + (this._context.clock().now() - start));
        }
    }

    private Entry parse(String buf, boolean shouldLog) {
        byte[] ip2;
        byte[] ip1;
        byte[] b;
        int start1 = 0;
        int end1 = buf.length();
        if (end1 <= 0) {
            return null;
        }
        if (end1 <= 0) {
            return null;
        }
        int start2 = -1;
        int mask = -1;
        String comment = null;
        int index = buf.indexOf(35);
        if (index == 0) {
            return null;
        }
        index = buf.lastIndexOf(58);
        if (index >= 0) {
            comment = buf.substring(0, index);
            start1 = index + 1;
        }
        if (end1 - start1 == 44 && buf.substring(start1).indexOf(46) < 0 && (b = Base64.decode(buf.substring(start1))) != null) {
            return new Entry(comment, Hash.create(b), null, null);
        }
        index = buf.indexOf(45, start1);
        if (index >= 0) {
            end1 = index;
            start2 = index + 1;
        } else {
            index = buf.indexOf(47, start1);
            if (index >= 0) {
                end1 = index;
                mask = index + 1;
            }
        }
        if (end1 - start1 <= 0) {
            return null;
        }
        try {
            String sip = buf.substring(start1, end1);
            sip = sip.replace(';', ':');
            InetAddress pi = InetAddress.getByName(sip);
            if (pi == null) {
                return null;
            }
            ip1 = pi.getAddress();
            if (start2 >= 0) {
                pi = InetAddress.getByName(buf.substring(start2));
                if (pi == null) {
                    return null;
                }
                ip2 = pi.getAddress();
                if (ip2.length != 4) {
                    throw new UnknownHostException();
                }
                if ((ip1[0] & 0xFF) < 128 && (ip2[0] & 0xFF) >= 128) {
                    if (this._wrapSave == null) {
                        this._wrapSave = new Entry(comment, null, new byte[]{-128, 0, 0, 0}, new byte[]{ip2[0], ip2[1], ip2[2], ip2[3]});
                        ip2 = new byte[]{127, -1, -1, -1};
                    } else {
                        throw new NumberFormatException();
                    }
                }
                for (int i = 0; i < 4 && (ip2[i] & 0xFF) <= (ip1[i] & 0xFF); ++i) {
                    if ((ip2[i] & 0xFF) >= (ip1[i] & 0xFF)) continue;
                    throw new NumberFormatException();
                }
            } else if (mask >= 0) {
                int i;
                int m = Integer.parseInt(buf.substring(mask));
                if (m < 3 || m > 32) {
                    throw new NumberFormatException();
                }
                ip2 = new byte[4];
                for (i = 0; i < 4; ++i) {
                    ip2[i] = ip1[i];
                }
                for (i = 0; i < 32 - m; ++i) {
                    int n = (31 - i) / 8;
                    ip2[n] = (byte)(ip2[n] | 1 << i % 8);
                }
            } else {
                ip2 = ip1;
            }
        }
        catch (UnknownHostException uhe) {
            if (shouldLog) {
                this._log.logAlways(30, "Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            if (shouldLog) {
                this._log.logAlways(30, "Format error in the blocklist file: " + buf);
            }
            return null;
        }
        catch (IndexOutOfBoundsException ioobe) {
            if (shouldLog) {
                this._log.logAlways(30, "Format error in the blocklist file: " + buf);
            }
            return null;
        }
        return new Entry(comment, null, ip1, ip2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSize(File blFile) {
        if (!blFile.exists() || blFile.length() <= 0L) {
            return 0;
        }
        int lines = 0;
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "ISO-8859-1"));
            while ((s = br.readLine()) != null) {
                if (s.length() <= 0 || s.startsWith("#")) continue;
                ++lines;
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading the blocklist file", ioe);
            }
            int n = 0;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    private int removeOverlap(long[] blist, int count) {
        int removed;
        if (count <= 0) {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < count - 1; i += removed + 1) {
            removed = 0;
            int to = Blocklist.getTo(blist[i]);
            for (int next = i + 1; next < count && to >= Blocklist.getFrom(blist[next]); ++next) {
                int nextTo;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Combining entries " + Blocklist.toStr(blist[i]) + " and " + Blocklist.toStr(blist[next]));
                }
                if ((nextTo = Blocklist.getTo(blist[next])) > to) {
                    this.store(Blocklist.getFrom(blist[i]), nextTo, i);
                }
                blist[next] = Long.MAX_VALUE;
                ++lines;
                ++removed;
            }
        }
        return lines;
    }

    public void add(String ip) {
        byte[] pib = Addresses.getIP(ip);
        if (pib == null) {
            return;
        }
        this.add(pib);
    }

    public void add(byte[] ip) {
        boolean rv = ip.length == 4 ? this.add(Blocklist.toInt(ip)) : (ip.length == 16 ? this.add(new BigInteger(1, ip)) : false);
        if (rv && this._log.shouldLog(30)) {
            this._log.warn("Adding IP to blocklist: " + Addresses.toString(ip));
        }
    }

    public void remove(byte[] ip) {
        if (ip.length == 4) {
            this.remove(Blocklist.toInt(ip));
        } else if (ip.length == 16) {
            this.remove(new BigInteger(1, ip));
        }
    }

    private boolean add(int ip) {
        if (this._singleIPBlocklist.size() >= 8192) {
            return false;
        }
        return this._singleIPBlocklist.add(ip);
    }

    private void remove(int ip) {
        this._singleIPBlocklist.remove(ip);
    }

    private boolean isOnSingleList(int ip) {
        return this._singleIPBlocklist.contains(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(BigInteger ip) {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            return this._singleIPv6Blocklist.put(ip, DUMMY) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(BigInteger ip) {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            this._singleIPv6Blocklist.remove(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOnSingleList(BigInteger ip) {
        Map<BigInteger, Object> map = this._singleIPv6Blocklist;
        synchronized (map) {
            return this._singleIPv6Blocklist.get(ip) != null;
        }
    }

    private List<byte[]> getAddresses(Hash peer) {
        RouterInfo pinfo = this._context.netDb().lookupRouterInfoLocally(peer);
        if (pinfo == null) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> rv = new ArrayList<byte[]>(4);
        for (RouterAddress pa : pinfo.getAddresses()) {
            byte[] pib = pa.getIP();
            if (pib == null) continue;
            boolean dup = false;
            for (int i = 0; i < rv.size(); ++i) {
                if (!DataHelper.eq((byte[])rv.get(i), pib)) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            rv.add(pib);
        }
        return rv;
    }

    public boolean isBlocklisted(Hash peer) {
        List<byte[]> ips = this.getAddresses(peer);
        if (ips.isEmpty()) {
            return false;
        }
        for (byte[] ip : ips) {
            if (!this.isBlocklisted(ip)) continue;
            if (!this._context.banlist().isBanlisted(peer)) {
                this.banlist(peer, ip);
            }
            return true;
        }
        return false;
    }

    public boolean isBlocklisted(String ip) {
        byte[] pib = Addresses.getIP(ip);
        if (pib == null) {
            return false;
        }
        return this.isBlocklisted(pib);
    }

    public boolean isBlocklisted(byte[] ip) {
        if (ip.length == 4) {
            return this.isBlocklisted(Blocklist.toInt(ip));
        }
        if (ip.length == 16) {
            return this.isOnSingleList(new BigInteger(1, ip));
        }
        return false;
    }

    private boolean isBlocklisted(int ip) {
        if (this.isOnSingleList(ip)) {
            return true;
        }
        int hi = this._blocklistSize - 1;
        if (hi <= 0) {
            return false;
        }
        int lo = 0;
        int cur = hi / 2;
        while (!this.match(ip, cur)) {
            if (this.isHigher(ip, cur)) {
                lo = cur;
            } else {
                hi = cur;
            }
            if (hi - lo <= 1) {
                if (lo == cur) {
                    cur = hi;
                    break;
                }
                cur = lo;
                break;
            }
            cur = lo + (hi - lo) / 2;
        }
        return this.match(ip, cur);
    }

    private boolean match(int ip, int cur) {
        return this.match(ip, this._blocklist[cur]);
    }

    private boolean match(int ip, long entry) {
        if (Blocklist.getFrom(entry) > ip) {
            return false;
        }
        return ip <= Blocklist.getTo(entry);
    }

    private boolean isHigher(int ip, int cur) {
        return ip > Blocklist.getFrom(this._blocklist[cur]);
    }

    private static int getFrom(long entry) {
        return (int)(entry >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getTo(long entry) {
        return (int)(entry & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long toEntry(byte[] ip1, byte[] ip2) {
        int i;
        long entry = 0L;
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip2[i] & 0xFF) << (3 - i) * 8;
        }
        for (i = 0; i < 4; ++i) {
            entry |= (long)(ip1[i] & 0xFF) << 32 + (3 - i) * 8;
        }
        return entry;
    }

    private void store(byte[] ip1, byte[] ip2, int idx) {
        this._blocklist[idx] = Blocklist.toEntry(ip1, ip2);
    }

    private void store(int ip1, int ip2, int idx) {
        long entry = (long)ip1 << 32;
        this._blocklist[idx] = entry |= (long)ip2 & 0xFFFFFFFFFFFFFFFFL;
    }

    private static int toInt(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return rv;
    }

    private static String toStr(long entry) {
        StringBuilder buf = new StringBuilder(32);
        for (int i = 7; i >= 0; --i) {
            buf.append(entry >> 8 * i & 0xFFL);
            if (i == 4) {
                buf.append('-');
                continue;
            }
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private static String toStr(int ip) {
        StringBuilder buf = new StringBuilder(16);
        for (int i = 3; i >= 0; --i) {
            buf.append(ip >> 8 * i & 0xFF);
            if (i <= 0) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void banlist(Hash peer, byte[] ip) {
        boolean shouldRunJob;
        int number;
        String reason = Blocklist._x("IP banned by blocklist.txt entry {0}");
        this._context.banlist().banlistRouterForever(peer, reason, Addresses.toString(ip));
        if (!this._context.getBooleanPropertyDefaultTrue(PROP_BLOCKLIST_DETAIL)) {
            return;
        }
        Set<Hash> set = this._inProcess;
        synchronized (set) {
            number = this._inProcess.size();
            shouldRunJob = this._inProcess.add(peer);
        }
        if (!shouldRunJob) {
            return;
        }
        BanlistJob job = new BanlistJob(peer, this.getAddresses(peer));
        if (number > 0) {
            job.getTiming().setStartAfter(this._context.clock().now() + 30000L * (long)number);
        }
        this._context.jobQueue().addJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void banlistForever(Hash peer, List<byte[]> ips) {
        File blFile = null;
        String file = this._context.getProperty(PROP_BLOCKLIST_FILE);
        if (file != null) {
            blFile = new File(file);
            if (!blFile.isAbsolute()) {
                blFile = new File(this._context.getConfigDir(), file);
            }
            if (!blFile.exists()) {
                blFile = null;
            }
        }
        if (blFile == null) {
            blFile = new File(this._context.getBaseDir(), BLOCKLIST_FILE_DEFAULT);
        }
        if (!blFile.exists() || blFile.length() <= 0L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Banlisting " + peer);
            }
            this._context.banlist().banlistRouterForever(peer, "Banned");
            return;
        }
        for (byte[] ip : ips) {
            int ipint = Blocklist.toInt(ip);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(blFile), "UTF-8"));
                String buf = null;
                while ((buf = br.readLine()) != null) {
                    Entry e = this.parse(buf, false);
                    if (e == null || e.peer != null) continue;
                    if (!this.match(ipint, Blocklist.toEntry(e.ip1, e.ip2))) continue;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String reason = Blocklist._x("IP banned by blocklist.txt entry {0}");
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Banlisting " + peer + " " + reason);
                    }
                    this._context.banlist().banlistRouterForever(peer, reason, buf.toString());
                    return;
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error reading the blocklist file", ioe);
            }
            finally {
                if (br == null) continue;
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void renderStatusHTML(Writer out) throws IOException {
        TreeSet<Integer> singles = new TreeSet<Integer>();
        singles.addAll(this._singleIPBlocklist);
        if (!singles.isEmpty() || !this._singleIPv6Blocklist.isEmpty()) {
            Integer n;
            int ip;
            out.write("<table><tr><th align=\"center\" colspan=\"2\"><b>");
            out.write(this._t("IPs Banned Until Restart"));
            out.write("</b></td></tr>");
            for (Integer n2 : singles) {
                ip = n2;
                if (ip < 0) continue;
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(ip));
                out.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            }
            Iterator iterator = singles.iterator();
            while (iterator.hasNext() && (ip = (n = (Integer)iterator.next()).intValue()) < 0) {
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(ip));
                out.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            }
            if (!this._singleIPv6Blocklist.isEmpty()) {
                ArrayList<BigInteger> s6;
                Map<BigInteger, Object> map = this._singleIPv6Blocklist;
                synchronized (map) {
                    s6 = new ArrayList<BigInteger>(this._singleIPv6Blocklist.keySet());
                }
                Collections.sort(s6);
                for (BigInteger bi : s6) {
                    out.write("<tr><td align=\"center\" width=\"50%\">");
                    out.write(Addresses.toString(Blocklist.toIPBytes(bi)));
                    out.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
                }
            }
            out.write("</table>");
        }
        if (this._blocklistSize > 0) {
            void var4_13;
            int to;
            int from;
            void var4_12;
            int i;
            out.write("<table><tr><th align=\"center\" colspan=\"2\"><b>");
            out.write(this._t("IPs Permanently Banned"));
            out.write("</b></th></tr><tr><td align=\"center\" width=\"50%\"><b>");
            out.write(this._t("From"));
            out.write("</b></td><td align=\"center\" width=\"50%\"><b>");
            out.write(this._t("To"));
            out.write("</b></td></tr>");
            int max = Math.min(this._blocklistSize, 1000);
            boolean bl = false;
            for (i = 0; i < this._blocklistSize && var4_12 < max; ++i) {
                from = Blocklist.getFrom(this._blocklist[i]);
                if (from < 0) continue;
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(from));
                out.write("</td><td align=\"center\" width=\"50%\">");
                to = Blocklist.getTo(this._blocklist[i]);
                if (to != from) {
                    out.write(Blocklist.toStr(to));
                    out.write("</td></tr>\n");
                } else {
                    out.write("&nbsp;</td></tr>\n");
                }
                ++var4_12;
            }
            for (i = 0; i < max && ++var4_13 < max && (from = Blocklist.getFrom(this._blocklist[i])) < 0; ++i) {
                out.write("<tr><td align=\"center\" width=\"50%\">");
                out.write(Blocklist.toStr(from));
                out.write("</td><td align=\"center\" width=\"50%\">");
                to = Blocklist.getTo(this._blocklist[i]);
                if (to != from) {
                    out.write(Blocklist.toStr(to));
                    out.write("</td></tr>\n");
                    continue;
                }
                out.write("&nbsp;</td></tr>\n");
            }
            if (this._blocklistSize > 1000) {
                out.write("<tr><th colspan=2>First 1000 displayed, see the blocklist.txt file for the full list</th></tr>");
            }
            out.write("</table>");
        } else {
            out.write("<br><i>");
            out.write(this._t("none"));
            out.write("</i>");
        }
        out.flush();
    }

    private static byte[] toIPBytes(BigInteger bi) {
        byte[] ba = bi.toByteArray();
        int len = ba.length;
        if (len == 16) {
            return ba;
        }
        byte[] rv = new byte[16];
        if (len < 16) {
            System.arraycopy(ba, 0, rv, 16 - len, len);
        } else {
            System.arraycopy(ba, len - 16, rv, 0, 16);
        }
        return rv;
    }

    private static final String _x(String s) {
        return s;
    }

    private String _t(String key) {
        return Translate.getString(key, this._context, BUNDLE_NAME);
    }

    private class BanlistJob
    extends JobImpl {
        private final Hash _peer;
        private final List<byte[]> _ips;

        public BanlistJob(Hash p, List<byte[]> ips) {
            super(Blocklist.this._context);
            this._peer = p;
            this._ips = ips;
        }

        @Override
        public String getName() {
            return "Ban Peer by IP";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Blocklist.this.banlistForever(this._peer, this._ips);
            Set set = Blocklist.this._inProcess;
            synchronized (set) {
                Blocklist.this._inProcess.remove(this._peer);
            }
        }
    }

    private static class Entry {
        final String comment;
        final byte[] ip1;
        final byte[] ip2;
        final Hash peer;

        public Entry(String c, Hash h, byte[] i1, byte[] i2) {
            this.comment = c;
            this.peer = h;
            this.ip1 = i1;
            this.ip2 = i2;
        }
    }

    private class ReadinJob
    extends JobImpl {
        private final List<File> _files;

        public ReadinJob(List<File> files) {
            super(Blocklist.this._context);
            this._files = files;
        }

        @Override
        public String getName() {
            return "Read Blocklist";
        }

        @Override
        public void runJob() {
            Blocklist.this.allocate(this._files);
            if (Blocklist.this._blocklist == null) {
                return;
            }
            int ccount = this.process();
            if (Blocklist.this._blocklist == null) {
                return;
            }
            if (ccount <= 0) {
                Blocklist.this.disable();
                return;
            }
            Blocklist.this.merge(ccount);
            if (Blocklist.this._log.shouldLog(30)) {
                if (Blocklist.this._blocklistSize <= 0) {
                    return;
                }
                FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)Blocklist.this._context.netDb();
                int count = 0;
                for (RouterInfo ri : fndf.getKnownRouterData()) {
                    Hash peer = ri.getIdentity().getHash();
                    if (!Blocklist.this.isBlocklisted(peer)) continue;
                    ++count;
                }
                if (count > 0) {
                    Blocklist.this._log.warn("Blocklisted " + count + " routers in the netDb");
                }
            }
            Blocklist.this._peerBlocklist = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int process() {
            int count = 0;
            Iterator iterator = Blocklist.this._lock;
            synchronized (iterator) {
                try {
                    for (File f : this._files) {
                        count = Blocklist.this.readBlocklistFile(f, count);
                    }
                }
                catch (OutOfMemoryError oom) {
                    Blocklist.this._log.log(50, "OOM processing the blocklist");
                    Blocklist.this.disable();
                    return 0;
                }
            }
            for (Hash peer : Blocklist.this._peerBlocklist.keySet()) {
                String comment = (String)Blocklist.this._peerBlocklist.get(peer);
                String reason = comment != null ? Blocklist._x("Banned by router hash: {0}") : Blocklist._x("Banned by router hash");
                Blocklist.this._context.banlist().banlistRouterForever(peer, reason, comment);
            }
            Blocklist.this._peerBlocklist.clear();
            return count;
        }
    }
}

