/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.router;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.Addresses;
import net.i2p.util.OrderedProperties;
import org.apache.http.conn.util.InetAddressUtils;

public class RouterAddress
extends DataStructureImpl {
    private short _cost;
    private long _expiration;
    private String _transportStyle;
    private final Properties _options;
    private byte[] _ip;
    private int _port;
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";

    public RouterAddress() {
        this._options = new OrderedProperties();
    }

    public RouterAddress(String style, OrderedProperties options, int cost) {
        this._transportStyle = style;
        this._options = options;
        if (cost < 0 || cost > 255) {
            throw new IllegalArgumentException();
        }
        this._cost = (short)cost;
    }

    public int getCost() {
        return this._cost;
    }

    public void setCost(int cost) {
        if (cost < 0 || cost > 255) {
            throw new IllegalArgumentException();
        }
        this._cost = (short)cost;
    }

    @Deprecated
    public Date getExpiration() {
        if (this._expiration > 0L) {
            return new Date(this._expiration);
        }
        return null;
    }

    @Deprecated
    public long getExpirationTime() {
        return this._expiration;
    }

    @Deprecated
    public void setExpiration(Date expiration) {
        this._expiration = expiration.getDate();
    }

    public String getTransportStyle() {
        return this._transportStyle;
    }

    @Deprecated
    public void setTransportStyle(String transportStyle) {
        if (this._transportStyle != null) {
            throw new IllegalStateException();
        }
        this._transportStyle = transportStyle;
    }

    @Deprecated
    public Properties getOptions() {
        return this._options;
    }

    public Map<Object, Object> getOptionsMap() {
        return Collections.unmodifiableMap(this._options);
    }

    public String getOption(String opt) {
        return this._options.getProperty(opt);
    }

    @Deprecated
    public void setOptions(Properties options) {
        if (!this._options.isEmpty()) {
            throw new IllegalStateException();
        }
        this._options.putAll((Map<?, ?>)options);
    }

    public byte[] getIP() {
        if (this._ip != null) {
            return this._ip;
        }
        byte[] rv = null;
        String host = this.getHost();
        if (host != null && (rv = Addresses.getIP(host)) != null && (InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host))) {
            this._ip = rv;
        }
        return rv;
    }

    public String getHost() {
        return this._options.getProperty(PROP_HOST);
    }

    public int getPort() {
        if (this._port != 0) {
            return this._port;
        }
        String port = this._options.getProperty(PROP_PORT);
        if (port != null) {
            try {
                int rv = Integer.parseInt(port);
                if (rv > 0 && rv <= 65535) {
                    this._port = rv;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this._port;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._transportStyle != null) {
            throw new IllegalStateException();
        }
        this._cost = (short)DataHelper.readLong(in, 1);
        this._expiration = DataHelper.readLong(in, 8);
        this._transportStyle = DataHelper.readString(in);
        if (this._transportStyle.equals("SSU")) {
            this._transportStyle = "SSU";
        } else if (this._transportStyle.equals("NTCP")) {
            this._transportStyle = "NTCP";
        }
        DataHelper.readProperties(in, this._options);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._transportStyle == null) {
            throw new DataFormatException("uninitialized");
        }
        out.write((byte)this._cost);
        DataHelper.writeLong(out, 8, this._expiration);
        DataHelper.writeString(out, this._transportStyle);
        DataHelper.writeProperties(out, this._options);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RouterAddress)) {
            return false;
        }
        RouterAddress addr = (RouterAddress)object;
        return this.getPort() == addr.getPort() && DataHelper.eq(this.getHost(), addr.getHost()) && DataHelper.eq(this._transportStyle, addr._transportStyle);
    }

    public boolean deepEquals(RouterAddress addr) {
        return this.equals(addr) && this._cost == addr._cost && this._options.equals(addr._options);
    }

    public int hashCode() {
        return DataHelper.hashCode(this._transportStyle) ^ DataHelper.hashCode(this.getIP()) ^ this.getPort();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[RouterAddress: ");
        buf.append("\n\tType: ").append(this._transportStyle);
        buf.append("\n\tCost: ").append(this._cost);
        if (this._expiration > 0L) {
            buf.append("\n\tExpiration: ").append(new Date(this._expiration));
        }
        buf.append("\n\tOptions (").append(this._options.size()).append("):");
        for (Map.Entry<Object, Object> e : this._options.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
        }
        buf.append("]");
        return buf.toString();
    }
}

