/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.web.Messages;
import net.i2p.stat.RateStat;

class TunnelRenderer {
    private RouterContext _context;
    private static final int DISPLAY_LIMIT = 200;

    public TunnelRenderer(RouterContext ctx) {
        this._context = ctx;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        out.write("<div class=\"wideload\"><h2><a name=\"exploratory\" ></a>" + this._t("Exploratory tunnels") + " (<a href=\"/configtunnels#exploratory\">" + this._t("configure") + "</a>)</h2>\n");
        this.renderPool(out, this._context.tunnelManager().getInboundExploratoryPool(), this._context.tunnelManager().getOutboundExploratoryPool());
        ArrayList<Hash> destinations = null;
        Map<Hash, TunnelPool> clientInboundPools = this._context.tunnelManager().getInboundClientPools();
        Map<Hash, TunnelPool> clientOutboundPools = this._context.tunnelManager().getOutboundClientPools();
        destinations = new ArrayList<Hash>(clientInboundPools.keySet());
        boolean debug = this._context.getBooleanProperty("routerconsole.advanced");
        for (int i = 0; i < destinations.size(); ++i) {
            String name;
            Hash client = (Hash)destinations.get(i);
            boolean isLocal = this._context.clientManager().isLocal(client);
            if (!isLocal && !debug) continue;
            TunnelPool in = clientInboundPools.get(client);
            TunnelPool outPool = clientOutboundPools.get(client);
            String string = name = in != null ? in.getSettings().getDestinationNickname() : null;
            if (name == null && outPool != null) {
                name = outPool.getSettings().getDestinationNickname();
            }
            if (name == null) {
                name = client.toBase64().substring(0, 4);
            }
            out.write("<h2><a name=\"" + client.toBase64().substring(0, 4) + "\" ></a>" + this._t("Client tunnels for") + ' ' + DataHelper.escapeHTML(this._t(name)));
            if (isLocal) {
                out.write(" (<a href=\"/configtunnels#" + client.toBase64().substring(0, 4) + "\">" + this._t("configure") + "</a>)</h2>\n");
            } else {
                out.write(" (" + this._t("dead") + ")</h2>\n");
            }
            this.renderPool(out, in, outPool);
        }
        List<HopConfig> participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        out.write("<h2><a name=\"participating\"></a>" + this._t("Participating tunnels") + "</h2>\n");
        if (!participating.isEmpty()) {
            Collections.sort(participating, new TunnelComparator());
            out.write("<table><tr><th>" + this._t("Receive on") + "</th><th>" + this._t("From") + "</th><th>" + this._t("Send on") + "</th><th>" + this._t("To") + "</th><th>" + this._t("Expiration") + "</th><th>" + this._t("Usage") + "</th><th>" + this._t("Rate") + "</th><th>" + this._t("Role") + "</th></tr>\n");
        }
        long processed = 0L;
        RateStat rs = this._context.statManager().getRate("tunnel.participatingMessageCount");
        if (rs != null) {
            processed = (long)rs.getRate(600000L).getLifetimeTotalValue();
        }
        int inactive = 0;
        int displayed = 0;
        for (int i = 0; i < participating.size(); ++i) {
            HopConfig cfg = participating.get(i);
            int count = cfg.getProcessedMessagesCount();
            if (count <= 0) {
                ++inactive;
                continue;
            }
            processed += (long)cfg.getRecentMessagesCount();
            if (++displayed > 200) continue;
            out.write("<tr>");
            if (cfg.getReceiveTunnel() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + cfg.getReceiveTunnel().getTunnelId() + "</td>");
            } else {
                out.write("<td class=\"cells\" align=\"center\">n/a</td>");
            }
            if (cfg.getReceiveFrom() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + this.netDbLink(cfg.getReceiveFrom()) + "</td>");
            } else {
                out.write("<td class=\"cells\">&nbsp;</td>");
            }
            if (cfg.getSendTunnel() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + cfg.getSendTunnel().getTunnelId() + "</td>");
            } else {
                out.write("<td class=\"cells\">&nbsp;</td>");
            }
            if (cfg.getSendTo() != null) {
                out.write("<td class=\"cells\" align=\"center\">" + this.netDbLink(cfg.getSendTo()) + "</td>");
            } else {
                out.write("<td class=\"cells\">&nbsp;</td>");
            }
            long timeLeft = cfg.getExpiration() - this._context.clock().now();
            if (timeLeft > 0L) {
                out.write("<td class=\"cells\" align=\"center\">" + DataHelper.formatDuration2(timeLeft) + "</td>");
            } else {
                out.write("<td class=\"cells\" align=\"center\">(" + this._t("grace period") + ")</td>");
            }
            out.write("<td class=\"cells\" align=\"center\">" + count + " KB</td>");
            int lifetime = (int)((this._context.clock().now() - cfg.getCreation()) / 1000L);
            if (lifetime <= 0) {
                lifetime = 1;
            }
            if (lifetime > 600) {
                lifetime = 600;
            }
            int bps = 1024 * count / lifetime;
            out.write("<td class=\"cells\" align=\"center\">" + bps + " Bps</td>");
            if (cfg.getSendTo() == null) {
                out.write("<td class=\"cells\" align=\"center\">" + this._t("Outbound Endpoint") + "</td>");
            } else if (cfg.getReceiveFrom() == null) {
                out.write("<td class=\"cells\" align=\"center\">" + this._t("Inbound Gateway") + "</td>");
            } else {
                out.write("<td class=\"cells\" align=\"center\">" + this._t("Participant") + "</td>");
            }
            out.write("</tr>\n");
        }
        if (!participating.isEmpty()) {
            out.write("</table>\n");
        }
        if (displayed > 200) {
            out.write("<div class=\"statusnotes\"><b>" + this._t("Limited display to the {0} tunnels with the highest usage", 200) + "</b></div>\n");
        }
        if (inactive > 0) {
            out.write("<div class=\"statusnotes\"><b>" + this._t("Inactive participating tunnels") + ": " + inactive + "</b></div>\n");
        } else if (displayed <= 0) {
            out.write("<div class=\"statusnotes\"><b>" + this._t("none") + "</b></div>\n");
        }
        out.write("<div class=\"statusnotes\"><b>" + this._t("Lifetime bandwidth usage") + ": " + DataHelper.formatSize2(processed * 1024L) + "B</b></div>\n");
        out.write("</div>");
    }

    private void renderPool(Writer out, TunnelPool in, TunnelPool outPool) throws IOException {
        List<PooledTunnelCreatorConfig> pending;
        TunnelInfo info;
        int i;
        List<TunnelInfo> tunnels = null;
        tunnels = in == null ? new ArrayList<TunnelInfo>() : in.listTunnels();
        if (outPool != null) {
            tunnels.addAll(outPool.listTunnels());
        }
        long processedIn = in != null ? in.getLifetimeProcessed() : 0L;
        long processedOut = outPool != null ? outPool.getLifetimeProcessed() : 0L;
        int live = 0;
        int maxLength = 1;
        for (i = 0; i < tunnels.size(); ++i) {
            info = tunnels.get(i);
            if (info.getLength() <= maxLength) continue;
            maxLength = info.getLength();
        }
        out.write("<table><tr><th>" + this._t("In/Out") + "</th><th>" + this._t("Expiry") + "</th><th>" + this._t("Usage") + "</th><th>" + this._t("Gateway") + "</th>");
        if (maxLength > 3) {
            out.write("<th align=\"center\" colspan=\"" + (maxLength - 2));
            out.write("\">" + this._t("Participants") + "</th>");
        } else if (maxLength == 3) {
            out.write("<th>" + this._t("Participant") + "</th>");
        }
        if (maxLength > 1) {
            out.write("<th>" + this._t("Endpoint") + "</th>");
        }
        out.write("</tr>\n");
        for (i = 0; i < tunnels.size(); ++i) {
            info = tunnels.get(i);
            long timeLeft = info.getExpiration() - this._context.clock().now();
            if (timeLeft <= 0L) continue;
            ++live;
            if (info.isInbound()) {
                out.write("<tr> <td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"Inbound\"></td>");
            } else {
                out.write("<tr> <td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"Outbound\"></td>");
            }
            out.write(" <td class=\"cells\" align=\"center\">" + DataHelper.formatDuration2(timeLeft) + "</td>\n");
            int count = info.getProcessedMessagesCount();
            out.write(" <td class=\"cells\" align=\"center\">" + count + " KB</td>\n");
            for (int j = 0; j < info.getLength(); ++j) {
                TunnelId id;
                Hash peer = info.getPeer(j);
                TunnelId tunnelId = id = info.isInbound() ? info.getReceiveTunnelId(j) : info.getSendTunnelId(j);
                if (this._context.routerHash().equals(peer)) {
                    out.write(" <td class=\"cells\" align=\"center\">" + (id == null ? "" : "" + id) + "</td>");
                } else {
                    String cap = this.getCapacity(peer);
                    out.write(" <td class=\"cells\" align=\"center\">" + this.netDbLink(peer) + (id == null ? "" : " " + id) + cap + "</td>");
                }
                if (info.getLength() >= maxLength || info.getLength() != 1 && j != info.getLength() - 2) continue;
                for (int k = info.getLength(); k < maxLength; ++k) {
                    out.write(" <td class=\"cells\" align=\"center\">&nbsp;</td>");
                }
            }
            out.write("</tr>\n");
            if (info.isInbound()) {
                processedIn += (long)count;
                continue;
            }
            processedOut += (long)count;
        }
        out.write("</table>\n");
        if (in != null && !(pending = in.listPending()).isEmpty()) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._t("Build in progress") + ": " + pending.size() + " " + this._t("inbound") + "</b></center></div>\n");
            live += pending.size();
        }
        if (outPool != null && !(pending = outPool.listPending()).isEmpty()) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._t("Build in progress") + ": " + pending.size() + " " + this._t("outbound") + "</b></center></div>\n");
            live += pending.size();
        }
        if (live <= 0) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._t("No tunnels; waiting for the grace period to end.") + "</b></center></div>\n");
        }
        out.write("<div class=\"statusnotes\"><center><b>" + this._t("Lifetime bandwidth usage") + ": " + DataHelper.formatSize2(processedIn * 1024L) + "B " + this._t("in") + ", " + DataHelper.formatSize2(processedOut * 1024L) + "B " + this._t("out") + "</b></center></div>");
    }

    private String getCapacity(Hash peer) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (info != null) {
            String caps = info.getCapabilities();
            for (char c = 'K'; c <= 'O'; c = (char)((char)(c + 1))) {
                if (caps.indexOf(c) < 0) continue;
                return " " + c;
            }
        }
        return "";
    }

    private String netDbLink(Hash peer) {
        return this._context.commSystem().renderPeerHTML(peer);
    }

    private String _t(String s) {
        return Messages.getString(s, this._context);
    }

    public String _t(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private static class TunnelComparator
    implements Comparator<HopConfig>,
    Serializable {
        private TunnelComparator() {
        }

        @Override
        public int compare(HopConfig l, HopConfig r) {
            return r.getProcessedMessagesCount() - l.getProcessedMessagesCount();
        }
    }
}

