/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileUtil;

public class FileDumpHelper
extends HelperBase {
    public String getFileSummary() {
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<table><tr><th>File</th><th>Size</th><th>Date</th><th>SHA 256</th><th>Revision</th><th>JDK</th><th>Built</th><th>By</th><th>Mods</th></tr>");
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)loader;
            URL[] urls = urlClassLoader.getURLs();
            ArrayList<File> flist = new ArrayList<File>();
            for (int i = 0; i < urls.length; ++i) {
                String p = urls[i].toString();
                if (!p.startsWith("file:") || !p.endsWith(".jar") || (p = p.substring(5)).startsWith(this._context.getBaseDir().getAbsolutePath()) || p.startsWith(this._context.getConfigDir().getAbsolutePath())) continue;
                flist.add(new File(p));
            }
            Collections.sort(flist);
            for (File f : flist) {
                FileDumpHelper.dumpFile(buf, f);
            }
        }
        File dir = new File(this._context.getBaseDir(), "lib");
        FileDumpHelper.dumpDir(buf, dir, ".jar");
        dir = new File(this._context.getBaseDir(), "webapps");
        FileDumpHelper.dumpDir(buf, dir, ".war");
        File pluginDir = new File(this._context.getConfigDir(), "plugins");
        Object[] files = pluginDir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                dir = new File((File)files[i], "lib");
                FileDumpHelper.dumpDir(buf, dir, ".jar");
                dir = new File((File)files[i], "console/webapps");
                FileDumpHelper.dumpDir(buf, dir, ".war");
            }
        }
        buf.append("</table>");
        return buf.toString();
    }

    private static void dumpDir(StringBuilder buf, File dir, String suffix) {
        Object[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (!((File)files[i]).getName().endsWith(suffix)) continue;
            FileDumpHelper.dumpFile(buf, (File)files[i]);
        }
    }

    private static void dumpFile(StringBuilder buf, File f) {
        String s;
        Attributes att;
        byte[] hash;
        buf.append("<tr><td><b>").append(f.getAbsolutePath()).append("</b></td><td align=\"right\">").append(f.length()).append("</td><td>");
        long mod = f.lastModified();
        if (mod > 0L) {
            buf.append(new Date(mod).toString());
        } else {
            buf.append("<font color=\"red\">Not found</font>");
        }
        buf.append("</td><td align=\"center\">");
        if (mod > 0L && !FileUtil.verifyZip(f)) {
            buf.append("<font color=\"red\">CORRUPT</font><br>");
        }
        if ((hash = FileDumpHelper.sha256(f)) != null) {
            byte[] hh = new byte[16];
            System.arraycopy(hash, 0, hh, 0, 16);
            buf.append("<tt>");
            String p1 = DataHelper.toHexString(hh);
            for (int i = p1.length(); i < 32; ++i) {
                buf.append('0');
            }
            buf.append(p1).append("</tt><br>");
            System.arraycopy(hash, 16, hh, 0, 16);
            buf.append("<tt>").append(DataHelper.toHexString(hh)).append("</tt>");
        }
        if ((att = FileDumpHelper.attributes(f)) == null) {
            att = new Attributes();
        }
        buf.append("<td align=\"center\">");
        String iv = FileDumpHelper.getAtt(att, "Implementation-Version");
        if (iv != null) {
            buf.append("<b>").append(iv).append("</b>");
        }
        if ((s = FileDumpHelper.getAtt(att, "Base-Revision")) != null && s.length() > 20) {
            if (iv != null) {
                buf.append("<br>");
            }
            buf.append("<tt>").append(s.substring(0, 20)).append("</tt><br><tt>").append(s.substring(20)).append("</tt>");
        }
        buf.append("</td><td>");
        s = FileDumpHelper.getAtt(att, "Created-By");
        if (s != null) {
            buf.append(s);
        }
        buf.append("</td><td>");
        s = FileDumpHelper.getAtt(att, "Build-Date");
        if (s != null) {
            buf.append(s);
        }
        buf.append("</td><td align=\"center\">");
        s = FileDumpHelper.getAtt(att, "Built-By");
        if (s != null) {
            buf.append(s);
        }
        buf.append("</td><td><font color=\"red\">");
        s = FileDumpHelper.getAtt(att, "Workspace-Changes");
        if (s != null) {
            buf.append(s.replace(",", "<br>"));
        }
        buf.append("</font></td></tr>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] sha256(File f) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            MessageDigest md = SHA256Generator.getDigestInstance();
            byte[] b = new byte[4096];
            int cnt = 0;
            while ((cnt = ((InputStream)in).read(b)) >= 0) {
                md.update(b, 0, cnt);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (IOException ioe) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes attributes(File f) {
        InputStream in = null;
        try {
            in = new URL("jar:file:" + f.getAbsolutePath() + "!/META-INF/MANIFEST.MF").openStream();
            Manifest man = new Manifest(in);
            Attributes attributes = man.getMainAttributes();
            return attributes;
        }
        catch (IOException ioe) {
            Attributes attributes = null;
            return attributes;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getAtt(Attributes atts, String s) {
        String rv = atts.getValue(s);
        if (rv != null) {
            rv = DataHelper.stripHTML(rv);
        }
        return rv;
    }
}

