/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.HashMap;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.web.FormHandler;

public class ConfigTunnelsHandler
extends FormHandler {
    private boolean _shouldSave;

    @Override
    protected void processForm() {
        if (this._shouldSave) {
            this.saveChanges();
        }
    }

    public void setShouldsave(String moo) {
        if (moo != null && moo.equals(this._t("Save changes"))) {
            this._shouldSave = true;
        }
    }

    private void saveChanges() {
        Object val;
        boolean saveRequired = false;
        HashMap<String, String> changes = new HashMap<String, String>();
        if (this._log.shouldLog(10)) {
            this._log.debug("Saving changes, with props = " + this._settings + ".");
        }
        int updated = 0;
        int index = 0;
        while ((val = this._settings.get("pool." + index)) != null) {
            Hash client = new Hash();
            String poolName = val instanceof String ? (String)val : ((String[])val)[0];
            TunnelPoolSettings in = null;
            TunnelPoolSettings out = null;
            if ("exploratory".equals(poolName)) {
                in = this._context.tunnelManager().getInboundSettings();
                out = this._context.tunnelManager().getOutboundSettings();
            } else {
                try {
                    client.fromBase64(poolName);
                }
                catch (DataFormatException dfe) {
                    this.addFormError("Internal error (pool name could not resolve - " + poolName + ").");
                    ++index;
                    continue;
                }
                in = this._context.tunnelManager().getInboundSettings(client);
                out = this._context.tunnelManager().getOutboundSettings(client);
            }
            if (in == null || out == null) {
                this.addFormError("Internal error (pool settings cound not be found for " + poolName + ").");
                ++index;
                continue;
            }
            in.setLength(ConfigTunnelsHandler.getInt(this._settings.get(index + ".depthInbound")));
            out.setLength(ConfigTunnelsHandler.getInt(this._settings.get(index + ".depthOutbound")));
            in.setLengthVariance(ConfigTunnelsHandler.getInt(this._settings.get(index + ".varianceInbound")));
            out.setLengthVariance(ConfigTunnelsHandler.getInt(this._settings.get(index + ".varianceOutbound")));
            in.setQuantity(ConfigTunnelsHandler.getInt(this._settings.get(index + ".quantityInbound")));
            out.setQuantity(ConfigTunnelsHandler.getInt(this._settings.get(index + ".quantityOutbound")));
            in.setBackupQuantity(ConfigTunnelsHandler.getInt(this._settings.get(index + ".backupInbound")));
            out.setBackupQuantity(ConfigTunnelsHandler.getInt(this._settings.get(index + ".backupOutbound")));
            if ("exploratory".equals(poolName)) {
                changes.put("router.inboundPool.length", in.getLength() + "");
                changes.put("router.outboundPool.length", out.getLength() + "");
                changes.put("router.inboundPool.lengthVariance", in.getLengthVariance() + "");
                changes.put("router.outboundPool.lengthVariance", out.getLengthVariance() + "");
                changes.put("router.inboundPool.quantity", in.getQuantity() + "");
                changes.put("router.outboundPool.quantity", out.getQuantity() + "");
                changes.put("router.inboundPool.backupQuantity", in.getBackupQuantity() + "");
                changes.put("router.outboundPool.backupQuantity", out.getBackupQuantity() + "");
            }
            if ("exploratory".equals(poolName)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Inbound exploratory settings: " + in);
                    this._log.debug("Outbound exploratory settings: " + out);
                }
                this._context.tunnelManager().setInboundSettings(in);
                this._context.tunnelManager().setOutboundSettings(out);
            } else {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Inbound settings for " + client.toBase64() + ": " + in);
                    this._log.debug("Outbound settings for " + client.toBase64() + ": " + out);
                }
                this._context.tunnelManager().setInboundSettings(client, in);
                this._context.tunnelManager().setOutboundSettings(client, out);
            }
            ++updated;
            saveRequired = true;
            ++index;
        }
        if (updated > 0) {
            this.addFormNotice(this._t("Updated settings for all pools."));
        }
        if (saveRequired) {
            boolean saved = this._context.router().saveConfig(changes, null);
            if (saved) {
                this.addFormNotice(this._t("Exploratory tunnel configuration saved successfully."));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs."));
            }
        }
    }

    private static final int getInt(Object val) {
        if (val == null) {
            return 0;
        }
        String str = null;
        str = val instanceof String ? (String)val : ((String[])val)[0];
        if (str.trim().length() <= 0) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

