/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.router.web.FormHandler;
import net.i2p.util.SecureDirectory;

public class ConfigFamilyHandler
extends FormHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processForm() {
        if (this._action.equals(this._t("Create New Router Family"))) {
            String family = this.getJettyString("family");
            String old = this._context.getProperty("netdb.family.name");
            if (family == null || family.trim().length() <= 0) {
                this.addFormError(this._t("You must enter a family name"));
            } else if (old != null) {
                this.addFormError("Family already configured: " + family);
            } else if (family.contains("/") || family.contains("\\")) {
                this.addFormError("Bad characters in Family: " + family);
            } else if (this._context.router().saveConfig("netdb.family.name", family.trim())) {
                this.addFormNotice(this._t("Configuration saved successfully."));
                this.addFormError(this._t("Restart required to take effect"));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        } else if (this._action.equals(this._t("Join Existing Router Family"))) {
            InputStream in = this._requestWrapper.getInputStream("file");
            try {
                File ks;
                if (in == null || in.available() <= 0) {
                    this.addFormError(this._t("You must enter a file"));
                    return;
                }
                PrivateKey pk = CertUtil.loadPrivateKey(in);
                List<X509Certificate> certs = CertUtil.loadCerts(in);
                String family = CertUtil.getSubjectValue(certs.get(0), "CN");
                if (family == null) {
                    this.addFormError("Bad certificate - No Subject CN");
                }
                if (family.endsWith(".family.i2p.net") && family.length() > ".family.i2p.net".length()) {
                    family = family.substring(0, family.length() - ".family.i2p.net".length());
                }
                if (!(ks = new SecureDirectory(this._context.getConfigDir(), "keystore")).exists()) {
                    ks.mkdirs();
                }
                ks = new File(ks, "family-" + family + ".ks");
                String keypw = KeyStoreUtil.randomString();
                KeyStoreUtil.storePrivateKey(ks, "changeit", family, keypw, pk, certs);
                File cf = new SecureDirectory(this._context.getConfigDir(), "certificates");
                if (!cf.exists()) {
                    ((File)cf).mkdirs();
                }
                cf = new SecureDirectory(cf, "family");
                if (!ks.exists()) {
                    ks.mkdirs();
                }
                cf = new File(cf, family + ".crt");
                KeyStoreUtil.exportCert(ks, "changeit", family, cf);
                HashMap<String, String> changes = new HashMap<String, String>();
                changes.put("netdb.family.name", family);
                changes.put("netdb.family.keyPassword", keypw);
                changes.put("netdb.family.keystorePassword", "changeit");
                if (this._context.router().saveConfig(changes, null)) {
                    this.addFormNotice("Family key configured for router family: " + family);
                    this.addFormError(this._t("Restart required to take effect"));
                }
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
            catch (GeneralSecurityException gse) {
                this.addFormError(this._t("Load from file failed") + " - " + gse);
            }
            catch (IOException ioe) {
                this.addFormError(this._t("Load from file failed") + " - " + ioe);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException gse) {}
            }
        } else if (this._action.equals(this._t("Leave Router Family"))) {
            ArrayList<String> removes = new ArrayList<String>();
            removes.add("netdb.family.name");
            removes.add("netdb.family.keyPassword");
            removes.add("netdb.family.keystorePassword");
            if (this._context.router().saveConfig(null, removes)) {
                this.addFormNotice(this._t("Configuration saved successfully."));
                this.addFormError(this._t("Restart required to take effect"));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        }
    }
}

