/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;

public class I2PTunnelConnectClient
extends I2PTunnelHTTPClientBase
implements Runnable {
    public static final String AUTH_REALM = "I2P SSL Proxy";
    private static final String ERR_BAD_PROTOCOL = "HTTP/1.1 405 Bad Method\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: METHOD NOT ALLOWED</H1>The request uses a bad protocol. The Connect Proxy supports CONNECT requests ONLY. Other methods such as GET are not allowed - Maybe you wanted the HTTP Proxy?.<BR>";
    private static final String ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>";

    public I2PTunnelConnectClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTPS Proxy on " + tunnel.listenHost + ':' + localPort, tunnel);
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this._proxyList.add(tok.nextToken().trim());
            }
        }
        this.setName("HTTPS Proxy on " + tunnel.listenHost + ':' + localPort);
    }

    @Override
    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    @Override
    public void startRunning() {
        super.startRunning();
        if (this.open) {
            this._context.portMapper().register("HTTPS", this.getTunnel().listenHost, this.getLocalPort());
        }
    }

    @Override
    public boolean close(boolean forced) {
        int reg = this._context.portMapper().getPort("HTTPS");
        if (reg == this.getLocalPort()) {
            this._context.portMapper().unregister("HTTPS");
        }
        return super.close(forced);
    }

    @Override
    protected String getRealm() {
        return AUTH_REALM;
    }

    @Override
    protected void clientConnectionRun(Socket s) {
        InputStream in = null;
        OutputStream out = null;
        String targetRequest = null;
        boolean usingWWWProxy = false;
        String currentProxy = null;
        long requestId = __requestId.incrementAndGet();
        try {
            String line;
            out = s.getOutputStream();
            in = s.getInputStream();
            String method = null;
            String host = null;
            String destination = null;
            String restofline = null;
            StringBuilder newRequest = new StringBuilder();
            String authorization = null;
            while ((line = DataHelper.readLine(in)) != null) {
                line = line.trim();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix(requestId) + "Line=[" + line + "]");
                }
                if (method == null) {
                    int pos = line.indexOf(32);
                    if (pos == -1) break;
                    method = line.substring(0, pos);
                    String request = line.substring(pos + 1);
                    if ((pos = request.indexOf(58)) == -1) {
                        pos = request.indexOf(32);
                    }
                    if (pos == -1) {
                        host = request;
                        restofline = "";
                    } else {
                        host = request.substring(0, pos);
                        restofline = request.substring(pos);
                    }
                    if (host.toLowerCase(Locale.US).endsWith(".i2p")) {
                        destination = host;
                    } else if (host.indexOf(46) != -1) {
                        currentProxy = this.selectProxy();
                        if (currentProxy == null) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn(this.getPrefix(requestId) + "Host wants to be outproxied, but we dont have any!");
                            }
                            I2PTunnelConnectClient.writeErrorMessage("HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel", out);
                            s.close();
                            return;
                        }
                        destination = currentProxy;
                        usingWWWProxy = true;
                        newRequest.append("CONNECT ").append(host).append(restofline).append("\r\n");
                    } else {
                        if (host.toLowerCase(Locale.US).equals("localhost")) {
                            I2PTunnelConnectClient.writeErrorMessage(ERR_LOCALHOST, out);
                            s.close();
                            return;
                        }
                        destination = host;
                    }
                    targetRequest = host;
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug(this.getPrefix(requestId) + "METHOD:" + method + ":");
                    this._log.debug(this.getPrefix(requestId) + "HOST  :" + host + ":");
                    this._log.debug(this.getPrefix(requestId) + "REST  :" + restofline + ":");
                    this._log.debug(this.getPrefix(requestId) + "DEST  :" + destination + ":");
                    continue;
                }
                if (line.toLowerCase(Locale.US).startsWith("proxy-authorization: ")) {
                    authorization = line.substring(21);
                    line = null;
                    continue;
                }
                if (line.length() > 0) {
                    line = null;
                    continue;
                }
                if (usingWWWProxy && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("outproxyAuth"))) {
                    String user = this.getTunnel().getClientOptions().getProperty("outproxyUsername." + currentProxy);
                    String pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword." + currentProxy);
                    if (user == null || pw == null) {
                        user = this.getTunnel().getClientOptions().getProperty("outproxyUsername");
                        pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword");
                    }
                    if (user != null && pw != null) {
                        newRequest.append("Proxy-Authorization: Basic ").append(Base64.encode(DataHelper.getUTF8(user + ':' + pw), true)).append("\r\n");
                    }
                }
                newRequest.append("\r\n");
                break;
            }
            if (destination == null || method == null || !"CONNECT".equals(method.toUpperCase(Locale.US))) {
                I2PTunnelConnectClient.writeErrorMessage(ERR_BAD_PROTOCOL, out);
                s.close();
                return;
            }
            I2PTunnelHTTPClientBase.AuthResult result = this.authorize(s, requestId, method, authorization);
            if (result != I2PTunnelHTTPClientBase.AuthResult.AUTH_GOOD) {
                if (this._log.shouldLog(30)) {
                    if (authorization != null) {
                        this._log.warn(this.getPrefix(requestId) + "Auth failed, sending 407 again");
                    } else {
                        this._log.warn(this.getPrefix(requestId) + "Auth required, sending 407");
                    }
                }
                out.write(DataHelper.getASCII(this.getAuthError(result == I2PTunnelHTTPClientBase.AuthResult.AUTH_STALE)));
                s.close();
                return;
            }
            Destination clientDest = this._context.namingService().lookup(destination);
            if (clientDest == null) {
                String header = usingWWWProxy ? this.getErrorPage("dnfp", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>") : this.getErrorPage("dnfh", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                this.writeErrorMessage(header, out, targetRequest, usingWWWProxy, destination);
                s.close();
                return;
            }
            I2PSocket i2ps = this.createI2PSocket(clientDest, this.getDefaultOptions());
            byte[] data = null;
            byte[] response = null;
            if (usingWWWProxy) {
                data = newRequest.toString().getBytes("ISO-8859-1");
            } else {
                response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
            }
            I2PTunnelHTTPClientBase.OnTimeout onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelRunner t = new I2PTunnelRunner(s, i2ps, this.sockLock, data, response, (List<I2PSocket>)this.mySockets, onTimeout);
            ((Thread)t).run();
        }
        catch (IOException ex) {
            this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
        catch (I2PException ex) {
            this._log.info("getPrefix(requestId) + Error trying to connect", ex);
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
        catch (OutOfMemoryError oom) {
            IOException ex = new IOException("OOM");
            this._log.info("getPrefix(requestId) + Error trying to connect", ex);
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelConnectClient.closeSocket(s);
        }
    }

    private static void writeErrorMessage(String errMessage, OutputStream out) throws IOException {
        if (out == null) {
            return;
        }
        out.write(errMessage.getBytes("UTF-8"));
        I2PTunnelConnectClient.writeFooter(out);
    }
}

