/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.crypto.SHA1Hash;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.Translate;
import org.klomp.snark.BWLimits;
import org.klomp.snark.BitField;
import org.klomp.snark.CompleteListener;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.IdleChecker;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;
import org.klomp.snark.Tracker;
import org.klomp.snark.TrackerClient;
import org.klomp.snark.UpdateHandler;
import org.klomp.snark.dht.DHT;

public class SnarkManager
implements CompleteListener {
    private final Map<String, Snark> _snarks;
    private final Set<String> _magnets;
    private final Object _addSnarkLock;
    private File _configFile;
    private File _configDir;
    private final Object _configLock = new Object();
    private Properties _config;
    private final I2PAppContext _context;
    private final String _contextPath;
    private final String _contextName;
    private final Log _log;
    private final Queue<String> _messages;
    private final I2PSnarkUtil _util;
    private PeerCoordinatorSet _peerCoordinatorSet;
    private ConnectionAcceptor _connectionAcceptor;
    private Thread _monitor;
    private volatile boolean _running;
    private volatile boolean _stopping;
    private final Map<String, Tracker> _trackerMap;
    private UpdateManager _umgr;
    private UpdateHandler _uhandler;
    private SimpleTimer2.TimedEvent _idleChecker;
    public static final String PROP_I2CP_HOST = "i2psnark.i2cpHost";
    public static final String PROP_I2CP_PORT = "i2psnark.i2cpPort";
    public static final String PROP_I2CP_OPTS = "i2psnark.i2cpOptions";
    public static final String PROP_UPLOADERS_TOTAL = "i2psnark.uploaders.total";
    public static final String PROP_UPBW_MAX = "i2psnark.upbw.max";
    public static final String PROP_DIR = "i2psnark.dir";
    private static final String PROP_META_PREFIX = "i2psnark.zmeta.";
    private static final String PROP_META_RUNNING = "running";
    private static final String PROP_META_STAMP = "stamp";
    private static final String PROP_META_BASE = "base";
    private static final String PROP_META_BITFIELD = "bitfield";
    private static final String PROP_META_PRIORITY = "priority";
    private static final String PROP_META_PRESERVE_NAMES = "preserveFileNames";
    private static final String PROP_META_UPLOADED = "uploaded";
    private static final String PROP_META_ADDED = "added";
    private static final String PROP_META_COMPLETED = "completed";
    private static final String PROP_META_MAGNET = "magnet";
    private static final String PROP_META_MAGNET_DN = "magnet_dn";
    private static final String PROP_META_MAGNET_TR = "magnet_tr";
    private static final String PROP_META_MAGNET_DIR = "magnet_dir";
    private static final String PROP_META_MAGNET_PREFIX = "i2psnark.magnet.";
    private static final String CONFIG_FILE_SUFFIX = ".config";
    private static final String CONFIG_FILE = "i2psnark.config";
    public static final String PROP_FILES_PUBLIC = "i2psnark.filesPublic";
    public static final String PROP_OLD_AUTO_START = "i2snark.autoStart";
    public static final String PROP_AUTO_START = "i2psnark.autoStart";
    public static final String DEFAULT_AUTO_START = "false";
    public static final String PROP_STARTUP_DELAY = "i2psnark.startupDelay";
    public static final String PROP_REFRESH_DELAY = "i2psnark.refreshSeconds";
    public static final String PROP_PAGE_SIZE = "i2psnark.pageSize";
    public static final String RC_PROP_THEME = "routerconsole.theme";
    public static final String RC_PROP_UNIVERSAL_THEMING = "routerconsole.universal.theme";
    public static final String PROP_THEME = "i2psnark.theme";
    public static final String DEFAULT_THEME = "ubergine";
    private static final String PROP_USE_OPENTRACKERS = "i2psnark.useOpentrackers";
    public static final String PROP_OPENTRACKERS = "i2psnark.opentrackers";
    public static final String PROP_PRIVATETRACKERS = "i2psnark.privatetrackers";
    private static final String PROP_USE_DHT = "i2psnark.enableDHT";
    private static final String PROP_SMART_SORT = "i2psnark.smartSort";
    private static final String PROP_LANG = "i2psnark.lang";
    private static final String PROP_COUNTRY = "i2psnark.country";
    public static final int MIN_UP_BW = 10;
    public static final int DEFAULT_MAX_UP_BW = 25;
    public static final int DEFAULT_STARTUP_DELAY = 3;
    public static final int DEFAULT_REFRESH_DELAY_SECS = 60;
    private static final int DEFAULT_PAGE_SIZE = 50;
    public static final int DEFAULT_TUNNEL_QUANTITY = 3;
    public static final String CONFIG_DIR_SUFFIX = ".d";
    private static final String SUBDIR_PREFIX = "s";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final String[] DEFAULT_TRACKERS = new String[]{"Postman", "http://tracker2.postman.i2p/announce.php=http://tracker2.postman.i2p/", "Diftracker", "http://diftracker.i2p/announce.php=http://diftracker.i2p/", "DgTrack", "http://w7tpbzncbcocrqtwwm3nezhnnsw4ozadvi2hmvzdhrqzfxfum7wa.b32.i2p/a=http://opentracker.dg2.i2p/", "TheBland", "http://s5ikrdyjwbcgxmqetxb3nyheizftms7euacuub2hic7defkh3xhq.b32.i2p/a=http://tracker.thebland.i2p/tracker/index.jsp", "psi's open tracker", "http://uajd4nctepxpac4c4bdyrdw7qvja2a5u3x25otfhkptcjgd53ioq.b32.i2p/announce=http://uajd4nctepxpac4c4bdyrdw7qvja2a5u3x25otfhkptcjgd53ioq.b32.i2p/"};
    public static final String DEFAULT_BACKUP_TRACKER = "http://opentracker.dg2.i2p/a";
    private static final String DEFAULT_OPENTRACKERS = "http://opentracker.dg2.i2p/a" + (SigType.ECDSA_SHA256_P256.isAvailable() ? ",http://tracker.thebland.i2p/a" : "");
    public static final Set<String> DEFAULT_TRACKER_ANNOUNCES;
    public static final Set<String> KNOWN_OPENTRACKERS;
    public static final String PROP_TRACKERS = "i2psnark.trackers";
    private static final int MAX_MESSAGES = 100;
    public static final int MAX_FILES_PER_TORRENT = 2000;

    public SnarkManager(I2PAppContext ctx) {
        this(ctx, "/i2psnark", "i2psnark");
    }

    public SnarkManager(I2PAppContext ctx, String ctxPath, String ctxName) {
        this._snarks = new ConcurrentHashMap<String, Snark>();
        this._magnets = new ConcurrentHashSet<String>();
        this._addSnarkLock = new Object();
        this._context = ctx;
        this._contextPath = ctxPath;
        this._contextName = ctxName;
        this._log = this._context.logManager().getLog(SnarkManager.class);
        this._messages = new LinkedBlockingQueue<String>();
        this._util = new I2PSnarkUtil(this._context, ctxName);
        String cfile = ctxName + CONFIG_FILE_SUFFIX;
        File configFile = new File(cfile);
        if (!configFile.isAbsolute()) {
            configFile = new File(this._context.getConfigDir(), cfile);
        }
        this._configDir = this.migrateConfig(configFile);
        this._configFile = new File(this._configDir, CONFIG_FILE);
        this._trackerMap = new ConcurrentHashMap<String, Tracker>(4);
        this.loadConfig(null);
        if (!ctx.isRouterContext()) {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new TempDeleter(this._util.getTempDir()), "Snark Temp Dir Deleter"));
        }
    }

    public void start() {
        String lang;
        this._running = true;
        this._peerCoordinatorSet = new PeerCoordinatorSet();
        this._connectionAcceptor = new ConnectionAcceptor(this._util, this._peerCoordinatorSet);
        this._monitor = new I2PAppThread(new DirMonitor(), "Snark DirMonitor", true);
        this._monitor.start();
        if (this._context.isRouterContext() && "i2psnark".equals(this._contextName)) {
            this._context.simpleTimer2().addEvent(new Register(), 240000L);
        }
        this._idleChecker = new IdleChecker(this, this._peerCoordinatorSet);
        this._idleChecker.schedule(300000L);
        if (!this._context.isRouterContext() && (lang = this._config.getProperty(PROP_LANG)) != null) {
            String country = this._config.getProperty(PROP_COUNTRY, "");
            Translate.setLanguage(lang, country);
        }
    }

    public void stop() {
        if (this._umgr != null && this._uhandler != null) {
            this._umgr.unregister(this._uhandler, UpdateType.ROUTER_SIGNED, UpdateMethod.TORRENT);
            this._umgr.unregister(this._uhandler, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.TORRENT);
        }
        this._running = false;
        this._monitor.interrupt();
        this._connectionAcceptor.halt();
        this._idleChecker.cancel();
        this.stopAllTorrents(true);
    }

    public boolean isStopping() {
        return this._stopping;
    }

    public I2PSnarkUtil util() {
        return this._util;
    }

    public void addMessage(String message) {
        this.addMessageNoEscape(message.replace("<", "&lt;").replace(">", "&gt;"));
    }

    public void addMessageNoEscape(String message) {
        this._messages.offer(message);
        while (this._messages.size() > 100) {
            this._messages.poll();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("MSG: " + message);
        }
    }

    public List<String> getMessages() {
        if (this._messages.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this._messages);
    }

    public void clearMessages() {
        this._messages.clear();
    }

    public boolean areFilesPublic() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_FILES_PUBLIC));
    }

    public boolean shouldAutoStart() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_AUTO_START, DEFAULT_AUTO_START));
    }

    public boolean isSmartSortEnabled() {
        String val = this._config.getProperty(PROP_SMART_SORT);
        if (val == null) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    public int getRefreshDelaySeconds() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_REFRESH_DELAY));
        }
        catch (NumberFormatException nfe) {
            return 60;
        }
    }

    public int getPageSize() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_PAGE_SIZE));
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    private int getStartupDelayMinutes() {
        if (!this._context.isRouterContext()) {
            return 0;
        }
        try {
            return Integer.parseInt(this._config.getProperty(PROP_STARTUP_DELAY));
        }
        catch (NumberFormatException nfe) {
            return 3;
        }
    }

    public File getDataDir() {
        String dir = this._config.getProperty(PROP_DIR, this._contextName);
        File f = this.areFilesPublic() ? new File(dir) : new SecureDirectory(dir);
        if (!f.isAbsolute()) {
            f = this.areFilesPublic() ? new File(this._context.getAppDir(), dir) : new SecureDirectory(this._context.getAppDir(), dir);
        }
        return f;
    }

    private File migrateConfig(File oldFile) {
        String oldDHT;
        File oldDHTFile;
        SecureDirectory dir = new SecureDirectory(oldFile + CONFIG_DIR_SUFFIX);
        if (!dir.exists() && !((File)dir).mkdirs()) {
            this._log.error("Error creating I2PSnark config dir " + dir);
            throw new RuntimeException("Error creating I2PSnark config dir " + dir);
        }
        String oldName = oldFile.toString();
        if (oldName.endsWith(CONFIG_FILE_SUFFIX) && (oldDHTFile = new File(oldDHT = oldName.replace(CONFIG_FILE_SUFFIX, ".dht.dat"))).exists()) {
            File newDHTFile = new File(dir, "i2psnark.dht.dat");
            FileUtil.rename(oldDHTFile, newDHTFile);
        }
        if (!oldFile.exists()) {
            return dir;
        }
        Properties oldProps = new Properties();
        try {
            DataHelper.loadProps(oldProps, oldFile);
            String auto = (String)oldProps.remove(PROP_OLD_AUTO_START);
            if (auto != null) {
                oldProps.setProperty(PROP_AUTO_START, auto);
            }
        }
        catch (IOException ioe) {
            this._log.error("Error loading I2PSnark config " + oldFile, ioe);
            return dir;
        }
        HashMap<String, Properties> configs = new HashMap<String, Properties>(16);
        Iterator<Map.Entry<Object, Object>> iter = oldProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String k = (String)entry.getKey();
            if (!k.startsWith(PROP_META_PREFIX)) continue;
            iter.remove();
            String v = (String)entry.getValue();
            try {
                k = k.substring(PROP_META_PREFIX.length());
                String h = k.substring(0, 28);
                k = k.substring(29);
                Properties tprops = (Properties)configs.get(h);
                if (tprops == null) {
                    tprops = new OrderedProperties();
                    configs.put(h, tprops);
                }
                if (k.equals(PROP_META_BITFIELD)) {
                    int comma = v.indexOf(44);
                    if (comma > 0 && v.length() > comma + 1) {
                        tprops.put(PROP_META_STAMP, v.substring(0, comma));
                        tprops.put(PROP_META_BITFIELD, v.substring(comma + 1));
                        continue;
                    }
                    tprops.put(PROP_META_STAMP, v);
                    continue;
                }
                tprops.put(k, v);
            }
            catch (IndexOutOfBoundsException ioobe) {}
        }
        for (Map.Entry<Object, Object> entry : configs.entrySet()) {
            File cfg;
            byte[] ih;
            String b64 = (String)entry.getKey();
            Properties props = (Properties)entry.getValue();
            if (props.isEmpty() || (ih = Base64.decode(b64 = b64.replace('$', '='))) == null || ih.length != 20 || (cfg = SnarkManager.configFile(dir, ih)).exists()) continue;
            File subdir = cfg.getParentFile();
            if (!subdir.exists()) {
                subdir.mkdirs();
            }
            try {
                DataHelper.storeProps(props, cfg);
            }
            catch (IOException ioe) {
                this._log.error("Error storing I2PSnark config " + cfg, ioe);
            }
        }
        File newFile = new File(dir, CONFIG_FILE);
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.putAll((Map<?, ?>)oldProps);
        try {
            DataHelper.storeProps(orderedProperties, newFile);
        }
        catch (IOException ioe) {
            this._log.error("Error storing I2PSnark config " + newFile, ioe);
            return dir;
        }
        oldFile.delete();
        if (this._log.shouldLog(30)) {
            this._log.warn("Config migrated from " + oldFile + " to " + dir);
        }
        return dir;
    }

    private Properties getConfig(Snark snark) {
        return this.getConfig(snark.getInfoHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getConfig(byte[] ih) {
        OrderedProperties rv = new OrderedProperties();
        File conf = SnarkManager.configFile(this._configDir, ih);
        Object object = this._configLock;
        synchronized (object) {
            try {
                DataHelper.loadProps((Properties)rv, conf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rv;
    }

    private static File configFile(File confDir, byte[] ih) {
        String hex = I2PSnarkUtil.toHex(ih);
        SecureDirectory subdir = new SecureDirectory(confDir, SUBDIR_PREFIX + B64.charAt(ih[0] >> 2 & 0x3F));
        return new File(subdir, hex + CONFIG_FILE_SUFFIX);
    }

    private static SHA1Hash configFileToInfoHash(File file) {
        String name = file.getName();
        if (name.length() != 40 + CONFIG_FILE_SUFFIX.length() || !name.endsWith(CONFIG_FILE_SUFFIX)) {
            return null;
        }
        String hex = name.substring(0, 40);
        byte[] ih = new byte[20];
        try {
            for (int i = 0; i < 20; ++i) {
                ih[i] = (byte)(Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16) & 0xFF);
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new SHA1Hash(ih);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(String filename) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_loadConfig(filename);
        }
    }

    private void locked_loadConfig(String filename) {
        if (this._config == null) {
            this._config = new OrderedProperties();
        }
        if (filename != null) {
            File cfg = new File(filename);
            if (!cfg.isAbsolute()) {
                cfg = new File(this._context.getConfigDir(), filename);
            }
            this._configDir = this.migrateConfig(cfg);
            this._configFile = new File(this._configDir, CONFIG_FILE);
            if (this._configFile.exists()) {
                try {
                    DataHelper.loadProps(this._config, this._configFile);
                }
                catch (IOException ioe) {
                    this._log.error("Error loading I2PSnark config " + this._configFile, ioe);
                }
            }
        }
        if (!this._config.containsKey(PROP_I2CP_HOST)) {
            this._config.setProperty(PROP_I2CP_HOST, "127.0.0.1");
        }
        if (!this._config.containsKey(PROP_I2CP_PORT)) {
            this._config.setProperty(PROP_I2CP_PORT, "7654");
        }
        if (!this._config.containsKey(PROP_I2CP_OPTS)) {
            this._config.setProperty(PROP_I2CP_OPTS, "inbound.length=3 outbound.length=3 inbound.quantity=3 outbound.quantity=3");
        }
        if (!this._config.containsKey(PROP_UPLOADERS_TOTAL)) {
            this._config.setProperty(PROP_UPLOADERS_TOTAL, "20");
        }
        if (!this._config.containsKey(PROP_DIR)) {
            this._config.setProperty(PROP_DIR, this._contextName);
        }
        if (!this._config.containsKey(PROP_AUTO_START)) {
            this._config.setProperty(PROP_AUTO_START, DEFAULT_AUTO_START);
        }
        if (!this._config.containsKey(PROP_REFRESH_DELAY)) {
            this._config.setProperty(PROP_REFRESH_DELAY, Integer.toString(60));
        }
        if (!this._config.containsKey(PROP_STARTUP_DELAY)) {
            this._config.setProperty(PROP_STARTUP_DELAY, Integer.toString(3));
        }
        if (!this._config.containsKey(PROP_PAGE_SIZE)) {
            this._config.setProperty(PROP_PAGE_SIZE, Integer.toString(50));
        }
        if (!this._config.containsKey(PROP_THEME)) {
            this._config.setProperty(PROP_THEME, DEFAULT_THEME);
        }
        this.updateConfig();
    }

    public String getTheme() {
        String theme = this._config.getProperty(PROP_THEME);
        boolean universalTheming = this._context.getBooleanProperty(RC_PROP_UNIVERSAL_THEMING);
        if (universalTheming) {
            theme = this._context.getProperty(RC_PROP_THEME, DEFAULT_THEME);
            String[] themes = this.getThemes();
            boolean themeExists = false;
            for (int i = 0; i < themes.length; ++i) {
                if (!themes[i].equals(theme)) continue;
                themeExists = true;
            }
            if (!themeExists) {
                theme = theme.equals("classic") ? "light" : DEFAULT_THEME;
                this._config.setProperty(PROP_THEME, DEFAULT_THEME);
            }
        }
        return theme;
    }

    public String[] getThemes() {
        String[] themes;
        if (this._context.isRouterContext()) {
            FileFilter fileFilter;
            File dir = new File(this._context.getBaseDir(), "docs/themes/snark");
            File[] dirnames = dir.listFiles(fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            if (dirnames != null) {
                themes = new String[dirnames.length];
                for (int i = 0; i < dirnames.length; ++i) {
                    themes[i] = dirnames[i].getName();
                }
            } else {
                themes = new String[]{};
            }
        } else {
            themes = new String[]{"light", DEFAULT_THEME, "vanilla"};
        }
        return themes;
    }

    private void getBWLimit() {
        int[] limits;
        if (!this._config.containsKey(PROP_UPBW_MAX) && (limits = BWLimits.getBWLimits(this._util.getI2CPHost(), this._util.getI2CPPort())) != null && limits[1] > 0) {
            this._util.setMaxUpBW(limits[1]);
        }
    }

    private void updateConfig() {
        String i2cpHost = this._config.getProperty(PROP_I2CP_HOST);
        int i2cpPort = this.getInt(PROP_I2CP_PORT, 7654);
        String opts = this._config.getProperty(PROP_I2CP_OPTS);
        HashMap<String, String> i2cpOpts = new HashMap<String, String>();
        if (opts != null) {
            StringTokenizer tok = new StringTokenizer(opts, " ");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                i2cpOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
        }
        this._util.setI2CPConfig(i2cpHost, i2cpPort, i2cpOpts);
        if (this._log.shouldLog(10)) {
            this._log.debug("Configuring with I2CP options " + i2cpOpts);
        }
        this._util.setMaxUploaders(this.getInt(PROP_UPLOADERS_TOTAL, 20));
        this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 25));
        this._util.setStartupDelay(this.getInt(PROP_STARTUP_DELAY, 3));
        this._util.setFilesPublic(this.areFilesPublic());
        this._util.setOpenTrackers(this.getListConfig(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS));
        String useOT = this._config.getProperty(PROP_USE_OPENTRACKERS);
        boolean bOT = useOT == null || Boolean.parseBoolean(useOT);
        this._util.setUseOpenTrackers(bOT);
        this._util.setUseDHT(Boolean.parseBoolean(this._config.getProperty(PROP_USE_DHT, Boolean.toString(true))));
        this.getDataDir().mkdirs();
        this.initTrackerMap();
    }

    private int getInt(String prop, int defaultVal) {
        String p = this._config.getProperty(prop);
        try {
            if (p != null && p.trim().length() > 0) {
                return Integer.parseInt(p.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(String dataDir, boolean filesPublic, boolean autoStart, boolean smartSort, String refreshDelay, String startDelay, String pageSize, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, boolean useOpenTrackers, boolean useDHT, String theme, String lang) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_updateConfig(dataDir, filesPublic, autoStart, smartSort, refreshDelay, startDelay, pageSize, seedPct, eepHost, eepPort, i2cpHost, i2cpPort, i2cpOpts, upLimit, upBW, useOpenTrackers, useDHT, theme, lang);
        }
    }

    private void locked_updateConfig(String dataDir, boolean filesPublic, boolean autoStart, boolean smartSort, String refreshDelay, String startDelay, String pageSize, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, boolean useOpenTrackers, boolean useDHT, String theme, String lang) {
        boolean interruptMonitor;
        boolean changed;
        block73: {
            block75: {
                int port;
                block77: {
                    HashMap<String, String> oldOpts;
                    HashMap<String, String> opts;
                    String oldI2CPHost;
                    int oldI2CPPort;
                    block76: {
                        boolean reconnect;
                        block74: {
                            int limit;
                            changed = false;
                            interruptMonitor = false;
                            if (upLimit != null) {
                                limit = this._util.getMaxUploaders();
                                try {
                                    limit = Integer.parseInt(upLimit.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (limit != this._util.getMaxUploaders()) {
                                    if (limit >= 4) {
                                        this._util.setMaxUploaders(limit);
                                        changed = true;
                                        this._config.setProperty(PROP_UPLOADERS_TOTAL, Integer.toString(limit));
                                        this.addMessage(this._t("Total uploaders limit changed to {0}", limit));
                                    } else {
                                        this.addMessage(this._t("Minimum total uploaders limit is {0}", 4));
                                    }
                                }
                            }
                            if (upBW != null) {
                                limit = this._util.getMaxUpBW();
                                try {
                                    limit = Integer.parseInt(upBW.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (limit != this._util.getMaxUpBW()) {
                                    if (limit >= 10) {
                                        this._util.setMaxUpBW(limit);
                                        changed = true;
                                        this._config.setProperty(PROP_UPBW_MAX, Integer.toString(limit));
                                        this.addMessage(this._t("Up BW limit changed to {0}KBps", limit));
                                    } else {
                                        this.addMessage(this._t("Minimum up bandwidth limit is {0}KBps", 10));
                                    }
                                }
                            }
                            if (startDelay != null && this._context.isRouterContext()) {
                                int minutes = this._util.getStartupDelay();
                                try {
                                    minutes = Integer.parseInt(startDelay.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (minutes != this._util.getStartupDelay()) {
                                    this._util.setStartupDelay(minutes);
                                    changed = true;
                                    this._config.setProperty(PROP_STARTUP_DELAY, Integer.toString(minutes));
                                    this.addMessage(this._t("Startup delay changed to {0}", DataHelper.formatDuration2((long)minutes * 60000L)));
                                }
                            }
                            if (refreshDelay != null) {
                                try {
                                    int secs = Integer.parseInt(refreshDelay.trim());
                                    if (secs != this.getRefreshDelaySeconds()) {
                                        changed = true;
                                        this._config.setProperty(PROP_REFRESH_DELAY, Integer.toString(secs));
                                        if (secs >= 0) {
                                            this.addMessage(this._t("Refresh time changed to {0}", DataHelper.formatDuration2(secs * 1000)));
                                        } else {
                                            this.addMessage(this._t("Refresh disabled"));
                                        }
                                    }
                                }
                                catch (NumberFormatException secs) {
                                    // empty catch block
                                }
                            }
                            if (pageSize != null) {
                                try {
                                    int size = Integer.parseInt(pageSize.trim());
                                    if (size <= 0) {
                                        size = 999999;
                                    } else if (size < 5) {
                                        size = 5;
                                    }
                                    if (size != this.getPageSize()) {
                                        changed = true;
                                        pageSize = Integer.toString(size);
                                        this._config.setProperty(PROP_PAGE_SIZE, pageSize);
                                        this.addMessage(this._t("Page size changed to {0}", pageSize));
                                    }
                                }
                                catch (NumberFormatException size) {
                                    // empty catch block
                                }
                            }
                            if (dataDir != null && !dataDir.equals(this.getDataDir().getAbsolutePath())) {
                                File dd = new File(dataDir = DataHelper.stripHTML(dataDir.trim()));
                                if (!dd.isAbsolute()) {
                                    this.addMessage(this._t("Data directory must be an absolute path") + ": " + dataDir);
                                } else if (!dd.exists()) {
                                    this.addMessage(this._t("Data directory does not exist") + ": " + dataDir);
                                } else if (!dd.isDirectory()) {
                                    this.addMessage(this._t("Not a directory") + ": " + dataDir);
                                } else if (!dd.canRead()) {
                                    this.addMessage(this._t("Unreadable") + ": " + dataDir);
                                } else {
                                    changed = true;
                                    interruptMonitor = true;
                                    this._config.setProperty(PROP_DIR, dataDir);
                                    this.addMessage(this._t("Data directory changed to {0}", dataDir));
                                }
                            }
                            if (lang != null && !this._context.isRouterContext() && lang.length() >= 2 && lang.length() <= 6) {
                                String ncountry;
                                String nlang;
                                int under = lang.indexOf(95);
                                if (under > 0 && lang.length() > under + 1) {
                                    nlang = lang.substring(0, under);
                                    ncountry = lang.substring(under + 1);
                                } else {
                                    nlang = lang;
                                    ncountry = "";
                                }
                                String olang = this._config.getProperty(PROP_LANG);
                                String ocountry = this._config.getProperty(PROP_COUNTRY);
                                if (!nlang.equals(olang) || !ncountry.equals(ocountry)) {
                                    changed = true;
                                    this._config.setProperty(PROP_LANG, nlang);
                                    this._config.setProperty(PROP_COUNTRY, ncountry);
                                    Translate.setLanguage(nlang, ncountry);
                                }
                            }
                            oldI2CPPort = this._util.getI2CPPort();
                            oldI2CPHost = this._util.getI2CPHost();
                            port = oldI2CPPort;
                            if (i2cpPort != null) {
                                try {
                                    port = Integer.parseInt(i2cpPort);
                                }
                                catch (NumberFormatException olang) {
                                    // empty catch block
                                }
                            }
                            opts = new HashMap<String, String>();
                            i2cpOpts = DataHelper.stripHTML(i2cpOpts);
                            StringTokenizer tok = new StringTokenizer(i2cpOpts, " \t\n");
                            while (tok.hasMoreTokens()) {
                                String pair = tok.nextToken();
                                int split = pair.indexOf(61);
                                if (split <= 0) continue;
                                opts.put(pair.substring(0, split), pair.substring(split + 1));
                            }
                            oldOpts = new HashMap<String, String>();
                            String oldI2CPOpts = this._config.getProperty(PROP_I2CP_OPTS);
                            if (oldI2CPOpts == null) {
                                oldI2CPOpts = "";
                            }
                            tok = new StringTokenizer(oldI2CPOpts, " \t\n");
                            while (tok.hasMoreTokens()) {
                                String pair = tok.nextToken();
                                int split = pair.indexOf(61);
                                if (split <= 0) continue;
                                oldOpts.put(pair.substring(0, split), pair.substring(split + 1));
                            }
                            boolean bl = reconnect = i2cpHost != null && i2cpHost.trim().length() > 0 && port > 0 && (port != this._util.getI2CPPort() || !oldI2CPHost.equals(i2cpHost));
                            if (!reconnect && oldOpts.equals(opts)) break block73;
                            boolean snarksActive = false;
                            if (reconnect) {
                                for (Snark snark : this._snarks.values()) {
                                    if (snark.isStopped()) continue;
                                    snarksActive = true;
                                    break;
                                }
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug("i2cp host [" + i2cpHost + "] i2cp port " + port + " opts [" + opts + "] oldOpts [" + oldOpts + "]");
                            }
                            if (!snarksActive) break block74;
                            Properties p = new Properties();
                            p.putAll((Map<?, ?>)opts);
                            this._util.setI2CPConfig(i2cpHost, port, p);
                            this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 25));
                            this.addMessage(this._t("I2CP and tunnel changes will take effect after stopping all torrents"));
                            break block75;
                        }
                        if (reconnect) break block76;
                        this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                        this.addMessage(this._t("I2CP options changed to {0}", i2cpOpts));
                        this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, opts);
                        break block75;
                    }
                    if (this._util.connected()) {
                        this._util.disconnect();
                        this.addMessage(this._t("Disconnecting old I2CP destination"));
                    }
                    this.addMessage(this._t("I2CP settings changed to {0}", i2cpHost + ':' + port + ' ' + i2cpOpts));
                    this._util.setI2CPConfig(i2cpHost, port, opts);
                    this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 25));
                    boolean ok = this._util.connect();
                    if (ok) break block77;
                    this.addMessage(this._t("Unable to connect with the new settings, reverting to the old I2CP settings"));
                    this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, oldOpts);
                    ok = this._util.connect();
                    if (ok) break block75;
                    this.addMessage(this._t("Unable to reconnect with the old settings!"));
                    break block75;
                }
                this.addMessage(this._t("Reconnected on the new I2CP destination"));
                this._config.setProperty(PROP_I2CP_HOST, i2cpHost.trim());
                this._config.setProperty(PROP_I2CP_PORT, "" + port);
                this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                for (Snark snark : this._snarks.values()) {
                    if (!snark.restartAcceptor()) continue;
                    this.addMessage(this._t("I2CP listener restarted for \"{0}\"", snark.getBaseName()));
                    break;
                }
            }
            changed = true;
        }
        if (this.areFilesPublic() != filesPublic) {
            this._config.setProperty(PROP_FILES_PUBLIC, Boolean.toString(filesPublic));
            this._util.setFilesPublic(filesPublic);
            if (filesPublic) {
                this.addMessage(this._t("New files will be publicly readable"));
            } else {
                this.addMessage(this._t("New files will not be publicly readable"));
            }
            changed = true;
        }
        if (this.shouldAutoStart() != autoStart) {
            this._config.setProperty(PROP_AUTO_START, Boolean.toString(autoStart));
            if (autoStart) {
                this.addMessage(this._t("Enabled autostart"));
            } else {
                this.addMessage(this._t("Disabled autostart"));
            }
            changed = true;
        }
        if (this.isSmartSortEnabled() != smartSort) {
            this._config.setProperty(PROP_SMART_SORT, Boolean.toString(smartSort));
            if (smartSort) {
                this.addMessage(this._t("Enabled smart sort"));
            } else {
                this.addMessage(this._t("Disabled smart sort"));
            }
            changed = true;
        }
        if (this._util.shouldUseOpenTrackers() != useOpenTrackers) {
            this._config.setProperty(PROP_USE_OPENTRACKERS, useOpenTrackers + "");
            if (useOpenTrackers) {
                this.addMessage(this._t("Enabled open trackers - torrent restart required to take effect."));
            } else {
                this.addMessage(this._t("Disabled open trackers - torrent restart required to take effect."));
            }
            this._util.setUseOpenTrackers(useOpenTrackers);
            changed = true;
        }
        if (this._util.shouldUseDHT() != useDHT) {
            this._config.setProperty(PROP_USE_DHT, Boolean.toString(useDHT));
            if (useDHT) {
                this.addMessage(this._t("Enabled DHT."));
            } else {
                this.addMessage(this._t("Disabled DHT."));
            }
            if (this._util.connected()) {
                this.addMessage(this._t("DHT change requires tunnel shutdown and reopen"));
            }
            this._util.setUseDHT(useDHT);
            changed = true;
        }
        if (theme != null && !theme.equals(this._config.getProperty(PROP_THEME))) {
            this._config.setProperty(PROP_THEME, theme);
            this.addMessage(this._t("{0} theme loaded, return to main i2psnark page to view.", theme));
            changed = true;
        }
        if (changed) {
            this.saveConfig();
            if (interruptMonitor) {
                this._monitor.interrupt();
            }
        } else {
            this.addMessage(this._t("Configuration unchanged."));
        }
    }

    private List<String> getOpenTrackers() {
        if (!this._util.shouldUseOpenTrackers()) {
            return Collections.emptyList();
        }
        return this.getListConfig(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS);
    }

    public List<String> getPrivateTrackers() {
        return this.getListConfig(PROP_PRIVATETRACKERS, null);
    }

    public void saveOpenTrackers(List<String> ot) {
        this.setListConfig(PROP_OPENTRACKERS, ot);
        if (ot == null) {
            ot = this.getListConfig(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS);
        }
        this._util.setOpenTrackers(ot);
        this.addMessage(this._t("Open Tracker list changed - torrent restart required to take effect."));
        this.saveConfig();
    }

    public void savePrivateTrackers(List<String> pt) {
        this.setListConfig(PROP_PRIVATETRACKERS, pt);
        this.addMessage(this._t("Private tracker list changed - affects newly created torrents only."));
        this.saveConfig();
    }

    private List<String> getListConfig(String prop, String dflt) {
        String val = this._config.getProperty(prop);
        if (val == null) {
            val = dflt;
        }
        if (val == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(DataHelper.split(val, ","));
    }

    private String setListConfig(String prop, List<String> values) {
        if (values == null || values.isEmpty()) {
            this._config.remove(prop);
            return "";
        }
        StringBuilder buf = new StringBuilder(64);
        for (String s : values) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(s);
        }
        String rv = buf.toString();
        this._config.setProperty(prop, rv);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        try {
            Object object = this._configLock;
            synchronized (object) {
                DataHelper.storeProps(this._config, this._configFile);
            }
        }
        catch (IOException ioe) {
            this.addMessage(this._t("Unable to save the config to {0}", this._configFile.getAbsolutePath()));
        }
    }

    public Set<String> listTorrentFiles() {
        return new HashSet<String>(this._snarks.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrent(String filename) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            return this._snarks.get(filename);
        }
    }

    public Collection<Snark> getTorrents() {
        return Collections.unmodifiableCollection(this._snarks.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrentByBaseName(String filename) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            for (Snark s : this._snarks.values()) {
                if (!s.getBaseName().equals(filename)) continue;
                return s;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrentByInfoHash(byte[] infohash) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            for (Snark s : this._snarks.values()) {
                if (!DataHelper.eq(infohash, s.getInfoHash())) continue;
                return s;
            }
        }
        return null;
    }

    private void addTorrent(String filename, File baseFile, boolean dontAutoStart) {
        this.addTorrent(filename, baseFile, dontAutoStart, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTorrent(String filename, File baseFile, boolean dontAutoStart, File dataDir) {
        if (!dontAutoStart && !this._util.connected()) {
            this.addMessage(this._t("Connecting to I2P"));
            boolean ok = this._util.connect();
            if (!ok) {
                this.addMessage(this._t("Error connecting to I2P - check your I2CP settings!"));
                return;
            }
        }
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to add the torrent " + filename, ioe);
            this.addMessage(this._t("Error: Could not add the torrent {0}", filename) + ": " + ioe);
            return;
        }
        if (dataDir == null) {
            dataDir = this.getDataDir();
        }
        Snark torrent = null;
        Object object = this._snarks;
        synchronized (object) {
            torrent = this._snarks.get(filename);
        }
        if (torrent != null) return;
        object = this._addSnarkLock;
        synchronized (object) {
            Map<String, Snark> map = this._snarks;
            synchronized (map) {
                if (this._snarks.get(filename) != null) {
                    return;
                }
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sfile);
            }
            catch (IOException ioe) {
                this.addMessage(this._t("Cannot open \"{0}\"", sfile.getName()) + ": " + ioe.getMessage());
                return;
            }
            try {
                String rejectMessage;
                MetaInfo info = new MetaInfo(fis);
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Snark snark = this.getTorrentByInfoHash(info.getInfoHash());
                if (snark != null) {
                    this.addMessage(this._t("Torrent with this info hash is already running: {0}", snark.getBaseName()));
                    return;
                }
                if (!TrackerClient.isValidAnnounce(info.getAnnounce())) {
                    if (info.isPrivate()) {
                        this.addMessage(this._t("ERROR - No I2P trackers in private torrent \"{0}\"", info.getName()));
                    } else if (!this._util.getOpenTrackers().isEmpty()) {
                        this.addMessage(this._t("Warning - No I2P trackers in \"{0}\", will announce to I2P open trackers and DHT only.", info.getName()));
                    } else if (this._util.shouldUseDHT()) {
                        this.addMessage(this._t("Warning - No I2P trackers in \"{0}\", and open trackers are disabled, will announce to DHT only.", info.getName()));
                    } else {
                        this.addMessage(this._t("Warning - No I2P trackers in \"{0}\", and DHT and open trackers are disabled, you should enable open trackers or DHT before starting the torrent.", info.getName()));
                        dontAutoStart = true;
                    }
                }
                if ((rejectMessage = this.validateTorrent(info)) != null) {
                    throw new IOException(rejectMessage);
                }
                if (baseFile == null) {
                    baseFile = this.getSavedBaseFile(info.getInfoHash());
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("New Snark, torrent: " + filename + " base: " + baseFile);
                }
                torrent = new Snark(this._util, filename, null, -1, null, null, this, this._peerCoordinatorSet, this._connectionAcceptor, this.shouldAutoStart(), dataDir.getPath(), baseFile);
                this.loadSavedFilePriorities(torrent);
                Map<String, Snark> map2 = this._snarks;
                synchronized (map2) {
                    this._snarks.put(filename, torrent);
                }
            }
            catch (IOException ioe) {
                if (fis != null) {
                    try {
                        fis.close();
                        fis = null;
                    }
                    catch (IOException snark) {
                        // empty catch block
                    }
                }
                String err = this._t("Torrent in \"{0}\" is invalid", sfile.toString()) + ": " + ioe.getMessage();
                this.addMessage(err);
                this._log.error(err, ioe);
                File rename = new File(filename + ".BAD");
                if (rename.exists()) {
                    if (!sfile.delete()) return;
                    this.addMessage(this._t("Torrent file deleted: {0}", sfile.toString()));
                } else {
                    if (!FileUtil.rename(sfile, rename)) return;
                    this.addMessage(this._t("Torrent file moved from {0} to {1}", sfile.toString(), rename.toString()));
                }
                return;
            }
            catch (OutOfMemoryError oom) {
                this.addMessage(this._t("ERROR - Out of memory, cannot create torrent from {0}", sfile.getName()) + ": " + oom.getMessage());
                return;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Properties config = this.getConfig(torrent);
        String prop = config.getProperty(PROP_META_RUNNING);
        boolean running = prop == null || Boolean.parseBoolean(prop);
        String link = this.linkify(torrent);
        if (!dontAutoStart && this.shouldAutoStart() && running) {
            torrent.startTorrent();
            this.addMessageNoEscape(this._t("Torrent added and started: {0}", link));
            return;
        }
        this.addMessageNoEscape(this._t("Torrent added: {0}", link));
    }

    public void addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus) {
        this.addMagnet(name, ih, trackerURL, updateStatus, updateStatus, null, this);
    }

    public void addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus, File dataDir) {
        this.addMagnet(name, ih, trackerURL, updateStatus, updateStatus, dataDir, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus, boolean autoStart, File dataDir, CompleteListener listener) {
        String dirPath = dataDir != null ? dataDir.getAbsolutePath() : this.getDataDir().getPath();
        Snark torrent = new Snark(this._util, name, ih, trackerURL, listener, this._peerCoordinatorSet, this._connectionAcceptor, false, dirPath);
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(ih);
            if (snark != null) {
                this.addMessage(this._t("Torrent with this info hash is already running: {0}", snark.getBaseName()));
                return null;
            }
            this._magnets.add(name);
            if (updateStatus) {
                this.saveMagnetStatus(ih, dirPath, trackerURL, name);
            }
            this._snarks.put(name, torrent);
        }
        if (autoStart) {
            boolean shouldWarn;
            this.startTorrent(ih);
            this.addMessage(this._t("Fetching {0}", name));
            DHT dht = this._util.getDHT();
            boolean bl = shouldWarn = this._util.connected() && this._util.getOpenTrackers().isEmpty() && (!this._util.shouldUseDHT() || dht == null || dht.size() <= 0);
            if (shouldWarn) {
                this.addMessage(this._t("Open trackers are disabled and we have no DHT peers. Fetch of {0} may not succeed until you start another torrent, enable open trackers, or enable DHT.", name));
            }
        } else {
            this.addMessage(this._t("Adding {0}", name));
        }
        return torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMagnet(Snark snark) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            this._snarks.remove(snark.getName());
        }
        snark.stopTorrent();
        this._magnets.remove(snark.getName());
        this.removeMagnetStatus(snark.getInfoHash());
        this.removeTorrentStatus(snark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloader(Snark torrent) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(torrent.getInfoHash());
            if (snark != null) {
                this.addMessage(this._t("Download already running: {0}", snark.getBaseName()));
                return;
            }
            String name = torrent.getName();
            this._magnets.add(name);
            this._snarks.put(name, torrent);
        }
        torrent.startTorrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTorrent(MetaInfo metainfo, BitField bitfield, String filename, File baseFile, boolean dontAutoStart) throws IOException {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(metainfo.getInfoHash());
            if (snark != null) {
                this.addMessage(this._t("Torrent with this info hash is already running: {0}", snark.getBaseName()));
                return false;
            }
            this.saveTorrentStatus(metainfo, bitfield, null, baseFile, true, 0L, true);
            try {
                SnarkManager.locked_writeMetaInfo(metainfo, filename, this.areFilesPublic());
                this.addTorrent(filename, baseFile, dontAutoStart);
            }
            catch (IOException ioe) {
                this.addMessage(this._t("Failed to copy torrent file to {0}", filename));
                this._log.error("Failed to write torrent file", ioe);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAndAddTorrent(File fromfile, String filename, File dataDir) throws IOException {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            boolean success = FileUtil.copy(fromfile.getAbsolutePath(), filename, false);
            if (!success) {
                this.addMessage(this._t("Failed to copy torrent file to {0}", filename));
                this._log.error("Failed to write torrent file to " + filename);
                return;
            }
            if (!this.areFilesPublic()) {
                SecureFileOutputStream.setPerms(new File(filename));
            }
            this.addTorrent(filename, null, false, dataDir);
        }
    }

    private static void locked_writeMetaInfo(MetaInfo metainfo, String filename, boolean areFilesPublic) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            throw new IOException("Cannot overwrite an existing .torrent file: " + file.getPath());
        }
        FileOutputStream out = null;
        try {
            out = areFilesPublic ? new FileOutputStream(filename) : new SecureFileOutputStream(filename);
            ((OutputStream)out).write(metainfo.getTorrentData());
        }
        catch (IOException ioe) {
            file.delete();
            throw ioe;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long getSavedTorrentTime(Snark snark) {
        Properties config = this.getConfig(snark);
        String time = config.getProperty(PROP_META_STAMP);
        if (time == null) {
            return 0L;
        }
        try {
            return Long.parseLong(time);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    @Override
    public BitField getSavedTorrentBitField(Snark snark) {
        MetaInfo metainfo = snark.getMetaInfo();
        if (metainfo == null) {
            return null;
        }
        Properties config = this.getConfig(snark);
        String bf = config.getProperty(PROP_META_BITFIELD);
        if (bf == null) {
            return null;
        }
        int len = metainfo.getPieces();
        if (bf.equals(".")) {
            BitField bitfield = new BitField(len);
            for (int i = 0; i < len; ++i) {
                bitfield.set(i);
            }
            return bitfield;
        }
        byte[] bitfield = Base64.decode(bf);
        if (bitfield == null) {
            return null;
        }
        if (bitfield.length * 8 < len) {
            return null;
        }
        return new BitField(bitfield, len);
    }

    public void loadSavedFilePriorities(Snark snark) {
        MetaInfo metainfo = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (metainfo == null || storage == null) {
            return;
        }
        if (metainfo.getFiles() == null) {
            return;
        }
        Properties config = this.getConfig(snark);
        String pri = config.getProperty(PROP_META_PRIORITY);
        if (pri == null) {
            return;
        }
        int filecount = metainfo.getFiles().size();
        int[] rv = new int[filecount];
        String[] arr = DataHelper.split(pri, ",");
        for (int i = 0; i < filecount && i < arr.length; ++i) {
            if (arr[i].length() <= 0) continue;
            try {
                rv[i] = Integer.parseInt(arr[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        storage.setFilePriorities(rv);
    }

    private File getSavedBaseFile(byte[] ih) {
        Properties config = this.getConfig(ih);
        String base = config.getProperty(PROP_META_BASE);
        if (base == null) {
            return null;
        }
        return new File(base);
    }

    @Override
    public boolean getSavedPreserveNamesSetting(Snark snark) {
        Properties config = this.getConfig(snark);
        return Boolean.parseBoolean(config.getProperty(PROP_META_PRESERVE_NAMES));
    }

    @Override
    public long getSavedUploaded(Snark snark) {
        Properties config = this.getConfig(snark);
        if (config != null) {
            try {
                return Long.parseLong(config.getProperty(PROP_META_UPLOADED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public long[] getSavedAddedAndCompleted(Snark snark) {
        long[] rv = new long[2];
        Properties config = this.getConfig(snark);
        if (config != null) {
            try {
                rv[0] = Long.parseLong(config.getProperty(PROP_META_ADDED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                rv[1] = Long.parseLong(config.getProperty(PROP_META_COMPLETED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    public void saveTorrentStatus(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return;
        }
        this.saveTorrentStatus(meta, storage.getBitField(), storage.getFilePriorities(), storage.getBase(), storage.getPreserveFileNames(), snark.getUploaded(), snark.isStopped());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, File base, boolean preserveNames, long uploaded, boolean stopped) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_saveTorrentStatus(metainfo, bitfield, priorities, base, preserveNames, uploaded, stopped);
        }
    }

    private void locked_saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, File base, boolean preserveNames, long uploaded, boolean stopped) {
        String bfs;
        byte[] ih = metainfo.getInfoHash();
        Properties config = this.getConfig(ih);
        String now = Long.toString(System.currentTimeMillis());
        config.setProperty(PROP_META_STAMP, now);
        if (config.getProperty(PROP_META_ADDED) == null) {
            config.setProperty(PROP_META_ADDED, now);
        }
        if (bitfield.complete()) {
            bfs = ".";
            if (config.getProperty(PROP_META_COMPLETED) == null) {
                config.setProperty(PROP_META_COMPLETED, now);
            }
        } else {
            byte[] bf = bitfield.getFieldBytes();
            bfs = Base64.encode(bf);
            config.remove(PROP_META_COMPLETED);
        }
        config.setProperty(PROP_META_BITFIELD, bfs);
        config.setProperty(PROP_META_PRESERVE_NAMES, Boolean.toString(preserveNames));
        config.setProperty(PROP_META_UPLOADED, Long.toString(uploaded));
        boolean running = !stopped;
        config.setProperty(PROP_META_RUNNING, Boolean.toString(running));
        if (base != null) {
            config.setProperty(PROP_META_BASE, base.getAbsolutePath());
        }
        if (priorities != null) {
            boolean nonzero = false;
            for (int i = 0; i < priorities.length; ++i) {
                if (priorities[i] == 0) continue;
                nonzero = true;
                break;
            }
            if (nonzero) {
                StringBuilder buf = new StringBuilder(2 * priorities.length);
                for (int i = 0; i < priorities.length; ++i) {
                    if (priorities[i] != 0) {
                        buf.append(Integer.toString(priorities[i]));
                    }
                    if (i == priorities.length - 1) continue;
                    buf.append(',');
                }
                config.setProperty(PROP_META_PRIORITY, buf.toString());
            } else {
                config.remove(PROP_META_PRIORITY);
            }
        } else {
            config.remove(PROP_META_PRIORITY);
        }
        config.remove(PROP_META_MAGNET);
        config.remove(PROP_META_MAGNET_DIR);
        config.remove(PROP_META_MAGNET_DN);
        config.remove(PROP_META_MAGNET_TR);
        this.locked_saveTorrentStatus(ih, config);
    }

    private void locked_saveTorrentStatus(byte[] ih, Properties config) {
        File conf = SnarkManager.configFile(this._configDir, ih);
        File subdir = conf.getParentFile();
        if (!subdir.exists()) {
            subdir.mkdirs();
        }
        try {
            DataHelper.storeProps(config, conf);
            if (this._log.shouldInfo()) {
                this._log.info("Saved config to " + conf);
            }
        }
        catch (IOException ioe) {
            this._log.error("Unable to save the config to " + conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTorrentStatus(Snark snark) {
        byte[] ih = snark.getInfoHash();
        File conf = SnarkManager.configFile(this._configDir, ih);
        Object object = this._configLock;
        synchronized (object) {
            File subdir;
            String[] files;
            boolean ok = conf.delete();
            if (ok) {
                if (this._log.shouldInfo()) {
                    this._log.info("Deleted " + conf + " for " + snark.getName());
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Failed to delete " + conf + " for " + snark.getName());
            }
            if ((files = (subdir = conf.getParentFile()).list()) != null && files.length == 0) {
                subdir.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTorrentStatus() {
        HashSet<SHA1Hash> torrents = new HashSet<SHA1Hash>(32);
        int found = 0;
        int totalDeleted = 0;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            for (Snark snark : this._snarks.values()) {
                torrents.add(new SHA1Hash(snark.getInfoHash()));
            }
            Object object = this._configLock;
            synchronized (object) {
                for (int i = 0; i < B64.length(); ++i) {
                    File subdir = new File(this._configDir, SUBDIR_PREFIX + B64.charAt(i));
                    File[] configs = subdir.listFiles();
                    if (configs == null) continue;
                    int deleted = 0;
                    for (int j = 0; j < configs.length; ++j) {
                        File config = configs[j];
                        SHA1Hash ih = SnarkManager.configFileToInfoHash(config);
                        if (ih == null) continue;
                        ++found;
                        if (torrents.contains(ih)) {
                            if (!this._log.shouldInfo()) continue;
                            this._log.info("Torrent for " + config + " exists");
                            continue;
                        }
                        boolean ok = config.delete();
                        if (ok) {
                            if (this._log.shouldInfo()) {
                                this._log.info("Deleted " + config + " for " + ih);
                            }
                            ++deleted;
                            continue;
                        }
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Failed to delete " + config + " for " + ih);
                    }
                    if (deleted == configs.length) {
                        if (this._log.shouldInfo()) {
                            this._log.info("Deleting " + subdir);
                        }
                        subdir.delete();
                    }
                    totalDeleted += deleted;
                }
            }
        }
        if (this._log.shouldInfo()) {
            this._log.info("Cleanup found " + torrents.size() + " torrents and " + found + " configs, deleted " + totalDeleted + " old configs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMagnetStatus(byte[] ih, String dir, String trackerURL, String dn) {
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        this._config.setProperty(PROP_META_MAGNET_PREFIX + infohash, ".");
        OrderedProperties config = new OrderedProperties();
        config.setProperty(PROP_META_MAGNET, "true");
        if (dir != null) {
            config.setProperty(PROP_META_MAGNET_DIR, dir);
        }
        if (trackerURL != null) {
            config.setProperty(PROP_META_MAGNET_TR, trackerURL);
        }
        if (dn != null) {
            config.setProperty(PROP_META_MAGNET_DN, dn);
        }
        String now = Long.toString(System.currentTimeMillis());
        config.setProperty(PROP_META_ADDED, now);
        config.setProperty(PROP_META_STAMP, now);
        Object object = this._configLock;
        synchronized (object) {
            this.saveConfig();
            this.locked_saveTorrentStatus(ih, config);
        }
    }

    public void removeMagnetStatus(byte[] ih) {
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        if (this._config.remove(PROP_META_MAGNET_PREFIX + infohash) != null) {
            this.saveConfig();
        }
    }

    private String validateTorrent(MetaInfo info) {
        List<List<String>> files = info.getFiles();
        if (files != null && files.size() > 2000) {
            return this._t("Too many files in \"{0}\" ({1})!", info.getName(), files.size());
        }
        if (files == null && info.getName().endsWith(".torrent")) {
            return this._t("Torrent file \"{0}\" cannot end in \".torrent\"!", info.getName());
        }
        if (info.getPieces() <= 0) {
            return this._t("No pieces in \"{0}\"!", info.getName());
        }
        if (info.getPieces() > 32768) {
            return this._t("Too many pieces in \"{0}\", limit is {1}!", info.getName(), 32768);
        }
        if (info.getPieceLength(0) > 0x1000000) {
            return this._t("Pieces are too large in \"{0}\" ({1}B)!", info.getName(), DataHelper.formatSize2(info.getPieceLength(0))) + ' ' + this._t("Limit is {0}B", DataHelper.formatSize2(0x1000000L));
        }
        if (info.getTotalLength() <= 0L) {
            return this._t("Torrent \"{0}\" has no data!", info.getName());
        }
        if (info.getTotalLength() > 0x8000000000L) {
            System.out.println("torrent info: " + info.toString());
            List<Long> lengths = info.getLengths();
            if (lengths != null) {
                for (int i = 0; i < lengths.size(); ++i) {
                    System.out.println("File " + i + " is " + lengths.get(i) + " long.");
                }
            }
            return this._t("Torrents larger than {0}B are not supported yet \"{1}\"!", 0x8000000000L, info.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark stopTorrent(String filename, boolean shouldRemove) {
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to remove the torrent " + filename, ioe);
            this.addMessage(this._t("Error: Could not remove the torrent {0}", filename) + ": " + ioe.getMessage());
            return null;
        }
        int remaining = 0;
        Snark torrent = null;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            torrent = shouldRemove ? this._snarks.remove(filename) : this._snarks.get(filename);
            remaining = this._snarks.size();
        }
        if (torrent != null) {
            boolean wasStopped = torrent.isStopped();
            torrent.stopTorrent();
            if (remaining == 0) {
                // empty if block
            }
            if (shouldRemove) {
                this.removeTorrentStatus(torrent);
            }
            if (!wasStopped) {
                this.addMessageNoEscape(this._t("Torrent stopped: {0}", this.linkify(torrent)));
            }
        }
        return torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTorrent(Snark torrent, boolean shouldRemove) {
        if (shouldRemove) {
            Map<String, Snark> map = this._snarks;
            synchronized (map) {
                this._snarks.remove(torrent.getName());
            }
        }
        boolean wasStopped = torrent.isStopped();
        torrent.stopTorrent();
        if (!wasStopped) {
            this.addMessageNoEscape(this._t("Torrent stopped: {0}", this.linkify(torrent)));
        }
        if (shouldRemove) {
            this.removeTorrentStatus(torrent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTorrent(String filename) {
        Snark torrent;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            torrent = this.stopTorrent(filename, true);
            if (torrent == null) {
                return;
            }
            File torrentFile = new File(filename);
            torrentFile.delete();
        }
        this.addMessage(this._t("Torrent removed: \"{0}\"", torrent.getBaseName()));
    }

    @Override
    public void torrentComplete(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return;
        }
        if (snark.getDownloaded() > 0L) {
            this.addMessageNoEscape(this._t("Download finished: {0}", this.linkify(snark)));
        }
        this.updateStatus(snark);
    }

    @Override
    public void updateStatus(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta != null && storage != null) {
            this.saveTorrentStatus(meta, storage.getBitField(), storage.getFilePriorities(), storage.getBase(), storage.getPreserveFileNames(), snark.getUploaded(), snark.isStopped());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String gotMetaInfo(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta != null && storage != null) {
            String rejectMessage = this.validateTorrent(meta);
            if (rejectMessage != null) {
                this.addMessage(rejectMessage);
                snark.stopTorrent();
                return null;
            }
            this.saveTorrentStatus(meta, storage.getBitField(), null, storage.getBase(), storage.getPreserveFileNames(), 0L, snark.isStopped());
            String name = storage.getBaseName();
            try {
                name = new File(this.getDataDir(), storage.getBaseName() + ".torrent").getCanonicalPath();
                String announce = snark.getTrackerURL();
                if (announce != null) {
                    meta = meta.reannounce(announce);
                }
                Map<String, Snark> map = this._snarks;
                synchronized (map) {
                    SnarkManager.locked_writeMetaInfo(meta, name, this.areFilesPublic());
                    this._snarks.remove(snark.getName());
                    this._snarks.put(name, snark);
                }
                this._magnets.remove(snark.getName());
                this.removeMagnetStatus(snark.getInfoHash());
                this.addMessageNoEscape(this._t("Starting up torrent {0}", this.linkify(snark)));
                return name;
            }
            catch (IOException ioe) {
                this.addMessage(this._t("Failed to copy torrent file to {0}", name));
                this._log.error("Failed to write torrent file", ioe);
            }
        }
        return null;
    }

    @Override
    public void fatal(Snark snark, String error) {
        this.addMessage(this._t("Error on torrent {0}", snark.getName()) + ": " + error);
    }

    @Override
    public void addMessage(Snark snark, String message) {
        this.addMessage(message);
    }

    @Override
    public void gotPiece(Snark snark) {
    }

    private String linkify(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return DataHelper.escapeHTML(snark.getBaseName());
        }
        StringBuilder buf = new StringBuilder(256);
        String base = DataHelper.escapeHTML(storage.getBaseName());
        buf.append("<a href=\"").append(this._contextPath).append('/').append(base);
        if (meta.getFiles() != null || !storage.complete()) {
            buf.append('/');
        }
        buf.append("\">").append(base).append("</a>");
        return buf.toString();
    }

    private void addMagnets() {
        boolean changed = false;
        Iterator<Object> iter = this._config.keySet().iterator();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            if (!k.startsWith(PROP_META_MAGNET_PREFIX)) continue;
            String b64 = k.substring(PROP_META_MAGNET_PREFIX.length());
            byte[] ih = Base64.decode(b64 = b64.replace('$', '='));
            if (ih != null && ih.length == 20) {
                Properties config = this.getConfig(ih);
                String name = config.getProperty(PROP_META_MAGNET_DN);
                if (name == null) {
                    name = this._t("Magnet") + ' ' + I2PSnarkUtil.toHex(ih);
                }
                String tracker = config.getProperty(PROP_META_MAGNET_TR);
                String dir = config.getProperty(PROP_META_MAGNET_DIR);
                File dirf = dir != null ? new File(dir) : null;
                this.addMagnet(name, ih, tracker, false, dirf);
                continue;
            }
            iter.remove();
            changed = true;
        }
        if (changed) {
            this.saveConfig();
        }
    }

    private boolean monitorTorrents(File dir) {
        boolean rv = true;
        String[] fileNames = dir.list(TorrentFilenameFilter.instance());
        ArrayList<String> foundNames = new ArrayList<String>(0);
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                try {
                    foundNames.add(new File(dir, fileNames[i]).getCanonicalPath());
                    continue;
                }
                catch (IOException ioe) {
                    this._log.error("Error resolving '" + fileNames[i] + "' in '" + dir, ioe);
                }
            }
        }
        Set<String> existingNames = this.listTorrentFiles();
        if (this._log.shouldLog(10)) {
            this._log.debug("DirMon found: " + DataHelper.toString(foundNames) + " existing: " + DataHelper.toString(existingNames));
        }
        for (String name : foundNames) {
            if (existingNames.contains(name)) continue;
            if (this.shouldAutoStart() && !this._util.connect()) {
                this.addMessage(this._t("Unable to connect to I2P!"));
            }
            try {
                this.addTorrent(name, null, !this.shouldAutoStart());
            }
            catch (RuntimeException e) {
                this.addMessage(this._t("Error: Could not add the torrent {0}", name) + ": " + e);
                this._log.error("Unable to add the torrent " + name, e);
                rv = false;
            }
        }
        existingNames.removeAll(this._magnets);
        for (String name : existingNames) {
            if (foundNames.contains(name)) continue;
            try {
                this.stopTorrent(name, true);
            }
            catch (RuntimeException runtimeException) {}
        }
        return rv;
    }

    private String _t(String s) {
        return this._util.getString(s);
    }

    private String _t(String s, Object o) {
        return this._util.getString(s, o);
    }

    private String _t(String s, Object o, Object o2) {
        return this._util.getString(s, o, o2);
    }

    public Map<String, Tracker> getTrackerMap() {
        return this._trackerMap;
    }

    public Collection<Tracker> getTrackers() {
        return this._trackerMap.values();
    }

    public List<Tracker> getSortedTrackers() {
        ArrayList<Tracker> rv = new ArrayList<Tracker>(this._trackerMap.values());
        Collections.sort(rv, new IgnoreCaseComparator());
        return rv;
    }

    private void initTrackerMap() {
        String trackers = this._config.getProperty(PROP_TRACKERS);
        if (trackers == null || trackers.trim().length() <= 0) {
            trackers = this._context.getProperty(PROP_TRACKERS);
        }
        if (trackers == null || trackers.trim().length() <= 0) {
            this.setDefaultTrackerMap(true);
        } else {
            String[] toks = DataHelper.split(trackers, ",");
            for (int i = 0; i < toks.length; i += 2) {
                String name = toks[i].trim().replace("&#44;", ",");
                String url = toks[i + 1].trim().replace("&#44;", ",");
                if (name.length() <= 0 || url.length() <= 0) continue;
                String[] urls = DataHelper.split(url, "=", 2);
                String url2 = urls.length > 1 ? urls[1] : "";
                this._trackerMap.put(name, new Tracker(name, urls[0], url2));
            }
        }
    }

    public void setDefaultTrackerMap() {
        this.setDefaultTrackerMap(true);
    }

    private void setDefaultTrackerMap(boolean save) {
        this._trackerMap.clear();
        for (int i = 0; i < DEFAULT_TRACKERS.length; i += 2) {
            String name = DEFAULT_TRACKERS[i];
            if (name.equals("TheBland") && !SigType.ECDSA_SHA256_P256.isAvailable()) continue;
            String[] urls = DataHelper.split(DEFAULT_TRACKERS[i + 1], "=", 2);
            String url2 = urls.length > 1 ? urls[1] : null;
            this._trackerMap.put(name, new Tracker(name, urls[0], url2));
        }
        if (save && this._config.remove(PROP_TRACKERS) != null) {
            this.saveConfig();
        }
    }

    public void saveTrackerMap() {
        StringBuilder buf = new StringBuilder(2048);
        boolean comma = false;
        for (Map.Entry<String, Tracker> e : this._trackerMap.entrySet()) {
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            Tracker t = e.getValue();
            buf.append(e.getKey().replace(",", "&#44;")).append(',').append(t.announceURL.replace(",", "&#44;"));
            if (t.baseURL == null) continue;
            buf.append('=').append(t.baseURL);
        }
        this._config.setProperty(PROP_TRACKERS, buf.toString());
        this.saveConfig();
    }

    public void startTorrent(byte[] infoHash) {
        for (Snark snark : this._snarks.values()) {
            if (!DataHelper.eq(infoHash, snark.getInfoHash())) continue;
            this.startTorrent(snark);
            return;
        }
        this.addMessage("Torrent not found?");
    }

    public void startTorrent(Snark snark) {
        if (snark.isStarting() || !snark.isStopped()) {
            this.addMessage("Torrent already started");
            return;
        }
        boolean connected = this._util.connected();
        if (!connected && !this._util.isConnecting()) {
            this.addMessage(this._t("Opening the I2P tunnel"));
        }
        this.addMessageNoEscape(this._t("Starting up torrent {0}", this.linkify(snark)));
        if (connected) {
            snark.startTorrent();
        } else {
            snark.setStarting();
            new I2PAppThread(new ThreadedStarter(snark), "TorrentStarter", true).start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void startAllTorrents() {
        if (this._util.connected()) {
            this.startAll();
        } else {
            this.addMessage(this._t("Opening the I2P tunnel and starting all torrents."));
            for (Snark snark : this._snarks.values()) {
                snark.setStarting();
            }
            new I2PAppThread(new ThreadedStarter(null), "TorrentStarterAll", true).start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void startAll() {
        for (Snark snark : this._snarks.values()) {
            if (!snark.isStopped()) continue;
            snark.startTorrent();
        }
    }

    public void stopAllTorrents(boolean finalShutdown) {
        this._stopping = true;
        if (finalShutdown && this._log.shouldLog(30)) {
            this._log.warn("SnarkManager final shutdown");
        }
        int count = 0;
        for (Snark snark : this._snarks.values()) {
            if (snark.isStopped()) continue;
            if (count == 0) {
                this.addMessage(this._t("Stopping all torrents and closing the I2P tunnel."));
            }
            ++count;
            if (finalShutdown) {
                snark.stopTorrent(true);
            } else {
                this.stopTorrent(snark, false);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._util.connected()) {
            if (count > 0) {
                DHT dht = this._util.getDHT();
                if (dht != null) {
                    dht.stop();
                }
                this._context.simpleTimer2().addEvent(new Disconnector(), 60000L);
                this.addMessage(this._t("Closing I2P tunnel after notifying trackers."));
                if (finalShutdown) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                this._util.disconnect();
                this._stopping = false;
                this.addMessage(this._t("I2P tunnel closed."));
            }
        }
    }

    public void recheckTorrent(Snark snark) {
        if (snark.isStarting() || !snark.isStopped()) {
            this.addMessage("Cannot check " + snark.getBaseName() + ", torrent already started");
            return;
        }
        Storage storage = snark.getStorage();
        if (storage == null) {
            this.addMessage("Cannot check " + snark.getBaseName() + ", no storage");
            return;
        }
        new I2PAppThread(new ThreadedRechecker(snark), "TorrentRechecker", true).start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        KNOWN_OPENTRACKERS = new HashSet<String>(Arrays.asList("tracker.welterde.i2p", "cfmqlafjfmgkzbt4r3jsfyhgsr5abgxryl6fnz3d3y5a365di5aa.b32.i2p", "opentracker.dg2.i2p", "w7tpbzncbcocrqtwwm3nezhnnsw4ozadvi2hmvzdhrqzfxfum7wa.b32.i2p", "tracker.thebland.i2p", "s5ikrdyjwbcgxmqetxb3nyheizftms7euacuub2hic7defkh3xhq.b32.i2p", "psi.i2p", "avviiexdngd32ccoy4kuckvc3mkf53ycvzbz6vz75vzhv4tbpk5a.b32.i2p", "opentracker.psi.i2p", "vmow3h54yljn7zvzbqepdddt5fmygijujycod2q6yznpy2rrzuwa.b32.i2p", "tracker.killyourtv.i2p", "5mpvzxfbd4rtped3c7ln4ddw52e7i7t56s36ztky4ustxtxrjdpa.b32.i2p", "opendiftracker.i2p", "bikpeyxci4zuyy36eau5ycw665dplun4yxamn7vmsastejdqtfoq.b32.i2p", "uajd4nctepxpac4c4bdyrdw7qvja2a5u3x25otfhkptcjgd53ioq.b32.i2p"));
        HashSet<String> ann = new HashSet<String>(8);
        for (int i = 1; i < DEFAULT_TRACKERS.length; i += 2) {
            if (DEFAULT_TRACKERS[i - 1].equals("TheBland") && !SigType.ECDSA_SHA256_P256.isAvailable()) continue;
            String[] urls = DataHelper.split(DEFAULT_TRACKERS[i], "=", 2);
            ann.add(urls[0]);
        }
        DEFAULT_TRACKER_ANNOUNCES = Collections.unmodifiableSet(ann);
    }

    private class DirMonitor
    implements Runnable {
        private DirMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delay = 60000L * (long)SnarkManager.this.getStartupDelayMinutes();
            if (delay > 0L && SnarkManager.this.shouldAutoStart()) {
                SnarkManager.this.addMessage(SnarkManager.this._t("Adding torrents in {0}", DataHelper.formatDuration2(delay)));
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (SnarkManager.this._messages.size() == 1) {
                    SnarkManager.this._messages.poll();
                }
            }
            SnarkManager.this.getBWLimit();
            boolean doMagnets = true;
            while (SnarkManager.this._running) {
                boolean ok;
                File dir = SnarkManager.this.getDataDir();
                if (SnarkManager.this._log.shouldLog(10)) {
                    SnarkManager.this._log.debug("Directory Monitor loop over " + dir.getAbsolutePath());
                }
                try {
                    Map map = SnarkManager.this._snarks;
                    synchronized (map) {
                        ok = SnarkManager.this.monitorTorrents(dir);
                    }
                }
                catch (RuntimeException e) {
                    SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                    ok = false;
                }
                if (doMagnets) {
                    try {
                        SnarkManager.this.addMagnets();
                        doMagnets = false;
                    }
                    catch (RuntimeException e) {
                        SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                    }
                    if (!SnarkManager.this._snarks.isEmpty()) {
                        SnarkManager.this.addMessage(SnarkManager.this._t("Up bandwidth limit is {0} KBps", SnarkManager.this._util.getMaxUpBW()));
                    }
                    if (ok) {
                        SnarkManager.this.cleanupTorrentStatus();
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private Disconnector() {
        }

        @Override
        public void timeReached() {
            if (SnarkManager.this._util.connected()) {
                SnarkManager.this._util.disconnect();
                SnarkManager.this._stopping = false;
                SnarkManager.this.addMessage(SnarkManager.this._t("I2P tunnel closed."));
            }
        }
    }

    private static class IgnoreCaseComparator
    implements Comparator<Tracker>,
    Serializable {
        private IgnoreCaseComparator() {
        }

        @Override
        public int compare(Tracker l, Tracker r) {
            return l.name.toLowerCase().compareTo(r.name.toLowerCase());
        }
    }

    private class Register
    implements SimpleTimer.TimedEvent {
        private Register() {
        }

        @Override
        public void timeReached() {
            if (!SnarkManager.this._running) {
                return;
            }
            ClientAppManager cmgr = SnarkManager.this._context.clientAppManager();
            if (cmgr != null) {
                SnarkManager.this._umgr = (UpdateManager)((Object)cmgr.getRegisteredApp("update"));
            }
            if (SnarkManager.this._umgr != null) {
                SnarkManager.this._uhandler = new UpdateHandler(SnarkManager.this._context, SnarkManager.this._umgr, SnarkManager.this);
                SnarkManager.this._umgr.register(SnarkManager.this._uhandler, UpdateType.ROUTER_SIGNED, UpdateMethod.TORRENT, 10);
                SnarkManager.this._umgr.register(SnarkManager.this._uhandler, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.TORRENT, 10);
                SnarkManager.this._log.warn("Registering with update manager");
            } else {
                SnarkManager.this._log.warn("No update manager to register with");
            }
        }
    }

    private static class TempDeleter
    implements Runnable {
        private final File file;

        public TempDeleter(File f) {
            this.file = f;
        }

        @Override
        public void run() {
            FileUtil.rmdir(this.file, false);
        }
    }

    private class ThreadedRechecker
    implements Runnable {
        private final Snark snark;

        public ThreadedRechecker(Snark s) {
            this.snark = s;
        }

        @Override
        public void run() {
            try {
                boolean changed;
                if (SnarkManager.this._log.shouldWarn()) {
                    SnarkManager.this._log.warn("Starting recheck of " + this.snark.getBaseName());
                }
                if (changed = this.snark.getStorage().recheck()) {
                    SnarkManager.this.updateStatus(this.snark);
                }
                if (SnarkManager.this._log.shouldWarn()) {
                    SnarkManager.this._log.warn("Finished recheck of " + this.snark.getBaseName() + " changed? " + changed);
                }
                String link = SnarkManager.this.linkify(this.snark);
                if (changed) {
                    int pieces = this.snark.getPieces();
                    double completion = (double)((long)pieces - this.snark.getNeeded()) / (double)pieces;
                    String complete = new DecimalFormat("0.00%").format(completion);
                    SnarkManager.this.addMessageNoEscape(SnarkManager.this._t("Finished recheck of torrent {0}, now {1} complete", link, complete));
                } else {
                    SnarkManager.this.addMessageNoEscape(SnarkManager.this._t("Finished recheck of torrent {0}, unchanged", link));
                }
            }
            catch (IOException e) {
                SnarkManager.this._log.error("Error rechecking " + this.snark.getBaseName(), e);
                SnarkManager.this.addMessage(SnarkManager.this._t("Error checking the torrent {0}", this.snark.getBaseName()) + ": " + e);
            }
        }
    }

    private class ThreadedStarter
    implements Runnable {
        private final Snark snark;

        public ThreadedStarter(Snark s) {
            this.snark = s;
        }

        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (RuntimeException e) {
                SnarkManager.this._log.error("Error starting", e);
            }
        }

        private void run2() {
            if (this.snark != null) {
                if (this.snark.isStopped()) {
                    this.snark.startTorrent();
                }
            } else {
                SnarkManager.this.startAll();
            }
        }
    }

    private static class TorrentFilenameFilter
    implements FilenameFilter {
        private static final TorrentFilenameFilter _filter = new TorrentFilenameFilter();

        private TorrentFilenameFilter() {
        }

        public static TorrentFilenameFilter instance() {
            return _filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".torrent");
        }
    }
}

