/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.apps.systray;

import java.lang.reflect.Method;
import net.i2p.util.SystemVersion;

public class SysTray {
    public static SysTray getInstance() {
        if (SystemVersion.isWindows() && !SystemVersion.is64Bit()) {
            return SysTray.getImpl();
        }
        return null;
    }

    private static SysTray getImpl() {
        try {
            Class<?> impl = Class.forName("net.i2p.apps.systray.SysTrayImpl", true, ClassLoader.getSystemClassLoader());
            Method getInstance = impl.getMethod("getInstance", new Class[0]);
            return (SysTray)getInstance.invoke(null, (Object[])null);
        }
        catch (Throwable t) {
            System.out.println("WARN: Unable to start systray");
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Thread t;
        SysTray impl = SysTray.getImpl();
        if (impl == null) {
            System.out.println("No systray implementation found");
            System.exit(1);
        }
        System.err.println("Hit ^C to exit");
        Thread thread = t = Thread.currentThread();
        synchronized (thread) {
            try {
                t.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

