/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.time;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.router.time.NtpClient;
import net.i2p.router.time.Zones;
import net.i2p.time.Timestamper;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class RouterTimestamper
extends Timestamper {
    private final I2PAppContext _context;
    private Log _log;
    private final List<String> _servers = new ArrayList<String>(3);
    private List<List<String>> _priorityServers;
    private final List<Timestamper.UpdateListener> _listeners = new CopyOnWriteArrayList<Timestamper.UpdateListener>();
    private int _queryFrequency;
    private int _concurringServers;
    private int _consecutiveFails;
    private volatile boolean _disabled;
    private final boolean _daemon;
    private volatile boolean _initialized;
    private boolean _wellSynced;
    private volatile boolean _isRunning;
    private Thread _timestamperThread;
    private final Zones _zones;
    private static final int MIN_QUERY_FREQUENCY = 300000;
    private static final int DEFAULT_QUERY_FREQUENCY = 660000;
    private static final String DEFAULT_SERVER_LIST = "0.pool.ntp.org,1.pool.ntp.org,2.pool.ntp.org";
    private static final boolean DEFAULT_DISABLED = true;
    private static final int DEFAULT_CONCURRING_SERVERS = 3;
    private static final int MAX_CONSECUTIVE_FAILS = 10;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int SHORT_TIMEOUT = 5000;
    private static final long MAX_WAIT_INITIALIZATION = 45000L;
    public static final String PROP_QUERY_FREQUENCY = "time.queryFrequencyMs";
    public static final String PROP_SERVER_LIST = "time.sntpServerList";
    public static final String PROP_DISABLED = "time.disabled";
    public static final String PROP_CONCURRING_SERVERS = "time.concurringServers";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";
    private static final int MAX_VARIANCE = 10000;

    public RouterTimestamper(I2PAppContext ctx) {
        this(ctx, null, true);
    }

    public RouterTimestamper(I2PAppContext ctx, Timestamper.UpdateListener lsnr) {
        this(ctx, lsnr, true);
    }

    public RouterTimestamper(I2PAppContext ctx, Timestamper.UpdateListener lsnr, boolean daemon) {
        this._context = ctx;
        this._daemon = daemon;
        this._disabled = ctx.getProperty(PROP_DISABLED, true);
        if (this._disabled) {
            this._initialized = true;
            this._zones = null;
            System.out.println("Warning: NTP is disabled");
            return;
        }
        if (lsnr != null) {
            this._listeners.add(lsnr);
        }
        this._zones = new Zones(ctx);
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerCount() {
        List<String> list = this._servers;
        synchronized (list) {
            return this._servers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServer(int index) {
        List<String> list = this._servers;
        synchronized (list) {
            return this._servers.get(index);
        }
    }

    public int getQueryFrequencyMs() {
        return this._queryFrequency;
    }

    public boolean getIsDisabled() {
        return this._disabled;
    }

    public void addListener(Timestamper.UpdateListener lsnr) {
        this._listeners.add(lsnr);
    }

    public void removeListener(Timestamper.UpdateListener lsnr) {
        this._listeners.remove(lsnr);
    }

    public int getListenerCount() {
        return this._listeners.size();
    }

    public Timestamper.UpdateListener getListener(int index) {
        return this._listeners.get(index);
    }

    public void startTimestamper() {
        if (this._disabled || this._initialized) {
            return;
        }
        this._timestamperThread = new I2PThread(this, "Timestamper", this._daemon);
        this._timestamperThread.setPriority(1);
        this._isRunning = true;
        this._timestamperThread.start();
        this._context.addShutdownTask(new Shutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForInitialization() {
        try {
            RouterTimestamper routerTimestamper = this;
            synchronized (routerTimestamper) {
                if (!this._initialized) {
                    this.wait(45000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void timestampNow() {
        if (this._initialized && this._isRunning && !this._disabled && this._timestamperThread != null) {
            this._timestamperThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean lastFailed = false;
        block16: while (true) {
            try {
                while (this._isRunning) {
                    long sleepTime;
                    boolean wasInitialized;
                    this.updateConfig();
                    if (!this._disabled) {
                        if (this._priorityServers != null) {
                            for (List<String> servers2 : this._priorityServers) {
                                if (this._log != null && this._log.shouldDebug()) {
                                    this._log.debug("Querying servers " + servers2);
                                }
                                try {
                                    lastFailed = !this.queryTime(servers2.toArray(new String[servers2.size()]), 5000);
                                }
                                catch (IllegalArgumentException iae) {
                                    if (!lastFailed && this._log != null && this._log.shouldWarn()) {
                                        this._log.warn("Unable to reach any regional NTP servers: " + servers2);
                                    }
                                    lastFailed = true;
                                }
                                if (lastFailed) continue;
                                break;
                            }
                        }
                        if (this._priorityServers == null || lastFailed) {
                            if (this._log != null && this._log.shouldDebug()) {
                                this._log.debug("Querying servers " + this._servers);
                            }
                            try {
                                lastFailed = !this.queryTime(this._servers.toArray(new String[this._servers.size()]), 10000);
                            }
                            catch (IllegalArgumentException iae) {
                                lastFailed = true;
                            }
                        }
                    }
                    RouterTimestamper servers2 = this;
                    synchronized (servers2) {
                        wasInitialized = this._initialized;
                        if (!wasInitialized) {
                            this._initialized = true;
                        }
                        this.notifyAll();
                    }
                    if (!wasInitialized) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException servers2) {
                            // empty catch block
                        }
                        this._log = this._context.logManager().getLog(RouterTimestamper.class);
                        if (lastFailed) {
                            ArrayList<String> all = new ArrayList<String>(9);
                            if (this._priorityServers != null) {
                                for (List<String> servers3 : this._priorityServers) {
                                    all.addAll(servers3);
                                }
                            }
                            all.addAll(this._servers);
                            String msg = "Unable to reach any of the NTP servers " + all + " - network disconnected? Or set time.sntpServerList=myserver1.com,myserver2.com in advanced configuration.";
                            this._log.logAlways(30, msg);
                            System.out.println("Warning: " + msg);
                        } else if (this._log.shouldDebug()) {
                            this._log.debug("NTP initialization successful");
                            int i = 1;
                            if (this._priorityServers != null) {
                                for (List<String> servers3 : this._priorityServers) {
                                    this._log.debug("NTP Server list " + i++ + ": " + servers3);
                                }
                            }
                            this._log.debug("NTP Server list " + i + ": " + this._servers);
                        }
                    }
                    if (lastFailed) {
                        sleepTime = ++this._consecutiveFails >= 10 ? 1800000L : 30000L;
                    } else {
                        this._consecutiveFails = 0;
                        sleepTime = this._context.random().nextInt(this._queryFrequency / 2) + this._queryFrequency;
                        if (this._wellSynced) {
                            sleepTime *= 3L;
                        }
                    }
                    try {
                        Thread.sleep(sleepTime);
                        continue block16;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Throwable t) {
                RouterTimestamper routerTimestamper = this;
                synchronized (routerTimestamper) {
                    this.notifyAll();
                }
                if (this._log != null) {
                    this._log.log(50, "Timestamper died!", t);
                }
                t.printStackTrace();
                break;
            }
        }
    }

    private boolean queryTime(String[] serverList, int perServerTimeout) throws IllegalArgumentException {
        long[] found = new long[this._concurringServers];
        long now = -1L;
        int stratum = -1;
        long expectedDelta = 0L;
        this._wellSynced = false;
        for (int i = 0; i < this._concurringServers; ++i) {
            long delta;
            long[] timeAndStratum = NtpClient.currentTimeAndStratum(serverList, perServerTimeout, this._log);
            now = timeAndStratum[0];
            stratum = (int)timeAndStratum[1];
            found[i] = delta = now - this._context.clock().now();
            if (i == 0) {
                if (Math.abs(delta) < 10000L) {
                    if (this._log != null && this._log.shouldInfo()) {
                        this._log.info("a single SNTP query was within the tolerance (" + delta + "ms)");
                    }
                    this._wellSynced = Math.abs(delta) < 500L;
                    break;
                }
                expectedDelta = delta;
                continue;
            }
            if (Math.abs(delta - expectedDelta) <= 10000L) continue;
            if (this._log != null && this._log.shouldError()) {
                StringBuilder err = new StringBuilder(96);
                err.append("SNTP client variance exceeded at query ").append(i);
                err.append(".  expected = ");
                err.append(expectedDelta);
                err.append(", found = ");
                err.append(delta);
                err.append(" all deltas: ");
                for (int j = 0; j < found.length; ++j) {
                    err.append(found[j]).append(' ');
                }
                this._log.error(err.toString());
            }
            return false;
        }
        this.stampTime(now, stratum);
        if (this._log != null && this._log.shouldDebug()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Deltas: ");
            for (int i = 0; i < found.length; ++i) {
                buf.append(found[i]).append(' ');
            }
            this._log.debug(buf.toString());
        }
        return true;
    }

    private void stampTime(long now, int stratum) {
        long before = this._context.clock().now();
        for (Timestamper.UpdateListener lsnr : this._listeners) {
            lsnr.setNow(now, stratum);
        }
        if (this._log != null && this._log.shouldDebug()) {
            this._log.debug("Stamped the time as " + now + " (delta=" + (now - before) + ")");
        }
    }

    private void updateConfig() {
        String serverList = this._context.getProperty(PROP_SERVER_LIST);
        if (serverList == null || serverList.trim().length() <= 0) {
            serverList = DEFAULT_SERVER_LIST;
            String country = this._context.getProperty(PROP_IP_COUNTRY);
            if (country == null && (country = Locale.getDefault().getCountry()) != null) {
                country = country.toLowerCase(Locale.US);
            }
            if (country != null && country.length() > 0 && !country.equals("a1") && !country.equals("a2")) {
                this._priorityServers = new ArrayList<List<String>>(2);
                ArrayList<String> p1 = new ArrayList<String>(3);
                for (int i = 0; i < 3; ++i) {
                    p1.add(i + "." + country + ".pool.ntp.org");
                }
                this._priorityServers.add(p1);
                String zone = this._zones.getZone(country);
                if (zone != null) {
                    ArrayList<String> p2 = new ArrayList<String>(3);
                    for (int i = 0; i < 3; ++i) {
                        p2.add(i + "." + zone + ".pool.ntp.org");
                    }
                    this._priorityServers.add(p2);
                }
            } else {
                this._priorityServers = null;
            }
        } else {
            this._priorityServers = null;
        }
        this._servers.clear();
        StringTokenizer tok = new StringTokenizer(serverList, ", ");
        while (tok.hasMoreTokens()) {
            String val = tok.nextToken();
            if ((val = val.trim()).length() <= 0) continue;
            this._servers.add(val);
        }
        this._queryFrequency = Math.max(300000, this._context.getProperty(PROP_QUERY_FREQUENCY, 660000));
        this._disabled = this._context.getProperty(PROP_DISABLED, true);
        this._concurringServers = Math.min(4, Math.max(1, this._context.getProperty(PROP_CONCURRING_SERVERS, 3)));
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            RouterTimestamper.this._isRunning = false;
            if (RouterTimestamper.this._timestamperThread != null) {
                RouterTimestamper.this._timestamperThread.interrupt();
            }
        }
    }
}

