/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.StoreMessageSelector;
import net.i2p.router.networkdb.kademlia.StoreState;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

class StoreJob
extends JobImpl {
    protected final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    protected final StoreState _state;
    private final Job _onSuccess;
    private final Job _onFailure;
    private final long _timeoutMs;
    private final long _expiration;
    private final PeerSelector _peerSelector;
    private static final int PARALLELIZATION = 4;
    private static final int REDUNDANCY = 4;
    private static final int STORE_PRIORITY = 460;
    private static final int MAX_PEERS_SENT = 10;
    private static final int MAX_DIRECT_EXPIRATION = 15000;
    private static final String MIN_ENCRYPTION_VERSION = "0.7.10";
    private static final String MIN_BIGLEASESET_VERSION = "0.9";

    public StoreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public StoreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs, Set<Hash> toSkip) {
        super(context);
        this._log = context.logManager().getLog(StoreJob.class);
        this._facade = facade;
        this._state = new StoreState(this.getContext(), key, data, toSkip);
        this._onSuccess = onSuccess;
        this._onFailure = onFailure;
        this._timeoutMs = timeoutMs;
        this._expiration = context.clock().now() + timeoutMs;
        this._peerSelector = facade.getPeerSelector();
    }

    @Override
    public String getName() {
        return "Kademlia NetDb Store";
    }

    @Override
    public void runJob() {
        this.sendNext();
    }

    private boolean isExpired() {
        return this.getContext().clock().now() >= this._expiration;
    }

    private void sendNext() {
        if (this._state.completed()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Already completed");
            }
            return;
        }
        if (this.isExpired()) {
            this._state.complete(true);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Expired: " + this._timeoutMs);
            }
            this.fail();
        } else if (this._state.getAttempted().size() > 10) {
            this._state.complete(true);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Max sent");
            }
            this.fail();
        } else {
            this.continueSending();
        }
    }

    protected int getParallelization() {
        return 4;
    }

    protected int getRedundancy() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void continueSending() {
        List<Hash> closestHashes;
        if (this._state.completed()) {
            return;
        }
        int toCheck = this.getParallelization() - this._state.getPending().size();
        if (toCheck <= 0) {
            if (!this._log.shouldLog(10)) return;
            this._log.debug(this.getJobId() + ": Too many store messages pending");
            return;
        }
        if (toCheck > this.getParallelization()) {
            toCheck = this.getParallelization();
        }
        if ((closestHashes = this.getClosestFloodfillRouters(this._state.getTarget(), toCheck, this._state.getAttempted())) == null || closestHashes.isEmpty()) {
            if (!this._state.getPending().isEmpty()) {
                if (!this._log.shouldLog(20)) return;
                this._log.info(this.getJobId() + ": No more peers left but some are pending, so keep waiting");
                return;
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": No more peers left and none pending");
            }
            this.fail();
            return;
        }
        int queued = 0;
        int skipped = 0;
        for (Hash peer : closestHashes) {
            DatabaseEntry ds = this._facade.getDataStore().get(peer);
            if (ds == null || ds.getType() != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Error selecting closest hash that wasnt a router! " + peer + " : " + ds);
                }
                this._state.addSkipped(peer);
                ++skipped;
                continue;
            }
            if (this._state.getData().getType() == 1 && !StoreJob.supportsCert((RouterInfo)ds, ((LeaseSet)this._state.getData()).getDestination().getCertificate())) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Skipping router that doesn't support key certs " + peer);
                }
                this._state.addSkipped(peer);
                ++skipped;
                continue;
            }
            if (this._state.getData().getType() == 1 && ((LeaseSet)this._state.getData()).getLeaseCount() > 6 && !StoreJob.supportsBigLeaseSets((RouterInfo)ds)) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Skipping router that doesn't support big leasesets " + peer);
                }
                this._state.addSkipped(peer);
                ++skipped;
                continue;
            }
            int peerTimeout = this._facade.getPeerTimeout(peer);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Continue sending key " + this._state.getTarget() + " after " + this._state.getAttempted().size() + " tries to " + closestHashes);
            }
            this._state.addPending(peer);
            this.sendStore((RouterInfo)ds, peerTimeout);
            ++queued;
        }
        if (queued != 0) return;
        if (!this._state.getPending().isEmpty()) return;
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": No more peers left after skipping " + skipped + " and none pending");
        }
        this.getContext().jobQueue().addJob(new WaitJob(this.getContext()));
    }

    private List<Hash> getClosestFloodfillRouters(Hash key, int numClosest, Set<Hash> alreadyChecked) {
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(key);
        KBucketSet<Hash> ks = this._facade.getKBuckets();
        if (ks == null) {
            return new ArrayList<Hash>();
        }
        return ((FloodfillPeerSelector)this._peerSelector).selectFloodfillParticipants(rkey, numClosest, alreadyChecked, ks);
    }

    private void sendStore(RouterInfo router, int responseTime) {
        if (!this._state.getTarget().equals(this._state.getData().getHash())) {
            this._log.error("Hash mismatch StoreJob");
            return;
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        if (this._state.getData().getType() == 0) {
            if (responseTime > 15000) {
                responseTime = 15000;
            }
        } else if (this._state.getData().getType() != 1) {
            throw new IllegalArgumentException("Storing an unknown data type! " + this._state.getData());
        }
        msg.setEntry(this._state.getData());
        long now = this.getContext().clock().now();
        msg.setMessageExpiration(now + this._timeoutMs);
        if (router.getIdentity().equals(this.getContext().router().getRouterInfo().getIdentity())) {
            if (this._log.shouldLog(40)) {
                this._log.error(this.getJobId() + ": Dont send store to ourselves - why did we try?");
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": Send store timeout is " + responseTime);
        }
        this.sendStore(msg, router, now + (long)responseTime);
    }

    private void sendStore(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        if (msg.getEntry().getType() == 1) {
            this.getContext().statManager().addRateData("netDb.storeLeaseSetSent", 1L);
            if (this.getContext().keyRing().get(msg.getKey()) != null) {
                this.sendStoreThroughGarlic(msg, peer, expiration);
            } else {
                this.sendStoreThroughClient(msg, peer, expiration);
            }
        } else {
            this.getContext().statManager().addRateData("netDb.storeRouterInfoSent", 1L);
            this.sendDirect(msg, peer, expiration);
        }
    }

    private void sendDirect(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        long token = 1L + this.getContext().random().nextLong(0xFFFFFFFFL);
        msg.setReplyToken(token);
        msg.setReplyGateway(this.getContext().routerHash());
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + token);
        }
        this._state.addPending(peer.getIdentity().getHash());
        SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer);
        FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
        StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, token, expiration);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending store directly to " + peer.getIdentity().getHash());
        }
        OutNetMessage m = new OutNetMessage(this.getContext(), msg, expiration, 460, peer);
        m.setOnFailedReplyJob(onFail);
        m.setOnFailedSendJob(onFail);
        m.setOnReplyJob(onReply);
        m.setReplySelector(selector);
        this.getContext().messageRegistry().registerPending(m);
        this.getContext().commSystem().processMessage(m);
    }

    private void sendStoreThroughGarlic(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        long token = 1L + this.getContext().random().nextLong(0xFFFFFFFFL);
        Hash to = peer.getIdentity().getHash();
        TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundExploratoryTunnel(to);
        if (replyTunnel == null) {
            this._log.warn("No reply inbound tunnels available!");
            return;
        }
        TunnelId replyTunnelId = replyTunnel.getReceiveTunnelId(0);
        msg.setReplyToken(token);
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyTunnel.getPeer(0));
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + token);
        }
        this._state.addPending(to);
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(to);
        if (outTunnel != null) {
            SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer, outTunnel, msg.getMessageSize());
            FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, token, expiration);
            if (this._log.shouldLog(10)) {
                this._log.debug("sending store to " + peer.getIdentity().getHash() + " through " + outTunnel + ": " + msg);
            }
            this.getContext().messageRegistry().registerPending(selector, onReply, onFail);
            this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnel.getSendTunnelId(0), null, to);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to send a dbStore out!");
            }
            this.fail();
        }
    }

    private void sendStoreThroughClient(DatabaseStoreMessage msg, RouterInfo peer, long expiration) {
        TunnelInfo outTunnel;
        long token = 1L + this.getContext().random().nextLong(0xFFFFFFFFL);
        Hash client = msg.getKey();
        Hash to = peer.getIdentity().getHash();
        TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel(client, to);
        if (replyTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No reply inbound tunnels available!");
            }
            this.fail();
            return;
        }
        TunnelId replyTunnelId = replyTunnel.getReceiveTunnelId(0);
        msg.setReplyToken(token);
        msg.setReplyTunnel(replyTunnelId);
        msg.setReplyGateway(replyTunnel.getPeer(0));
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": send(dbStore) w/ token expected " + token);
        }
        if ((outTunnel = this.getContext().tunnelManager().selectOutboundTunnel(client, to)) != null) {
            MessageWrapper.WrappedMessage wm;
            boolean shouldEncrypt = StoreJob.supportsEncryption(peer);
            if (shouldEncrypt) {
                wm = MessageWrapper.wrap(this.getContext(), (I2NPMessage)msg, client, peer);
                if (wm == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Fail garlic encrypting from: " + client);
                    }
                    this.fail();
                    return;
                }
            } else {
                this._state.addPending(to);
                this._state.replyTimeout(to);
                this.getContext().jobQueue().addJob(new WaitJob(this.getContext()));
                return;
            }
            GarlicMessage sent = wm.getMessage();
            this._state.addPending(to, wm);
            SendSuccessJob onReply = new SendSuccessJob(this.getContext(), peer, outTunnel, sent.getMessageSize());
            FailedJob onFail = new FailedJob(this.getContext(), peer, this.getContext().clock().now());
            StoreMessageSelector selector = new StoreMessageSelector(this.getContext(), this.getJobId(), peer, token, expiration);
            if (this._log.shouldLog(10)) {
                if (shouldEncrypt) {
                    this._log.debug("sending encrypted store to " + peer.getIdentity().getHash() + " through " + outTunnel + ": " + sent);
                } else {
                    this._log.debug("sending store to " + peer.getIdentity().getHash() + " through " + outTunnel + ": " + sent);
                }
            }
            this.getContext().messageRegistry().registerPending(selector, onReply, onFail);
            this.getContext().tunnelDispatcher().dispatchOutbound(sent, outTunnel.getSendTunnelId(0), null, to);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("No outbound tunnels to send a dbStore out - delaying...");
            }
            this._state.replyTimeout(to);
            WaitJob waiter = new WaitJob(this.getContext());
            waiter.getTiming().setStartAfter(this.getContext().clock().now() + 3000L);
            this.getContext().jobQueue().addJob(waiter);
        }
    }

    private static boolean supportsEncryption(RouterInfo ri) {
        String v = ri.getVersion();
        return VersionComparator.comp(v, MIN_ENCRYPTION_VERSION) >= 0;
    }

    public static boolean supportsCert(RouterInfo ri, Certificate cert) {
        String since;
        SigType type;
        if (cert.getCertificateType() != 5) {
            return true;
        }
        try {
            type = cert.toKeyCertificate().getSigType();
        }
        catch (DataFormatException dfe) {
            return false;
        }
        if (type == null) {
            return false;
        }
        String v = ri.getVersion();
        return VersionComparator.comp(v, since = type.getSupportedSince()) >= 0;
    }

    public static boolean supportsBigLeaseSets(RouterInfo ri) {
        String v = ri.getVersion();
        return VersionComparator.comp(v, MIN_BIGLEASESET_VERSION) >= 0;
    }

    protected void succeed() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Succeeded sending key " + this._state.getTarget());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": State of successful send: " + this._state);
        }
        if (this._onSuccess != null) {
            this.getContext().jobQueue().addJob(this._onSuccess);
        }
        this._state.complete(true);
        this.getContext().statManager().addRateData("netDb.storePeers", this._state.getAttempted().size(), this._state.getWhenCompleted() - this._state.getWhenStarted());
    }

    protected void fail() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Failed sending key " + this._state.getTarget());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": State of failed send: " + this._state, new Exception("Who failed me?"));
        }
        if (this._onFailure != null) {
            this.getContext().jobQueue().addJob(this._onFailure);
        }
        this._state.complete(true);
        this.getContext().statManager().addRateData("netDb.storeFailedPeers", this._state.getAttempted().size(), this._state.getWhenCompleted() - this._state.getWhenStarted());
    }

    private class FailedJob
    extends JobImpl {
        private final RouterInfo _peer;
        private final long _sendOn;

        public FailedJob(RouterContext enclosingContext, RouterInfo peer, long sendOn) {
            super(enclosingContext);
            this._peer = peer;
            this._sendOn = sendOn;
        }

        @Override
        public void runJob() {
            MessageWrapper.WrappedMessage wm;
            Hash hash = this._peer.getIdentity().getHash();
            if (StoreJob.this._log.shouldLog(20)) {
                StoreJob.this._log.info(StoreJob.this.getJobId() + ": Peer " + hash.toBase64() + " timed out sending " + StoreJob.this._state.getTarget());
            }
            if ((wm = StoreJob.this._state.getPendingMessage(hash)) != null) {
                wm.fail();
            }
            StoreJob.this._state.replyTimeout(hash);
            this.getContext().profileManager().dbStoreFailed(hash);
            this.getContext().statManager().addRateData("netDb.replyTimeout", this.getContext().clock().now() - this._sendOn);
            StoreJob.this.sendNext();
        }

        @Override
        public String getName() {
            return "Kademlia Store Send Failed";
        }
    }

    private class SendSuccessJob
    extends JobImpl
    implements ReplyJob {
        private final RouterInfo _peer;
        private final TunnelInfo _sendThrough;
        private final int _msgSize;

        public SendSuccessJob(RouterContext enclosingContext, RouterInfo peer) {
            this(enclosingContext, peer, null, 0);
        }

        public SendSuccessJob(RouterContext enclosingContext, RouterInfo peer, TunnelInfo sendThrough, int size) {
            super(enclosingContext);
            this._peer = peer;
            this._sendThrough = sendThrough;
            this._msgSize = size <= 0 ? 0 : (size + 1023) / 1024 * 1024;
        }

        @Override
        public String getName() {
            return "Kademlia Store Send Success";
        }

        @Override
        public void runJob() {
            Hash hash = this._peer.getIdentity().getHash();
            MessageWrapper.WrappedMessage wm = StoreJob.this._state.getPendingMessage(hash);
            if (wm != null) {
                wm.acked();
            }
            long howLong = StoreJob.this._state.confirmed(hash);
            if (StoreJob.this._log.shouldLog(20)) {
                StoreJob.this._log.info(StoreJob.this.getJobId() + ": Marking store of " + StoreJob.this._state.getTarget() + " to " + hash.toBase64() + " successful after " + howLong);
            }
            this.getContext().profileManager().dbStoreSent(hash, howLong);
            this.getContext().statManager().addRateData("netDb.ackTime", howLong, howLong);
            if (this._sendThrough != null && this._msgSize > 0) {
                if (StoreJob.this._log.shouldLog(20)) {
                    StoreJob.this._log.info("sent a " + this._msgSize + " byte netDb message through tunnel " + this._sendThrough + " after " + howLong);
                }
                for (int i = 0; i < this._sendThrough.getLength(); ++i) {
                    this.getContext().profileManager().tunnelDataPushed(this._sendThrough.getPeer(i), howLong, this._msgSize);
                }
                this._sendThrough.incrementVerifiedBytesTransferred(this._msgSize);
            }
            if (this._sendThrough == null) {
                this.getContext().commSystem().mayDisconnect(this._peer.getHash());
            }
            if (StoreJob.this._state.getCompleteCount() >= StoreJob.this.getRedundancy()) {
                StoreJob.this.succeed();
            } else {
                StoreJob.this.sendNext();
            }
        }

        @Override
        public void setMessage(I2NPMessage message) {
        }
    }

    private class WaitJob
    extends JobImpl {
        public WaitJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        @Override
        public void runJob() {
            StoreJob.this.sendNext();
        }

        @Override
        public String getName() {
            return "Kademlia Store Send Delay";
        }
    }
}

