/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class SummaryRenderer {
    private final Log _log;
    private final SummaryListener _listener;
    private final I2PAppContext _context;
    private static final Color RESTART_BAR_COLOR = new Color(255, 144, 0, 224);
    private static final boolean IS_WIN = SystemVersion.isWindows();

    public SummaryRenderer(I2PAppContext ctx, SummaryListener lsnr) {
        this._log = ctx.logManager().getLog(SummaryRenderer.class);
        this._listener = lsnr;
        this._context = ctx;
    }

    @Deprecated
    public static synchronized void render(I2PAppContext ctx, OutputStream out, String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void render(OutputStream out) throws IOException {
        this.render(out, 250, 100, false, false, false, false, -1, 0, false);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit) throws IOException {
        this.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, endp, showCredit, null, null);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit, SummaryListener lsnr2, String titleOverride) throws IOException {
        long end = Math.min(this._listener.now(), System.currentTimeMillis()) - 75000L;
        long period = this._listener.getRate().getPeriod();
        if (endp > 0) {
            end -= period * (long)endp;
        }
        if (periodCount <= 0 || periodCount > this._listener.getRows()) {
            periodCount = this._listener.getRows();
        }
        long start = end - period * (long)periodCount;
        ImageInputStream ios = null;
        try {
            RrdGraph graph;
            RrdGraphDef def = new RrdGraphDef();
            String lang = Messages.getLanguage(this._context);
            Font small = def.getSmallFont();
            Font large = def.getLargeFont();
            if ("ar".equals(lang) || "jp".equals(lang) || "zh".equals(lang) && !IS_WIN) {
                small = small.deriveFont(small.getSize2D() + 2.0f);
                large = large.deriveFont(0, large.getSize2D() + 3.0f);
            } else {
                small = small.deriveFont(small.getSize2D() + 1.0f);
                large = large.deriveFont(large.getSize2D() + 1.0f);
            }
            def.setSmallFont(small);
            def.setLargeFont(large);
            def.setTimeSpan(start / 1000L, end / 1000L);
            def.setMinValue(0.0);
            String name = this._listener.getRate().getRateStat().getName();
            if ((name.startsWith("bw.") || name.indexOf("Size") >= 0 || name.indexOf("Bps") >= 0 || name.indexOf("memory") >= 0) && !showEvents) {
                def.setBase(1024.0);
            }
            if (titleOverride != null) {
                def.setTitle(titleOverride);
            } else if (!hideTitle) {
                String p = IS_WIN && "zh".equals(Messages.getLanguage(this._context)) ? DataHelper.formatDuration(period) : DataHelper.formatDuration2(period).replace("&nbsp;", " ");
                String title = showEvents ? name + ' ' + this._t("events in {0}", p) : name + ' ' + this._t("averaged for {0}", p);
                def.setTitle(title);
            }
            String path = this._listener.getData().getPath();
            String[] dsNames = this._listener.getData().getDsNames();
            String plotName = null;
            String descr = null;
            if (showEvents) {
                plotName = dsNames[1];
                descr = this._t("Events per period");
            } else {
                plotName = dsNames[0];
                descr = this._t(this._listener.getRate().getRateStat().getDescription());
            }
            def.datasource(plotName, path, plotName, "AVERAGE", this._listener.getBackendName());
            if (descr.length() > 0) {
                def.area(plotName, Color.BLUE, descr + "\\r");
            } else {
                def.area(plotName, Color.BLUE);
            }
            if (!hideLegend) {
                def.gprint(plotName, "AVERAGE", this._t("avg") + ": %.2f %s");
                def.gprint(plotName, "MAX", ' ' + this._t("max") + ": %.2f %S");
                def.gprint(plotName, "LAST", ' ' + this._t("now") + ": %.2f %S\\r");
            }
            String plotName2 = null;
            if (lsnr2 != null) {
                String[] dsNames2 = lsnr2.getData().getDsNames();
                plotName2 = dsNames2[0];
                String path2 = lsnr2.getData().getPath();
                String descr2 = this._t(lsnr2.getRate().getRateStat().getDescription());
                def.datasource(plotName2, path2, plotName2, "AVERAGE", lsnr2.getBackendName());
                def.line(plotName2, Color.RED, descr2 + "\\r", 3.0f);
                if (!hideLegend) {
                    def.gprint(plotName2, "AVERAGE", this._t("avg") + ": %.2f %s");
                    def.gprint(plotName2, "MAX", ' ' + this._t("max") + ": %.2f %S");
                    def.gprint(plotName2, "LAST", ' ' + this._t("now") + ": %.2f %S\\r");
                }
            }
            if (!hideLegend) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM HH:mm");
                SortedMap<Long, String> events = ((RouterContext)this._context).router().eventLog().getEvents("started", start);
                for (Map.Entry event : events.entrySet()) {
                    long started = (Long)event.getKey();
                    if (started <= start || started >= end) continue;
                    String legend = this._t("Restart") + ' ' + sdf.format(new Date(started)) + " UTC " + (String)event.getValue() + "\\r";
                    def.vrule(started / 1000L, RESTART_BAR_COLOR, legend, 4.0f);
                }
                def.comment(sdf.format(new Date(start)) + " -- " + sdf.format(new Date(end)) + " UTC\\r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setNoLegend(true);
            }
            if (hideGrid) {
                def.setDrawXGrid(false);
                def.setDrawYGrid(false);
            }
            def.setAntiAliasing(false);
            def.setWidth(width);
            def.setHeight(height);
            def.setImageFormat("PNG");
            def.setLazy(true);
            try {
                graph = new RrdGraph(def);
            }
            catch (NullPointerException npe) {
                this._log.error("Error rendering", npe);
                StatSummarizer.setDisabled();
                throw new IOException("Error rendering - disabling graph generation. Missing font? See http://trac.i2p2.i2p/ticket/915");
            }
            int totalWidth = graph.getRrdGraphInfo().getWidth();
            int totalHeight = graph.getRrdGraphInfo().getHeight();
            BufferedImage img = new BufferedImage(totalWidth, totalHeight, 8);
            Graphics gfx = img.getGraphics();
            graph.render(gfx);
            ios = new MemoryCacheImageOutputStream(out);
            ImageIO.write((RenderedImage)img, "png", (ImageOutputStream)ios);
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error rendering", ioe);
            }
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getMessage());
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String _t(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    private String _t(String s, String o) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s.replace("{0}", o);
        }
        return Messages.getString(s, o, this._context);
    }
}

