/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.SendMessageStatusListener;
import net.i2p.client.impl.I2PClientMessageHandlerMap;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.MessageState;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2cp.MessageId;
import net.i2p.util.SimpleTimer2;

class I2PSessionImpl2
extends I2PSessionImpl {
    protected final Map<Long, MessageState> _sendingStates;
    protected final AtomicLong _sendMessageNonce;
    private static final long SEND_TIMEOUT = 60000L;
    private static final boolean SHOULD_COMPRESS = true;
    private static final boolean SHOULD_DECOMPRESS = true;
    protected boolean _noEffort;
    private static final long REMOVE_EXPIRED_TIME = 63000L;
    private static final int DONT_COMPRESS_SIZE = 66;

    protected I2PSessionImpl2(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap) {
        super(context, options, handlerMap);
        this._sendingStates = null;
        this._sendMessageNonce = null;
    }

    protected I2PSessionImpl2(I2PAppContext ctx, InputStream destKeyStream, Properties options) throws I2PSessionException {
        super(ctx, destKeyStream, options);
        this._sendingStates = new ConcurrentHashMap<Long, MessageState>(32);
        this._sendMessageNonce = new AtomicLong();
        this._noEffort = "none".equals(this.getOptions().getProperty("i2cp.messageReliability", "").toLowerCase(Locale.US));
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.1", "How long it took to get status=1 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.4", "How long it took to get status=4 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.5", "How long it took to get status=5 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.tx.msgCompressed", "compressed size transferred", "i2cp", new long[]{1800000L});
        this._context.statManager().createRateStat("i2cp.tx.msgExpanded", "size before compression", "i2cp", new long[]{1800000L});
    }

    protected I2PSessionImpl2(I2PSessionImpl primary, InputStream destKeyStream, Properties options) throws I2PSessionException {
        super(primary, destKeyStream, options);
        this._sendingStates = new ConcurrentHashMap<Long, MessageState>(32);
        this._sendMessageNonce = new AtomicLong();
        this._noEffort = "none".equals(this.getOptions().getProperty("i2cp.messageReliability", "").toLowerCase(Locale.US));
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.1", "How long it took to get status=1 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.4", "How long it took to get status=4 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.5", "How long it took to get status=5 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.tx.msgCompressed", "compressed size transferred", "i2cp", new long[]{1800000L});
        this._context.statManager().createRateStat("i2cp.tx.msgExpanded", "size before compression", "i2cp", new long[]{1800000L});
    }

    @Override
    protected void startVerifyUsage() {
        super.startVerifyUsage();
        new RemoveExpired();
    }

    protected long getTimeout() {
        return 60000L;
    }

    @Override
    public void destroySession(boolean sendDisconnect) {
        this.clearStates();
        super.destroySession(sendDisconnect);
    }

    protected boolean shouldCompress(int size) {
        if (size <= 66) {
            return false;
        }
        String p = this.getOptions().getProperty("i2cp.gzip");
        if (p != null) {
            return Boolean.parseBoolean(p);
        }
        return true;
    }

    @Override
    public void addSessionListener(I2PSessionListener lsnr, int proto, int port) {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public void addMuxedSessionListener(I2PSessionMuxedListener l, int proto, int port) {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public void removeListener(int proto, int port) {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int proto, int fromport, int toport) throws I2PSessionException {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set<SessionTag> tagsSent, int proto, int fromport, int toport) throws I2PSessionException {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set<SessionTag> tagsSent, long expire, int proto, int fromport, int toport) throws I2PSessionException {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set<SessionTag> tagsSent, long expire, int proto, int fromport, int toport, int flags) throws I2PSessionException {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, int proto, int fromport, int toport, SendMessageOptions options) throws I2PSessionException {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public long sendMessage(Destination dest, byte[] payload, int offset, int size, int proto, int fromport, int toport, SendMessageOptions options, SendMessageStatusListener listener) throws I2PSessionException {
        throw new UnsupportedOperationException("Use MuxedImpl");
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload) throws I2PSessionException {
        return this.sendMessage(dest, payload, 0, payload.length);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, null, null, 0L);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, SessionKey keyUsed, Set<SessionTag> tagsSent) throws I2PSessionException {
        return this.sendMessage(dest, payload, 0, payload.length, keyUsed, tagsSent, 0L);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set<SessionTag> tagsSent) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, keyUsed, tagsSent, 0L);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set<SessionTag> tagsSent, long expires) throws I2PSessionException {
        if (this._log.shouldLog(10)) {
            this._log.debug("sending message");
        }
        this.verifyOpen();
        this.updateActivity();
        boolean sc = this.shouldCompress(size);
        payload = sc ? DataHelper.compress(payload, offset, size) : DataHelper.compress(payload, offset, size, 0);
        int compressed = payload.length;
        if (this._log.shouldLog(20)) {
            String d = dest.calculateHash().toBase64().substring(0, 4);
            this._log.info("sending message to: " + d + " compress? " + sc + " sizeIn=" + size + " sizeOut=" + compressed);
        }
        this._context.statManager().addRateData("i2cp.tx.msgCompressed", compressed);
        this._context.statManager().addRateData("i2cp.tx.msgExpanded", size);
        if (this._noEffort) {
            return this.sendNoEffort(dest, payload, expires, 0);
        }
        return this.sendBestEffort(dest, payload, keyUsed, tagsSent, expires);
    }

    @Override
    public byte[] receiveMessage(int msgId) throws I2PSessionException {
        byte[] compressed = super.receiveMessage(msgId);
        if (compressed == null) {
            this._log.error("Error: message " + msgId + " already received!");
            return null;
        }
        try {
            return DataHelper.decompress(compressed);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error decompressing message", ioe);
        }
    }

    protected boolean sendBestEffort(Destination dest, byte[] payload, SessionKey keyUsed, Set<SessionTag> tagsSent, long expires) throws I2PSessionException {
        return this.sendBestEffort(dest, payload, expires, 0);
    }

    protected boolean sendBestEffort(Destination dest, byte[] payload, long expires, int flags) throws I2PSessionException {
        boolean found;
        long nonce = this._sendMessageNonce.incrementAndGet();
        MessageState state = new MessageState(this._context, nonce, this.getPrefix());
        boolean actuallyWait = false;
        if (actuallyWait) {
            this._sendingStates.put(nonce, state);
        }
        this._producer.sendMessage(this, dest, nonce, payload, expires, flags);
        if (actuallyWait) {
            try {
                state.waitForAccept(this._context.clock().now() + this.getTimeout());
            }
            catch (InterruptedException ie) {
                throw new I2PSessionException("interrupted");
            }
            finally {
                this._sendingStates.remove(nonce);
            }
        }
        boolean bl = found = !actuallyWait || state.wasAccepted();
        if (found) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Message sent after " + state.getElapsed() + "ms with " + payload.length + " bytes");
            }
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Message send failed after " + state.getElapsed() + "ms with " + payload.length + " bytes");
            }
            return false;
        }
        return found;
    }

    protected boolean sendNoEffort(Destination dest, byte[] payload, long expires, int flags) throws I2PSessionException {
        this._producer.sendMessage(this, dest, 0L, payload, expires, flags);
        return true;
    }

    @Override
    public void receiveStatus(int msgId, long nonce, int status) {
        MessageState state;
        block15: {
            block14: {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "Received status " + status + " for msgId " + msgId + " / " + nonce);
                }
                state = null;
                state = this._sendingStates.get(nonce);
                if (state == null) break block14;
                if (!this._log.shouldLog(10)) break block15;
                this._log.debug(this.getPrefix() + "Found a matching state");
                break block15;
            }
            if (!this._sendingStates.isEmpty()) {
                for (MessageState s : this._sendingStates.values()) {
                    if (s.getMessageId() == null || s.getMessageId().getMessageId() != (long)msgId) continue;
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.getPrefix() + "Found a matching state by msgId");
                    }
                    state = s;
                    break;
                }
            }
        }
        if (state != null) {
            if (state.getMessageId() == null) {
                MessageId id = new MessageId();
                id.setMessageId(msgId);
                state.setMessageId(id);
            }
            state.receive(status);
            if (state.wasSuccessful()) {
                this._sendingStates.remove(nonce);
            }
            long lifetime = state.getElapsed();
            switch (status) {
                case 1: {
                    this._context.statManager().addRateData("i2cp.receiveStatusTime.1", lifetime);
                    break;
                }
                case 4: {
                    this._context.statManager().addRateData("i2cp.receiveStatusTime.4", lifetime);
                    break;
                }
                case 5: {
                    this._context.statManager().addRateData("i2cp.receiveStatusTime.5", lifetime);
                }
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "No matching state for messageId " + msgId + " / " + nonce + " w/ status = " + status);
        }
    }

    @Override
    protected boolean reconnect() {
        this.clearStates();
        return super.reconnect();
    }

    private void clearStates() {
        if (this._sendingStates == null) {
            return;
        }
        for (MessageState state : this._sendingStates.values()) {
            state.cancel();
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Disconnecting " + this._sendingStates.size() + " states");
        }
        this._sendingStates.clear();
    }

    private class RemoveExpired
    extends SimpleTimer2.TimedEvent {
        public RemoveExpired() {
            super(I2PSessionImpl2.this._context.simpleTimer2(), 63000L);
        }

        @Override
        public void timeReached() {
            if (I2PSessionImpl2.this.isClosed()) {
                return;
            }
            if (!I2PSessionImpl2.this._sendingStates.isEmpty()) {
                long now = I2PSessionImpl2.this._context.clock().now();
                Iterator<MessageState> iter = I2PSessionImpl2.this._sendingStates.values().iterator();
                while (iter.hasNext()) {
                    MessageState state = iter.next();
                    if (state.getExpires() >= now) continue;
                    iter.remove();
                }
            }
            this.schedule(63000L);
        }
    }
}

