/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.apps.systray.SysTray;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.data.DataHelper;
import net.i2p.desktopgui.Main;
import net.i2p.jetty.I2PLogger;
import net.i2p.router.RouterContext;
import net.i2p.router.app.RouterApp;
import net.i2p.router.news.NewsManager;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.LocaleWebAppHandler;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.PluginStopper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.Addresses;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.PortMapper;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SystemVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.tanukisoftware.wrapper.WrapperManager;

public class RouterConsoleRunner
implements RouterApp {
    private final RouterContext _context;
    private final ClientAppManager _mgr;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private static Server _server;
    private String _listenPort;
    private String _listenHost;
    private String _sslListenPort;
    private String _sslListenHost;
    private String _webAppsDir;
    private static final String DEFAULT_WEBAPP_CONFIG_FILENAME = "webapps.config";
    private static final DigestAuthenticator authenticator;
    public static final String JETTY_REALM = "i2prouter";
    private static final String JETTY_ROLE = "routerAdmin";
    public static final String PROP_CONSOLE_PW = "routerconsole.auth.i2prouter";
    public static final String PROP_PW_ENABLE = "routerconsole.auth.enable";
    public static final String ROUTERCONSOLE = "routerconsole";
    public static final String PREFIX = "webapps.";
    public static final String ENABLED = ".startOnLoad";
    private static final String PROP_KEYSTORE_PASSWORD = "routerconsole.keystorePassword";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String PROP_KEY_PASSWORD = "routerconsole.keyPassword";
    public static final int DEFAULT_LISTEN_PORT = 7657;
    private static final String DEFAULT_LISTEN_HOST = "127.0.0.1";
    private static final String DEFAULT_WEBAPPS_DIR = "./webapps/";
    private static final String USAGE = "Bad RouterConsoleRunner arguments, check clientApp.0.args in your clients.config file! Usage: [[port host[,host]] [-s sslPort [host[,host]]] [webAppsDir]]";
    private static final int MIN_THREADS = 1;
    private static final int MAX_THREADS = 24;
    private static final int MAX_IDLE_TIME = 90000;
    private static final String THREAD_NAME = "RouterConsole Jetty";
    public static final String DAEMON_USER = "i2psvc";
    public static final String PROP_DTG_ENABLED = "desktopgui.enabled";

    public RouterConsoleRunner(RouterContext ctx, ClientAppManager mgr, String[] args) {
        this._context = ctx;
        this._mgr = mgr;
        if (args.length == 0) {
            this._listenPort = Integer.toString(7657);
        } else {
            boolean ssl = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-s")) {
                    ssl = true;
                    continue;
                }
                if (!ssl && this._listenPort == null) {
                    this._listenPort = args[i];
                    continue;
                }
                if (!ssl && this._listenHost == null) {
                    this._listenHost = args[i];
                    continue;
                }
                if (ssl && this._sslListenPort == null) {
                    this._sslListenPort = args[i];
                    continue;
                }
                if (ssl && this._sslListenHost == null) {
                    this._sslListenHost = args[i];
                    continue;
                }
                if (this._webAppsDir == null) {
                    this._webAppsDir = args[i];
                    continue;
                }
                System.err.println(USAGE);
                throw new IllegalArgumentException(USAGE);
            }
        }
        if (this._listenHost == null) {
            this._listenHost = DEFAULT_LISTEN_HOST;
        }
        if (this._sslListenHost == null) {
            this._sslListenHost = this._listenHost;
        }
        if (this._webAppsDir == null) {
            this._webAppsDir = DEFAULT_WEBAPPS_DIR;
        }
        if (this._listenPort == null && this._sslListenPort == null) {
            System.err.println(USAGE);
            throw new IllegalArgumentException(USAGE);
        }
        this._state = ClientAppState.INITIALIZED;
    }

    public static void main(String[] args) {
        List<RouterContext> contexts = RouterContext.listContexts();
        if (contexts == null || contexts.isEmpty()) {
            throw new IllegalStateException("no router context");
        }
        RouterConsoleRunner runner = new RouterConsoleRunner(contexts.get(0), null, args);
        runner.startup();
    }

    @Override
    public synchronized void startup() {
        this.changeState(ClientAppState.STARTING);
        this.checkJavaVersion();
        this.startTrayApp();
        this.startConsole();
    }

    @Override
    public synchronized void shutdown(String[] args) {
        if (this._state == ClientAppState.STOPPED) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        if (PluginStarter.pluginsEnabled(this._context)) {
            new I2PAppThread(new PluginStopper(this._context), "PluginStopper").start();
        }
        try {
            _server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PortMapper portMapper = this._context.portMapper();
        portMapper.unregister("console");
        portMapper.unregister("https_console");
        this.changeState(ClientAppState.STOPPED);
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return "console";
    }

    @Override
    public String getDisplayName() {
        return "Router Console";
    }

    private synchronized void changeState(ClientAppState state) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify(this, state, null, null);
        }
    }

    static Server getConsoleServer() {
        return _server;
    }

    private void startTrayApp() {
        if (DAEMON_USER.equals(System.getProperty("user.name")) || SystemVersion.isWindows() && this._context.hasWrapper() && WrapperManager.isLaunchedAsService()) {
            System.setProperty("java.awt.headless", "true");
            return;
        }
        try {
            boolean desktopguiEnabled = this._context.getBooleanProperty(PROP_DTG_ENABLED);
            if (desktopguiEnabled) {
                System.setProperty("java.awt.headless", Boolean.toString(GraphicsEnvironment.isHeadless()));
                Main dtg = new Main(this._context, this._mgr, null);
                dtg.startup();
            } else {
                System.setProperty("java.awt.headless", "true");
                if (SystemVersion.isWindows() && !Boolean.getBoolean("systray.disable") && !SystemVersion.is64Bit()) {
                    SysTray.getInstance();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void checkJavaVersion() {
        boolean openARM;
        boolean noJava7 = !SystemVersion.isJava7();
        boolean noPack200 = (PluginStarter.pluginsEnabled(this._context) || !NewsHelper.isUpdateDisabled(this._context)) && !FileUtil.isPack200Supported();
        boolean bl = openARM = SystemVersion.isARM() && SystemVersion.isOpenJDK();
        if (noJava7 || noPack200 || openARM) {
            String s = "Java version: " + System.getProperty("java.version") + " OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + ' ' + System.getProperty("os.version");
            net.i2p.util.Log log = this._context.logManager().getLog(RouterConsoleRunner.class);
            log.logAlways(30, s);
            System.out.println("Warning: " + s);
            if (noJava7) {
                s = "Java 7 is now required, please upgrade";
                log.logAlways(30, s);
                System.out.println("Warning: " + s);
            }
            if (noPack200) {
                s = "Pack200 is required for plugins and automatic updates, please upgrade Java";
                log.logAlways(30, s);
                System.out.println("Warning: " + s);
            }
            if (openARM) {
                s = "OpenJDK is not recommended for ARM. Use Oracle Java 8";
                log.logAlways(30, s);
                System.out.println("Warning: " + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void startConsole() {
        File app;
        boolean workDirCreated;
        SecureDirectory workDir = new SecureDirectory(this._context.getTempDir(), "jetty-work");
        boolean workDirRemoved = FileUtil.rmdir(workDir, false);
        if (!workDirRemoved) {
            System.err.println("ERROR: Unable to remove Jetty temporary work directory");
        }
        if (!(workDirCreated = ((File)workDir).mkdirs())) {
            System.err.println("ERROR: Unable to create Jetty temporary work directory");
        }
        System.setProperty("jetty.class.path", this._context.getBaseDir() + "/lib/routerconsole.jar");
        _server = new Server();
        _server.setGracefulShutdown(1000);
        LinkedBlockingQueue lbq = new LinkedBlockingQueue(96);
        QueuedThreadPool qtp = new QueuedThreadPool(lbq);
        qtp.setMaxIdleTimeMs(90000);
        qtp.setName(THREAD_NAME);
        qtp.setDaemon(true);
        _server.setThreadPool((ThreadPool)qtp);
        HandlerCollection hColl = new HandlerCollection();
        ContextHandlerCollection chColl = new ContextHandlerCollection();
        _server.setHandler((Handler)hColl);
        hColl.addHandler((Handler)chColl);
        hColl.addHandler((Handler)new DefaultHandler());
        String log = this._context.getProperty("routerconsole.log");
        if (log != null) {
            File logFile = new File(log);
            if (!logFile.isAbsolute()) {
                logFile = new File(this._context.getLogDir(), "logs/" + log);
            }
            try {
                RequestLogHandler rhl = new RequestLogHandler();
                rhl.setRequestLog((RequestLog)new NCSARequestLog(logFile.getAbsolutePath()));
                hColl.addHandler((Handler)rhl);
            }
            catch (Exception ioe) {
                System.err.println("ERROR: Unable to create Jetty log: " + ioe);
            }
        }
        boolean rewrite = false;
        Properties props = this.webAppProperties();
        if (props.isEmpty()) {
            props.setProperty("webapps.routerconsole.startOnLoad", "true");
            rewrite = true;
        }
        if (!(app = new File(this._webAppsDir)).isAbsolute()) {
            app = new File(this._context.getBaseDir(), this._webAppsDir);
            try {
                this._webAppsDir = app.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this._webAppsDir.endsWith("/")) {
            this._webAppsDir = this._webAppsDir + '/';
        }
        LocaleWebAppHandler rootWebApp = null;
        ServletHandler rootServletHandler = null;
        ArrayList<Object> connectors = new ArrayList<Object>(4);
        try {
            int boundAddresses = 0;
            SortedSet<String> addresses = Addresses.getAllAddresses();
            boolean bl = addresses.contains("0.0.0.0");
            boolean hasIPV6 = addresses.contains("0:0:0:0:0:0:0:0");
            int lport = 0;
            if (this._listenPort != null) {
                try {
                    lport = Integer.parseInt(this._listenPort);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (lport <= 0) {
                    System.err.println("Bad routerconsole port " + this._listenPort);
                }
            }
            if (lport > 0) {
                ArrayList<String> hosts = new ArrayList<String>(2);
                StringTokenizer tok = new StringTokenizer(this._listenHost, " ,");
                while (tok.hasMoreTokens()) {
                    String host = tok.nextToken().trim();
                    try {
                        SocketConnector lsnr;
                        InetAddress test = InetAddress.getByName(host);
                        if (!hasIPV6 && !(test instanceof Inet4Address)) {
                            throw new IOException("IPv6 addresses unsupported");
                        }
                        if (!bl && test instanceof Inet4Address) {
                            throw new IOException("IPv4 addresses unsupported");
                        }
                        ServerSocket testSock = null;
                        try {
                            testSock = new ServerSocket();
                            InetSocketAddress isa = new InetSocketAddress(host, 0);
                            testSock.bind(isa);
                        }
                        finally {
                            if (testSock != null) {
                                try {
                                    testSock.close();
                                }
                                catch (IOException isa) {}
                            }
                        }
                        if (SystemVersion.isJava6() && !SystemVersion.isGNU()) {
                            SelectChannelConnector slsnr = new SelectChannelConnector();
                            slsnr.setUseDirectBuffers(false);
                            lsnr = slsnr;
                        } else {
                            lsnr = new SocketConnector();
                        }
                        lsnr.setHost(host);
                        lsnr.setPort(lport);
                        lsnr.setMaxIdleTime(90000);
                        lsnr.setName("ConsoleSocket");
                        lsnr.setAcceptors(1);
                        connectors.add(lsnr);
                        ++boundAddresses;
                        hosts.add(host);
                    }
                    catch (Exception ioe) {
                        System.err.println("Unable to bind routerconsole to " + host + " port " + this._listenPort + ": " + ioe);
                        System.err.println("You may ignore this warning if the console is still available at http://localhost:" + this._listenPort);
                    }
                }
                if (hosts.isEmpty()) {
                    this._context.portMapper().register("console", lport);
                } else {
                    Collections.sort(hosts, new HostComparator());
                    this._context.portMapper().register("console", (String)hosts.get(0), lport);
                }
            }
            int sslPort = 0;
            if (this._sslListenPort != null) {
                try {
                    sslPort = Integer.parseInt(this._sslListenPort);
                }
                catch (NumberFormatException tok) {
                    // empty catch block
                }
                if (sslPort <= 0) {
                    System.err.println("Bad routerconsole SSL port " + this._sslListenPort);
                }
            }
            if (sslPort > 0) {
                File keyStore = new File(this._context.getConfigDir(), "keystore/console.ks");
                if (this.verifyKeyStore(keyStore)) {
                    SslContextFactory sslFactory = new SslContextFactory(keyStore.getAbsolutePath());
                    sslFactory.setKeyStorePassword(this._context.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD));
                    sslFactory.setKeyManagerPassword(this._context.getProperty(PROP_KEY_PASSWORD, "thisWontWork"));
                    sslFactory.addExcludeProtocols(I2PSSLSocketFactory.EXCLUDE_PROTOCOLS.toArray(new String[I2PSSLSocketFactory.EXCLUDE_PROTOCOLS.size()]));
                    sslFactory.addExcludeCipherSuites(I2PSSLSocketFactory.EXCLUDE_CIPHERS.toArray(new String[I2PSSLSocketFactory.EXCLUDE_CIPHERS.size()]));
                    ArrayList<String> hosts = new ArrayList<String>(2);
                    StringTokenizer tok = new StringTokenizer(this._sslListenHost, " ,");
                    while (tok.hasMoreTokens()) {
                        String host = tok.nextToken().trim();
                        try {
                            SslSocketConnector ssll;
                            SslSocketConnector sssll;
                            InetAddress test = InetAddress.getByName(host);
                            if (!hasIPV6 && !(test instanceof Inet4Address)) {
                                throw new IOException("IPv6 addresses unsupported");
                            }
                            if (!bl && test instanceof Inet4Address) {
                                throw new IOException("IPv4 addresses unsupported");
                            }
                            ServerSocket testSock = null;
                            try {
                                testSock = new ServerSocket();
                                InetSocketAddress isa = new InetSocketAddress(host, 0);
                                testSock.bind(isa);
                            }
                            finally {
                                if (testSock != null) {
                                    try {
                                        testSock.close();
                                    }
                                    catch (IOException isa) {}
                                }
                            }
                            if (SystemVersion.isJava6() && !SystemVersion.isGNU()) {
                                sssll = new SslSelectChannelConnector(sslFactory);
                                sssll.setUseDirectBuffers(false);
                                ssll = sssll;
                            } else {
                                ssll = sssll = new SslSocketConnector(sslFactory);
                            }
                            ssll.setHost(host);
                            ssll.setPort(sslPort);
                            ssll.setMaxIdleTime(90000);
                            ssll.setName("ConsoleSocket");
                            ssll.setAcceptors(1);
                            connectors.add(ssll);
                            ++boundAddresses;
                            hosts.add(host);
                        }
                        catch (Exception e) {
                            System.err.println("Unable to bind routerconsole to " + host + " port " + sslPort + " for SSL: " + e);
                            if (SystemVersion.isGNU()) {
                                System.err.println("Probably because GNU classpath does not support Sun keystores");
                            }
                            System.err.println("You may ignore this warning if the console is still available at https://localhost:" + sslPort);
                        }
                    }
                    if (hosts.isEmpty()) {
                        this._context.portMapper().register("https_console", sslPort);
                    } else {
                        Collections.sort(hosts, new HostComparator());
                        this._context.portMapper().register("https_console", (String)hosts.get(0), sslPort);
                    }
                } else {
                    System.err.println("Unable to create or access keystore for SSL: " + keyStore.getAbsolutePath());
                }
            }
            if (boundAddresses <= 0) {
                System.err.println("Unable to bind routerconsole to any address on port " + this._listenPort + (sslPort > 0 ? " or SSL port " + sslPort : ""));
                return;
            }
            qtp.setMinThreads(1 + 2 * boundAddresses);
            qtp.setMaxThreads(24 + 2 * boundAddresses);
            SecureDirectory tmpdir = new SecureDirectory(workDir, "routerconsole-" + (this._listenPort != null ? this._listenPort : this._sslListenPort));
            ((File)tmpdir).mkdir();
            rootServletHandler = new ServletHandler();
            rootWebApp = new LocaleWebAppHandler(this._context, "/", this._webAppsDir + ROUTERCONSOLE + ".war", tmpdir, rootServletHandler);
            RouterConsoleRunner.initialize(this._context, (WebAppContext)rootWebApp.getHandler());
            chColl.addHandler((Handler)rootWebApp);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        Resource.setDefaultUseCaches((boolean)false);
        try {
            _server.start();
        }
        catch (Throwable me) {
            System.err.println("Error starting the Router Console server: " + me);
            me.printStackTrace();
        }
        if (_server.isRunning()) {
            boolean error = false;
            for (Connector connector : connectors) {
                try {
                    _server.addConnector(connector);
                    connector.start();
                }
                catch (Throwable me) {
                    try {
                        _server.removeConnector(connector);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    System.err.println("WARNING: Error starting " + connector + ": " + me);
                    me.printStackTrace();
                    error = true;
                }
            }
            if (error) {
                String port = this._listenPort != null ? this._listenPort : (this._sslListenPort != null ? this._sslListenPort : "7657");
                System.err.println("WARNING: Error starting one or more listeners of the Router Console server.\nIf your console is still accessible at http://127.0.0.1:" + port + "/,\n" + "this may be a problem only with binding to the IPV6 address ::1.\n" + "If so, you may ignore this error, or remove the\n" + "\"::1,\" in the \"clientApp.0.args\" line of the clients.config file.");
            }
        }
        ArrayList<String> notStarted = new ArrayList<String>();
        if (_server.isRunning()) {
            File dir = new File(this._webAppsDir);
            String[] stringArray = dir.list(WarFilenameFilter.instance());
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String appName = stringArray[i].substring(0, stringArray[i].lastIndexOf(".war"));
                    String enabled = props.getProperty(PREFIX + appName + ENABLED);
                    if (!"false".equals(enabled)) {
                        try {
                            String path = new File(dir, stringArray[i]).getCanonicalPath();
                            WebAppStarter.startWebApp(this._context, chColl, appName, path);
                            if (enabled != null) continue;
                            props.setProperty(PREFIX + appName + ENABLED, "true");
                            rewrite = true;
                        }
                        catch (Throwable t) {
                            System.err.println("ERROR: Failed to start " + appName + ' ' + t);
                            t.printStackTrace();
                            notStarted.add(appName);
                        }
                        continue;
                    }
                    notStarted.add(appName);
                }
                this.changeState(ClientAppState.RUNNING);
                if (this._mgr != null) {
                    this._mgr.register(this);
                }
            }
        } else {
            System.err.println("ERROR: Router console did not start, not starting webapps");
            this.changeState(ClientAppState.START_FAILED);
        }
        if (rewrite) {
            RouterConsoleRunner.storeWebAppProperties(this._context, props);
        }
        if (rootServletHandler != null && notStarted.size() > 0) {
            void var17_28;
            ServletHolder noWebApp = rootServletHandler.getServlet("net.i2p.router.web.jsp.nowebapp_jsp");
            boolean bl = false;
            while (var17_28 < notStarted.size()) {
                try {
                    if (noWebApp != null) {
                        String path = '/' + (String)notStarted.get((int)var17_28);
                        rootServletHandler.addServletWithMapping(noWebApp, path + ".jsp");
                        rootServletHandler.addServletWithMapping(noWebApp, path + "/*");
                    } else {
                        System.err.println("Can't find nowebapp.jsp?");
                    }
                }
                catch (Throwable me) {
                    System.err.println(me);
                    me.printStackTrace();
                }
                ++var17_28;
            }
        }
        I2PAppThread t = new I2PAppThread(new StatSummarizer(), "StatSummarizer", true);
        t.setPriority(4);
        ((Thread)t).start();
        ConsoleUpdateManager consoleUpdateManager = new ConsoleUpdateManager(this._context, this._mgr, null);
        consoleUpdateManager.start();
        NewsManager nm = new NewsManager(this._context, this._mgr, null);
        nm.startup();
        if (PluginStarter.pluginsEnabled(this._context)) {
            t = new I2PAppThread(new PluginStarter(this._context), "PluginStarter", true);
            t.setPriority(4);
            ((Thread)t).start();
        }
        if (this._mgr == null) {
            this._context.addShutdownTask(new ServerShutdown());
        }
        ConfigServiceHandler.registerSignalHandler(this._context);
    }

    private boolean verifyKeyStore(File ks) {
        if (ks.exists()) {
            boolean rv;
            boolean bl = rv = this._context.getProperty(PROP_KEY_PASSWORD) != null;
            if (!rv) {
                System.err.println("Console SSL error, must set routerconsole.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
            }
            return rv;
        }
        return this.createKeyStore(ks);
    }

    private boolean createKeyStore(File ks) {
        String keyPassword = KeyStoreUtil.randomString();
        String cname = KeyStoreUtil.randomString() + ".console.i2p.net";
        boolean success = KeyStoreUtil.createKeys(ks, "console", cname, "Console", keyPassword);
        if (success && (success = ks.exists())) {
            try {
                HashMap<String, String> changes = new HashMap<String, String>();
                changes.put(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
                changes.put(PROP_KEY_PASSWORD, keyPassword);
                this._context.router().saveConfig(changes, null);
            }
            catch (Exception changes) {
                // empty catch block
            }
            SecureDirectory dir = new SecureDirectory(this._context.getConfigDir(), "certificates");
            ((File)dir).mkdir();
            dir = new SecureDirectory(dir, "console");
            ((File)dir).mkdir();
            File certFile = new File(dir, "console.local.crt");
            KeyStoreUtil.exportCert(ks, DEFAULT_KEYSTORE_PASSWORD, "console", certFile);
        }
        if (success) {
            System.err.println("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath() + "\n" + "The certificate name was generated randomly, and is not associated with your " + "IP address, host name, router identity, or destination keys.");
        } else {
            System.err.println("Failed to create console SSL keystore.\nThis is for the Sun/Oracle keytool, others may be incompatible.\nIf you create the keystore manually, you must add routerconsole.keystorePassword and routerconsole.keyPassword to " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
        }
        return success;
    }

    static void initialize(RouterContext ctx, WebAppContext context) {
        ConstraintSecurityHandler sec = new ConstraintSecurityHandler();
        ArrayList<ConstraintMapping> constraints = new ArrayList<ConstraintMapping>(4);
        ConsolePasswordManager mgr = new ConsolePasswordManager(ctx);
        boolean enable = ctx.getBooleanProperty(PROP_PW_ENABLE);
        if (enable) {
            Map<String, String> userpw = mgr.getMD5(PROP_CONSOLE_PW);
            if (userpw.isEmpty()) {
                enable = false;
                ctx.router().saveConfig(PROP_CONSOLE_PW, "false");
            } else {
                HashLoginService realm = new HashLoginService(JETTY_REALM);
                sec.setLoginService((LoginService)realm);
                sec.setAuthenticator((Authenticator)authenticator);
                String[] role = new String[]{JETTY_ROLE};
                for (Map.Entry<String, String> e : userpw.entrySet()) {
                    byte[] b2;
                    String user = e.getKey();
                    String pw = e.getValue();
                    Credential cred = Credential.getCredential((String)("MD5:" + pw));
                    realm.putUser(user, cred, role);
                    Constraint constraint = new Constraint(user, JETTY_ROLE);
                    constraint.setAuthenticate(true);
                    ConstraintMapping cm = new ConstraintMapping();
                    cm.setConstraint(constraint);
                    cm.setPathSpec("/");
                    constraints.add(cm);
                    byte[] b1 = DataHelper.getUTF8(user);
                    if (DataHelper.eq(b1, b2 = DataHelper.getASCII(user))) continue;
                    try {
                        String user2 = new String(b2, "ISO-8859-1");
                        realm.putUser(user2, cred, role);
                        constraint = new Constraint(user2, JETTY_ROLE);
                        constraint.setAuthenticate(true);
                        cm = new ConstraintMapping();
                        cm.setConstraint(constraint);
                        cm.setPathSpec("/");
                        constraints.add(cm);
                        String user3 = new String(b1, "ISO-8859-1");
                        realm.putUser(user3, cred, role);
                        constraint = new Constraint(user3, JETTY_ROLE);
                        constraint.setAuthenticate(true);
                        cm = new ConstraintMapping();
                        cm.setConstraint(constraint);
                        cm.setPathSpec("/");
                        constraints.add(cm);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
        }
        Constraint sc = new Constraint();
        sc.setName("No trace");
        ConstraintMapping cm = new ConstraintMapping();
        cm.setMethod("TRACE");
        cm.setConstraint(sc);
        cm.setPathSpec("/");
        constraints.add(cm);
        sc = new Constraint();
        sc.setName("No options");
        cm = new ConstraintMapping();
        cm.setMethod("OPTIONS");
        cm.setConstraint(sc);
        cm.setPathSpec("/");
        constraints.add(cm);
        ConstraintMapping[] cmarr = constraints.toArray(new ConstraintMapping[constraints.size()]);
        sec.setConstraintMappings(cmarr);
        context.setSecurityHandler((SecurityHandler)sec);
    }

    private Properties webAppProperties() {
        return RouterConsoleRunner.webAppProperties(this._context.getConfigDir().getAbsolutePath());
    }

    public static Properties webAppProperties(I2PAppContext ctx) {
        return RouterConsoleRunner.webAppProperties(ctx.getConfigDir().getAbsolutePath());
    }

    public static Properties webAppProperties(String dir) {
        Properties rv = new Properties();
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(dir, webappConfigFile);
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rv;
    }

    public static void storeWebAppProperties(RouterContext ctx, Properties props) {
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(ctx.getConfigDir(), webappConfigFile);
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            Log.setLog((Logger)new I2PLogger());
        }
        catch (Throwable t) {
            System.err.println("INFO: I2P Jetty logging class not found, logging to wrapper log");
        }
        authenticator = new DigestAuthenticator();
        authenticator.setMaxNonceAge(604800000L);
    }

    private static class HostComparator
    implements Comparator<String>,
    Serializable {
        private HostComparator() {
        }

        @Override
        public int compare(String l, String r) {
            boolean l4 = l.contains(".");
            boolean r4 = r.contains(".");
            if (l4 && !r4) {
                return -1;
            }
            if (r4 && !l4) {
                return 1;
            }
            return l.compareTo(r);
        }
    }

    private class ServerShutdown
    implements Runnable {
        private ServerShutdown() {
        }

        @Override
        public void run() {
            RouterConsoleRunner.this.shutdown(null);
        }
    }

    static class WarFilenameFilter
    implements FilenameFilter {
        private static final WarFilenameFilter _filter = new WarFilenameFilter();

        WarFilenameFilter() {
        }

        public static WarFilenameFilter instance() {
            return _filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".war") && !name.equals("routerconsole.war");
        }
    }
}

