/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NewsHelper;

public class ConfigUpdateHelper
extends HelperBase {
    private boolean _dontInstall;
    private static final long[] PERIODS = new long[]{43200000L, 86400000L, 129600000L, 172800000L, 259200000L, 604800000L, -1L};

    @Override
    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._dontInstall = NewsHelper.dontInstall(this._context);
    }

    public boolean canInstall() {
        return !this._dontInstall;
    }

    public boolean updateAvailable() {
        return true;
    }

    public String getNewsURL() {
        return ConfigUpdateHelper.getNewsURL(this._context);
    }

    public static String getNewsURL(I2PAppContext ctx) {
        String url = ctx.getProperty("router.newsURL");
        if (!(url == null || url.equals("http://complication.i2p/news.xml") || url.equals("http://echelon.i2p/i2p/news.xml") || url.equals("http://echelon.i2p/news/news.su3"))) {
            return url;
        }
        return "http://tc73n4kivdroccekirco7rhgxdg5f3cjvbaapabupeyzrqwv5guq.b32.i2p/news.su3";
    }

    public String getUpdateURL() {
        String url = this._context.getProperty("router.updateURL");
        if (url != null) {
            return url.replace(",", "\n");
        }
        return ConfigUpdateHandler.DEFAULT_UPDATE_URL;
    }

    public String getProxyHost() {
        if (this.isInternal()) {
            return this._t("internal") + "\" readonly=\"readonly";
        }
        return this._context.getProperty("router.updateProxyHost", "127.0.0.1");
    }

    public String getProxyPort() {
        if (this.isInternal()) {
            return this._t("internal") + "\" readonly=\"readonly";
        }
        return Integer.toString(ConfigUpdateHandler.proxyPort(this._context));
    }

    private boolean isInternal() {
        String host = this._context.getProperty("router.updateProxyHost");
        String port = this._context.getProperty("router.updateProxyPort");
        return !(host != null && !host.equals("127.0.0.1") || port != null && !port.equals("4444") || this._context.portMapper().getPort("HTTP") != 4444);
    }

    public String getUpdateThroughProxy() {
        if (this._context.getProperty("router.updateThroughProxy", true)) {
            return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateThroughProxy\" checked=\"checked\" >";
        }
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateThroughProxy\" >";
    }

    public String getNewsThroughProxy() {
        if (this._context.getProperty("router.fetchNewsThroughProxy", true)) {
            return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"newsThroughProxy\" checked=\"checked\" >";
        }
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"newsThroughProxy\" >";
    }

    public String getUpdateUnsigned() {
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateUnsigned\" " + this.getChecked("router.updateUnsigned") + '>';
    }

    public String getUpdateDevSU3() {
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateDevSU3\" " + this.getChecked("router.updateDevSU3") + '>';
    }

    public String getRefreshFrequencySelectBox() {
        String freq = this._context.getProperty("router.newsRefreshFrequency", ConfigUpdateHandler.DEFAULT_REFRESH_FREQUENCY);
        long ms = 129600000L;
        try {
            ms = Long.parseLong(freq);
            if (ms <= 0L) {
                ms = -1L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"refreshFrequency\">");
        for (int i = 0; i < PERIODS.length; ++i) {
            buf.append("<option value=\"").append(PERIODS[i]);
            if (PERIODS[i] == ms) {
                buf.append("\" selected=\"selected");
            }
            if (PERIODS[i] == -1L) {
                buf.append("\">").append(this._t("Never")).append("</option>\n");
                continue;
            }
            buf.append("\">").append(this._t("Every")).append(' ').append(DataHelper.formatDuration2(PERIODS[i])).append("</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getUpdatePolicySelectBox() {
        String policy = this._context.getProperty("router.updatePolicy", "download");
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"updatePolicy\">");
        buf.append("<option value=\"notify\"");
        if ("notify".equals(policy) || this._dontInstall) {
            buf.append(" selected=\"selected\"");
        }
        buf.append('>').append(this._t("Notify only")).append("</option>");
        buf.append("<option value=\"download\"");
        if (this._dontInstall) {
            buf.append(" disabled=\"disabled\"");
        } else if ("download".equals(policy)) {
            buf.append(" selected=\"selected\"");
        }
        buf.append('>').append(this._t("Download and verify only")).append("</option>");
        if (this._context.hasWrapper()) {
            buf.append("<option value=\"install\"");
            if (this._dontInstall) {
                buf.append(" disabled=\"disabled\"");
            } else if ("install".equals(policy)) {
                buf.append(" selected=\"selected\"");
            }
            buf.append('>').append(this._t("Download, verify, and restart")).append("</option>");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getTrustedKeys() {
        return new TrustedUpdate(this._context).getTrustedKeysString();
    }

    public String getZipURL() {
        return this._context.getProperty("router.updateUnsignedURL", "");
    }

    public String getDevSU3URL() {
        return this._context.getProperty("router.updateDevSU3URL", "");
    }

    public String getNewsStatus() {
        return NewsHelper.status(this._context);
    }
}

