/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.Messages;

public class ConfigReseedHandler
extends FormHandler {
    private final Map<String, String> changes = new HashMap<String, String>();
    private final List<String> removes = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processForm() {
        block41: {
            if (this._action.equals(this._t("Save changes and reseed now"))) {
                this.saveChanges();
                if (!this._context.netDb().reseedChecker().requestReseed()) {
                    this.addFormError(this._t("Reseeding is already in progress"));
                } else {
                    this.addFormNotice(this._t("Starting reseed process"));
                }
            } else if (this._action.equals(this._t("Reseed from URL"))) {
                URI url;
                String val = this.getJettyString("url");
                if (val != null) {
                    val = val.trim();
                }
                if (val == null || val.length() == 0) {
                    this.addFormError(this._t("You must enter a URL"));
                    return;
                }
                try {
                    url = new URI(val);
                }
                catch (URISyntaxException mue) {
                    this.addFormError(this._t("Bad URL {0}", val));
                    return;
                }
                try {
                    if (!this._context.netDb().reseedChecker().requestReseed(url)) {
                        this.addFormError(this._t("Reseeding is already in progress"));
                        break block41;
                    }
                    for (int i = 0; i < 40; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!this._context.netDb().reseedChecker().inProgress()) break;
                    }
                    String status = this._context.netDb().reseedChecker().getStatus();
                    String error = this._context.netDb().reseedChecker().getError();
                    if (error.length() > 0) {
                        this.addFormErrorNoEscape(error);
                        break block41;
                    }
                    if (status.length() > 0) {
                        this.addFormNoticeNoEscape(status);
                        break block41;
                    }
                    if (this._context.netDb().reseedChecker().inProgress()) {
                        this.addFormNotice(this._t("Reseed in progress, check summary bar for status"));
                        break block41;
                    }
                    this.addFormNotice(this._t("Reseed complete, check summary bar for status"));
                }
                catch (IllegalArgumentException iae) {
                    this.addFormError(this._t("Bad URL {0}", val) + " - " + iae.getMessage());
                }
            } else if (this._action.equals(this._t("Reseed from file"))) {
                InputStream in = this._requestWrapper.getInputStream("file");
                try {
                    if (in == null || in.available() <= 0) {
                        this.addFormError(this._t("You must enter a file"));
                        return;
                    }
                    int count = this._context.netDb().reseedChecker().requestReseed(in);
                    if (count <= 0) {
                        this.addFormError(this._t("Reseed from file failed"));
                    }
                    this.addFormNotice(this.ngettext("Reseed successful, loaded {0} router info from file", "Reseed successful, loaded {0} router infos from file", count));
                }
                catch (IOException ioe) {
                    this.addFormError(this._t("Reseed from file failed") + " - " + ioe);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (this._action.equals(this._t("Save changes"))) {
                this.saveChanges();
            } else if (this._action.equals(this._t("Reset URL list"))) {
                this.resetUrlList();
            }
        }
    }

    private void resetUrlList() {
        if (this._context.router().saveConfig("i2p.reseedURL", null)) {
            this.addFormNotice(this._t("URL list reset successfully"));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }

    private void saveString(String config, String param) {
        String val = this.getJettyString(param);
        if (val != null && val.length() > 0) {
            this.changes.put(config, val);
        } else {
            this.removes.add(config);
        }
    }

    private void saveBoolean(String config, String param) {
        boolean val = this.getJettyString(param) != null;
        this.changes.put(config, Boolean.toString(val));
    }

    private void saveChanges() {
        this.saveString("router.reseedProxyPort", "port");
        this.saveString("router.reseedProxyHost", "host");
        this.saveString("router.reseedProxy.username", "username");
        this.saveString("router.reseedProxy.password", "password");
        this.saveBoolean("router.reseedProxy.authEnable", "auth");
        this.saveString("router.reseedSSLProxyPort", "sport");
        this.saveString("router.reseedSSLProxyHost", "shost");
        this.saveString("router.reseedSSLProxy.username", "susername");
        this.saveString("router.reseedSSLProxy.password", "spassword");
        this.saveBoolean("router.reseedSSLProxy.authEnable", "sauth");
        String url = this.getJettyString("reseedURL");
        if (url != null) {
            if ((url = url.trim().replace("\r\n", ",").replace("\n", ",")).length() <= 0) {
                this.addFormNotice("Restoring default URLs");
                this.removes.add("i2p.reseedURL");
            } else {
                this.changes.put("i2p.reseedURL", url);
            }
        }
        String mode = this.getJettyString("mode");
        boolean req = "1".equals(mode);
        boolean disabled = "2".equals(mode);
        this.changes.put("router.reseedSSLRequired", Boolean.toString(req));
        this.changes.put("router.reseedSSLDisable", Boolean.toString(disabled));
        this.saveBoolean("router.reseedProxyEnable", "enable");
        this.saveBoolean("router.reseedSSLProxyEnable", "senable");
        if (this._context.router().saveConfig(this.changes, this.removes)) {
            this.addFormNotice(this._t("Configuration saved successfully."));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }

    public String ngettext(String s, String p, int n) {
        return Messages.getString(n, s, p, (I2PAppContext)this._context);
    }
}

