/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;

public class ConfigNavHelper
extends HelperBase {
    private static final String[] pages = new String[]{"", "net", "ui", "sidebar", "home", "service", "update", "tunnels", "clients", "peer", "keyring", "logging", "stats", "reseed", "advanced", "family"};
    private static final String[] titles = new String[]{ConfigNavHelper._x("Bandwidth"), ConfigNavHelper._x("Network"), ConfigNavHelper._x("UI"), ConfigNavHelper._x("Summary Bar"), ConfigNavHelper._x("Home Page"), ConfigNavHelper._x("Service"), ConfigNavHelper._x("Update"), ConfigNavHelper._x("Tunnels"), ConfigNavHelper._x("Clients"), ConfigNavHelper._x("Peers"), ConfigNavHelper._x("Keyring"), ConfigNavHelper._x("Logging"), ConfigNavHelper._x("Stats"), ConfigNavHelper._x("Reseeding"), ConfigNavHelper._x("Advanced"), ConfigNavHelper._x("Router Family")};

    public void renderNavBar(String requestURI, boolean graphical) throws IOException {
        int i;
        boolean span;
        StringBuilder buf = new StringBuilder(1024);
        String theme = this._context.getProperty("routerconsole.theme");
        boolean bl = span = graphical && (theme == null || theme.equals("light"));
        if (!span) {
            buf.append("<center>");
        }
        ArrayList<Tab> tabs = new ArrayList<Tab>(pages.length);
        for (i = 0; i < pages.length; ++i) {
            tabs.add(new Tab(pages[i], this._t(titles[i])));
        }
        Collections.sort(tabs, new TabComparator());
        for (i = 0; i < tabs.size(); ++i) {
            String page = "config" + ((Tab)tabs.get((int)i)).page;
            if (requestURI.endsWith(page) || requestURI.endsWith(page + ".jsp")) {
                if (span) {
                    buf.append("<span class=\"tab2\">");
                }
                buf.append(((Tab)tabs.get((int)i)).title);
            } else {
                if (span) {
                    buf.append("<span class=\"tab\">");
                }
                buf.append("<a href=\"").append(page).append("\">").append(((Tab)tabs.get((int)i)).title).append("</a>");
            }
            if (span) {
                buf.append(" </span>\n");
                continue;
            }
            if (i == pages.length - 1) continue;
            buf.append(" |\n");
        }
        if (!span) {
            buf.append("</center>");
        }
        this._out.write(buf.toString());
    }

    private static class Tab {
        public final String page;
        public final String title;

        public Tab(String p, String t) {
            this.page = p;
            this.title = t;
        }
    }

    private class TabComparator
    implements Comparator<Tab> {
        private static final long serialVersionUID = 1L;
        private final Collator coll;

        public TabComparator() {
            this.coll = Collator.getInstance(new Locale(Messages.getLanguage(ConfigNavHelper.this._context)));
        }

        @Override
        public int compare(Tab l, Tab r) {
            return this.coll.compare(l.title, r.title);
        }
    }
}

