/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import net.i2p.I2PAppContext;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.util.SecureDirectory;

public class SSLClientUtil {
    private static final String PROP_KEYSTORE_PASSWORD = "keystorePassword";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String PROP_KEY_PASSWORD = "keyPassword";
    private static final String PROP_KEY_ALIAS = "keyAlias";
    private static final String ASCII_KEYFILE_SUFFIX = ".local.crt";
    private static final String PROP_KS_NAME = "keystoreFile";
    private static final String KS_DIR = "keystore";
    private static final String PREFIX = "i2ptunnel-";
    private static final String KS_SUFFIX = ".ks";
    private static final String CERT_DIR = "certificates/i2ptunnel";

    public static boolean verifyKeyStore(Properties opts) throws IOException {
        return SSLClientUtil.verifyKeyStore(opts, "");
    }

    public static boolean verifyKeyStore(Properties opts, String optPfx) throws IOException {
        SecureDirectory sdir;
        File ks;
        String ksname;
        String name = opts.getProperty(optPfx + PROP_KEY_ALIAS);
        if (name == null) {
            name = KeyStoreUtil.randomString();
            opts.setProperty(optPfx + PROP_KEY_ALIAS, name);
        }
        if ((ksname = opts.getProperty(optPfx + PROP_KS_NAME)) == null) {
            ksname = PREFIX + name + KS_SUFFIX;
            opts.setProperty(optPfx + PROP_KS_NAME, ksname);
        }
        if (!(ks = new File(ksname)).isAbsolute()) {
            ks = new File(I2PAppContext.getGlobalContext().getConfigDir(), KS_DIR);
            ks = new File(ks, ksname);
        }
        if (ks.exists()) {
            return false;
        }
        File dir = ks.getParentFile();
        if (!dir.exists() && !((File)(sdir = new SecureDirectory(dir.getAbsolutePath()))).mkdirs()) {
            throw new IOException("Unable to create keystore " + ks);
        }
        boolean rv = SSLClientUtil.createKeyStore(ks, name, opts, optPfx);
        if (!rv) {
            throw new IOException("Unable to create keystore " + ks);
        }
        SSLClientUtil.exportCert(ks, name, opts, optPfx);
        return true;
    }

    private static boolean createKeyStore(File ks, String name, Properties opts, String optPfx) {
        String keyPassword = KeyStoreUtil.randomString();
        String cname = name + ".i2ptunnel.i2p.net";
        String keyName = opts.getProperty(optPfx + PROP_KEY_ALIAS);
        boolean success = KeyStoreUtil.createKeys(ks, keyName, cname, "I2PTUNNEL", keyPassword);
        if (success && (success = ks.exists())) {
            opts.setProperty(optPfx + PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            opts.setProperty(optPfx + PROP_KEY_PASSWORD, keyPassword);
        }
        if (success) {
            SSLClientUtil.logAlways("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath() + "\n" + "The certificate name was generated randomly, and is not associated with your " + "IP address, host name, router identity, or destination keys.");
        } else {
            SSLClientUtil.error("Failed to create I2PTunnel SSL keystore.\nIf you create the keystore manually, you must add " + optPfx + PROP_KEYSTORE_PASSWORD + " and " + optPfx + PROP_KEY_PASSWORD + " to " + new File(I2PAppContext.getGlobalContext().getConfigDir(), "i2ptunnel.config").getAbsolutePath());
        }
        return success;
    }

    private static void exportCert(File ks, String name, Properties opts, String optPfx) {
        SecureDirectory sdir = new SecureDirectory(I2PAppContext.getGlobalContext().getConfigDir(), CERT_DIR);
        if (sdir.exists() || ((File)sdir).mkdirs()) {
            File out;
            String keyAlias = opts.getProperty(optPfx + PROP_KEY_ALIAS);
            String ksPass = opts.getProperty(optPfx + PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            boolean success = KeyStoreUtil.exportCert(ks, ksPass, keyAlias, out = new File(sdir, PREFIX + name + ASCII_KEYFILE_SUFFIX));
            if (!success) {
                SSLClientUtil.error("Error getting SSL cert to save as ASCII");
            }
        } else {
            SSLClientUtil.error("Error saving ASCII SSL keys");
        }
    }

    public static SSLServerSocketFactory initializeFactory(Properties opts) throws IOException {
        String ksPass = opts.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
        String keyPass = opts.getProperty(PROP_KEY_PASSWORD);
        if (keyPass == null) {
            throw new IOException("No key password, set keyPassword in " + new File(I2PAppContext.getGlobalContext().getConfigDir(), "i2ptunnel.config").getAbsolutePath());
        }
        String ksname = opts.getProperty(PROP_KS_NAME);
        if (ksname == null) {
            throw new IOException("No keystore, set keystoreFile in " + new File(I2PAppContext.getGlobalContext().getConfigDir(), "i2ptunnel.config").getAbsolutePath());
        }
        File ks = new File(ksname);
        if (!ks.isAbsolute()) {
            ks = new File(I2PAppContext.getGlobalContext().getConfigDir(), KS_DIR);
            ks = new File(ks, ksname);
        }
        InputStream fis = null;
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            keyStore.load(fis, ksPass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPass.toCharArray());
            sslc.init(kmf.getKeyManagers(), null, I2PAppContext.getGlobalContext().random());
            SSLServerSocketFactory sSLServerSocketFactory = sslc.getServerSocketFactory();
            return sSLServerSocketFactory;
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("keystore error");
            ioe.initCause(gse);
            throw ioe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void error(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(SSLClientUtil.class).error(s);
    }

    private static void logAlways(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(SSLClientUtil.class).logAlways(20, s);
    }
}

