/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.util.ByteCache;
import net.i2p.util.Clock;
import net.i2p.util.I2PAppThread;
import net.i2p.util.InternalSocket;
import net.i2p.util.Log;

public class I2PTunnelOutproxyRunner
extends I2PAppThread {
    protected final Log _log;
    private static final AtomicLong __runnerId = new AtomicLong();
    private final long _runnerId;
    private static final int MAX_PACKET_SIZE = 4096;
    private static final int NETWORK_BUFFER_SIZE = 4096;
    private final Socket s;
    private final Socket i2ps;
    private final Object slock;
    private final Object finishLock = new Object();
    volatile boolean finished = false;
    private final byte[] initialI2PData;
    private final byte[] initialSocketData;
    private long lastActivityOn;
    private final long startedOn;
    private final I2PTunnelRunner.FailCallback onTimeout;
    private long totalSent;
    private long totalReceived;
    private static final AtomicLong __forwarderId = new AtomicLong();

    public I2PTunnelOutproxyRunner(Socket s, Socket i2ps, Object slock, byte[] initialI2PData, byte[] initialSocketData, I2PTunnelRunner.FailCallback onTimeout) {
        this.s = s;
        this.i2ps = i2ps;
        this.slock = slock;
        this.initialI2PData = initialI2PData;
        this.initialSocketData = initialSocketData;
        this.onTimeout = onTimeout;
        this.lastActivityOn = -1L;
        this.startedOn = Clock.getInstance().now();
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        if (this._log.shouldLog(20)) {
            this._log.info("OutproxyRunner started");
        }
        this._runnerId = __runnerId.incrementAndGet();
        this.setName("OutproxyRunner " + this._runnerId);
    }

    @Deprecated
    public boolean isFinished() {
        return this.finished;
    }

    @Deprecated
    public long getLastActivityOn() {
        return this.lastActivityOn;
    }

    public long getStartedOn() {
        return this.startedOn;
    }

    protected InputStream getSocketIn() throws IOException {
        return this.s.getInputStream();
    }

    protected OutputStream getSocketOut() throws IOException {
        return this.s.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStream in = this.getSocketIn();
            OutputStream out = this.getSocketOut();
            InputStream i2pin = this.i2ps.getInputStream();
            OutputStream i2pout = this.i2ps.getOutputStream();
            if (this.initialI2PData != null) {
                i2pout.write(this.initialI2PData);
                i2pout.flush();
            }
            if (this.initialSocketData != null) {
                out.write(this.initialSocketData);
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Initial data " + (this.initialI2PData != null ? this.initialI2PData.length : 0) + " written to the outproxy, " + (this.initialSocketData != null ? this.initialSocketData.length : 0) + " written to the socket, starting forwarders");
            }
            if (!(this.s instanceof InternalSocket)) {
                in = new BufferedInputStream(in, 8192);
            }
            StreamForwarder t1 = new StreamForwarder(in, i2pout, true);
            StreamForwarder t2 = new StreamForwarder(i2pin, out, false);
            ((Thread)t1).start();
            ((Thread)t2).start();
            Object object = this.finishLock;
            synchronized (object) {
                while (!this.finished) {
                    this.finishLock.wait();
                }
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("At least one forwarder completed, closing and joining");
            }
            if (this.onTimeout != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("runner has a timeout job, totalReceived = " + this.totalReceived + " totalSent = " + this.totalSent + " job = " + this.onTimeout);
                }
                if (this.totalReceived <= 0L) {
                    this.onTimeout.onFail(null);
                }
            }
            this.close(out, in, i2pout, i2pin, this.s, this.i2ps, t1, t2);
        }
        catch (InterruptedException ex) {
            if (this._log.shouldLog(40)) {
                this._log.error("Interrupted", ex);
            }
        }
        catch (SSLException she) {
            this._log.error("SSL error", she);
        }
        catch (IOException ex) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Error forwarding", ex);
            }
        }
        catch (IllegalStateException ise) {
            if (this._log.shouldLog(30)) {
                this._log.warn("gnu?", ise);
            }
        }
        catch (RuntimeException e) {
            if (this._log.shouldLog(40)) {
                this._log.error("Internal error", e);
            }
        }
        finally {
            block61: {
                block60: {
                    try {
                        if (this.s != null) {
                            this.s.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!this._log.shouldLog(30)) break block60;
                        this._log.warn("Could not close java socket", ex);
                    }
                }
                if (this.i2ps != null) {
                    try {
                        this.i2ps.close();
                    }
                    catch (IOException ex) {
                        if (!this._log.shouldLog(30)) break block61;
                        this._log.warn("Could not close Socket", ex);
                    }
                }
            }
        }
    }

    protected void close(OutputStream out, InputStream in, OutputStream i2pout, InputStream i2pin, Socket s, Socket i2ps, Thread t1, Thread t2) throws InterruptedException {
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2pout.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2pin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            i2ps.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        t1.join(30000L);
        t2.join(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorOccurred() {
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notifyAll();
        }
    }

    private class StreamForwarder
    extends I2PAppThread {
        private final InputStream in;
        private final OutputStream out;
        private final String direction;
        private final boolean _toI2P;
        private final ByteCache _cache;

        private StreamForwarder(InputStream in, OutputStream out, boolean toI2P) {
            this.in = in;
            this.out = out;
            this._toI2P = toI2P;
            this.direction = toI2P ? "toOutproxy" : "fromOutproxy";
            this._cache = ByteCache.getInstance(32, 4096);
            this.setName("OutproxyForwarder " + I2PTunnelOutproxyRunner.this._runnerId + '.' + __forwarderId.incrementAndGet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String from = "todo";
            String to = "todo";
            if (I2PTunnelOutproxyRunner.this._log.shouldLog(10)) {
                I2PTunnelOutproxyRunner.this._log.debug(this.direction + ": Forwarding between " + from + " and " + to);
            }
            ByteArray ba = this._cache.acquire();
            byte[] buffer = ba.getData();
            try {
                int len;
                while ((len = this.in.read(buffer)) != -1) {
                    if (len > 0) {
                        this.out.write(buffer, 0, len);
                        if (this._toI2P) {
                            I2PTunnelOutproxyRunner.this.totalSent += len;
                        } else {
                            I2PTunnelOutproxyRunner.this.totalReceived += len;
                        }
                    }
                    if (this.in.available() != 0) continue;
                    if (I2PTunnelOutproxyRunner.this._log.shouldLog(10)) {
                        I2PTunnelOutproxyRunner.this._log.debug(this.direction + ": " + len + " bytes flushed through " + (this._toI2P ? "to " : "from ") + "outproxy");
                    }
                    if (this._toI2P) {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (this.in.available() > 0) continue;
                        this.out.flush();
                        continue;
                    }
                    this.out.flush();
                }
            }
            catch (SocketException ex) {
                Object object = I2PTunnelOutproxyRunner.this.finishLock;
                synchronized (object) {
                    if (!I2PTunnelOutproxyRunner.this.finished && I2PTunnelOutproxyRunner.this._log.shouldLog(10)) {
                        I2PTunnelOutproxyRunner.this._log.debug(this.direction + ": Socket closed - error reading and writing", ex);
                    }
                }
            }
            catch (InterruptedIOException ex) {
                if (I2PTunnelOutproxyRunner.this._log.shouldLog(30)) {
                    I2PTunnelOutproxyRunner.this._log.warn(this.direction + ": Closing connection due to timeout (error: \"" + ex.getMessage() + "\")");
                }
            }
            catch (IOException ex) {
                if (!I2PTunnelOutproxyRunner.this.finished && I2PTunnelOutproxyRunner.this._log.shouldLog(30)) {
                    I2PTunnelOutproxyRunner.this._log.warn(this.direction + ": Error forwarding", ex);
                }
            }
            finally {
                block65: {
                    block64: {
                        this._cache.release(ba);
                        if (I2PTunnelOutproxyRunner.this._log.shouldLog(20)) {
                            I2PTunnelOutproxyRunner.this._log.info(this.direction + ": done forwarding between " + from + " and " + to);
                        }
                        try {
                            this.in.close();
                        }
                        catch (IOException ex) {
                            if (!I2PTunnelOutproxyRunner.this._log.shouldLog(30)) break block64;
                            I2PTunnelOutproxyRunner.this._log.warn(this.direction + ": Error closing input stream", ex);
                        }
                    }
                    try {
                        if (I2PTunnelOutproxyRunner.this.onTimeout == null || this._toI2P || I2PTunnelOutproxyRunner.this.totalReceived > 0L) {
                            this.out.close();
                        } else if (I2PTunnelOutproxyRunner.this._log.shouldLog(20)) {
                            I2PTunnelOutproxyRunner.this._log.info(this.direction + ": not closing so we can write the error message");
                        }
                    }
                    catch (IOException ioe) {
                        if (!I2PTunnelOutproxyRunner.this._log.shouldLog(30)) break block65;
                        I2PTunnelOutproxyRunner.this._log.warn(this.direction + ": Error flushing to close", ioe);
                    }
                }
                Object ioe = I2PTunnelOutproxyRunner.this.finishLock;
                synchronized (ioe) {
                    I2PTunnelOutproxyRunner.this.finished = true;
                    I2PTunnelOutproxyRunner.this.finishLock.notifyAll();
                }
            }
        }
    }
}

