/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import net.i2p.I2PAppContext;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.util.SecureDirectory;

class SSLUtil {
    private static final String PROP_KEYSTORE_PASSWORD = "sam.keystorePassword";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String PROP_KEY_PASSWORD = "sam.keyPassword";
    private static final String PROP_KEY_ALIAS = "sam.keyAlias";
    private static final String ASCII_KEYFILE_SUFFIX = ".local.crt";
    private static final String PROP_KS_NAME = "sam.keystoreFile";
    private static final String KS_DIR = "keystore";
    private static final String PREFIX = "sam-";
    private static final String KS_SUFFIX = ".ks";
    private static final String CERT_DIR = "certificates/sam";

    SSLUtil() {
    }

    public static boolean verifyKeyStore(Properties opts) throws IOException {
        SecureDirectory sdir;
        File ks;
        String ksname;
        String name = opts.getProperty(PROP_KEY_ALIAS);
        if (name == null) {
            name = KeyStoreUtil.randomString();
            opts.setProperty(PROP_KEY_ALIAS, name);
        }
        if ((ksname = opts.getProperty(PROP_KS_NAME)) == null) {
            ksname = PREFIX + name + KS_SUFFIX;
            opts.setProperty(PROP_KS_NAME, ksname);
        }
        if (!(ks = new File(ksname)).isAbsolute()) {
            ks = new File(I2PAppContext.getGlobalContext().getConfigDir(), KS_DIR);
            ks = new File(ks, ksname);
        }
        if (ks.exists()) {
            return false;
        }
        File dir = ks.getParentFile();
        if (!dir.exists() && !((File)(sdir = new SecureDirectory(dir.getAbsolutePath()))).mkdirs()) {
            throw new IOException("Unable to create keystore " + ks);
        }
        boolean rv = SSLUtil.createKeyStore(ks, name, opts);
        if (!rv) {
            throw new IOException("Unable to create keystore " + ks);
        }
        SSLUtil.exportCert(ks, name, opts);
        return true;
    }

    private static boolean createKeyStore(File ks, String name, Properties opts) {
        String keyPassword = KeyStoreUtil.randomString();
        String cname = name + ".sam.i2p.net";
        String keyName = opts.getProperty(PROP_KEY_ALIAS);
        boolean success = KeyStoreUtil.createKeys(ks, keyName, cname, "SAM", keyPassword);
        if (success && (success = ks.exists())) {
            opts.setProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            opts.setProperty(PROP_KEY_PASSWORD, keyPassword);
        }
        if (success) {
            SSLUtil.logAlways("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath() + "\n" + "The certificate name was generated randomly, and is not associated with your " + "IP address, host name, router identity, or destination keys.");
        } else {
            SSLUtil.error("Failed to create SAM SSL keystore.\nIf you create the keystore manually, you must add sam.keystorePassword and sam.keyPassword to " + new File(I2PAppContext.getGlobalContext().getConfigDir(), "sam.config").getAbsolutePath());
        }
        return success;
    }

    private static void exportCert(File ks, String name, Properties opts) {
        SecureDirectory sdir = new SecureDirectory(I2PAppContext.getGlobalContext().getConfigDir(), CERT_DIR);
        if (sdir.exists() || ((File)sdir).mkdirs()) {
            File out;
            String keyAlias = opts.getProperty(PROP_KEY_ALIAS);
            String ksPass = opts.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            boolean success = KeyStoreUtil.exportCert(ks, ksPass, keyAlias, out = new File(sdir, PREFIX + name + ASCII_KEYFILE_SUFFIX));
            if (!success) {
                SSLUtil.error("Error getting SSL cert to save as ASCII");
            }
        } else {
            SSLUtil.error("Error saving ASCII SSL keys");
        }
    }

    public static SSLServerSocketFactory initializeFactory(Properties opts) throws IOException {
        String ksPass = opts.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
        String keyPass = opts.getProperty(PROP_KEY_PASSWORD);
        if (keyPass == null) {
            throw new IOException("No key password, set sam.keyPassword in " + new File(I2PAppContext.getGlobalContext().getConfigDir(), "sam.config").getAbsolutePath());
        }
        String ksname = opts.getProperty(PROP_KS_NAME);
        if (ksname == null) {
            throw new IOException("No keystore, set sam.keystoreFile in " + new File(I2PAppContext.getGlobalContext().getConfigDir(), "sam.config").getAbsolutePath());
        }
        File ks = new File(ksname);
        if (!ks.isAbsolute()) {
            ks = new File(I2PAppContext.getGlobalContext().getConfigDir(), KS_DIR);
            ks = new File(ks, ksname);
        }
        InputStream fis = null;
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            keyStore.load(fis, ksPass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPass.toCharArray());
            sslc.init(kmf.getKeyManagers(), null, I2PAppContext.getGlobalContext().random());
            SSLServerSocketFactory sSLServerSocketFactory = sslc.getServerSocketFactory();
            return sSLServerSocketFactory;
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("keystore error");
            ioe.initCause(gse);
            throw ioe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void error(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(SSLUtil.class).error(s);
    }

    private static void logAlways(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(SSLUtil.class).logAlways(20, s);
    }
}

