/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataInputStream;
import java.io.IOException;
import org.klomp.snark.PartialPiece;

class Request {
    private final PartialPiece piece;
    final int off;
    final int len;
    long sendTime;

    Request(PartialPiece piece, int off, int len) {
        this.piece = piece;
        this.off = off;
        this.len = len;
        if (off < 0 || len <= 0 || off + len > piece.getLength()) {
            throw new IndexOutOfBoundsException("Illegal Request " + this.toString());
        }
    }

    public void read(DataInputStream din) throws IOException {
        this.piece.read(din, this.off, this.len);
    }

    public int getPiece() {
        return this.piece.getPiece();
    }

    public PartialPiece getPartialPiece() {
        return this.piece;
    }

    public int hashCode() {
        return this.piece.getPiece() ^ this.off ^ this.len;
    }

    public boolean equals(Object o) {
        if (o instanceof Request) {
            Request req = (Request)o;
            return req.piece.equals(this.piece) && req.off == this.off && req.len == this.len;
        }
        return false;
    }

    public String toString() {
        return "(" + this.piece.getPiece() + "," + this.off + "," + this.len + ")";
    }
}

