/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.apps.systray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.I2PAppThread;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public class UrlLauncher
implements ClientApp {
    private final ShellCommand _shellCommand;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private final I2PAppContext _context;
    private final ClientAppManager _mgr;
    private final String[] _args;
    private static final int WAIT_TIME = 5000;
    private static final int MAX_WAIT_TIME = 300000;
    private static final int MAX_TRIES = 99;
    private static final String REGISTERED_NAME = "UrlLauncher";
    private static final String PROP_BROWSER = "routerconsole.browser";
    private static final String[] BROWSERS = new String[]{"sensible-browser", "xdg-open", "x-www-browser", "defaultbrowser", "opera -newpage", "firefox", "mozilla", "netscape", "konqueror", "galeon", "www-browser", "links", "lynx"};

    public UrlLauncher(I2PAppContext context, ClientAppManager mgr, String[] args) {
        this._context = context;
        this._mgr = mgr;
        if (args == null || args.length <= 0) {
            args = new String[]{"http://127.0.0.1:7657/index.jsp"};
        }
        this._args = args;
        this._shellCommand = new ShellCommand();
        this._state = ClientAppState.INITIALIZED;
    }

    public UrlLauncher() {
        this._context = I2PAppContext.getGlobalContext();
        this._mgr = null;
        this._args = null;
        this._shellCommand = new ShellCommand();
        this._state = ClientAppState.INITIALIZED;
    }

    private static boolean waitForServer(String urlString) {
        InetSocketAddress sa;
        URI url;
        try {
            url = new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0) {
            port = "https".equals(url.getScheme()) ? 443 : 80;
        }
        try {
            sa = new InetSocketAddress(host, port);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        long done = System.currentTimeMillis() + 300000L;
        for (int i = 0; i < 99; ++i) {
            try {
                Socket test = new Socket();
                test.connect(sa, 5000);
                try {
                    test.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() > done) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openUrl(String url) throws IOException {
        UrlLauncher.waitForServer(url);
        if (UrlLauncher.validateUrlFormat(url)) {
            String cbrowser = this._context.getProperty(PROP_BROWSER);
            if (cbrowser != null) {
                return this.openUrl(url, cbrowser);
            }
            if (SystemVersion.isMac()) {
                String osName = System.getProperty("os.name");
                if (osName.toLowerCase(Locale.US).startsWith("mac os x")) {
                    if (this._shellCommand.executeSilentAndWaitTimed("open " + url, 5)) {
                        return true;
                    }
                } else {
                    return false;
                }
                if (this._shellCommand.executeSilentAndWaitTimed("iexplore " + url, 5)) {
                    return true;
                }
            } else if (SystemVersion.isWindows()) {
                String browserString = "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" -nohome";
                BufferedReader bufferedReader = null;
                File foo = new File(this._context.getTempDir(), "browser.reg");
                this._shellCommand.executeSilentAndWait("regedit /E \"" + foo.getAbsolutePath() + "\" \"HKEY_CLASSES_ROOT\\http\\shell\\open\\command\"");
                try {
                    String line;
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(foo), "UTF-16"));
                    while ((line = bufferedReader.readLine()) != null) {
                        if (!line.startsWith("@=")) continue;
                        browserString = line.substring(3, line.toLowerCase(Locale.US).indexOf(".exe") + 4);
                        if (browserString.startsWith("\\\"")) {
                            browserString = browserString.substring(2);
                        }
                        browserString = "\"" + browserString + "\"";
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    foo.delete();
                }
                catch (IOException iOException) {
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (this._shellCommand.executeSilentAndWaitTimed(browserString + ' ' + url, 5)) {
                    return true;
                }
            }
            for (int i = 0; i < BROWSERS.length; ++i) {
                if (!this._shellCommand.executeSilentAndWaitTimed(BROWSERS[i] + ' ' + url, 5)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean openUrl(String url, String browser) throws IOException {
        UrlLauncher.waitForServer(url);
        return UrlLauncher.validateUrlFormat(url) && this._shellCommand.executeSilentAndWaitTimed(browser + " " + url, 5);
    }

    private static boolean validateUrlFormat(String urlString) {
        try {
            new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public void startup() {
        String url = this._args[0];
        if (!UrlLauncher.validateUrlFormat(url)) {
            this.changeState(ClientAppState.START_FAILED, new MalformedURLException("Bad url: " + url));
            return;
        }
        this.changeState(ClientAppState.STARTING);
        I2PAppThread t = new I2PAppThread((Runnable)new Runner(), REGISTERED_NAME, true);
        t.start();
    }

    public ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return REGISTERED_NAME;
    }

    public String getDisplayName() {
        return "UrlLauncher \"" + this._args[0] + '\"';
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify((ClientApp)this, state, null, e);
        }
    }

    public void shutdown(String[] args) {
        this.changeState(ClientAppState.STOPPED);
    }

    public static void main(String[] args) {
        UrlLauncher launcher = new UrlLauncher();
        try {
            if (args.length > 0) {
                launcher.openUrl(args[0]);
            } else {
                launcher.openUrl("http://127.0.0.1:7657/index.jsp");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            UrlLauncher.this.changeState(ClientAppState.RUNNING);
            try {
                String url = UrlLauncher.this._args[0];
                UrlLauncher.this.openUrl(url);
                UrlLauncher.this.changeState(ClientAppState.STOPPED);
            }
            catch (IOException e) {
                UrlLauncher.this.changeState(ClientAppState.CRASHED, e);
            }
        }
    }
}

