/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.HashDistance;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NetDbRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.ObjectCounter;
import net.i2p.util.Translate;

class SybilRenderer {
    private final RouterContext _context;
    private final DecimalFormat fmt = new DecimalFormat("#0.00");
    private static final int PAIRMAX = 20;
    private static final int MAX = 10;
    private static final double POINTS32 = 5.0;
    private static final double POINTS24 = 5.0;
    private static final double POINTS16 = 0.25;
    private static final double POINTS_US32 = 25.0;
    private static final double POINTS_US24 = 25.0;
    private static final double POINTS_US16 = 10.0;
    private static final double POINTS_FAMILY = -2.0;
    private static final double MIN_CLOSE = 242.0;
    private static final double PAIR_DISTANCE_FACTOR = 2.0;
    private static final double OUR_KEY_FACTOR = 4.0;
    private static final double MIN_DISPLAY_POINTS = 5.0;
    private static final double VERSION_FACTOR = 1.0;
    private static final double POINTS_BAD_VERSION = 50.0;
    private static final double POINTS_UNREACHABLE = 4.0;
    private static final double POINTS_NEW = 4.0;
    private static final long DAY = 86400000L;

    public SybilRenderer(RouterContext ctx) {
        this._context = ctx;
    }

    public String getNetDbSummary(Writer out) throws IOException {
        this.renderRouterInfoHTML(out, null);
        return "";
    }

    private void addPoints(Map<Hash, Points> points, Hash h, double d, String reason) {
        Points dd = points.get(h);
        if (dd != null) {
            dd.points += d;
            dd.reasons.add("<b>" + this.fmt.format(d) + ":</b> " + reason);
        } else {
            points.put(h, new Points(d, "<b>" + this.fmt.format(d) + ":</b> " + reason));
        }
    }

    private void renderRouterInfoHTML(Writer out, String routerPrefix) throws IOException {
        Set<Hash> ffs = this._context.peerManager().getPeersByCapability('f');
        ArrayList<RouterInfo> ris = new ArrayList<RouterInfo>(ffs.size());
        Hash us = this._context.routerHash();
        Hash ourRKey = this._context.router().getRouterInfo().getRoutingKey();
        for (Hash ff : ffs) {
            RouterInfo ri;
            if (ff.equals(us) || (ri = this._context.netDb().lookupRouterInfoLocally(ff)) == null) continue;
            ris.add(ri);
        }
        if (ris.isEmpty()) {
            out.write("<h3>No known floodfills</h3>");
            return;
        }
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<p><b>This is an experimental network database tool for debugging and analysis. Do not panic even if you see warnings below. Possible \"threats\" are summarized at the bottom, however these are unlikely to be real threats. If you see anything you would like to discuss with the devs, contact us on IRC #i2p-dev.</b></p><ul><li><a href=\"#known\">FF Summary</a></li><li><a href=\"#family\">Same Family</a></li><li><a href=\"#ourIP\">IP close to us</a></li><li><a href=\"#sameIP\">Same IP</a></li><li><a href=\"#same24\">Same /24</a></li><li><a href=\"#same16\">Same /16</a></li><li><a href=\"#pairs\">Pair distance</a></li><li><a href=\"#ritoday\">Close to us</a></li><li><a href=\"#ritmrw\">Close to us tomorrow</a></li><li><a href=\"#dht\">DHT neighbors</a></li><li><a href=\"#dest\">Close to our destinations</a></li><li><a href=\"#threats\">Highest threats</a></li></ul>");
        this.renderRouterInfo(buf, this._context.router().getRouterInfo(), null, true, false);
        buf.append("<h3 id=\"known\">Known Floodfills: ").append(ris.size()).append("</h3>");
        double tot = 0.0;
        int count = 200;
        byte[] b = new byte[32];
        for (int i = 0; i < count; ++i) {
            this._context.random().nextBytes(b);
            Hash h = new Hash(b);
            double d = this.closestDistance(h, ris);
            tot += d;
        }
        double avgMinDist = tot / (double)count;
        buf.append("<p>Average closest floodfill distance: " + this.fmt.format(avgMinDist) + "</p>");
        buf.append("<p>Routing Data: \"").append(DataHelper.getUTF8(this._context.routerKeyGenerator().getModData())).append("\" Last Changed: ").append(new Date(this._context.routerKeyGenerator().getLastChanged()));
        buf.append("</p><p>Next Routing Data: \"").append(DataHelper.getUTF8(this._context.routerKeyGenerator().getNextModData())).append("\" Rotates in: ").append(DataHelper.formatDuration(this._context.routerKeyGenerator().getTimeTillMidnight()));
        buf.append("</p>");
        HashMap<Hash, Points> points = new HashMap<Hash, Points>(64);
        this.renderIPGroupsFamily(out, buf, ris, points);
        this.renderIPGroupsUs(out, buf, ris, points);
        this.renderIPGroups32(out, buf, ris, points);
        this.renderIPGroups24(out, buf, ris, points);
        this.renderIPGroups16(out, buf, ris, points);
        this.renderPairDistance(out, buf, ris, points);
        buf.append("<h3 id=\"ritoday\">Closest Floodfills to Our Routing Key (Where we Store our RI)</h3>");
        this.renderRouterInfoHTML(out, buf, ourRKey, avgMinDist, ris, points);
        RouterKeyGenerator rkgen = this._context.routerKeyGenerator();
        Hash nkey = rkgen.getNextRoutingKey(us);
        buf.append("<h3 id=\"ritmrw\">Closest Floodfills to Tomorrow's Routing Key (Where we will Store our RI)</h3>");
        this.renderRouterInfoHTML(out, buf, nkey, avgMinDist, ris, points);
        buf.append("<h3 id=\"dht\">Closest Floodfills to Our Router Hash (DHT Neighbors if we are Floodfill)</h3>");
        this.renderRouterInfoHTML(out, buf, us, avgMinDist, ris, points);
        buf.append("<h3 id=\"dest\">Floodfills Close to Our Destinations</h3>");
        Map<Hash, TunnelPool> clientInboundPools = this._context.tunnelManager().getInboundClientPools();
        ArrayList<Hash> destinations = new ArrayList<Hash>(clientInboundPools.keySet());
        boolean debug = this._context.getBooleanProperty("routerconsole.advanced");
        for (Hash client : destinations) {
            LeaseSet ls;
            boolean isLocal = this._context.clientManager().isLocal(client);
            if (!isLocal || !this._context.clientManager().shouldPublishLeaseSet(client) || (ls = this._context.netDb().lookupLeaseSetLocally(client)) == null) continue;
            Hash rkey = ls.getRoutingKey();
            TunnelPool in = clientInboundPools.get(client);
            String name = in != null ? in.getSettings().getDestinationNickname() : client.toBase64().substring(0, 4);
            buf.append("<h3>Closest floodfills to the Routing Key for " + DataHelper.escapeHTML(name) + " (where we store our LS)</h3>");
            this.renderRouterInfoHTML(out, buf, rkey, avgMinDist, ris, points);
            nkey = rkgen.getNextRoutingKey(ls.getHash());
            buf.append("<h3>Closest floodfills to Tomorrow's Routing Key for " + DataHelper.escapeHTML(name) + " (where we will store our LS)</h3>");
            this.renderRouterInfoHTML(out, buf, nkey, avgMinDist, ris, points);
        }
        this.addProfilePoints(ris, points);
        this.addVersionPoints(ris, points);
        if (!points.isEmpty()) {
            ArrayList warns = new ArrayList(points.keySet());
            Collections.sort(warns, new PointsComparator(points));
            buf.append("<h3 id=\"threats\">Routers with Most Threat Points</h3>");
            for (Hash h : warns) {
                RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(h);
                if (ri == null) continue;
                Points pp = (Points)points.get(h);
                double p = pp.points;
                if (p < 5.0) break;
                buf.append("<p><b>Threat Points: " + this.fmt.format(p) + "</b><ul>");
                for (String s : pp.reasons) {
                    buf.append("<li>").append(s).append("</li>");
                }
                buf.append("</ul></p>");
                this.renderRouterInfo(buf, ri, null, false, false);
            }
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private void renderPairDistance(Writer out, StringBuilder buf, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        int sz = ris.size();
        ArrayList<Pair> pairs = new ArrayList<Pair>(20);
        double total = 0.0;
        for (int i = 0; i < sz; ++i) {
            RouterInfo info1 = ris.get(i);
            for (int j = i + 1; j < sz; ++j) {
                RouterInfo info2 = ris.get(j);
                BigInteger dist = HashDistance.getDistance(info1.getHash(), info2.getHash());
                if (pairs.isEmpty()) {
                    pairs.add(new Pair(info1, info2, dist));
                } else if (pairs.size() < 20) {
                    pairs.add(new Pair(info1, info2, dist));
                    Collections.sort(pairs);
                } else if (dist.compareTo(((Pair)pairs.get((int)19)).dist) < 0) {
                    pairs.set(19, new Pair(info1, info2, dist));
                    Collections.sort(pairs);
                }
                total += SybilRenderer.biLog2(dist);
            }
        }
        double avg = total / (double)(sz * sz / 2);
        buf.append("<h3>Average Floodfill Distance is ").append(this.fmt.format(avg)).append("</h3>");
        buf.append("<h3 id=\"pairs\">Closest Floodfill Pairs by Hash</h3>");
        for (Pair p : pairs) {
            double distance = SybilRenderer.biLog2(p.dist);
            double point = 242.0 - distance;
            if (point < 0.0) break;
            if (point >= 2.0) {
                buf.append("<p><b>Hash Distance: ").append(this.fmt.format(distance)).append(": </b>");
                buf.append("</p>");
                this.renderRouterInfo(buf, p.r1, null, false, false);
                this.renderRouterInfo(buf, p.r2, null, false, false);
            }
            String b2 = p.r2.getHash().toBase64();
            this.addPoints(points, p.r1.getHash(), point *= 2.0, "Very close (" + this.fmt.format(distance) + ") to other floodfill <a href=\"netdb?r=" + b2 + "\">" + b2 + "</a>");
            String b1 = p.r1.getHash().toBase64();
            this.addPoints(points, p.r2.getHash(), point, "Very close (" + this.fmt.format(distance) + ") to other floodfill <a href=\"netdb?r=" + b1 + "\">" + b1 + "</a>");
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private double closestDistance(Hash h, List<RouterInfo> ris) throws IOException {
        BigInteger min = new BigInteger("2").pow(256);
        for (RouterInfo info : ris) {
            BigInteger dist = HashDistance.getDistance(h, info.getHash());
            if (dist.compareTo(min) >= 0) continue;
            min = dist;
        }
        return SybilRenderer.biLog2(min);
    }

    private static byte[] getIP(RouterInfo ri) {
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null || rv.length != 4) continue;
            return rv;
        }
        return null;
    }

    private void renderIPGroupsUs(Writer out, StringBuilder buf, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        RouterInfo us = this._context.router().getRouterInfo();
        byte[] ourIP = SybilRenderer.getIP(us);
        if (ourIP == null) {
            return;
        }
        buf.append("<h3 \"ourIP\">Floodfills close to Our IP</h3>");
        boolean found = false;
        for (RouterInfo info : ris) {
            byte[] ip = SybilRenderer.getIP(info);
            if (ip == null || ip[0] != ourIP[0] || ip[1] != ourIP[1]) continue;
            buf.append("<p><b>");
            if (ip[2] == ourIP[2]) {
                if (ip[3] == ourIP[3]) {
                    buf.append("Same IP as us");
                    this.addPoints(points, info.getHash(), 25.0, "Same IP as us");
                } else {
                    buf.append("Same /24 as us");
                    this.addPoints(points, info.getHash(), 25.0, "Same /24 as us");
                }
            } else {
                buf.append("Same /16 as us");
                this.addPoints(points, info.getHash(), 10.0, "Same /16 as us");
            }
            buf.append(":</b></p>");
            this.renderRouterInfo(buf, info, null, false, false);
            found = true;
        }
        if (!found) {
            buf.append("<p>None</p>");
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private void renderIPGroups32(Writer out, StringBuilder buf, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        buf.append("<h3 id=\"sameIP\">Floodfills with the Same IP</h3>");
        ObjectCounter<Integer> oc = new ObjectCounter<Integer>();
        for (RouterInfo info : ris) {
            byte[] ip = SybilRenderer.getIP(info);
            if (ip == null) continue;
            Integer x = (int)DataHelper.fromLong(ip, 0, 4);
            oc.increment(x);
        }
        ArrayList<Integer> foo = new ArrayList<Integer>();
        for (Integer ii : oc.objects()) {
            int count = oc.count(ii);
            if (count < 2) continue;
            foo.add(ii);
        }
        Collections.sort(foo, new FooComparator(oc));
        boolean found = false;
        for (Integer ii : foo) {
            int count = oc.count(ii);
            int i = ii;
            int i0 = i >> 24 & 0xFF;
            int i1 = i >> 16 & 0xFF;
            int i2 = i >> 8 & 0xFF;
            int i3 = i & 0xFF;
            buf.append("<p><b>").append(count).append(" floodfills with IP ").append(i0).append('.').append(i1).append('.').append(i2).append('.').append(i3).append(":</b></p>");
            for (RouterInfo info : ris) {
                byte[] ip = SybilRenderer.getIP(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1 || (ip[2] & 0xFF) != i2 || (ip[3] & 0xFF) != i3) continue;
                found = true;
                this.renderRouterInfo(buf, info, null, false, false);
                double point = 5.0 * (double)(count - 1);
                this.addPoints(points, info.getHash(), point, "Same IP with " + (count - 1) + " other" + (count > 2 ? "s" : ""));
            }
        }
        if (!found) {
            buf.append("<p>None</p>");
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private void renderIPGroups24(Writer out, StringBuilder buf, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        buf.append("<h3 id=\"same24\">Floodfills in the Same /24 (2 minimum)</h3>");
        ObjectCounter<Integer> oc = new ObjectCounter<Integer>();
        for (RouterInfo info : ris) {
            byte[] ip = SybilRenderer.getIP(info);
            if (ip == null) continue;
            Integer x = (int)DataHelper.fromLong(ip, 0, 3);
            oc.increment(x);
        }
        ArrayList<Integer> foo = new ArrayList<Integer>();
        for (Integer ii : oc.objects()) {
            int count = oc.count(ii);
            if (count < 2) continue;
            foo.add(ii);
        }
        Collections.sort(foo, new FooComparator(oc));
        boolean found = false;
        for (Integer ii : foo) {
            int count = oc.count(ii);
            int i = ii;
            int i0 = i >> 16;
            int i1 = i >> 8 & 0xFF;
            int i2 = i & 0xFF;
            buf.append("<p><b>").append(count).append(" floodfills in ").append(i0).append('.').append(i1).append('.').append(i2).append(".0/24:</b></p>");
            for (RouterInfo info : ris) {
                byte[] ip = SybilRenderer.getIP(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1 || (ip[2] & 0xFF) != i2) continue;
                found = true;
                this.renderRouterInfo(buf, info, null, false, false);
                double point = 5.0 * (double)(count - 1);
                this.addPoints(points, info.getHash(), point, "Same /24 IP with " + (count - 1) + " other" + (count > 2 ? "s" : ""));
            }
        }
        if (!found) {
            buf.append("<p>None</p>");
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private void renderIPGroups16(Writer out, StringBuilder buf, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        buf.append("<h3 id=\"same16\">Floodfills in the Same /16 (4 minimum)</h3>");
        ObjectCounter<Integer> oc = new ObjectCounter<Integer>();
        for (RouterInfo info : ris) {
            byte[] ip = SybilRenderer.getIP(info);
            if (ip == null) continue;
            Integer x = (int)DataHelper.fromLong(ip, 0, 2);
            oc.increment(x);
        }
        ArrayList<Integer> foo = new ArrayList<Integer>();
        for (Integer ii : oc.objects()) {
            int count = oc.count(ii);
            if (count < 4) continue;
            foo.add(ii);
        }
        Collections.sort(foo, new FooComparator(oc));
        boolean found = false;
        for (Integer ii : foo) {
            int count = oc.count(ii);
            int i = ii;
            int i0 = i >> 8;
            int i1 = i & 0xFF;
            buf.append("<p><b>").append(count).append(" floodfills in ").append(i0).append('.').append(i1).append(".0.0/16</b></p>");
            for (RouterInfo info : ris) {
                byte[] ip = SybilRenderer.getIP(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1) continue;
                found = true;
                double point = 0.25 * (double)(count - 1);
                this.addPoints(points, info.getHash(), point, "Same /16 IP with " + (count - 1) + " other" + (count > 2 ? "s" : ""));
            }
        }
        if (!found) {
            buf.append("<p>None</p>");
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private void renderIPGroupsFamily(Writer out, StringBuilder buf, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        buf.append("<h3>Floodfills in the Same Declared Family</h3>");
        ObjectCounter<String> oc = new ObjectCounter<String>();
        for (RouterInfo info : ris) {
            String fam = info.getOption("family");
            if (fam == null) continue;
            oc.increment(fam);
        }
        ArrayList foo = new ArrayList(oc.objects());
        Collections.sort(foo, new FoofComparator(oc));
        boolean found = false;
        for (String s : foo) {
            int count = oc.count(s);
            buf.append("<p><b>").append(count).append(" floodfills in declared family \"").append(DataHelper.escapeHTML(s) + '\"').append("</b></p>");
            for (RouterInfo info : ris) {
                String fam = info.getOption("family");
                if (fam == null || !fam.equals(s)) continue;
                found = true;
                double point = -2.0;
                if (count > 1) {
                    this.addPoints(points, info.getHash(), point, "Same declared family \"" + DataHelper.escapeHTML(s) + "\" with " + (count - 1) + " other" + (count > 2 ? "s" : ""));
                    continue;
                }
                this.addPoints(points, info.getHash(), point, "Declared family \"" + DataHelper.escapeHTML(s) + '\"');
            }
        }
        if (!found) {
            buf.append("<p>None</p>");
        }
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private void addProfilePoints(List<RouterInfo> ris, Map<Hash, Points> points) {
        long now = this._context.clock().now();
        RateAverages ra = RateAverages.getTemp();
        for (RouterInfo info : ris) {
            double avg;
            Rate r;
            RateStat rs;
            DBHistory dbh;
            long age;
            Hash h = info.getHash();
            PeerProfile prof = this._context.profileOrganizer().getProfileNonblocking(h);
            if (prof == null) continue;
            long heard = prof.getFirstHeardAbout();
            if (heard > 0L && (age = Math.max(now - heard, 1L)) < 172800000L) {
                double point = Math.min(4.0, (double)(172800000L - age) / 4.32E7);
                this.addPoints(points, h, point, "First heard about: " + this._t("{0} ago", DataHelper.formatDuration2(age)));
            }
            if ((dbh = prof.getDBHistory()) == null || (rs = dbh.getFailedLookupRate()) == null || (r = rs.getRate(86400000L)) == null) continue;
            r.computeAverages(ra, false);
            if (ra.getTotalEventCount() <= 0L || !((avg = 100.0 * ra.getAverage()) > 40.0)) continue;
            this.addPoints(points, h, (avg - 40.0) / 6.0, "Lookup fail rate " + (int)avg + '%');
        }
    }

    private void addVersionPoints(List<RouterInfo> ris, Map<Hash, Points> points) {
        int minor;
        RouterInfo us = this._context.router().getRouterInfo();
        if (us == null) {
            return;
        }
        String ourVer = us.getVersion();
        if (!ourVer.startsWith("0.9.")) {
            return;
        }
        int dot = (ourVer = ourVer.substring(4)).indexOf(46);
        if (dot > 0) {
            ourVer = ourVer.substring(0, dot);
        }
        try {
            minor = Integer.parseInt(ourVer);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        for (RouterInfo info : ris) {
            int hisMinor;
            String hisFullVer;
            Hash h = info.getHash();
            String caps = info.getCapabilities();
            if (!caps.contains("R")) {
                this.addPoints(points, h, 4.0, "Unreachable: " + DataHelper.escapeHTML(caps));
            }
            if (!(hisFullVer = info.getVersion()).startsWith("0.9.")) {
                this.addPoints(points, h, 50.0, "Strange version " + DataHelper.escapeHTML(hisFullVer));
                continue;
            }
            String hisVer = hisFullVer.substring(4);
            dot = hisVer.indexOf(46);
            if (dot > 0) {
                hisVer = hisVer.substring(0, dot);
            }
            try {
                hisMinor = Integer.parseInt(hisVer);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            int howOld = minor - hisMinor;
            if (howOld < 3) continue;
            this.addPoints(points, h, (double)howOld * 1.0, howOld + " versions behind: " + DataHelper.escapeHTML(hisFullVer));
        }
    }

    private void renderRouterInfoHTML(Writer out, StringBuilder buf, Hash us, double avgMinDist, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        Collections.sort(ris, new RouterInfoRoutingKeyComparator(us));
        double min = 256.0;
        double max = 0.0;
        double tot = 0.0;
        double median = 0.0;
        int count = Math.min(10, ris.size());
        boolean isEven = count % 2 == 0;
        int medIdx = isEven ? count / 2 - 1 : count / 2;
        for (int i = 0; i < count; ++i) {
            RouterInfo ri = ris.get(i);
            double dist = this.renderRouterInfo(buf, ri, us, false, false);
            if (dist < avgMinDist && i != 0) {
                if (i == 1) {
                    buf.append("<p><b>Not to worry, but above routers are closer than average minimum distance " + this.fmt.format(avgMinDist) + "</b></p>");
                } else if (i == 2) {
                    buf.append("<p><b>Possible Sybil Warning - above routers are closer than average minimum distance " + this.fmt.format(avgMinDist) + "</b></p>");
                } else {
                    buf.append("<p><b>Major Sybil Warning - above router is closer than average minimum distance " + this.fmt.format(avgMinDist) + "</b></p>");
                }
            }
            if (dist < min) {
                min = dist;
            }
            if (dist > max) {
                max = dist;
            }
            tot += dist;
            if (i == medIdx) {
                median = dist;
            } else if (i == medIdx + 1 && isEven) {
                median = (median + dist) / 2.0;
            }
            double point = 242.0 - dist;
            if (point > 0.0) {
                this.addPoints(points, ri.getHash(), point *= 4.0, "Very close (" + this.fmt.format(dist) + ") to our key " + us.toBase64());
            }
            if (i >= 9) break;
        }
        double avg = tot / (double)count;
        buf.append("<p><b>Totals for " + count + " floodfills: </b>MIN=" + this.fmt.format(min) + " AVG=" + this.fmt.format(avg) + " MEDIAN=" + this.fmt.format(median) + " MAX=" + this.fmt.format(max) + "</p>\n");
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private static double biLog2(BigInteger a) {
        return NetDbRenderer.biLog2(a);
    }

    private String getTranslatedCountry(String code) {
        String name = this._context.commSystem().getCountryName(code);
        return Translate.getString(name, this._context, "net.i2p.router.countries.messages");
    }

    private double renderRouterInfo(StringBuilder buf, RouterInfo info, Hash us, boolean isUs, boolean full) {
        PeerProfile prof;
        String kr;
        String kls;
        String hash = info.getIdentity().getHash().toBase64();
        buf.append("<table><tr><th><a name=\"").append(hash.substring(0, 6)).append("\" ></a>");
        double distance = 0.0;
        if (isUs) {
            buf.append("<a name=\"our-info\" ></a><b>" + this._t("Our info") + ": ").append(hash).append("</b></th></tr><tr><td>\n");
        } else {
            buf.append("<b>" + this._t("Router") + ":</b> ").append(hash).append("\n");
            if (!full) {
                buf.append("[<a href=\"netdb?r=").append(hash.substring(0, 6)).append("\" >").append(this._t("Full entry")).append("</a>]");
            }
            buf.append("</th><th><img src=\"/imagegen/id?s=32&amp;c=" + hash.replace("=", "%3d") + "\" height=\"32\" width=\"32\"> ");
            buf.append("</th></tr><tr><td colspan=\"2\">\n");
            if (us != null) {
                BigInteger dist = HashDistance.getDistance(us, info.getHash());
                distance = SybilRenderer.biLog2(dist);
                buf.append("<b>Hash Distance: ").append(this.fmt.format(distance)).append("</b><br>");
            }
        }
        buf.append("<b>Routing Key: </b>").append(info.getRoutingKey().toBase64()).append("<br>\n");
        buf.append("<b>Version: </b>").append(DataHelper.stripHTML(info.getVersion())).append("<br>\n");
        buf.append("<b>Caps: </b>").append(DataHelper.stripHTML(info.getCapabilities())).append("<br>\n");
        String fam = info.getOption("family");
        if (fam != null) {
            buf.append("<b>Family: ").append(DataHelper.escapeHTML(fam)).append("</b><br>\n");
        }
        if ((kls = info.getOption("netdb.knownLeaseSets")) != null) {
            buf.append("<b>Lease Sets: </b>").append(DataHelper.stripHTML(kls)).append("<br>\n");
        }
        if ((kr = info.getOption("netdb.knownRouters")) != null) {
            buf.append("<b>Routers: </b>").append(DataHelper.stripHTML(kr)).append("<br>\n");
        }
        long now = this._context.clock().now();
        if (!isUs && (prof = this._context.profileOrganizer().getProfileNonblocking(info.getHash())) != null) {
            DBHistory dbh;
            long age;
            long heard = prof.getFirstHeardAbout();
            if (heard > 0L) {
                age = Math.max(now - heard, 1L);
                buf.append("<b>First heard about:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
            }
            if ((heard = prof.getLastHeardAbout()) > 0L) {
                age = Math.max(now - heard, 1L);
                buf.append("<b>Last heard about:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
            }
            if ((heard = prof.getLastHeardFrom()) > 0L) {
                age = Math.max(now - heard, 1L);
                buf.append("<b>Last heard from:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
            }
            if ((dbh = prof.getDBHistory()) != null) {
                long age2;
                heard = dbh.getLastLookupSuccessful();
                if (heard > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<b>Last lookup successful:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age2))).append("<br>\n");
                }
                if ((heard = dbh.getLastLookupFailed()) > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<b>Last lookup failed:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age2))).append("<br>\n");
                }
                if ((heard = dbh.getLastStoreSuccessful()) > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<b>Last store successful:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age2))).append("<br>\n");
                }
                if ((heard = dbh.getLastStoreFailed()) > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<b>Last store failed:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age2))).append("<br>\n");
                }
            }
        }
        long age = Math.max(now - info.getPublished(), 1L);
        if (isUs && this._context.router().isHidden()) {
            buf.append("<b>").append(this._t("Hidden")).append(", ").append(this._t("Updated")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
        } else {
            buf.append("<b>").append(this._t("Published")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("<br>\n");
        }
        buf.append("<b>").append(this._t("Signing Key")).append(":</b> ").append(info.getIdentity().getSigningPublicKey().getType().toString());
        buf.append("<br>\n<b>" + this._t("Addresses") + ":</b> ");
        String country = this._context.commSystem().getCountry(info.getIdentity().getHash());
        if (country != null) {
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase(Locale.US)).append('\"');
            buf.append(" title=\"").append(this.getTranslatedCountry(country)).append('\"');
            buf.append(" src=\"/flags.jsp?c=").append(country).append("\"> ");
        }
        for (RouterAddress addr : info.getAddresses()) {
            String style = addr.getTransportStyle();
            buf.append("<b>").append(DataHelper.stripHTML(style)).append(":</b> ");
            Map<Object, Object> p = addr.getOptionsMap();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                String name = (String)e.getKey();
                if (name.equals("key") || name.startsWith("ikey") || name.startsWith("itag") || name.startsWith("iport") || name.equals("mtu")) continue;
                String val = (String)e.getValue();
                buf.append('[').append(this._t(DataHelper.stripHTML(name))).append('=');
                if (name.equals("host")) {
                    buf.append("<b>");
                }
                buf.append(DataHelper.stripHTML(val)).append("] ");
                if (!name.equals("host")) continue;
                buf.append("</b>");
            }
        }
        buf.append("</td></tr>\n");
        buf.append("</table>\n");
        return distance;
    }

    private String _t(String s) {
        return Messages.getString(s, this._context);
    }

    private static final String _x(String s) {
        return s;
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private static class FooComparator
    implements Comparator<Integer>,
    Serializable {
        private final ObjectCounter<Integer> _o;

        public FooComparator(ObjectCounter<Integer> o) {
            this._o = o;
        }

        @Override
        public int compare(Integer l, Integer r) {
            int rv = this._o.count(r) - this._o.count(l);
            if (rv != 0) {
                return rv;
            }
            return l - r;
        }
    }

    private static class FoofComparator
    implements Comparator<String>,
    Serializable {
        private final ObjectCounter<String> _o;

        public FoofComparator(ObjectCounter<String> o) {
            this._o = o;
        }

        @Override
        public int compare(String l, String r) {
            int rv = this._o.count(r) - this._o.count(l);
            if (rv != 0) {
                return rv;
            }
            return l.compareTo(r);
        }
    }

    private static class Pair
    implements Comparable<Pair> {
        public final RouterInfo r1;
        public final RouterInfo r2;
        public final BigInteger dist;

        public Pair(RouterInfo ri1, RouterInfo ri2, BigInteger distance) {
            this.r1 = ri1;
            this.r2 = ri2;
            this.dist = distance;
        }

        @Override
        public int compareTo(Pair p) {
            return this.dist.compareTo(p.dist);
        }
    }

    private static class Points
    implements Comparable<Points> {
        private double points;
        private final List<String> reasons;

        public Points(double points, String reason) {
            this.points = points;
            this.reasons = new ArrayList<String>(4);
            this.reasons.add(reason);
        }

        @Override
        public int compareTo(Points r) {
            if (this.points > r.points) {
                return 1;
            }
            if (this.points < r.points) {
                return -1;
            }
            return 0;
        }
    }

    private static class PointsComparator
    implements Comparator<Hash>,
    Serializable {
        private final Map<Hash, Points> _points;

        public PointsComparator(Map<Hash, Points> points) {
            this._points = points;
        }

        @Override
        public int compare(Hash l, Hash r) {
            return this._points.get(r).compareTo(this._points.get(l));
        }
    }

    private static class RouterInfoRoutingKeyComparator
    implements Comparator<RouterInfo>,
    Serializable {
        private final Hash _us;

        public RouterInfoRoutingKeyComparator(Hash us) {
            this._us = us;
        }

        @Override
        public int compare(RouterInfo l, RouterInfo r) {
            return HashDistance.getDistance(this._us, l.getHash()).compareTo(HashDistance.getDistance(this._us, r.getHash()));
        }
    }
}

