/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;

public class SearchHelper
extends HelperBase {
    private String _engine;
    private String _query;
    private Map<String, String> _engines = new TreeMap<String, String>();
    private static final char S = ',';
    private static final String SOURCE = "&amp;ref=console";
    static final String PROP_ENGINES = "routerconsole.searchEngines";
    private static final String PROP_DEFAULT = "routerconsole.searchEngine";
    static final String ENGINES_DEFAULT = "eepsites.i2p,http://eepsites.i2p/Content/Search/SearchResults.aspx?inpQuery=%s&amp;ref=console,epsilon.i2p,http://epsilon.i2p/search.jsp?q=%s&amp;ref=console,";
    private static final String SS = Character.toString(',');

    public void setEngine(String s) {
        String dflt;
        this._engine = s;
        if (s != null && !s.equals(dflt = this._context.getProperty(PROP_DEFAULT))) {
            this._context.router().saveConfig(PROP_DEFAULT, s);
        }
    }

    public void setQuery(String s) {
        this._query = s;
    }

    private void buildEngineMap() {
        String config = this._context.getProperty(PROP_ENGINES, ENGINES_DEFAULT);
        String[] args = DataHelper.split(config, SS);
        for (int i = 0; i < args.length - 1; i += 2) {
            String name = args[i];
            String url = args[i + 1];
            this._engines.put(name, url);
        }
    }

    public String getSelector() {
        this.buildEngineMap();
        if (this._engines.isEmpty()) {
            return "<b>No search engines specified</b>";
        }
        String dflt = this._context.getProperty(PROP_DEFAULT);
        if (dflt == null || !this._engines.containsKey(dflt)) {
            int idx = this._context.random().nextInt(this._engines.size());
            int i = 0;
            Iterator<String> i$ = this._engines.keySet().iterator();
            while (i$.hasNext()) {
                String name;
                dflt = name = i$.next();
                if (i++ < idx) continue;
                this._context.router().saveConfig(PROP_DEFAULT, dflt);
                break;
            }
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<select name=\"engine\" title=\"").append(this._t("Select search engine")).append("\">");
        for (String name : this._engines.keySet()) {
            buf.append("<option value=\"").append(name).append('\"');
            if (name.equals(dflt)) {
                buf.append(" selected=\"selected\"");
            }
            buf.append('>').append(name).append("</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getURL() {
        if (this._engine == null || this._query == null) {
            return null;
        }
        this._query = DataHelper.escapeHTML(this._query).trim();
        if (this._query.length() <= 0) {
            return null;
        }
        this.buildEngineMap();
        String url = this._engines.get(this._engine);
        if (url == null) {
            return null;
        }
        url = url.contains("%s") ? url.replace("%s", this._query) : url + this._query;
        return url;
    }
}

